--
--    Program : Worms.ada
--    Purpose : This program is based on the UNIX game worms.  It is
--      implemented to show how tasks can be used in ADA.  It
--      is interesting since the Worms program could really be
--      implemented as a sequential program.  This implementation
--      shows how tasks can be used to simplify the design of a
--      sequential program.  By defining the Worms as individual
--      tasks, the programmer only has to worry about defining the
--      behavior of a single Worm, and then creating multiple 
--      instantiations of that Worm.
--
--    To use with GWUMON : To use this program with GWUMON, from the command
--              line type:
--                       adacomp -a -b -mworms worms.ada
--                       gwumon -mworms
--
--    On the intial setup screen, choose 'Y' to the questions if tasks are
--          used.  Also, set the intial speed to 10, the fastest speed 
--      (the monitor will still run slow.  To get a better feel for
--      how the worms run, try running it once not through the
--      monitor).  The first four windows which will show up will be
--      the main procedure WORMS, the task SCREEN, and two instances
--      of the WORM task.  Notice how the WORM task interacts with
--      SCREEN task.  
--      

WITH Text_IO; USE Text_IO;
WITH My_Int_IO;
WITH Screen; USE Screen;
WITH Creatures; USE Creatures;
PROCEDURE Worms IS
    TYPE W_Array IS ARRAY(INTEGER RANGE <>) of Creatures.Worm;
    TYPE Worms_Array IS ACCESS W_Array;
    OnScreen : Worms_Array;
    Number_Of_Worms : INTEGER;
BEGIN
    LOOP
        PUT_LINE( "Enter the number of worms (1-6) " );
        My_Int_IO.GET( Number_Of_Worms );
        IF  Number_Of_Worms < 1 OR Number_Of_Worms > 6 THEN
        PUT_LINE ( "Invalid number of worms, use 1-6" );
        ELSE
        EXIT;
        END IF;
    END LOOP;

    OnScreen := NEW W_Array( 1..Number_Of_Worms );
    PUT_LINE( "Enter the screen Size (Min X, Y, Max X, Y)");
    My_Int_IO.GET( Minimum_xy.x );
    My_Int_IO.GET( Minimum_xy.y );
        My_Int_IO.GET( Maximum_xy.x );
    My_Int_IO.GET( Maximum_xy.y );
    ClearScreen;
        OnScreen(1).Init_Worm( '@' );
    IF Number_Of_Worms >1 THEN
            OnScreen(2).Init_Worm( '#' );
    END IF;
    IF Number_Of_Worms >2 THEN
            OnScreen(3).Init_Worm( '$' );
    END IF;
    IF Number_Of_Worms >3 THEN
            OnScreen(4).Init_Worm( '%' );
    END IF;
    IF Number_Of_Worms >4 THEN
        OnScreen(5).Init_Worm( '&' );
    END IF;
    IF Number_Of_Worms >5 THEN
        OnScreen(6).Init_Worm( '*' );
    END IF;
END Worms;

