WITH Unchecked_Deallocation;

GENERIC

TYPE Item IS PRIVATE;

PACKAGE Stk IS
	TYPE Stack IS PRIVATE;
	PROCEDURE Make_Empty(S : IN OUT Stack);
	FUNCTION Is_Empty(S : Stack) RETURN BOOLEAN;
	PROCEDURE Push(S : IN OUT Stack; E : Item);
	PROCEDURE Pop(S : IN OUT Stack);
	FUNCTION Top(S : Stack) RETURN Item;
	Stack_Full  : EXCEPTION;
	Stack_Empty : EXCEPTION;
PRIVATE
	TYPE Node;
	TYPE Node_Link IS ACCESS Node;
	TYPE Node IS RECORD
		Value    : Item;
		Previous : Node_Link;
		END RECORD;
	TYPE Stack IS RECORD
		Last : Node_Link := NULL;
		END RECORD;
END Stk;

PACKAGE BODY Stk IS
	Temp : Node_Link := NULL;
	-- Non portable ; Instantiate Unchecked_Deallocation
	PROCEDURE Free(Ptr : IN OUT Node_Link) IS
	BEGIN
		Ptr := NULL;
	END Free;

	PROCEDURE Make_Empty(S : IN OUT Stack) IS
	BEGIN
		-- First release memory
		WHILE S.Last /= NULL LOOP
			Temp := S.Last;
			S.Last := Temp.Previous;
			Free(Temp);
			END LOOP;
	END Make_Empty;

	FUNCTION Is_Empty(S : Stack) RETURN BOOLEAN IS
	BEGIN
		RETURN S.Last = NULL;
	END Is_Empty;

	PROCEDURE Push(S : IN OUT Stack; E : Item) IS
	BEGIN
		Temp := New Node;
		IF Temp = NULL THEN
			RAISE Stack_Full;
		END IF;
		Temp.Previous := S.Last;
		Temp.Value := E;
		S.Last := Temp;
	END Push;

	PROCEDURE Pop(S : IN OUT Stack) IS
	BEGIN
		IF S.Last = NULL THEN
			RAISE Stack_Empty;
		END IF;
		Temp := S.Last;
		S.Last := Temp.Previous;
		Free(Temp);
	END Pop;

	FUNCTION Top(S : Stack) RETURN Item IS
	BEGIN
		IF S.Last = NULL THEN
			RAISE Stack_Empty;
		END IF;
		RETURN S.Last.Value;
	END Top;
BEGIN
	-- Nothing to do here!
	NULL;
END Stk;

-- To instantiate the package use:
-- PACKAGE My_Stack IS NEW($); USE My_Stack;
