-- JANUS.ADA   Ver. 2.02   4-SEP-1992   Copyright 1988-1992 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- Compile this before compiling ADA_TUTR.ADA, when using a PC with Janus/Ada.
--
with TEXT2_IO; use TEXT2_IO;
package CUSTOM_IO is
   type COLOR is (BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE);
   FOREGRND_COLOR   : COLOR := WHITE;                 -- Default values in case
   BACKGRND_COLOR   : COLOR := BLACK;                 -- ADA-TUTR finds no User
   BORDER_COLOR     : COLOR := BLACK;                 -- File.
   FORE_COLOR_DIGIT : CHARACTER := CHARACTER'VAL(COLOR'POS(FOREGRND_COLOR)+48);
   BACK_COLOR_DIGIT : CHARACTER := CHARACTER'VAL(COLOR'POS(BACKGRND_COLOR)+48);
   NORMAL_COLORS    : STRING(1 .. 10) := ASCII.ESC & "[0;3" &
                            FORE_COLOR_DIGIT & ";4" & BACK_COLOR_DIGIT & "m";
   CLEAR_SCRN       : constant STRING := ASCII.ESC & "[H" & ASCII.ESC &"[2J";

   procedure SET_BORDER_COLOR (TO   : In COLOR);
   procedure GET              (CHAR : out CHARACTER);
   procedure PUT              (CHAR : in  CHARACTER) renames TEXT2_IO.PUT;
   procedure PUT              (STR  : in  STRING)    renames TEXT2_IO.PUT;
   procedure PUT_LINE         (STR  : in  STRING)    renames TEXT2_IO.PUT_LINE;
   procedure GET_LINE         (STR  : out STRING;
                               LAST : out NATURAL)   renames TEXT2_IO.GET_LINE;
   procedure NEW_LINE(SPACING : in POSITIVE_COUNT := 1)
                                                     renames TEXT2_IO.NEW_LINE;
end CUSTOM_IO;

with DOSCALL, SYSTEM; use DOSCALL, SYSTEM;
package body CUSTOM_IO is
    procedure SET_BORDER_COLOR(TO : in COLOR) is
        --
        -- This procedure sets the border color on a PC by calling interrupt
        -- 10 hex.  Before the call, register AH is set to service number
        -- 0B hex, BH is set to zero, and BL is set to an integer as shown in
        -- the declaration of Color_Number below.  Note that the integers in
        -- Color_Number are bit reversed from the integers defining foreground
        -- and background colors in ANSI escape sequences.  Note also that some
        -- color PCs don't have separate border colors.
        --
        REGS         : SIMPLE_REGS;
        COLOR_NUMBER : constant array(COLOR) of SYSTEM.WORD :=
            (BLACK   => 0,   RED     => 4,   GREEN   => 2,   YELLOW  => 6,
             BLUE    => 1,   MAGENTA => 5,   CYAN    => 3,   WHITE   => 7);
    begin
        REGS.AX := 16#0B00#;
        REGS.BX := 16#0000# + Color_Number(To);
        SIMPLE_INT_CALL(INT_NUM => 16#10#, REGS => REGS);
    end SET_BORDER_COLOR;

    procedure GET(CHAR : out CHARACTER) is
        REGS : SIMPLE_REGS;
    begin
        REGS.AX := 16#0800#;
        SIMPLE_INT_CALL(INT_NUM => 16#21#, REGS => REGS);
        CHAR := CHARACTER'VAL(REGS.AX mod 128);
    end GET;
end CUSTOM_IO;
