program test;

var ffrom,fto:file;
var typ:word;

procedure getheader; { EB BE, BE EB 8C 00 }
var a:word;
begin
  writeln('source: getting header ...');
  seek(ffrom,0);
  blockread(ffrom,a,2);
  if a=$BEEB then begin
    typ:= $BEEB;
    writeln('Compression type: 4DOS <6.02');
  end else if a<>$EBBE then begin
    writeln('source: not a valid compressed .BTM file. halt.');
    halt(1);
  end else begin
    blockread(ffrom,a,2);
    if a<>$008C then begin
      writeln('source: looks like compression type 4DOS >=6.02, but unknown subtype');
      writeln('source: not a valid compressed .BTM file. halt.');
      halt(1);
    end;
    typ:=a;
    writeln('Compression type: 4DOS >=6.02 (subtype 008C)');
  end;
end;

var len,outp:word;

procedure getlength;
begin
  writeln('source: getting length of original batch-file ...');
  case typ of
    $BEEB: seek(ffrom,2);
    $008C: seek(ffrom,4);
    else begin
      writeln('getlength: invalid type');
      halt(1);
    end;
  end;
  blockread(ffrom,len,2);
  outp:=0;
end;

var token:array[2..$1F] of byte;

procedure gettoken;
var i:byte;
begin
  writeln('source: getting list of 32 most frequently used chars ...');
  case typ of
    $BEEB: begin
        seek(ffrom,4);
        blockread(ffrom,token,$1E);
      end;
    $008C: begin
        seek(ffrom,6);
        blockread(ffrom,token,$1E);
        for i:=2 to $1E do
          token[i]:=token[i] xor token[i+1]; {note: last token is unencrypted}
      end;
    else begin
      writeln('gettoken: invalid type');
      halt(1);
    end;
  end;
end;

var pos:word;
    lower:boolean;
    posval:byte;

function getnextnibble:byte;
begin
  if lower then begin
    inc(pos);
    blockread(ffrom,posval,1);
    getnextnibble:=posval shr 4;
  end else begin
    getnextnibble:=posval and $F;
  end;
  lower:=not lower;
end;

procedure convert;
var n,v:byte;
    line:word;
begin
  line:=1;
  case typ of
    $BEEB: pos:=$21; {note: set counters to "lower nibble of byte before first byte of stream read}
    $008C: pos:=$23; {so the code correctly starts at first (=upper) nibble of first data byte}
    else begin
      writeln('convert: invalid type');
      halt(1);
    end;
  end;
  write('converted line       ');
  lower:=true;
  while not (outp=len) do begin
    n:=getnextnibble;
    case n of
      0: begin
	   v:=getnextnibble;
           v:=v+(getnextnibble shl 4);
	 end;
      1: v:=token[$10+getnextnibble];
      else v:=token[n];
    end;
    blockwrite(fto,v,1);
    if v=$0d then begin
      v:=$0a;
      blockwrite(fto,v,1);
      write(#8#8#8#8#8#8,line:6);
      inc(line);
    end;
    inc(outp);
  end;
  writeln;
end;

begin
  writeln('4DECOMP 1.01 - (c) 1999 by Akisoft, Vienna');
  writeln('decompresses 4DOS 5.0 & 6.02 .BTM-files compressed with BATCOMP');
  writeln;
  if paramcount<2 then begin
    writeln('usage: 4DECOMP source-file destination-file');
    writeln;
    writeln('Note: destination-file will be overwritten.');
    halt;
  end;
  assign(ffrom,paramstr(1));
  assign(fto,paramstr(2));
  reset(ffrom,1);
  rewrite(fto,1);
  getheader;
  getlength;
  gettoken;
  convert;
  writeln('closing files ...');
  close(ffrom);
  close(fto);
  writeln('finished!');
end.
