;*************************************************
;*      Programm......... CPC-TERMINATE          *
;*      Autor............ Wolfgang Noisternig    *
;*      Start............ 07.10.1992             *
;*      Letzte Aenderung. 25.11.1992             *
;*      Auftrag von...... DMV-Verlag             *
;*                        Abt. CPC Amstrad Int.  *
;*************************************************

	ORG	#8000

	NoList
	WRITE	"TERMINAT.BIN"

zsatz	EQU	#9000		; Zeichensatz
inch	EQU	#9800		; Eingangs Chain
outch	EQU	#9900		; Ausgangs Chain
init	EQU	#9A00		; laenge + 40 Zeichen
dial	EQU	init+41		; laenge + 20 Zeichen
comm	EQU	dial+21		; laenge + 20 Zeichen
hangup	EQU	comm+21		; laenge + 20 Zeichen
adresse	EQU	hangup+21	; Port-Adresse
speed	EQU	adresse+1	; BPS-Rate
taswart	EQU	speed+1		; tastenwartewert
ctsrts	EQU	taswart+1	; CTS/RTS Pruefung an/aus
spewar	EQU	ctsrts+1	; Warteschleife fuer Upload
ftast	EQU	spewar+1	; F-Tasten
soh	EQU	#01		;
eot	EQU	#04		;
ack	EQU	#06		;
nak	EQU	#15		;
can	EQU	#18		;

	LD	HL,messoff	;
	CALL	#BCD4		;
	JP	NC,#0000	; Keine Floppy!!! => RESET
	LD	A,#01		;
	CALL	#001B		;
	LD	HL,gedtab	;
	LD	DE,gedtab+1	;
	LD	BC,#004F	;
	LD	(HL),B		;
	LDIR			;
	INC	HL		;
	PUSH	HL		;
	POP	IX		;
	LD	HL,ftast	;
	LD	B,#28		;
init2	LD	A,L		;
	LD	(IX+0),A	;
	LD	A,H		;
	LD	(IX+1),A	;
	LD	DE,#0029	;
	ADD	HL,DE		;
	INC	IX		;
	INC	IX		;
	DJNZ	init2		;
	LD	BC,#7FC4	;
	LD	HL,#4000	;
	LD	(HL),#00	;
	OUT	(C),C		;
	LD	(HL),#FF	;
	LD	C,#C0		;
	OUT	(C),C		;
	LD	A,(HL)		;
	OR	A		; 128kB vorhanden
	JR	Z,init1		;
	LD	A,#02		; 64kB vorhanden
init1	LD	HL,div		;
	OR	(HL)		;
	LD	(HL),A		;
	LD	A,#C9		;
	LD	(#BB5A),A	;
	DI			;
	LD	HL,(#0039)	;
	LD	(orig+1),HL	;
	LD	(timin1+1),HL	;
	LD	HL,inter	;
	LD	(#0039),HL	;
	LD	A,#C9		;
	LD	(#BB5A),A	;
	LD	BC,#7F8E	;
	OUT	(C),C		;
	EI			;
	LD	A,(adresse)	;
	LD	B,A		;
	LD	C,#DC		;
	LD	A,#03		;
	OUT	(C),C		;
	OUT	(C),A		;
	LD	A,(speed)	;
	OUT	(C),C		;
	OUT	(C),A		;
	CALL	clrscr		;
	CALL	cursor		;
	LD	HL,info		;
	CALL	print_o		;
anf1	CALL	tasten		;
	JR	NC,anf1		;

	CALL	clrscr		;
	LD	HL,init		;
	JR	inchain		;

haupt	CALL	tasten		;
	PUSH	AF		;
	LD	HL,z_snd+1	;
z_snd	LD	A,#00		;
	OR	A		;
	JR	Z,haupt0	;
	DEC	(HL)		;
	JR	NZ,haupt0	;
	LD	DE,#0800	;
	CALL	sndaus		;
haupt0	POP	AF		;
	JR	NC,aus		;
	LD	B,A		;
sh_ctrl	LD	A,#00		;
	OR	A		;
	LD	A,B		;
	JP	NZ,steuer	;
	CP	#D0		;
	JR	NC,ftaste	;
haupt1	CALL	ors232		;
	CALL	outecho		;
	LD	HL,div		;
	BIT	2,(HL)		;
	JR	Z,aus		;
	CP	#0D		;
	LD	A,#0A		;
	CALL	Z,outecho	;
aus	CALL	iscr		;
	JR	Z,haupt		;
	PUSH	AF		;
	CALL	inlog		;
	CALL	zeichen		;
	POP	AF		;
	LD	HL,div		;
	BIT	2,(HL)		;
	JR	Z,haupt		;
	CP	#0D		;
	JR	NZ,haupt	;
	LD	A,#0A		;
	CALL	inlog		;
	CALL	zeichen		;
	JR	haupt		;

ftast2	INC	A		;
	JR	Z,aus		;
	SUB	#C9		;
	JR	ftaste1		;

ftaste	SUB	#DC		;
ftaste1	ADD	A,A		;
	LD	L,A		;
	LD	H,#00		;
	LD	DE,gedtab+80	;
	ADD	HL,DE		;
	LD	E,(HL)		;
	INC	HL		;
	LD	D,(HL)		;
	EX	DE,HL		;

inchain LD	B,(HL)		;
	INC	HL		;
	LD	DE,(psout)	;
	LD	C,B		;
inch1	LD	A,(HL)		;
	LD	(DE),A		;
	PUSH	BC		;
	PUSH	DE		;
	PUSH	HL		;
	CALL	outecho		;
	LD	HL,div		;
	BIT	2,(HL)		;
	JR	Z,inch2		;
	CP	#0D		;
	LD	A,#0A		;
	CALL	Z,outecho	;
inch2	POP	HL		;
	POP	DE		;
	POP	BC		;
	INC	HL		;
	INC	E		;
	DJNZ	inch1		;
	LD	(psout),DE	;
	LD	A,(zout)	;
	ADD	A,C		;
	LD	(zout),A	;
	JR	aus		;

steuer	CP	#E6		;
	JR	NC,ftast2	;
	CP	"H"		;
	LD	HL,hangup	;
	JR	Z,inchain	;
	CP	"C"		;
	LD	HL,comm		;
	JR	Z,inchain	;
	CP	"I"		;
	LD	HL,init		;
	JR	Z,inchain	;
	CP	"D"		;
	LD	HL,dial		;
	JR	Z,inchain	;
	CP	"R"		;
	JR	Z,crlf		;
	CP	"L"		;
	JR	Z,log		;
	CP	#0A		;
	JP	Z,do_load	;
	CP	#0B		;
	JP	Z,up_load	;
	CP	"E"		;
	JR	Z,echosw	;
	CP	#1B		;
	JP	NZ,haupt	;
reset	LD	BC,#7F8D	;
	EXX			;
	RST	#00		;

crlf	LD	A,#04		;
	JR	verkn		;

echosw	LD	A,#01		;
verkn	LD	HL,div		;
	XOR	(HL)		;
	LD	(HL),A		;
	JP	haupt		;

log	LD	HL,div		;
	BIT	3,(HL)		;
	JR	NZ,logend	;
	SET	3,(HL)		;
	LD	A,#C0		;
	LD	(logbnk),A	;
	LD	B,#7F		;
	OUT	(C),A		;
	LD	HL,#4000	;
	LD	(logad),HL	;
	LD	DE,log_ot	;
log1	CALL	getpos		;
	PUSH	HL		;
	PUSH	DE		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	POP	HL		;
	CALL	print_c		;
log2	CALL	tasten		;
	JR	NC,log2		;
	CALL	clrline		;
	POP	HL		;
	CALL	setpos		;
	LD	A,L		;
	OR	A		;
	CALL	Z,cursor	;
	JP	haupt		;

logend	LD	BC,#F801	;
	OUT	(C),C		;
	RES	3,(HL)		;
	LD	HL,(logad)	;
	LD	A,#40		;
	CP	H		;
	JR	NZ,slog1	;
	XOR	A		;
	OR	L		;
	JR	NZ,slog1	;
	LD	A,(logbnk)	;
	CP	#C0		;
	LD	DE,log_ct	;
	JR	Z,log1		;
slog1	CALL	ori_int		;
	CALL	getpos		;
	PUSH	HL		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,log_fra	;
	CALL	print_c		;
	CALL	getname		;
	POP	HL		;
	CALL	setpos		;
	XOR	A		;
	OR	B		;
	JP	Z,ende		;
	LD	HL,namzwi	;
	LD	DE,#0100	;
	XOR	A		;
	CALL	#BC8C		;
	JP	NC,diskerr	;
	LD	DE,(logad)	;
	LD	BC,#7FC0	;
	LD	HL,#4000	;
	OUT	(C),C		;
slog2	LD	A,(HL)		;
	CALL	#BC95		;
	JP	NC,diskerr	;
	INC	HL		;
slog3	LD	A,D		;
	CP	H		;
	JR	NZ,slog4	;
	LD	A,E		;
	CP	L		;
	JR	NZ,slog4	;
	LD	A,(logbnk)	;
	CP	C		;
	JR	Z,slog5		;
slog4	BIT	7,H		;
	JR	Z,slog2		;
	INC	C		;
	OUT	(C),C		;
	LD	HL,#4000	;
	JR	slog3		;
slog5	LD	A,#1A		;
	CALL	#BC95		;
	JP	NC,diskerr	;
	CALL	#BC8F		;
	JP	NC,diskerr	;
	JP	ende		;

getpos	LD	A,(xpos+1)	;
	LD	H,A		;
	LD	A,(ypos+1)	;
	LD	L,A		;
	RET			;

setpos	LD	A,H		;
	LD	(xpos+1),A	;
	LD	A,L		;
	LD	(ypos+1),A	;
	RET			;

do_load	LD	BC,#F801	;
	OUT	(C),C		;
	CALL	ori_int		;
	CALL	getpos		;
	PUSH	HL		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,do_frag	;
	CALL	print_c		;
	CALL	getname		;
	POP	HL		;
	CALL	setpos		;
	XOR	A		;
	OR	B		;
	JP	Z,ende		;
	LD	HL,namzwi	;
	LD	DE,#0100	;
	XOR	A		;
	CALL	#BC8C		;
	JP	NC,diskerr	;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,xm_frag	;
	CALL	print_c		;
do_lo1	CALL	tasten		;
	JR	NC,do_lo1	;
	CP	#1B		;
	JP	Z,ende		;
	CP	"A"		;
	JR	Z,do_lo2	;
	CP	"a"		;
	JR	Z,do_lo2	;
	CP	"X"		;
	JR	Z,do_lo2	;
	CP	"x"		;
	JR	NZ,do_lo1	;
do_lo2	PUSH	AF		;
	CALL	cursor		;
	CALL	return		;
	CALL	nline		;
	POP	AF		;
	CP	"A"		;
	JP	Z,adown		;
	CP	"a"		;
	JP	Z,adown		;

xmdo	DI			; X-MODEM-Download!
	LD	HL,timint	;
	LD	(#0039),HL	;
	EI			;
	CALL	tasten		;
	JR	NC,xmd1		;
	CP	#1B		;
	JP	Z,xmab		;
xmd1	LD	HL,block	;
	LD	(HL),#01	;
	INC	HL		;
	LD	(HL),#0A	;
	LD	A,nak		;
	CALL	tors232		;
	LD	B,#0A		;
xmdo1	PUSH	BC		;
	LD	HL,#0BB8	; 10sec.
	CALL	rcvti		;
	POP	BC		;
	JR	NC,xmdo2	;
	CP	soh		;
	JR	Z,xmdo3		;
xmdo2	LD	A,nak		;
	PUSH	BC		;
	CALL	tors232		;
	CALL	tasten		;
	POP	BC		;
	JR	NC,xmd2		;
	CP	#1B		;
	JP	Z,xmab		;
xmd2	DJNZ	xmdo1		;
	JP	xmab		; => Abbruch
xmdo3	LD	HL,#012C	; 1sec.
	CALL	rcvti		;
	JP	NC,xmab		; => kein Zeichen
	PUSH	AF		;
	CALL	rcvti		;
	POP	BC		;
	JP	NC,xmab		; => kein Zeichen
	CPL			;
	XOR	B		;
	JR	NZ,xmwd		; => neuer Versuch
	LD	A,(block)	;
	CP	B		;
	JR	NZ,xmber	; => Block error!
	LD	DE,bldat	;
	XOR	A		;
	LD	(crczwi),A	;
	LD	B,#80		;
xmdo4	PUSH	BC		;	
	CALL	rcvti		;
	POP	BC		;
	JR	NC,xmwd		; => kein Zeichen
	LD	(DE),A		;
	CALL	crc		;
	INC	DE		;
	DJNZ	xmdo4		;
	CALL	rcvti		;
	JR	NC,xmwd		; => kein Zeichen
	LD	B,A		;
	LD	A,(crczwi)	;
	XOR	B		;
	JR	NZ,xmwd		; => CRC-Error!
	LD	B,#80		;
	LD	DE,bldat	;
xmdo5	LD	A,(DE)		;
	CALL	#BC95		;
	JR	NC,xmder	; => Disk error!
	INC	DE		;
	DJNZ	xmdo5		;
	LD	A,ack		;
	CALL	ttis		;
	JR	NC,xmab		; => Abbruch
	CALL	ttir		;
	JR	NC,xmab		; => Abbruch
	LD	I,A		;
	CALL	tasten		;
	JR	NC,xmd3		;
	CP	#1B		;
	JR	Z,xmab		;
xmd3	LD	A,I		;
	CP	eot		;
	JR	Z,xmend		;
	CP	soh		;
	JR	NZ,xmwd		; => wrong data
	LD	HL,block	;
	INC	(HL)		;
	INC	HL		;
	LD	(HL),#0A	;
	JR	xmdo3		;

xmber	SUB	B		;
	JR	Z,xmwd		; => retry Block
	DEC	A		;
	JR	NZ,xmab		; => Abbruch
	CALL	purge		; => Block ignorieren
	JP	xmdo3		;

xmwd	CALL	purge		;
	CALL	s_nak		;
	LD	HL,blret	;
	DEC	(HL)		;
	JR	Z,xmab		;
	JP	xmdo3		;

xmend	LD	A,ack		;
	CALL	ttis		;
	CALL	#BC8F		;
	JP	ende		;

xmder	CALL	purge		;
xmder1	LD	A,can		;
	CALL	tors232		;
	JR	NC,xmder1	;
	JP	diskerr		;

xmab	CALL	purge		;
xmab1	LD	A,can		;
	CALL	tors232		;
	JR	NC,xmab1	;
	CALL	#BC8F		;
	JP	ende		;

ttir	LD	B,#0A		; HL = Wartezeit in 1/300sec.
ttir1	PUSH	BC		; Korrekt:
	CALL	rcvti		; A = Zeichen, Carry = 1
	POP	BC		; Fehler:
	RET	C		; A = 0, Carry = 0
	DJNZ	ttir1		;
	RET			;

ttis	LD	B,#0A		; A = Zeichen
ttis1	PUSH	BC		; Korrekt:
	CALL	tors232		; Carry = 1
	POP	BC		; Fehler:
	RET	C		; Carry = 0
	DJNZ	ttis1		;
	RET			;

crc	LD	C,A		;
	LD	A,(crczwi)	;
	ADD	A,C		;
	LD	(crczwi),A	;
	RET			;

adown	CALL	tasten		; ASCII-Download!
	JR	NC,adown1	;
	CP	#1B		;
	JR	Z,adown2	;
adown1	LD	A,(adresse)	;
	LD	B,A		;
	LD	C,#DC		;
	IN	A,(C)		;
	BIT	0,A		;
	JR	Z,adown		;
	INC	BC		;
	IN	A,(C)		;
	CP	#1A		;
	JR	Z,adown2	;
	PUSH	AF		;
	CALL	zeichen		;
	POP	AF		;
	CALL	#BC95		;
	JP	NC,diskerr	;
	JR	adown		;
adown2	CALL	#BC8F		;
	JP	ende		;

;crc_16	LD	B,#08		; A = Zeichen / HL = oldCRC
;crc1	SLA	A		;
;	RL	L		;
;	RL	H		;
;	JR	NC,crc2		;
;	LD	A,#10		;
;	XOR	H		;
;	LD	H,A		;
;	LD	A,#21		;
;	XOR	L		;
;	LD	L,A		;
;crc2	DJNZ	crc1		;
;	RET			;

up_load	LD	BC,#F801	;
	OUT	(C),C		;
	CALL	ori_int		;
	CALL	getpos		;
	PUSH	HL		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,up_frag	;
	CALL	print_c		;
	CALL	getname		;
	POP	HL		;
	CALL	setpos		;
	XOR	A		;
	OR	B		;
	JP	Z,ende		;
	LD	HL,namzwi	;
	LD	DE,#0100	;
	CALL	#BC77		;
	JP	NC,diskerr	;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,xm_frag	;
	CALL	print_c		;
up_lo1	CALL	tasten		;
	JR	NC,up_lo1	;
	CP	#1B		;
	JP	Z,ende		;
	CP	"A"		;
	JR	Z,up_lo2	;
	CP	"a"		;
	JR	Z,up_lo2	;
	CP	"X"		;
	JR	Z,up_lo2	;
	CP	"x"		;
	JR	NZ,up_lo1	;
up_lo2	PUSH	AF		;
	CALL	cursor		;
	CALL	return		;
	CALL	nline		;
	POP	AF		;
	CP	"A"		;
	JP	Z,a_up		;
	CP	"a"		;
	JP	Z,a_up		;

xup	LD	B,#3C		;
xup1	LD	HL,#012C	;
	PUSH	BC		;
	CALL	rcvti		;
	POP	BC		;
	JR	NC,xup2		;
	CP	nak		;
	JR	Z,xup3		;
xup2	DJNZ	xup		;
	JP	xupend		;
xup3	LD	HL,block	;
	LD	(HL),#01	;
	INC	HL		;
	LD	(HL),#00	;
xup4	LD	B,#80		;
	LD	DE,bldat	;
xup5	CALL	#BC80		;
	JR	NC,xup6		;
	LD	(DE),A		;
	INC	DE		;
	DJNZ	xup5		;
	JR	xup7		;
xup6	LD	A,#1A		;
	LD	(DE),A		;
	INC	DE		;
	DJNZ	xup6		;
	LD	HL,blret	;
	DEC	(HL)		;
xup7	XOR	A		;
	LD	(crczwi),A	;
xup_1	LD	A,soh		;
	CALL	tors232		;
	JR	NC,xup_1	;
xup_4	LD	A,(block)	;
	CALL	tors232		;
	JR	NC,xup_4	;
xup_5	LD	A,(block)	;
	CPL			;
	CALL	tors232		;
	JR	NC,xup_5	;
	LD	DE,bldat	;
	LD	B,#80		;
xup8	LD	A,(DE)		;
	CALL	crc		;
	LD	A,(DE)		;
	PUSH	DE		;
	PUSH	BC		;
xup_2	CALL	tors232		;
	JR	NC,xup_2	;
	POP	BC		;
	POP	DE		;
	INC	DE		;
	DJNZ	xup8		;
	LD	A,(crczwi)	;
xup_3	CALL	tors232		;
	JR	NC,xup_3	;
	LD	B,#0A		;
xup9	PUSH	BC		;
	LD	HL,#012C	;
	CALL	rcvti		;
	POP	BC		;
	JR	NC,xup10	;
	CP	ack		;
	JR	Z,xup11		;
	CP	nak		;
	JR	Z,xup7		;
	CP	can		;
	JR	Z,xupend	;
xup10	DJNZ	xup9		;
	JR	xupend		;
xup11	LD	HL,block	;
	INC	(HL)		;
	INC	HL		;
	LD	A,(HL)		;
	OR	A		;
	JR	Z,xup4		;
xup_6	LD	A,eot		;
	CALL	tors232		;
	JR	NC,xup_6	;
	LD	HL,#0BB8	;
	CALL	rcvti		;
xupend	JR	ende		;

xuperr	JP	diskerr		;

a_up	CALL	#BC80		;
	PUSH	AF		;
	CALL	zeichen		;
	POP	AF		;
	JR	C,a_up1		;
	LD	A,#1A		;
a_up1	CALL	tors232		;
	JR	NC,a_up1	;
	CP	#1A		;
	JR	NZ,a_up		;

ende	CALL	#BC7A		;
	CALL	getpos		;
	PUSH	HL		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	POP	HL		;
	CALL	setpos		;
	LD	A,L		;
	OR	A		;
	CALL	Z,cursor	;
	LD	BC,#F800	;
	OUT	(C),C		;

alt_int	LD	HL,inter	;
	DI			;
	LD	(#0039),HL	;
	EI			;
	JP	haupt		;

diskerr	CALL	#BC92		;
	CALL	#BC7D		;
	CALL	getpos		;
	PUSH	HL		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	LD	HL,fehler	;
	CALL	print_c		;
	DI			;
derr1	CALL	tasten		;
	JR	NC,derr1	;
	EI			;
	CALL	clrline		;
	POP	HL		;
	CALL	setpos		;
	LD	A,L		;
	OR	A		;
	CALL	Z,cursor	;
	LD	BC,#F800	;
	OUT	(C),C		;
	JR	alt_int		;

ori_int	DI			;
	LD	BC,#7F8E	;
	EXX			;
orig	LD	HL,#0000	;
	LD	(#0039),HL	;
	EI			;
	RET			;

print_c	CALL	print_o		;
	JP	cursor		;

print_o	LD	A,(HL)		;
	INC	HL		;
	CP	#1F		;
	JR	Z,print_p	;
	OR	A		;
	RET	Z		;
	PUSH	HL		;
	CALL	zeiaus		;
	POP	HL		;
	JR	print_o		;

print_p	LD	D,(HL)		;
	INC	HL		;
	LD	E,(HL)		;
	INC	HL		;
	EX	DE,HL		;
	CALL	setpos		;
	EX	DE,HL		;
	JR	print_o		;

getname	LD	B,#00		;
	LD	HL,namzwi	;
getnam1	PUSH	HL		;
	PUSH	BC		;
	DI			;
getnam2	CALL	tasten		;
	JR	NC,getnam2	;
	LD	B,A		;
	LD	A,(steuer+1)	;
	OR	A		;
	JR	Z,getnam2	;
	LD	A,B		;
	POP	BC		;
	POP	HL		;
	EI			;
	CP	#0D		;
	RET	Z		;
	CP	#08		;
	JR	Z,getnam3	;
	CP	"#"		;
	JR	C,getnam1	;
	CP	#7E		;
	JR	NC,getnam1	;
	JR	getnam4		;
getnam3	LD	A,B		;
	OR	A		;
	JR	Z,getnam1	;
	DEC	B		;
	DEC	HL		;
	LD	A,#08		;
	JR	getnam5		;
getnam4	LD	(HL),A		;
	LD	A,B		;
	CP	#0C		;
	JR	Z,getnam1	;
	LD	A,(HL)		;
	INC	B		;
	INC	HL		;
getnam5	PUSH	HL		;
	PUSH	BC		;
	CALL	zeichen		;
	POP	BC		;
	POP	HL		;
	JR	getnam1		;
	
clrscr	LD	BC,#1000	;
	LD	HL,#C000	; Bildschirm loeschen
	LD	DE,#C001	;
	LD	(HL),L		;
clrscr1	PUSH	BC		;
	LD	BC,#03FF	;
	LDIR			;
	POP	BC		;
	DJNZ	clrscr1		;
	LD	HL,#0000	;
	CALL	setpos		;
	LD	B,#C0		;
	LD	(scrver+1),BC	;
	LD	BC,#BC0C	;
	OUT	(C),C		;
	LD	BC,#BD30	;
	OUT	(C),C		;
	LD	BC,#BC0D	;
	OUT	(C),C		;
	LD	BC,#BD00	;
	OUT	(C),C		;

cursor	CALL	curpos		;
	LD	B,#08		;
cursor1	LD	A,#FF		;
	XOR	(HL)		;
	LD	(HL),A		;
	LD	A,#08		;
	ADD	A,H		;
	LD	H,A		;
	DJNZ	cursor1		;
	RET			;

nzei	LD	A,(ypos+1)	;
	CP	#18		;
	JR	Z,nzei1		;
	INC	A		;
	LD	(ypos+1),A	;
	RET			;
nzei1	LD	HL,(scrver+1)	;
	LD	DE,#0050	;
	ADD	HL,DE		;
	LD	A,#C7		;
	AND	H		;
	LD	H,A		;
	LD	(scrver+1),HL	;
	RRA			;
	RR	L		;
	AND	#03		;
	OR	#30		;
	LD	BC,#BC0C	;
	OUT	(C),C		;
	INC	B		;
	OUT	(C),A		;
	LD	BC,#BC0D	;
	OUT	(C),C		;
	INC	B		;
	OUT	(C),L		;
	LD	A,(xpos+1)	;
	PUSH	AF		;
	CALL	clrline		;
	POP	AF		;
	LD	(xpos+1),A	;
	RET			;

clrline	LD	A,#50		;
clrl1	SUB	#10		;
	PUSH	AF		;
	LD	(xpos+1),A	;
	CALL	curpos		;
clrl2	LD	D,H		;
	LD	E,L		;
	INC	DE		;
	LD	(HL),#00	;
	LDI:LDI:LDI:LDI		;
	LDI:LDI:LDI:LDI		;
	LDI:LDI:LDI:LDI		;
	LDI:LDI:LDI		;
	LD	DE,#07F1	;
	ADD	HL,DE		;
        JR	NC,clrl2	;
	POP	AF		;
	JR	NZ,clrl1	;
	RET			;

curpos
ypos	LD	DE,#0000	;
	LD	L,E		;
	LD	H,D		;
	ADD	HL,HL		;
	ADD	HL,HL		;
	ADD	HL,DE		;
	ADD	HL,HL		;
	ADD	HL,HL		;
	ADD	HL,HL		;
	ADD	HL,HL		;
scrver	LD	DE,#C000	;
	ADD	HL,DE		;
xpos	LD	DE,#0000	;
	ADD	HL,DE		;
	LD	I,A		;
	LD	A,H		;
	AND	#07		;
	OR	#C0		;
	LD	H,A		;
	LD	A,I		;
	RET			;

zeichen	CP	#0D		;
	JR	Z,return	;
	CP	#0C		;
	JP	Z,clrscr	;
	CP	#0A		;
	JR	Z,nline		;
	CP	#09		;
	JR	Z,tab		;
	CP	#08		;
	JR	Z,del		;
	CP	#07		;
	JR	Z,beep		;
	CALL	zeiaus		;
	JP	cursor		;

tab	CALL	cursor		;
	LD	A,(xpos+1)	;
	ADD	A,#08		;
	AND	#F8		;
	CP	#50		;
	JR	C,tab1		;
	XOR	A		;
tab1	LD	(xpos+1),A	;
	JR	Z,nline1	;
	JP	cursor		;

return	CALL	cursor		;
	XOR	A		;
	LD	(xpos+1),A	;
	JR	del1		;

nline	CALL	cursor		;
nline1	CALL	nzei		;
	JR	del1		;

beep	LD	DE,#0738	;
	CALL	sndaus		;
	LD	DE,#005A	;
	CALL	sndaus		;
	LD	DE,#080C	;
	CALL	sndaus		;
	LD	A,#50		;
	LD	(z_snd+1),A	;
	RET			;

zeiaus	CALL	curpos		;
	PUSH	HL		;
	LD	L,A		;
	LD	H,#00		;
	ADD	HL,HL		;
	ADD	HL,HL		;
	ADD	HL,HL		;
	LD	DE,zsatz	;
	ADD	HL,DE		;
	POP	DE		;
	LD	B,#08		;
zeiprt	LD	A,(HL)		;
	LD	(DE),A		;
	LD	A,#08		;
	ADD	A,D		;
	LD	D,A		;
	INC	HL		;
	DJNZ	zeiprt		;
	LD	A,(xpos+1)	;
	INC	A		:
	CP	#50		;
	JR	NZ,zei5		;
	CALL	nzei		;
	XOR	A		;
zei5	LD	(xpos+1),A	;
	RET			;

del	CALL	cursor		;
	LD	A,(xpos+1)	;
	OR	A		;
	JR	Z,del1		;
	DEC	A		;
	PUSH	AF		;
	LD	(xpos+1),A	;
	LD	A," "		;
	CALL	zeiaus		;
	POP	AF		;
	LD	(xpos+1),A	;
del1	JP	cursor		;

tasten	LD	BC,#F40E	; Alle Tasten abfragen
	OUT	(C),C		;
	LD	BC,#F6C0	;
	OUT	(C),C		;
	LD	C,#00		;
	OUT	(C),C		;
	LD	BC,#F792	;
	OUT	(C),C		;
	LD	HL,tastab	; Tabelle fuer die 10 Tastaturbytes
	LD	D,#40		;
tasspa	LD	B,#F6		;
	OUT	(C),D		;
	LD	B,#F4		;
	IN	A,(C)		;
	LD	(HL),A		;
	INC	HL		;
	INC	D		;
	LD	A,D		;
	CP	#4A		;
	JR	NZ,tasspa	;
	LD	BC,#F782	;
	OUT	(C),C		;
	LD	BC,#F600	;
	OUT	(C),C		;
	XOR	A		;
	LD	(sh_ctrl+1),A	;
	LD	A,(tastab+8)	;
	BIT	6,A		;
	JR	NZ,nocaps1	;

	OR	#40		;
	LD	(tastab+8),A	;
czaehl	LD	A,#01		;
	DEC	A		;
	LD	(czaehl+1),A	;
	JR	NZ,nocaps	;
caps	LD	A,#00		;
	XOR	#FF		;
	LD	(caps+1),A	;
	LD	A,#80		;
	LD	(czaehl+1),A	;
	JR	nocaps		;

nocaps1	LD	A,#01		;
	LD	(czaehl+1),A	;

nocaps	LD	A,(tastab+2)	;
	LD	HL,shift	;
	BIT	5,A		;
	JR	Z,tas1		;
	LD	HL,control	;
	BIT	7,A		;
	JR	Z,tas2		;
	LD	HL,normal	;
	JR	tas2		;
tas1	BIT	7,A		;
	JR	NZ,tas2		;
	LD	A,#FF		;
	LD	(sh_ctrl+1),A	;
tas2	LD	C,#0A		;
	OR	#A0		;
	LD	(tastab+2),A	;
	LD	IX,gedtab	;
	LD	DE,tastab	;
tas3	LD	B,#08		;
	LD	A,(DE)		;
tas4	RRCA			;
	JR	NC,gedr		;
	INC	HL		;
	INC	IX		;
	DJNZ	tas4		;
	INC	DE		;
	DEC	C		;
	JR	NZ,tas3		;
	LD	HL,(oldkey+1)	;
	LD	(HL),#00	;
nokey	XOR	A		;
	RET			;
gedr	XOR	A		;
	OR	(IX+0)		;
	JR	Z,ngedr		;
	DEC	(IX+0)		;
	JR	nokey		;
ngedr	LD	A,(HL)		;
	PUSH	AF		;
oldkey	LD	HL,gedtab	;
	LD	(HL),#00	;
	LD	A,(taswart)	;
	LD	(IX+0),A	;
	LD	(oldkey+1),IX	;
	LD	A,(caps+1)	;
	OR	A		;
	LD	A,(HL)		;
	JR	Z,tasend	;
	CP	"a"		;
	JR	C,tasend	;
	CP	"{"		;
	JR	NC,tasend	;
	SUB	#20		;
tasend	POP	AF		;
	SCF			;
	RET			;

inter	EXX			;
	EX	AF,AF'		;
	LD	HL,send1+1	;
send1	LD	A,#00		;
	OR	A		;
	JR	Z,send2		;
	DEC	(HL)		;
	JR	empf		;
send2	LD	HL,zout		;
	XOR	A		;
	OR	(HL)		;
	JR	Z,empf		;
	LD	HL,(phout)	;
	LD	A,(HL)		;
	CP	#FF		;
	JR	Z,send3		;
	CALL	tors232		;
	DI			;
	JR	NC,empf		;
send3	INC	L		;
	LD	(phout),HL	;
	LD	HL,zout		;
	DEC	(HL)		;
	INC	A		;
	JR	NZ,empf		;
	LD	A,#1E		;
	LD	(send1+1),A	;

empf	CALL	rcvch		;
	CALL	C,oscr		;
	EXX			;
	EX	AF,AF'		;
	EI			;
	RET			;

rcvch	LD	A,(adresse)	; Zeichen von RS232 holen.
	LD	B,A		; Korrekt:
	LD	C,#DC		; A = Zeichen, Carry = 1
	IN	A,(C)		; Fehler (kein Zeichen zu holen):
	BIT	0,A		; A = 0, Carry = 0
	JR	Z,rcvch1	;
	INC	BC		;
	IN	A,(C)		;
	SCF			;
	RET			;
rcvch1	XOR	A		;
	RET			;

rcvti	LD	(timer),HL	; x sec. auf Zeichen warten
	LD	A,#FF		;
	LD	(tizero),A	;
rcvti1	CALL	rcvch		; Eingaben:
	RET	C		; HL = Wartezeit (in 1/300 sec)
	LD	B,A		;
	LD	A,(tizero)	; Korrekt:
	OR	A		; A = Zeichen, Carry = 1
	LD	A,B		;
	RET	Z		; Fehler:
	JR	rcvti1		; A = 0, Carry = 0

timint	EXX			;
	EX	AF,AF'		;
	LD	HL,(timer)	;
	DEC	HL		;
	LD	(timer),HL	;
	LD	A,H		;
	OR	L		;
	LD	(tizero),A	;
	EX	AF,AF'		;
	EXX			;
timin1	JP	#0000		;

purge	LD	HL,#012C	;
	CALL	rcvti		;
	JR	NC,purge	;
	RET			;

s_nak	CALL	purge		;
	LD	A,nak		;
s_nak1	CALL	tors232		;
	JR	NC,s_nak1	;
	RET			;

ors232	LD	HL,(psout)	;
	LD	(HL),A		;
	INC	L		;
	LD	(psout),HL	;
	LD	HL,zout		;
	INC	(HL)		;
	RET			;

oscr	LD	HL,(psin)	;
	LD	(HL),A		;
	INC	L		;
	LD	(psin),HL	;
	LD	HL,zin		;
	INC	(HL)		;
	RET			;

iscr	LD	HL,zin		;
	XOR	A		;
	OR	(HL)		;
	RET	Z		;
	DEC	(HL)		;
	LD	HL,(phin)	;
	LD	A,(HL)		;
	INC	L		;
	LD	(phin),HL	;
	INC	H		;
	RET			;

outecho	LD	HL,div		;
	BIT	0,(HL)		;
	JR	Z,inlog		;
	PUSH	AF		;
	CALL	zeichen		;
	POP	AF		;

inlog	LD	HL,div		;
	BIT	3,(HL)		;
	RET	Z		;
	PUSH	AF		;
	LD	HL,(logad)	;
	LD	(HL),A		;
	INC	HL		;
	BIT	7,H		;
	JR	NZ,inlog1	;
	LD	(logad),HL	;
	POP	AF		;
	RET			;
inlog1	LD	A,(div)		;
	BIT	1,A		;
	JP	NZ,logend	;
	LD	A,(logbnk)	;
	INC	A		;
	LD	(logbnk),A	;
	CP	#C5		;
	JP	Z,logend	;
	LD	H,#40		;
	LD	(logad),HL	;
	OUT	(C),C		;
	POP	AF		;
	RET			;

sndaus	DI			;
	LD	B,#F4		;
	OUT	(C),D		;
	LD	BC,#F6C0	;
	OUT	(C),C		;
	LD	C,#00		;
	OUT	(C),C		;
	LD	B,#F4		;
	OUT	(C),E		;
	LD	BC,#F680	;
	OUT	(C),C		;
	LD	C,#00		;
	OUT	(C),C		;
	EI			;
	RET			;

tors232	PUSH	AF		;
	PUSH	DE		;
	LD	D,A		;
	LD	E,#02		;
	LD	A,(adresse)	;
	LD	B,A		;
	LD	C,#DC		;
	LD	A,(ctsrts)	;
	OR	A		;
	JR	NZ,tors2	;
	PUSH	HL		;
	LD	HL,(#0038)	;
	PUSH	HL		;
	LD	HL,#C9FB	;
	LD	(#0038),HL	;
	EI			;
	LD	A,(spewar)	;
tors1	HALT			;
	DEC	A		;
	JR	NZ,tors1	;
	POP	HL		;
	LD	(#0038),HL	;
	POP	HL		;
	JR	tors3		;
tors2	IN	A,(C)		;
	AND	E		;
	CP	E		;
        JR	Z,tors3		;
	POP	DE		;
	POP	AF		;
	OR	A		;
	RET			;
tors3	INC	BC		;
	OUT	(C),D		;
	POP	DE		;
	POP	AF		;
	SCF			;
	RET			;

obtxt	CALL	getpos		;
	PUSH	HL		;
	PUSH	DE		;
	XOR	A		;
	LD	(ypos+1),A	;
	CALL	clrline		;
	POP	DE		;
	CALL	print_c		;
	CALL	getname		;
	POP	HL		;
	JP	setpos		;

tastab	DS	#0A		; 10 Bytes fuer Tastaturabfrage

normal	BYTE	#0B,#09,#0A,#E5,#E2,#DF,#FF,#FF	; Spalte 0
	BYTE	#08,#FC,#E3,#E4,#E1,#DD,#DE,#DC ; Spalte 1
	BYTE	#10,"[",#0D,"]",#E0,#FF,"\",#FF ; Spalte 2
	BYTE	"^","-","@","p",";",":","/","." ; Spalte 3
	BYTE	"0","9","o","i","l","k","m","," ; Spalte 4
	BYTE	"8","7","u","y","h","j","n"," " ; Spalte 5
	BYTE	"6","5","r","t","g","f","b","v" ; Spalte 6
	BYTE	"4","3","e","w","s","d","c","x" ; Spalte 7
	BYTE	"1","2",#1B,"q",#09,"a",#FF,"z" ; Spalte 8
	BYTE	#FF,#FF,#FF,#FF,#FF,#FF,#FF,#08	; Spalte 9

shift	BYTE	#0B,#09,#0A,#EF,#EC,#E9,#FF,#FF	; Spalte 0
	BYTE	#08,#FC,#ED,#EE,#EB,#E7,#E8,#E6 ; Spalte 1
	BYTE	#10,"{",#0D,"}",#EA,#FF,"`",#FF ; Spalte 2
	BYTE	#A3,"=","|","P","+","*","?",">" ; Spalte 3
	BYTE	"_",")","O","I","L","K","M","<" ; Spalte 4
	BYTE	"(","'","U","Y","H","J","N"," " ; Spalte 5
	BYTE	"&","%","R","T","G","F","B","V" ; Spalte 6
	BYTE	"$","#","E","W","S","D","C","X" ; Spalte 7
	BYTE	"!",'"',#1B,"Q",#09,"A",#FF,"Z" ; Spalte 8
	BYTE	#FF,#FF,#FF,#FF,#FF,#FF,#FF,#08	; Spalte 9

control	BYTE	#0B,#09,#0A,#F9,#F6,#F3,#FF,#FF	; Spalte 0
	BYTE	#08,#FC,#F7,#F8,#F5,#F1,#F2,#F0 ; Spalte 1
	BYTE	#10,#1B,#0D,#1D,#F4,#FF,#1C,#FF ; Spalte 2
	BYTE	#1E,#FF,#00,#10,#FF,#FF,#FF,#FF ; Spalte 3
	BYTE	#1F,#FF,#0F,#09,#0C,#0B,#0D,#FF ; Spalte 4
	BYTE	#FF,#FF,#15,#19,#08,#0A,#0E,#FF ; Spalte 5
	BYTE	#FF,#FF,#12,#14,#07,#06,#02,#16 ; Spalte 6
	BYTE	#FF,#FF,#05,#17,#13,#04,#03,#18 ; Spalte 7
	BYTE	#FF,"~",#1B,#11,#09,#01,#FF,#1A ; Spalte 8
	BYTE	#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF	; Spalte 9

messoff	DEFB	#81				;

do_frag	TEXT	"Bitte Downloaddateinamen ein"	;
	TEXT	"geben: ",0			;

up_frag	TEXT	"Bitte Uploaddateinamen ein"	;
	TEXT	"geben: ",0			;

delstr	DEFB	#08," ",#08,#00			;

namzwi	DEFS	#0D				;

log_ct	TEXT	"Logfile wurde geschlossen! "	;
	TEXT	"Es war aber nichts protokol"	;
	TEXT	"liert!  TASTE ",0		;

log_ot	TEXT	"Neues Logfile wird ge",#94	;
	TEXT	"ffnet!  TASTE ",0		;

log_fra	TEXT	"Bitte Logfiledateinamen ein"	;
	TEXT	"geben: ",0			;

fehler	TEXT	"Fehler bei Diskettenzugriff"	;
	TEXT	" ... Funktion abgebrochen -"	;
	TEXT	" TASTE dr",#81,"cken",0	;

xm_frag	TEXT	"[A]SCII oder [X]MODEM ? ",0	;

info	DEFB	#1F,#1D,#00			;
	TEXT	#C9,#CD,#CD,#CD,#CD		;
	TEXT	#CD,#CD,#CD,#CD,#CD,#CD,#CD,#CD	;
	TEXT	#CD,#CD,#CD,#CD,#CD,#CD,#CD,#CD	;
	TEXT	#BB,#1F,#1D,#01,#BA		;
	TEXT	" CPC-TERMINATE  0.8 "		;
	TEXT	#BA,#1F,#1D,#02,#C8,#CD,#CD,#CD	;
	TEXT	#CD,#CD,#CD,#CD,#CD,#CD,#CD,#CD	;
	TEXT	#CD,#CD,#CD,#CD,#CD,#CD,#CD,#CD	;
	TEXT	#CD,#BC				;
	DEFB	#1F,#0E,#06			;
	TEXT	"Terminalprogramm f",#81,"r die";
	TEXT	" serielle Schnittstelle aus"	;
	DEFB	#1F,#14,#08			;
	TEXT	"CPC Amstrad International "	;
	TEXT	"Juni/Juli 1992"		;
	DEFB	#1F,#19,#0C			;
	TEXT	"Programmiert von W. Noisternig";
	DEFB	#1F,#19,#0E			;
	TEXT	"f",#81,"r: CPC Amstrad "	;
	TEXT	"International"			;
	DEFB	#1F,#1E,#11			;
	TEXT	"Wolfgang  Noisternig"		;
	DEFB	#1F,#1D,#12			;
	TEXT	"Friedrich-Ebert-Str.27"	;
	DEFB	#1F,#21,#13			;
	TEXT	"2418 Ratzeburg"		;
	DEFB	#1F,#21,#14			;
	TEXT	"FIDO 2:240/110"		;
	DEFB	#1F,#21,#15			;
	TEXT	"INFOX 85:200/1"		;
	DEFB	#1F,#19,#16			;
	TEXT	"TransVision BBS +49-4541-84944";
	DEFB	#1F,#21,#18			;
	TEXT	"TASTE  DR",#9A,"CKEN",0	;

timer	DEFW	0				;
tizero	DEFB	0				;
psout	DEFW	outch				;Schreibkette fuer RS232
phout	DEFW	outch				;Lesekette fuer RS232
psin	DEFW	inch				;Schreibekette fuer Screen
phin	DEFW	inch				;Lesekette fuer Screen
zout	DEFB	#00				;RS232-Kettenlaenge
zin	DEFB	#00				;Screen-Kettenlaenge
div	DEFB	#00				;Bit       0     1
						; 0  Echo Aus   An
                                                ; 1  128k Ja    Nein
						; 2  CR   CR	CRLF
						; 3  Log  aus   an
logad	DEFW	#4000				;Aktuelle Logadresse
logbnk	DEFB	#C0				;Aktuelle Speicherbank fuer Log
gedtab	DEFB	0				;
block	DEFB	#00		; gew. Blocknummer
blret	DEFB	#00		; Empfangsversuche fuer Block
crczwi	DEFB	#00		;
bldat	DEFS	128		; Blockdaten
