/**********************************************************
	RIPROMS2.C - (c) Various sources
	       (put together by Sammy)
 **********************************************************/

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif

#define MAXCODE(n_bits) ((1 << (n_bits)) - 1)
#define htabof(i) htab[i]
#define codetabof(i) codetab[i]
#define tab_prefixof(i) codetabof(i)
#define tab_suffixof(i) ((char_type *)(htab))[i]
#define de_stack ((char_type *)&tab_suffixof(1<<16))

typedef unsigned char Byte;
typedef int code_int;
typedef int count_int;
typedef unsigned char char_type;
typedef enum {FNOERR, FEND, FRWERR} Ferror; 
typedef enum {NOERR, RERR, WERR, CRCERR} Status;

typedef struct
{
  long offset, length;
} Basic;

typedef struct
{
  long offset;
  unsigned char value;
} Os;

static int n_bits;
static int maxbits;
static code_int maxcode;
static code_int maxmaxcode;
static count_int htab[65536];
static unsigned short codetab[65536];
static char_type rmask[9] ={0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff};
static code_int free_ent;
static int clear_flg;
static long readsize;
static int offset, size;

long writesize;
long crc;
long crcsize;

Byte TestArc[] = {26,255,33,82,117,110,73,109,97,103,101,0,0,0,0,48,212,0,0,
	178,24,99,95,115,45,200,253,0,0,67,250,255,255,232,93,210,223,19,222};

static unsigned long crctable[256] = {
    0x0000,0xc0c1,0xc181,0x0140,0xc301,0x03c0,0x0280,0xc241,
    0xc601,0x06c0,0x0780,0xc741,0x0500,0xc5c1,0xc481,0x0440,
    0xcc01,0x0cc0,0x0d80,0xcd41,0x0f00,0xcfc1,0xce81,0x0e40,
    0x0a00,0xcac1,0xcb81,0x0b40,0xc901,0x09c0,0x0880,0xc841,
    0xd801,0x18c0,0x1980,0xd941,0x1b00,0xdbc1,0xda81,0x1a40,
    0x1e00,0xdec1,0xdf81,0x1f40,0xdd01,0x1dc0,0x1c80,0xdc41,
    0x1400,0xd4c1,0xd581,0x1540,0xd701,0x17c0,0x1680,0xd641,
    0xd201,0x12c0,0x1380,0xd341,0x1100,0xd1c1,0xd081,0x1040,
    0xf001,0x30c0,0x3180,0xf141,0x3300,0xf3c1,0xf281,0x3240,
    0x3600,0xf6c1,0xf781,0x3740,0xf501,0x35c0,0x3480,0xf441,
    0x3c00,0xfcc1,0xfd81,0x3d40,0xff01,0x3fc0,0x3e80,0xfe41,
    0xfa01,0x3ac0,0x3b80,0xfb41,0x3900,0xf9c1,0xf881,0x3840,
    0x2800,0xe8c1,0xe981,0x2940,0xeb01,0x2bc0,0x2a80,0xea41,
    0xee01,0x2ec0,0x2f80,0xef41,0x2d00,0xedc1,0xec81,0x2c40,
    0xe401,0x24c0,0x2580,0xe541,0x2700,0xe7c1,0xe681,0x2640,
    0x2200,0xe2c1,0xe381,0x2340,0xe101,0x21c0,0x2080,0xe041,
    0xa001,0x60c0,0x6180,0xa141,0x6300,0xa3c1,0xa281,0x6240,
    0x6600,0xa6c1,0xa781,0x6740,0xa501,0x65c0,0x6480,0xa441,
    0x6c00,0xacc1,0xad81,0x6d40,0xaf01,0x6fc0,0x6e80,0xae41,
    0xaa01,0x6ac0,0x6b80,0xab41,0x6900,0xa9c1,0xa881,0x6840,
    0x7800,0xb8c1,0xb981,0x7940,0xbb01,0x7bc0,0x7a80,0xba41,
    0xbe01,0x7ec0,0x7f80,0xbf41,0x7d00,0xbdc1,0xbc81,0x7c40,
    0xb401,0x74c0,0x7580,0xb541,0x7700,0xb7c1,0xb681,0x7640,
    0x7200,0xb2c1,0xb381,0x7340,0xb101,0x71c0,0x7080,0xb041,
    0x5000,0x90c1,0x9181,0x5140,0x9301,0x53c0,0x5280,0x9241,
    0x9601,0x56c0,0x5780,0x9741,0x5500,0x95c1,0x9481,0x5440,
    0x9c01,0x5cc0,0x5d80,0x9d41,0x5f00,0x9fc1,0x9e81,0x5e40,
    0x5a00,0x9ac1,0x9b81,0x5b40,0x9901,0x59c0,0x5880,0x9841,
    0x8801,0x48c0,0x4980,0x8941,0x4b00,0x8bc1,0x8a81,0x4a40,
    0x4e00,0x8ec1,0x8f81,0x4f40,0x8d01,0x4dc0,0x4c80,0x8c41,
    0x4400,0x84c1,0x8581,0x4540,0x8701,0x47c0,0x4680,0x8641,
    0x8201,0x42c0,0x4380,0x8341,0x4100,0x81c1,0x8081,0x4040
   };

Basic grab[] = {
  {0x4BC8,0x0038}, {0x4C38,0x0008}, {0x4C50,0x0030}, {0x4CF0,0x0010},
  {0x4D1C,0x0024}, {0x4D60,0x0020}, {0x4DAC,0x0014}, {0x4DE8,0x0018},
  {0x4E18,0x0028}, {0x4E50,0x0030}, {0x4E88,0x0038}, {0x4EF8,0x0008},
  {0x4F2C,0x0014}, {0x4F70,0x0010}, {0x4FB0,0x0010}, {0x4FEC,0x0014},
  {0x5034,0x000C}, {0x5070,0x0010}, {0x50BC,0x0004}, {0x50F0,0x0010},
  {0x5120,0x0020}, {0x5164,0x001C}, {0x51B0,0x0010}, {0x51D4,0x002C},
  {0x5230,0x0010}, {0x5254,0x002C}, {0x52B4,0x000C}, {0x52F8,0x0008},
  {0x5330,0x0010}, {0x5374,0x000C}, {0x53B4,0x000C}, {0x53EC,0x0014},
  {0x5438,0x0008}, {0x5448,0x0038}, {0x54EC,0x0014}, {0x551C,0x0024},
  {0x5560,0x0020}, {0x55A8,0x0018}, {0x55FC,0x0004}, {0x5618,0x0028},
  {0x5654,0x002C}, {0x5688,0x0038}, {0x56FC,0x0004}, {0x572C,0x0014},
  {0x5770,0x0010}, {0x57B0,0x0010}, {0x57EC,0x0014}, {0x5834,0x000C},
  {0x5870,0x0010}, {0x58BC,0x0004}, {0x58F0,0x0010}, {0x5920,0x0020},
  {0x5964,0x001C}, {0x59B0,0x0010}, {0x59D4,0x002C}, {0x5A30,0x0010},
  {0x5A54,0x002C}, {0x5AB4,0x000C}, {0x5B30,0x0010}, {0x5B74,0x000C},
  {0x5BB4,0x000C}, {0x5BFC,0x0004}, {0x5C38,0x0008}, {0x5C48,0x0038},
  {0x5CD0,0x0030}, {0x5D1C,0x0024}, {0x5D64,0x001C}, {0x5DAC,0x0014},
  {0x5DD4,0x002C}, {0x5E18,0x0028}, {0x5E58,0x0028}, {0x5EA0,0x0020},
  {0x5EEC,0x0014}, {0x5F2C,0x0014}, {0x5F74,0x000C}, {0x5FB4,0x000C},
  {0x5FEC,0x0014}, {0x6034,0x000C}, {0x6070,0x0010}, {0x60D0,0x0030},
  {0x6120,0x0020}, {0x6168,0x0018}, {0x61B4,0x000C}, {0x61E0,0x0020},
  {0x6230,0x0010}, {0x6254,0x002C}, {0x62B8,0x0008}, {0x62D0,0x0030},
  {0x6330,0x0010}, {0x6378,0x0008}, {0x63B8,0x0008}, {0x63F0,0x0010},
  {0x6448,0x0038}, {0x648C,0x0034}, {0x64D4,0x002C}, {0x6524,0x001C},
  {0x6570,0x0010}, {0x65B8,0x0008}, {0x65D8,0x0028}, {0x6620,0x0020},
  {0x665C,0x0024}, {0x66A4,0x001C}, {0x66E8,0x0018}, {0x6734,0x000C},
  {0x6778,0x0008}, {0x67EC,0x0014}, {0x683C,0x0004}, {0x6878,0x0008},
  {0x688C,0x0034}, {0x68D8,0x0028}, {0x6928,0x0018}, {0x696C,0x0014},
  {0x69D0,0x0030}, {0x6A38,0x0008}, {0x6A58,0x0028}, {0x6AEC,0x0014},
  {0x6B38,0x0008}, {0x6B7C,0x0004}, {0x6BE8,0x0018}, {0x6C2C,0x0014},
  {0x6C50,0x0030}, {0x6CB4,0x000C}, {0x6CD8,0x0028}, {0x6D18,0x0028},
  {0x6D58,0x0028}, {0x6D9C,0x0024}, {0x6DD4,0x002C}, {0x6E28,0x0018},
  {0x6E50,0x0030}, {0x6E88,0x0038}, {0x6EE0,0x0020}, {0x6F20,0x0020},
  {0x6F60,0x0020}, {0x6FA4,0x001C}, {0x6FEC,0x0014}, {0x7028,0x0018},
  {0x7064,0x001C}, {0x70B4,0x000C}, {0x70DC,0x0024}, {0x711C,0x0024},
  {0x715C,0x0024}, {0x71A0,0x0020}, {0x71D0,0x0030}, {0x7224,0x001C},
  {0x7254,0x002C}, {0x72B4,0x000C}, {0x72E0,0x0020}, {0x7324,0x001C},
  {0x7364,0x001C}, {0x73AC,0x0014}, {0x73D8,0x0028}, {0x7438,0x0008},
  {0x7458,0x0028}, {0x74BC,0x0004}, {0x74DC,0x0024}, {0x751C,0x0024},
  {0x755C,0x0024}, {0x75A4,0x001C}, {0x75D0,0x0030}, {0x7618,0x0028},
  {0x7650,0x0030}, {0x7688,0x0038}, {0x76EC,0x0014}, {0x772C,0x0014},
  {0x776C,0x0014}, {0x77AC,0x0014}, {0x77EC,0x0014}, {0x7834,0x000C},
  {0x7870,0x0010}, {0x78B8,0x0008}, {0x78E0,0x0020}, {0x7920,0x0020},
  {0x7960,0x0020}, {0x79AC,0x0014}, {0x79D4,0x002C}, {0x7A30,0x0010},
  {0x7A54,0x002C}, {0x7AF0,0x0010}, {0x7B30,0x0010}, {0x7B70,0x0010},
  {0x7BB0,0x0010}, {0x7BE4,0x001C}, {0x7C3C,0x0004}, {0x7C50,0x0030},
  {0x7C88,0x0038}, {0x7CE8,0x0018}, {0x7D28,0x0018}, {0x7D6C,0x0014},
  {0x7DB8,0x0008}, {0x7DD4,0x002C}, {0x7E24,0x001C}, {0x7E54,0x002C},
  {0x7E88,0x0038}, {0x7EF8,0x0008}, {0x7F38,0x0008}, {0x7F74,0x000C},
  {0x7FEC,0x0014}, {0x807C,0x0004}, {0x808C,0x0034}, {0x80D0,0x0030},
  {0x812C,0x0014}, {0x8168,0x0018}, {0x81D0,0x0030}, {0x823C,0x0004},
  {0x8254,0x002C}, {0x82D0,0x0030}, {0x833C,0x0004}, {0x8378,0x0008},
  {0x83E4,0x001C}, {0x8450,0x0030}, {0x848C,0x0034}, {0x84E8,0x0018},
  {0x8524,0x001C}, {0x856C,0x0014}, {0x85B8,0x0008}, {0x85D4,0x002C},
  {0x8620,0x0020}, {0x864C,0x0034}, {0x8688,0x0038}, {0x86F8,0x0008},
  {0x8734,0x000C}, {0x8774,0x000C}, {0x87EC,0x0014}, {0x883C,0x0004},
  {0x8878,0x0008}, {0x888C,0x0034}, {0x88D0,0x0030}, {0x8928,0x0018},
  {0x8968,0x0018}, {0x89D0,0x0030}, {0x8A38,0x0008}, {0x8A58,0x0028},
  {0x8AD0,0x0030}, {0x8B38,0x0008}, {0x8B78,0x0008}, {0xD644,0x2784},
  {-1, -1}
};

Os patch[] = {
  {4040, 0240},    {4041, 07},       {4158, 012},    {4159, 052},
  {7330, 0255},    {7331, 010},      {7332, 0376},   {7706, 054},
  {7707, 0327},    {7708, 02},       {12505, 010},   {12506, 0220},
  {12507, 02},     {12508, 0240},    {12509, 0356},  {12654, 0376},
  {12657, 0336},   {12658, 0241},    {12659, 02},    {12660, 020},
  {12661, 015},    {-1, 0}
};

void calccrc(Byte byte)
{
    if (crcsize-- > 0)
	crc = ((crc >> 8) & 0xff) ^ crctable[(crc ^ byte) & 0xff];
}

Ferror check_stream(FILE *fp)
{
    Ferror ret = FNOERR;
    if (feof(fp)) ret = FEND;
    else if (ferror(fp)) ret = FRWERR;
    if (ret != FNOERR) clearerr(fp);
    return (ret);
}

void write_byte(FILE *ofp, Byte byte)
{
    if (writesize-- > 0)
	putc((int)byte, ofp);
}


Byte read_byte(FILE *ifp)
{
    return ((Byte)getc(ifp));
}

static code_int getcode(FILE *ifp)
{
    register code_int code;
    static char_type buf[16];
    register int r_off, bits;
    register char_type *bp = buf;

    if (clear_flg > 0 || offset >= size || free_ent > maxcode) {
	if (free_ent > maxcode) {
	    n_bits++;
	    maxcode = n_bits == maxbits ? maxmaxcode :
		MAXCODE(n_bits);
	}
	if (clear_flg > 0) {
	    maxcode = MAXCODE(n_bits = 9);
	    clear_flg = 0;
	}
	if (readsize == 0)
	    return (-1);
	size = readsize < n_bits ? readsize : n_bits;
	size = fread(buf, 1, size, ifp);
	if (size <= 0)
	    return (-1);        
	readsize -= size;
	offset = 0;
	size = (size << 3) - (n_bits - 1);
   }
    r_off = offset;
    bits = n_bits;

    bp += (r_off >> 3);
    r_off &= 7;

    code = (*bp++ >> r_off);
    bits -= (8 - r_off);
    r_off = 8 - r_off;  
    if (bits >= 8) {
	code |= *bp++ << r_off;
	r_off += 8;
	bits -= 8;
   }
    code |= (*bp & rmask[bits]) << r_off;
    offset += n_bits;

    return (code);
}

Status uncompress(FILE *ifp, FILE *ofp)
{
    register char_type *stackp;
    register int finchar;
    register code_int code, oldcode, incode;

    crc = 0;
	crcsize = writesize = 0xfdc8;
    clear_flg = 0;
    offset = 0;
    size = 0;
    readsize = 0xd430;

    maxbits = read_byte(ifp);
    readsize--;
    maxmaxcode = 1 << maxbits;

    maxcode = MAXCODE(n_bits = 9);
    for (code = 255; code >= 0; code--) {
		tab_prefixof(code) = 0;
		tab_suffixof(code) = (char_type) code;
   }
    free_ent = 257;

    finchar = oldcode = getcode(ifp);
    if (oldcode == -1)  
	goto compress_exit;     

	    write_byte(ofp, finchar);
	calccrc(finchar);

    stackp = de_stack;

    while ((code = getcode(ifp)) != -1) {
	if (check_stream(ifp) != FNOERR)
	    break;
	if (code == 256) {
	    for (code = 255; code >= 0; code--)
		tab_prefixof(code) = 0;
	    clear_flg = 1;
	    free_ent = 257 - 1;
	    if ((code = getcode(ifp)) == -1)    
		break;
	}
	incode = code;

	if (code >= free_ent) {
	    *stackp++ = finchar;
	    code = oldcode;
	}

	while (code >= 256) {
	    *stackp++ = tab_suffixof(code);
	    code = tab_prefixof(code);
	}
	*stackp++ = finchar = tab_suffixof(code);
	
	while (stackp > de_stack) {
	    stackp--;
		    write_byte(ofp, *stackp);
		calccrc(*stackp);
	}

	if ((code = free_ent) < maxmaxcode) {
	    tab_prefixof(code) = oldcode;
	    tab_suffixof(code) = finchar;
	    free_ent = code + 1;
	}
	oldcode = incode;
   }
compress_exit:
    if (check_stream(ifp) == FRWERR) return (RERR);
    if (check_stream(ofp) == FRWERR) return (WERR);
    if (crc != 0x2d73) return (CRCERR);
    return (NOERR);
}

void Error(const char *fn, FILE *fb, int r)
{
  perror(fn);
  if (fb) fclose(fb);
  exit(r);
}


void Write(const char *fn, const char *image)
{
  FILE *out;

  out=fopen(fn, "wb");
  if (!out) {
    fprintf(stderr, "Failed to open %s file '%s'\n", "output",fn);
    exit(3);
 }
  if (fwrite(image, 0x4000, 1, out)!=1) Error(fn, out, 3);
  fclose(out);
}


int main(int argc, char *argv[])
{
  FILE *in;
  FILE *out;
  unsigned char BASIC[16384], OS[16384], *ROMptr=BASIC;
  int i=0;
  Status dec;
  
  if (argc==2 && (!strcmp(argv[1], "-h") || !strcmp(argv[1], "-H"))) {
    fprintf(stderr, "RipROMs version 1.00 (21 Jun 1996)\n\n");
    fprintf(stderr, "Usage: RipROMs <APP2.ARC> <BASIC ROM file> <OS ROM file>\n");
    return 0;
 }

  if (argc!=4) {
    fprintf(stderr, "Usage: RipROMs <APP2.ARC> <BASIC ROM file> <OS ROM file>\n");
    return 1;
 }

  in=fopen(argv[1], "rb");
  if (!in) {
		fprintf(stderr, "Failed to open %s file '%s'\n", "input",argv[1]);
 }

  out=fopen("!RUNIMG","wb");

  fseek(in, 0x50f, SEEK_SET);
  for(i=0;TestArc[i]!=222;i++)
	if(read_byte(in)!=TestArc[i]) {
		printf("%d\n",TestArc[i]);
		fprintf(stderr, "Incorrect version of file '%s'\n",argv[1]);
		fclose(in);
		return 1;
	}
	
  fseek(in,0x538, SEEK_SET);
  dec = uncompress(in,out);
  fclose(in);
  fclose(out);
  if(dec!=NOERR) {
		fprintf(stderr, "Decompression error in file '%s'\n",argv[1]);
		return 1;
  }

  in=fopen("!RUNIMG", "rb");
  if (!in) {
    fprintf(stderr, "Failed to open %s file '%s'\n", "input",argv[1]);
    return 2;
 }

  if (fseek(in, 0x3CL, SEEK_SET) || fread(BASIC, 0x31L, 1, in)!=1)
    Error(argv[1], in, 2);
  if (strcmp(BASIC, "6502 Emulator\t1.20 (18 May 1992) (BBC emulation)"))
 {
    fclose(in);
    fprintf(stderr, "Incorrect version of file '%s'\n",argv[1]);
    return 1;
 }

  do {
    if (fseek(in, grab[i].offset, SEEK_SET)
	|| fread(ROMptr, grab[i].length, 1, in)!=1)
      Error(argv[1], in, 2);
    ROMptr+=grab[i].length;
 } while (grab[++i].offset!=-1);

  if (fseek(in, 0x9638L, SEEK_SET)
      || fread(OS, 0x4000, 1, in)!=1)
    Error(argv[1], in, 2);

  fclose(in);

  i = 0;
  do OS[patch[i].offset] = patch[i].value;
  while (patch[++i].offset!=-1);

  Write(argv[2], BASIC);
  Write(argv[3], OS);
  printf("Roms successfully Ripped\n");
  return 0;
}
