/* lowlevel.c: emulator spul
 *
 * Copyright (C) W.H.Scholten 1997
 * (bbcim)
 */

#define UNIX

#ifdef UNIX
#include <sys/types.h>
#include <dirent.h>
#endif

#ifdef TURBOC
#include <dir.h>
#endif

#ifdef W32
#include <windows.h>
#endif



#ifdef TURBOC /* UNTESTED */
/* A readdir wrapper: returns 0 if ok, -1 if no more files */
int  find_file(char *dirname, char *filename, int action) {
    static int handle;
    int finished = FALSE;
    struct ffblk filedata;
    static int dir_open;
    int attr;

    char beebdir[200];

    /* TEST STUFF: */
    setdisk(0); /* ? C: ? */
    getcurdir(0, beebdir);
    printf("cur dir=%s", beebdir);


    switch(action) {
    case FIND_FILE:
	if (!dir_open) {
	    strcpy(beebdir, dirname);
	    if (beebdir[strlen(beebdir-1)] !='/') strcat(beebdir,"/");
/* 	    strcat(beebdir,"*.*"); */
	    attr=DIRECTORY; /* | WILDCARDS */
	    handle = findfirst(beebdir, &filedata, attr);
	    dir_open=1;
	}
	else {
	    for(;;) {
		if (!findnext(&filedata)) return -1;
		if (handle <1 /* == INVALID_HANDLE_VALUE */) return -1;
		if (!(filedata.ff_attrib & DIRECTORY)) {
		    strcpy(filename, filedata.ff_name);
		    return 0;
		}
	    }
	}
	break;
    case CLOSE_DIR:
	/* How?? Or not necessary?? */
/* 	if (dir_open) */
/* 	    FindClose(handle); */
	dir_open=0;
    }
    return 0;
}
#endif

#ifdef W32
/* A readdir wrapper: returns 0 if ok, -1 if no more files */
int  find_file(char *dirname, char *filename, int action) {
    static HANDLE handle;
    static WIN32_FIND_DATA filedata;
    int finished = FALSE;
    static int dir_open;

    char beebdir[200];

    switch(action) {
    case FIND_FILE:
	if (!dir_open) {
	    strcpy(beebdir, dirname);
	    if (beebdir[strlen(beebdir-1)] !='/') strcat(beebdir,"/");
	    strcat(beebdir,"*.*");
	    handle = FindFirstFile(beebdir,&filedata);
	    dir_open=1;
	}
	else {
	    for(;;) {
		if (!FindNextFile(handle,&filedata)) {
		    FindClose(handle); dir_open=0;
		    return -1;
		}
		if (handle == INVALID_HANDLE_VALUE) {
		    FindClose(handle); dir_open=0;
		    return -1;
		}
		if (!(filedata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
		    strcpy(filename, filedata.cFileName);
		    return 0;
		}
	    }
	}
	break;
    case CLOSE_DIR:
	if (dir_open)
	    FindClose(handle);
	dir_open=0;
    }
    return 0;
  }
#endif

#ifdef UNIX
/* A readdir wrapper: returns 0 if ok, -1 if no more files */
int  find_file(char *dirname, char *filename, int action) {
    static struct dirent *currentdirentry;
    static DIR *thisdir;
    static int dir_open;

    switch(action) {
    case FIND_FILE:
	if (!dir_open)
	    thisdir=opendir(dirname);
	dir_open=1;
	for(;;) {
	    currentdirentry=readdir(thisdir); /* next entry */
	    if (currentdirentry==NULL) { /* last entry */
		closedir(thisdir); dir_open=0; return -1;
	    }
	    if (strcmp(currentdirentry->d_name, ".") && strcmp(currentdirentry->d_name, "..")) break;
	}
	strcpy(filename, currentdirentry->d_name);
	/* printf("Filename %s\n", currentdirentry->d_name); */
	break;
    case CLOSE_DIR:
	if (dir_open)
	    closedir(thisdir);
	dir_open=0;
    }
    return 0;
}
#endif

/* bbcim -l[i,d] dir
 *        List all bbc files and/or bbc disk files
 * -l alone lists virtual files
 */


/* DEMO...  Tests all files and tells if they are bbc files */
void list_bbc_files(char *dir) {
    char filename[100];
    struct bbcfile file;

    printf("checking all bbc files\n");
    file.filename=filename;
    while (find_file(dir, filename, FIND_FILE)!=-1) {
/* 	printf("file %s\n", file.filename); */
	if (!get_fileattributes_info(filename, &file, 0)) {
	    printf(" %s is a bbc file\n", filename);
	}
    }
}


/* DEMO...  Tests all files and tells if they are bbc disks */
void list_bbc_disks(char *dir) {
    char filename[100];
    struct diskimage image;

    printf("checking all bbc disks\n");
    image.filename=filename;
    while (find_file(dir, filename, FIND_FILE)!=-1) {
/* 	printf("file %s\n", image.filename); */
	if (!get_diskattributes(&image, 0))
	    printf(" %s is a bbc disk\n", filename);
    }
}



/* returns: 0 if OK, -n in case of errors */
/* Read attributes for a bbc file named file->naam */
int  d_read_first_catalogue_entry(struct diskimage *image, struct bbcfile *file) {
    disk_cat_extract_crc(image, 0, NULL, file, NEW_DISK);
    if (!bbcim_errno)
	disk_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES);
    return bbcim_errno;
}
int  d_read_catalogue_entry(struct diskimage *image, struct bbcfile *file) {
    return disk_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES);
}

int  d_write_catalogue_entry(struct diskimage *image, struct bbcfile *file) {
    /* from add file */
#if 0
    unsigned char byte;
    file *fpdisk;
    int eellddss;

    fpdisk=fopen(image->filename, "rb+");

    byte=file->naam[0]+(locked<<7);
    fseek(fpdisk,15L,SEEK_SET);
    fwrite(&byte,1,1,fpdisk);
    
    fseek(fpdisk,8L,SEEK_SET);
    for(i=0; i<7; i++) {
      byte=bbcfile_naam[i+2];
      if (byte==0) {
	  byte=' '; bbcfile_naam[i+3]=0;
      }
      fwrite(&byte,1,1,fpdisk);
    }

    afiles +=8;
    fseek(fpdisk,256+5L,SEEK_SET);
    fwrite(&afiles,1,1,fpdisk);

    /* load/exec  adressen + lengte schrijven */
    fseek(fpdisk,256L+14L,SEEK_SET);
    eellddss=((startsector >>8) & 0x3)+((loadaddress >>14) &0xC);
    eellddss +=((execaddress >>10) &0xC0);
    eellddss +=((length >>12) &0x30);
    fwrite(&eellddss,1,1,fpdisk);

    /* STARTSECTOR */
    byte=startsector & 0xFF;
    fwrite(&byte,1,1,fpdisk);


    /* LOADADDRESS */
    fseek(fpdisk,256L+8L,0);
    byte=loadaddress & 0xFF;
    H=(loadaddress >>8) & 0xFF;
    fwrite(&byte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);

    /* EXECADDRESS */
    byte=execaddress & 0xFF;
    H=(execaddress >>8) & 0xFF;
    fwrite(&byte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);

    /* FILELENGTE */
    byte= length & 0xFF;
    H=(length >>8) & 0xFF;
    fwrite(&byte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);
#endif
    return 1; /* not implemented yet */
}


int  d_read_first_file(struct diskimage *image, struct bbcfile *file, byte *data) {
    disk_cat_extract_crc(image, 0, NULL, file, NEW_DISK);
    if (!bbcim_errno)
	disk_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES);
    file->data=data;
    if (!bbcim_errno)
	disk_cat_extract_crc(image, 0, NULL, file, LOAD_FILE);
    return bbcim_errno;
}
int  d_read_file(struct diskimage *image, struct bbcfile *file, byte *data) {
/*      disk_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES); */
    file->data=data;
    return disk_cat_extract_crc(image, 0, NULL, file, LOAD_FILE);
}
int  d_read_next_file(struct diskimage *image, struct bbcfile *file, byte *data) {
    disk_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES);
    file->data=data;
    if (!bbcim_errno)
	disk_cat_extract_crc(image, 0, NULL, file, LOAD_FILE);
    return bbcim_errno;
}
int  d_write_file(struct diskimage *image, struct bbcfile *file) {
#if 0
    disk_del_file(image, 0, NULL, file, DEL_FILE);/* make sure it's gone */
    file->data=data;
    if (!bbcim_errno)
	disk_add_file(image, 0, NULL, file, SAVE_FILE);
#endif
    return bbcim_errno;
}

/* delete_file  ? */
#define d_delete_file(image, file) del_from_image( image, 1 )


/* int  rename_file -> write catalogue entry with new name. */







#if VIRTUAL
/* VITUALISE: */
int  Vread_file(int type, void *image, struct bbcfile *file, int flags) {
    if (type==ARCHIVE_FORMAT) {
	a_read_file ((struct archiveimage *) image, struct bbcfile *file, int flags);
    }
    else if (type==DISK_FORMAT) {
	d_read_file ((struct diskimage *) image, struct bbcfile *file, int flags);
    }
    else if (type==TAPE_FORMAT) {
	t_read_file ((struct tapeimage *) image, struct bbcfile *file, int flags);
    }
    else {
	bbcim_error="Bad virtual format";
	bbcim_errno=BAD_VIRTUAL_FORMAT;
    }
    return bbcim_errno;
}
#endif





#if RISC
/* RISCifying */
int d_cat_extract_crc(image, 0, NULL, file, GET_ATTRIBUTES) {

    disk_open(image);
    dir="";
    disk_set_dir(image, dir); /* ADFS, zet dir, init pointers */
    disk_get_attributes(image, file, FIRST_FILE); /* NEXT_FILE,  */

    file.address=emu_address;
    disk_load_file(image, file);

    disk_close(image);
}

int d_cat(image, 0, NULL, file, flags) {

    disk_open(image, /*GET_DSKINFO*/ flags);
    dir="";
    disk_set_dir(image, dir); /* ADFS, zet dir, init pointers */
    disk_get_attributes(image, file, FIRST_FILE); /* NEXT_FILE,  */

    disk_show_file_attributes(file);

    disk_close(image);
}
int d_extract(image, 0, NULL, file, flags) {

    disk_open(image, /*GET_DSKINFO*/ flags);
    dir="";
    disk_set_dir(image, dir); /* ADFS, zet dir, init pointers */
    disk_get_attributes(image, file, FIRST_FILE); /* NEXT_FILE,  */

    disk_show_file_attributes(file);

    disk_close(image);
}
#endif
