/* (bbcim) diskb_del.c: verwijder bestand uit diskbeeld
 *
 * Copyright (C) W.H.Scholten 1996
 */


/* voor Acorn DFS */
int  disk_del_file(struct diskimage *image, int args, char *arglist[], int flags) {
    FILE *fpdisk;
    char bbcfile_naam[15];
    unsigned char filebyte;
    unsigned char files;
    int  rfiles;
    long file,k;
    int  locked;
    int  removed;
    int  i,j;
    char testnaam[15];
    char *disk;


    disk=image->filename;
    if (diskimage_sanitycheck(image, flags &VERBOSE)) return bbcim_errno;

    fpdisk=fopen(disk,"rb+");
    fseek(fpdisk,256+5L,SEEK_SET);
    fread(&files,1,1,fpdisk);

    rfiles=files/8;
#ifdef NL
    printf("aantal bestanden: %d\n",rfiles);
#else
    printf("number of files: %d\n",rfiles);
#endif

    removed=0;

    /*Hoofdlus: alle bestanden opzoeken. */
    if (files>0) {
	for(file=0;file<files; file +=8) {
	    fseek(fpdisk,file+15L,SEEK_SET);
	    fread(&filebyte,1,1,fpdisk);

	    locked=filebyte >>7;

	    bbcfile_naam[0]=(filebyte & 0x7F);
	    bbcfile_naam[1]='.';    

	    fseek(fpdisk,file+8L,SEEK_SET);
	    fread(bbcfile_naam+2,1,7,fpdisk);
	    bbcfile_naam[9]=0;
	    /*spaties aan het einde van extract weghalen: geeft anders bestands namen
	      met spaties aan het einde */
	    for(i=8; i>0 && (bbcfile_naam[i]==' '); i--);
	    bbcfile_naam[i+1]=0;

	    for (j=0; j<args; j++) {
		if (arglist[j][1]=='.')
		    strncpy(testnaam, arglist[j],9);
		else {
		    testnaam[0]='$'; testnaam[1]='.';
		    strncpy(testnaam+2, arglist[j],7);
		}
		testnaam[9]=0;

		if (!strcmp(bbcfile_naam, testnaam)) {
		    for (k=(file+8)+8; k<256; k++) {
			fseek(fpdisk,k, SEEK_SET);
			fread(&filebyte,1,1,fpdisk);
			fseek(fpdisk,k-8L, SEEK_SET);
			fwrite(&filebyte,1,1,fpdisk);

			fseek(fpdisk,k+256L, SEEK_SET);
			fread(&filebyte,1,1,fpdisk);
			fseek(fpdisk,k-8L+256L, SEEK_SET);
			fwrite(&filebyte,1,1,fpdisk);
		    }
#ifdef NL
		    printf("Bestand %s verwijderd\n",testnaam);
#else
		    printf("File %s removed\n",testnaam);
#endif
		    removed++;
/*          continue;*/
		    break;
		}
	    }
	}/*for*/

	files -=removed*8;
	fseek(fpdisk,256+5L,SEEK_SET);
	fwrite(&files,1,1,fpdisk);

	fclose(fpdisk);

#ifdef NL
	printf("  %d bestand%s verwijderd\n", removed, (removed!=1) ? "en" : "");
#else
	printf("  %d file%s removed\n", removed, (removed!=1) ? "s" : "");
#endif

    }/*if files>0 */
    fclose(fpdisk);
    return 0;
}
