/* bbcimlib.h (bbcim; bbc diskbeeld manipulatie): Functies.
 *
 * Copyright (c) W.H. Scholten 1996, 1997
 */





/*----------------------------------------------*/
/* vlaggen voor cat-extract-crc-add */
#define VERBOSE            1
#define EXTRACT_FILES      2
#define EXTRACT_DIR        4
#define SHOW_FILES         8
#define CALC_CRC          16
#define BBC_DIR           32
#define REMOVE_DISK       64
#define SHORT_NAME       128
#define DISK_INFO        256
#define REMOVE_FILE      512
#define FILE_INFO       1024

/* Low level reading */
#define GET_ATTRIBUTES  2048
#define LOAD_FILE       4096
#define SAVE_FILE       8192
#define NEW_DISK       16384
#define ADD_FILES 32768

/* Ditto but for find_file(..) */
#define FIND_FILE          1
#define CLOSE_DIR          2

enum Disktype { DFS_DISK, DDOS_DISK, W62_DISK, ADFS_DISK, HDFS_DISK };

#define SD_TRACKSIZE   (10*256)
#define DD_TRACKSIZE   (18*256)
#define ADFS_TRACKSIZE (16*256)





/* Foutmeldingen (error messages) */
#define BBC_OK                  0
#define BBC_OPEN_FAILED        -1
#define BBC_NO_ROOT_DIR        -2
#define BAD_DISK_TYPE_ARGUMENT -3

#define BBC_DISK_TRUNCATED    -20

#define BBC_NO_INF_FOUND      -30
#define BBC_BAD_DSK_FORMAT    -31
#define BBC_BAD_INF_FORMAT    -32
#define BBC_OPEN_CATALOG_FAILED -33 /* xbeeb */

/* BBC like errors: */
#define BBC_BAD_DISK          -50
#define BBC_DISK_FULL         -51
#define BBC_LOCKED_FILE       -52
#define BBC_FILE_NOT_FOUND    -53
#define BBC_DIR_NOT_FOUND     -54

#define BBC_NOT_IMPLEMENTED  -256

/*__________________VARIABELEN___________________*/
extern char *bbcim_error; /* points to the last error */
extern int  bbcim_errno;


struct diskimage {
    char *filename;
    int  type; /* DFS_DISK, W62_DISK, DDOS_DISK, ADFS_DISK, HDFS_DISK */
    int  sides;
    int  tracks;
    int  sectors_per_track;
    int  bytes_per_sector;
#if 0
    /* might be usefull: */
    int  bootoption;
    char *diskname;
    char dirname[50]; /* current dir */
    long fileptr;
    char filename[50];
    int  status; /* bad image, error? */
#endif
};

#define ATTR_LOCKED 1
#define ATTR_R      1 /* ADFS */
#define ATTR_W      2
#define ATTR_E      4
#define ATTR_D      8

struct bbcfile {
    char naam[20];
    long loadaddr;
    long execaddr;
    long length;
    byte attributes;

    byte *data;
    char *filename; /* remove and use bbcfile_data? */
};

struct bbcdisk_data {
/* should this be in diskimage struct ? */
/* NB only file address and cat address really needed. All else can be calculated from the data in the diskimage struct
   tracksize=image->sectors*image->bytes
   track=addr /(tracksize*sides); side =(addr /tracksize)&(sides-1);
   */
    int file_address;
    int cat_address;
    int file_no; /* index into catalogue at 'cat_address' */

#if 0 /* Not needed: */
    int side;
    int file_track; /* file address */
    int file_sector;
    int file_byte;
    int cat_track;  /* catalogue entry address */
    int cat_sector;
    int cat_byte;
#endif
};

struct bbcfile_data {
    /* should this be in bbcfile struct ? */
    char *filename;
    byte *data;
};

/*__________________FUNCTIES___________________*/
int  archive_cleanup(int args, char *arglist[], int flags); /* check's crc's and renames accoring to the standard reduction (the # option in -e) */
long fcrc(char *file, int verbose); /* calc 16 bit crc of file (see bbc userguid p. 399) */
int  archive_crc_check(int args, char *arglist[], int flags); /* check crc's of given archive files */
int  xbeeb_crc_check(char *dir, int flags); /* check crc's of files in xbeeb __CATALOG__ */
int  disk_cat_extract_crc(struct diskimage *image, int args, char *arglist[], struct bbcfile* file, int flags);
int  disk_add_file(struct diskimage *image, int args, char *arglist[], struct bbcfile *file, int flags);
int  disk_del_file(struct diskimage *image, int args, char *arglist[], int flags);
int  disk_minimize(struct diskimage *image, int verbose);
int  diks_expand(struct diskimage *image, int expand, int verbose);
int  disk_new(struct diskimage *image, unsigned int size, int verbose);
int  disk_set_boot(struct diskimage *image, int bootoption, int verbose);
int  disk_identify(struct diskimage *image, int verbose);

int  interss(char *side0, char *side1, char *interleaved, int disktype, int verbose);
int  splitds(char *interleaved, int disktype , int verbose);

int  split_cat(char *cat_naam, int flags);

int  ddos2dfs(char *disk, int verbose);
int  w62dfs(char *disk, int verbose);
int  ds2ss(char *interleaved, int verbose);

int  archive_to_xbeeb(char *xbeeb_dir, int args, char *arglist[], int verbose);

int  rename_sequential(char *naam); /* Rename if file 'naam' already exists by appending number 0 ... n */
int  overschrijf_vraag(char *oude_naam, char *nieuwe_naam);

void replace_bad_chars(char *unix_bbcfile_naam);
void reduceer_unix_naam(char *unixnaam, char *bbcnaam);

int  file_sanitycheck(char *filename, int verbose);
int  diskimage_sanitycheck(struct diskimage *image, int verbose);
int  diskinfo_from_string(char *string, struct diskimage *image);




/* Low level; loading files in memory, getting file attributes etc. */
int  d_read_first_catalogue_entry(struct diskimage *image, struct bbcfile *file);
int  d_read_catalogue_entry(struct diskimage *image, struct bbcfile *file);
int  d_write_catalogue_entry(struct diskimage *image, struct bbcfile *file); /* NOT YET IMPL*/
int  d_read_first_file(struct diskimage *image, struct bbcfile *file, byte *data);
/*read_file =read file with name file->naam */
int  d_read_file(struct diskimage *image, struct bbcfile *file, byte *data);
int  d_read_next_file(struct diskimage *image, struct bbcfile *file, byte *data);
int  d_write_file(struct diskimage *image, struct bbcfile *file); /* NOT YET IMPL*/

int  find_file(char *dirname, char *filename, int action);
int  get_diskattributes(struct diskimage *image, int verbose);
int  diskinfo_from_string(char *string, struct diskimage *image);
int  get_fileattributes_info(char *filename, struct bbcfile *file, int verbose);


/* Internal use: */
long read4lsb(byte *data);
long read3lsb(byte *data);
long read2lsb(byte *data);


/*__________________DEFINITIES___________________*/
/* Byte offsets in diskimage for Acorn DFS */
#define DFStitle0_7    0
#define DFStitle8_11   256
#define DFS accessct   (256+0x04)
#define DFSentries     (256+5)
#define DFSbootsec     (256+6)
#define DFSsectondiskL (256+0x07)

/*next offsets +n*8 for each file */
#define DFSfilename  8
#define DFSdirectory 0x0f
#define DFSloadaddrL (256+8)
#define DFSloadaddrM (256+9)
#define DFSexecaddrL (256+0x0a)
#define DFSexecaddrM (256+0x0b)
#define DFSlengthL   (256+0x0c)
#define DFSlengthM   (256+0x0d)
#define DFSeellddss  (256+0x0e)
#define DFSstartsecL (256+0x0f)


