/*
// bbcim.c (bbc diskbeeld manipulatie): SINGLE DENSITY, DD extensions and more.

// Copyright (c) W.H. Scholten 1996, 1997
 
// Permission to use, copy, modify, distribute, and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appear in all copies and
// that both that copyright notice and this permission notice appear in
// supporting documentation, and that the name of the copyright holder
// not be used in advertising or publicity pertaining to distribution
// of the software without specific, written prior permission. The
// copyright holder makes no representations about the suitability of
// this software for any purpose. It is provided "as is" without express
// or implied warranty.
//
// THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
// RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
// CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// Send comments and bug-reports to 
//
//    wouters@cistron.nl
//
// Send flames to /dev/null.
//
// It works under linux (1.2.13/GCC 2.7.0, 2.0.30/GCC 2.7.2).
*/


#define VERSION "0.97-alpha 27"



/*__________________INCLUDES___________________*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mytypes.h"

#ifndef SHARED
#include "bbcimlib.c"
#else
#include <bbcimlib.h>
#endif


/*************** CONFIGURATION ************************/
/* Comment out for english messages in the front end */
#define FE_NL

/* See bbcimlib.c for all other configuration */
/*************** END OF CONFIGURATION *****************/




/*__________________DATA___________________*/
char *help_string=
#ifdef FE_NL
"\nbbcim commando overzicht\n" \
" -c [disk opties] diskbeeld [adfs_dir]\n" \
"    Toon bestanden in diskbeeld\n" \
" -e[s|d,#,b,r] [disk opties] diskbeeld [adfs_dir] [{lijst}]\n" \
"    Bestanden uit diskbeeld halen\n" \
" -a[b,r] [disk opties] diskbeeld [adfs_dir] {lijst}\n" \
"    Bestanden in diskbeeld plaatsen\n" \
" -d [disk opties] diskbeeld [adfs_dir] {lijst}\n" \
"    Verwijder bestanden uit diskbeeld\n" \
" -40/-80/-max diskbeeld\n" \
"    Grootte van DFS diskbeeld wijzigen\n" \
" -min [disk opties] diskbeeld\n" \
"    Diskbeeld minimaliseren\n" \
" -crc [disk opties] diskbeeld\n" \
"    Bereken CRC's van bestanden in diskbeeld\n" \
" -boot [disk opties] beeld optie\n" \
"    Stel bootoptie van diskbeeld in\n" \
" -id beeld\n" \
"    Probeer het diskbeeld te identificeren\n\n" \

" -y {lijst}\n" \
"    Archief bestanden bijwerken (naam &crc)\n" \
" -s[#] bestand\n" \
"    Splits tekst bestand in .inf bestanden\n" \
" -x {lijst}\n" \
"    Archief bestanden omzetten naar xbeeb formaat\n" \
" -icrc {lijst}\n" \
"    Controleer CRC's van archief bestanden\n"\
" -xcrc\n" \
"    Controleer CRC's van xbeeb bestanden in de huidige dir\n\n"\

" -interss sd|dd B0 B1 B2\n" \
"    Enkelzijdig naar dubbelzijdig diskbeeld\n"\
" -splitds sd|dd B\n" \
"    Dubbelzijdig naar enkelzijdig diskbeeld\n"\
" -ddos2dfs ddosbeeld\n" \
"    Splits enkelzijdig DDOS diskbeeld in DFS diskbeelden\n"\
" -w62dfs w62beeld\n" \
"    Splits een watford 62 bestanden diskbeeld in 2 DFS diskbeelden\n"\
" -ds2ss\n" \
"    Om en om adfs diskbeeld naar lineair diskbeeld\n\n" \

" -V : toon versie\n\n" \
"Disk opties zijn:\n" \
" -DFS|W62|DDOS|ADFS|HDFS -DS|SS\n\n"
;
#else
"\nCommand overview\n" \
" -c      [disk options] diskimage : show files in diskimage\n" \

" -e[s|d,#,b,r]  [disk options] diskimage [{list}]: extract files from diskimage\n" \
" -a[b,r] [disk options] diskimage {list} : add files to diskimage\n" \
" -d      [disk options] diskimage {list} : delete files from diskimage\n" \
" -40/-80/-max diskimage : change size of diskimage\n" \
" -min    [disk options] diskimage : minimize diskimage\n" \
" -crc    [disk options] diskimage : calculate CRC's of files in diskimage\n\n" \

" -y {list}  : cleanup archive file information (name & crc)\n" \
" -s[#] file : split a text file in .inf files\n" \
" -x {list}  : convert archive files to xbeeb format\n" \
" -icrc {list} : check CRC's of archive files\n"\
" -xcrc : check CRC's of xbeeb files in the current dir\n\n"\

" -interss sd|dd B0 B1 B2 : single sided to double sided diskimage conversion\n"\
" -splitds sd|dd B : double sided to single sided diskimage conversion\n"\
" -ddos2dfs ddosimage : split single sided DDOS diskimage in DFS diskimages\n"\
" -w62dfs   w62image  : split a watford 62 file diskimage in 2 DFS diskimages\n"\
" -ds2ss    adfsimage : interleaved adfs diskimage to linear diskimage\n\n" \

" -boot [disk options] image option : set bootoption of diskimage\n" \
" -id image: try to identify the diskimage\n" \
" -V : show version\n\n" \
"Disk options are:\n" \
"-DFS|W62|DDOS|ADFS|HDFS -DS|SS\n\n"
;
#endif



/*__________________PROGRAMMA___________________*/


void use() {
#ifdef FE_NL
    printf("Opties: -e[s|d,#,b,r] -a[b,r] -d -c -crc -min -40/80/max -boot -id\n" \
	   "        -y -icrc -s[#]\n" \
	   "        -x -xcrc\n" \
	   "        -splitds -interss -ddos2dfs -w62dfs -ds2ss\n" \
	   "        -V -H\n\n");
#else
    printf("Options: -e[s|d,#,b,r] -a[b,r] -d -c -crc -min -40/80/max\n" \
	   "        -y -icrc -s[#]\n" \
	   "        -x -xcrc\n" \
	   "        -splitds -interss -ddos2dfs -w62dfs -ds2ss\n" \
	   "        -id -boot\n" \
	   "        -V -H\n\n");
#endif
}


enum optie_type { VERSIE, HELP, INTERSS, SPLITDS, DDOS_DFS, W62_DFS, SPLIT_CAT, EXTRACT, ADD, DEL, CAT, CRC, XBEEB_CONVERT, ARCHIVE_CLEANUP, XBEEB_CRC, ARCHIVE_CRC, DISKSIZE40, DISKSIZE80, MINIMIZE, MAXIMIZE, BOOT, ADFS_DS2SS, ID, _NUM_TYPES_ };

char *optie_strings[]={
    "V", "H", "interss", "splitds", "ddos2dfs", "w62dfs", "s", "e", "a", "d", "c", "crc", "x", "y", "xcrc", "ycrc", "40", "80", "min", "max", "boot", "ds2ss" ,"id"
};

char subopties[] = { 0,0,0,0,0,0,1,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

char min_args[] = { 0,0,4,2, 1,1, 1, 1, 2, 2, 1, 1, 1, 1,1,1,1,1,1,1,1,1,1};




int main(int argc, char *argv[]) {
    FILE *fpdisk;
    char disk[50];
    char optstring[21];
    int  bad_option;
    int  options=0;

    int  i;
    int  flags;
    int  optie;

    char side0[50],  side1[50], interleaved[50];
    int  disktype, track_size;
    char option2[100], cat_naam[100];
    int  bootoption=0;

    struct diskimage image;
    struct bbcfile file; /* dummy argument to general functions */





#ifdef NO_COMMAND_LINE
    argc=1;
#endif

    /* Defaults: */
    image.type=DFS_DISK;
    image.sides=1;
    image.filename=disk;


    bbcim_errno=0;

#if 0
/* TEST */
    list_bbc_disks(".");
    list_bbc_files(".");
#endif

    /* ------------------------------------ */
    /* Process options and arguments        */
    if (argc-1 < 1) {
       #ifdef FE_NL
	printf("Welke optie?");
       #else
	printf("Which option?");
       #endif
	scanf("%20s", optstring);
    }
    else { strncpy(optstring, argv[1], 20); options++; }


    optie=-1; /* geeft bad option in de switch */

 /*  for (;;) options=saved_options; */
 /* to check all options that completely/partially resemble? */
 /* i.e. if -extr is checked as -e it gives bad option, but -extr could be another command */

    if (optstring[0]=='-')
	for (i=0; i<_NUM_TYPES_; i++) {
	    if (!subopties[i]) {
		if (!strcmp(optstring+1,optie_strings[i])) { optie=i; options++; break; }
	    }
	    else {
		if (!strncmp(optstring+1,optie_strings[i], strlen(optie_strings[i]))) { optie=i; options++; break; }
	    }
	}

    /* Check to see if there are enough arguments, if not ask for them in some cases */
    if (min_args[optie]>0) {
	switch(optie) {
	case INTERSS:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Single density (sd) of double density (dd)?");
               #else
		printf("Single density (sd) or double density (dd)?");
               #endif
		scanf("%2s", option2);
	    } else { strcpy(option2, argv[options]); options++; }

	    track_size=SD_TRACKSIZE;
	    if (!strcmp(option2, "dd")) track_size=DD_TRACKSIZE;
	    if (!strcmp(option2, "adfs")) track_size=ADFS_TRACKSIZE;

	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van het diskbeeld voor zijde 0?");
               #else
		printf("Name of the disk image for side 0?");
               #endif
		scanf("%50s", side0);
	    } else { strcpy(side0, argv[options]); options++; }


	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van het diskbeeld voor zijde 1?");
               #else
		printf("Name of the disk image for side 1?");
               #endif
		scanf("%50s", side1);
	    } else { strcpy(side1, argv[2+options]); options++; }

	    if ((argc-options)<1) {

               #ifdef FE_NL
		printf("Naam van om-en-om beeld?");
               #else
		printf("Name of the interleaved diskimage?");
               #endif
		scanf("%50s", interleaved);
	    } else { strcpy(interleaved, argv[options]); options++; }

	    break;

	case SPLITDS:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Single density (sd), double density (dd) of adfs (adfs)?");
               #else
		printf("Single density (sd), double density (dd) or adfs (adfs)?");
               #endif
		scanf("%2s", option2);
	    } else { strncpy(option2, argv[options],2); options++; }

	    track_size=SD_TRACKSIZE;
	    if (!strcmp(option2, "dd")) track_size=DD_TRACKSIZE;
	    if (!strcmp(option2, "adfs")) track_size=ADFS_TRACKSIZE;


	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van de om-en-om diskdump?");
               #else
		printf("Name of the interleaved diskdump?");
               #endif
		scanf("%50s", interleaved);
	    } else strcpy(interleaved, argv[options]);
	    break;
	case ADFS_DS2SS:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van het om-en-om diskbeeld?");
               #else
		printf("Name of the interleaved diskdump?");
               #endif
		scanf("%50s", disk);
	    } else { strcpy(disk, argv[options]); options++; }
	    break;
	case DEL:
	case ADD:
	case ARCHIVE_CRC:
	case XBEEB_CRC:
	case ARCHIVE_CLEANUP:
	case XBEEB_CONVERT:
	    if ((argc-options)<min_args[optie]) {
               #ifdef FE_NL
		printf("Niet genoeg parameters\n");
               #else
		printf("Not enough parameters\n");
               #endif
		exit(1);
	    } else { strcpy(disk, argv[options]); options++; }
	    break;
	case SPLIT_CAT:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van de te splitsen catalogus?");
               #else
		printf("Name of the catalogue to be split?");
               #endif
		scanf("%50s", cat_naam);
	    } else { strcpy(cat_naam, argv[options]); options++; }
	    break;
	case BOOT:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van het bbc diskbeeld?");
               #else
		printf("Name of the bbc disk image?");
               #endif
		scanf("%50s", disk);
	    } else { strcpy(disk, argv[options]); options++; }
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Welke bootoptie ?");
               #else
		printf("Which bootoption ?");
               #endif
		scanf("%50s", option2);
	    } else { strcpy(option2, argv[options]); options++; }
	    bootoption=atol(option2);
	    break;
	default:
	    if ((argc-options)<1) {
               #ifdef FE_NL
		printf("Naam van het bbc diskbeeld?");
               #else
		printf("Name of the bbc disk image?");
               #endif
		scanf("%50s", disk);
	    } else {
		int return_val=set_disktype(&image, argc-options, argv+options, 1);
		if (return_val<0) return -1;
		options+=return_val;
		strcpy(disk, argv[options]); options++;
		if (return_val==0) { /* no options found */
		    if (get_diskattributes(&image, 1)) { /* no dsk file found */
			image.type=DFS_DISK;
		    }
		}
	    }
	}
    }
    bad_option=0;





    /* --------------------------------------------------------- */
    /* All arguments should now be known, so execute the command */
    switch (optie) {
    case VERSIE:
	printf(" bbcim "VERSION" (c) WHS 1996,1997\n\n"); break;
    case HELP:
	printf(help_string);
	break;
    case INTERSS:   interss(side0, side1, interleaved, disktype, VERBOSE); break;
    case SPLITDS:   splitds(interleaved, disktype, VERBOSE); break;
    case DDOS_DFS:  ddos2dfs(disk, VERBOSE); break;
    case W62_DFS:   w62dfs(disk, VERBOSE); break;
    case SPLIT_CAT: split_cat(cat_naam, BBC_DIR | VERBOSE); break;
    case EXTRACT:
	flags = EXTRACT_FILES|DISK_INFO|BBC_DIR|VERBOSE;

	for (i=/*2*/strlen(optie_strings[optie])+1; i<strlen(optstring); i++) {
	    switch (optstring[i]) {
	    case 'd' : flags |=EXTRACT_DIR; break;
	    case 's' : flags |=SHORT_NAME; break;
	    case 'b' : flags &= ~DISK_INFO; break;
	    case '#' : flags &= ~BBC_DIR; break;
	    case 'r' : flags |=REMOVE_DISK; break;
	    default  : bad_option=1;
	    }
	    if ((flags & SHORT_NAME) && (flags & EXTRACT_DIR)) {
		bad_option=1; break;
	    }
	}
	if (!bad_option) {
	    disk_cat_extract_crc(&image, argc-options, argv+options, &file, flags);
	}
	break;
    case ADD:
printf("image.filename=%s\n", image.filename); 
	if (get_diskattributes(&image, 1))
	    image.type=DFS_DISK;

	flags = DISK_INFO;
	for (i=2; i<strlen(optstring); i++) {
	    switch (optstring[i]) {
	    case 'r' : flags |= REMOVE_FILE; break;
	    case 'b' : flags &=~DISK_INFO; break;
	    default  : bad_option=1;
	    }
	}
	/* Het volgende moet naar add_to_image() code (of NIET?). */
	fpdisk=fopen(disk,"rb");
	if (fpdisk==NULL) {
	    disk_new(&image, 800, VERBOSE); /*DEFAULT size=80 track*/
           #ifdef FE_NL
	    printf("Nieuw diskbeeld gemaakt\n");
           #else
	    printf("New diskimage made\n");
           #endif
	}
	else fclose(fpdisk);

	disk_add_file(&image, argc-options,  argv+options, &file, flags);
	break;
    case DEL:
	if (get_diskattributes(&image, 1))
	    image.type=DFS_DISK;
	disk_del_file(&image, argc-options, argv+options, flags); break;
    case CAT:
	flags = SHOW_FILES;
	disk_cat_extract_crc(&image, argc-options, argv+options, &file, flags);
	break;
    case CRC:
	if (get_diskattributes(&image, 1))
	    image.type=DFS_DISK;
	flags=CALC_CRC | SHOW_FILES;
	disk_cat_extract_crc(&image, argc-options, argv+options, &file, flags);
	break;
    case XBEEB_CONVERT:   archive_to_xbeeb("./", argc-options, argv+options, VERBOSE); break;
    case ARCHIVE_CLEANUP: archive_cleanup(argc-options, argv+options, VERBOSE); break;
    case XBEEB_CRC:    xbeeb_crc_check("./", VERBOSE); break;
    case ARCHIVE_CRC:  archive_crc_check(argc-options, argv+options, VERBOSE); break;
    case DISKSIZE40:   disk_expand(&image, 40*10, 1); break;
    case DISKSIZE80:   disk_expand(&image, 80*10, 1); break;
    case MINIMIZE:     disk_minimize(&image, 1); break;
    case MAXIMIZE:     disk_expand(&image, 1023, 1); break;

/*  case NEW_DISK:     disk_new(disk, &image, 800, 1); break;*/ /* -new */

    case ADFS_DS2SS:   ds2ss(disk, 1); break;
    case BOOT:
	if (get_diskattributes(&image, 1))
	    image.type=DFS_DISK;
	disk_set_boot(&image, bootoption, 1); break;
    case ID:  printf("Not implemented\n"); break;
    default: bad_option=1;
    }

    if (bad_option) {
	/* Don't do this again buddy! */
       #ifdef FE_NL
	printf("Slechte optie\n");
       #else
	printf("Bad option\n");
       #endif
	use();
    }

/*    if (bbcim_errno) printf(bbcim_error);*/
    return bbcim_errno;
}


int  set_disktype(struct diskimage *image, int args, char *arglist[], int verbose) {
    int i;
    int found_option=0;

    for (i=0; i<args; i++) {
	if (arglist[i][0]!='-') break;
	found_option++;
	if (diskinfo_from_string(arglist[i]+1, image)) {
	    bbcim_error="Bad option\n"; bbcim_errno=-30;
	    return bbcim_errno;
	}
    }
    return found_option;
}

