/*
 * free.c - the free routine
 *
 * free will free a block of memory previously allocated
 * to it by malloc. It will combine contiguous blocks
 * of free memory.
 * -Pete French. 17/7/1990
 */

struct mlist {			/* malloc list structure */
              unsigned int len;
              char free;
              struct mlist *next;
             };

#define	FREE	'f'
#define	USED	'u'
#define MINBRK	64	/* minimum allocatable block */

extern struct mlist m_base;

free(p)
char *p;
{
struct mlist *ptr;
ptr=&m_base;		/* get the list base */
while(ptr->next != (struct mlist*)0)	/* scan the list */
 {
  ptr=ptr->next;
  if(((char*)ptr+sizeof(struct mlist))==p)	/* found the block ? */
   ptr->free=FREE;				/* mark as free */
 }
ptr=m_base.next;		/* get the first slot */
if(ptr==(struct mlist*)0)	/* if it doesnt exist then exit */
 return;
while(ptr->next != (struct mlist*)0)	/* scan the list */
 {
  if((ptr->free==FREE) && (ptr->next->free==FREE)) /* contiguous freespace ? */
   {
    ptr->len=ptr->len + ptr->next->len + sizeof(struct mlist);	/* new size */
    ptr->next=ptr->next->next;		/* concatenate blocks */
   }
  else
   ptr=ptr->next;
 }
}
