const
  Numbers:set of char=['0'..'9'];
type
  str80=string[80];
var
  Source:text;
  Comp:file of integer;
  Line:str80;
  NewWlCh,NoOfWalls,Weapons:byte;
  Code,LineNo,Ctr,Dat:integer;

procedure Wcomp(Dat:integer);
begin
  Write(Comp,Dat);
end;

procedure Strip(var St:Str80);
begin
  while (St[1] = ' ') and (Length(St)>0) do St:=Copy(St,2,80);
  while (St[Length(St)] = ' ') and (Length(St)>0) do Dec(St[0]);
end;

function Eval(St:Str80):byte;
var
  Tmp:byte;
  Code:integer;
begin
  while not (St[1] in ['-','0'..'9']) and (Length(St)>0) do St:=Copy(St,2,80);
  while not (St[Length(St)] in ['0'..'9']) and (Length(St)>0) do Dec(St[0]);
  Val(St,Tmp,Code);
  if Code>0 then begin
    Writeln('Error line ',LineNo,': ',Line);
    Halt;
  end;
  Eval:=Tmp;
end;

begin
  Writeln; Writeln('Hunchback wall compiler'); Writeln;
  NoOfWalls:=0;
  NewWlCh:=255;
  Weapons:=0;
  LineNo:=0;
  Assign(Source,'b:WALLS.TXT');
  Assign(Comp,'c:WALL.DAT');
  Reset(Source); ReWrite(Comp);
  while not eof(Source) do begin
    Readln(Source,Line);
    Inc(LineNo);
    Strip(Line);
    if not ((Line[1]=';') or (Line[0]=#0)) then begin
      if Line[1]='#' then begin
        Inc(NoOfWalls);
        Writeln('Reading wall ',Chr(64+NoOfWalls));
        Wcomp(MaxInt);
        Weapons:=0;
      end;
      case UpCase(Line[1]) of
        'N':Wcomp(0);
        'R':begin Wcomp(1); Writeln('  Rope'); end;
        'G':begin Wcomp(2); Writeln('  Guards'); end;
        'P':begin Wcomp(3); Writeln('  Pitholes'); end;
      end;
      if Line[1] in Numbers then
        if Weapons=0 then begin
          Weapons:=Eval(Line);
          Writeln(Weapons:3,' weapon(s)');
          Wcomp(Weapons);
          for Ctr:=1 to 5*Weapons do begin
            Read(Source,Dat);
            Wcomp(Dat);
          end;
        end;
    end;
  end;
  Close(Source);
  Close(Comp);
end.