uses Dos,Crt,Graph,Cgadrv;

type
  OneChar=array[0..7] of byte;
  FontType=array[128..255] of OneChar;
  Str80=string[80];

var
  Font:FontType;
  FontFil: file of FontType;
  CurChar:array[0..7,0..7] of boolean;
  x,y,ChrNo:integer;
  Key:char;
  OldFont,NewFont:pointer;
  Quit:boolean;
  Regs:Registers;

function Power(Gr,Mnt:real):integer;
begin
  Power:=Round(Exp(Ln(Gr)*Mnt));
end;

procedure WriteAt(x,y:integer; Txt:Str80; Col:integer);
var Ctr,Ch:byte;
begin
  TextColor(Col);
  GotoXY(x,y);
(*  for Ctr:=1 to Length(Txt) do begin
    Ch:=Ord(Txt[Ctr]);
    if Ch<128 then Inc(Ch,128);
    Write(Chr(Ch));
  end;*)
  Write(Txt);
end;

procedure InitScreen;
begin
  WriteAt(15,1,'THE CHARACTER SET EDITOR',3);
  WriteAt(12,2,'(C) 1988-89 FireBall Software',1);
  WriteAt(25,4,'Written by',2);
  WriteAt(23,6,'Robert Schmidt',3);
  WriteAt(1,20,'SELECT mode: arrows + ENTER selects',2);
  WriteAt(1,21,'  C)lear char  D)elete set  O)rig set',2);
  WriteAt(1,22,'  L)oad set  S)tore set',2);
  WriteAt(1,23,'EDIT mode: arrows + INS & DEL (on/off)',2);
  WriteAt(1,24,'  C)lear char   ENTER accepts,',2);
  WriteAt(1,25,'  ESC - no changes',2);
  SetColor(2); Rectangle(0,0,81,81);
  WriteAt(13,3,'ͻ',2);
  WriteAt(13,4,' ',2);
  WriteAt(13,5,'ͼ',2);
  WriteAt(12,8,'(       )',2);
end;

procedure ShowBit(x,y:integer);
begin
  SetFillStyle(1,3*Ord(CurChar[x,y]));
  Bar(x*10+1,y*10+1,(x+1)*10,(y+1)*10);
  PutPixel(104+x,24+y,3*Ord(CurChar[x,y]));
end;

procedure ShowCurChar(ChrNo:integer);
var
  x,y:integer;
  Mask:byte;
begin
  for x:=0 to 7 do begin
    Mask:=Power(2,7-x);
    for y:=0 to 7 do begin
      CurChar[x,y]:=(Font[ChrNo,y] and Mask)=Mask;
      ShowBit(x,y);
    end;
  end;
end;

procedure ShowChars;
var
  ChrNo:integer;
begin
  for x:=1 to 40 do
    for y:=1 to 4 do begin
      ChrNo:=y*40+x+87;
      if ChrNo<=255 then WriteAt(x,y*2+10,Chr(ChrNo),1);
    end;
end;

procedure GetCoords(ChrNo:integer; var x,y:integer);
begin
  x:=(ChrNo-7) mod 40;
  y:=((ChrNo-7) div 40)*2+6;
  if x=0 then begin
    x:=40; Dec(y,2);
  end;
end;

procedure CreateChar(ChrNo:integer);
var
  x,y:integer;
  Mask:byte;
begin
  FillChar(Font[ChrNo],SizeOf(Font[ChrNo]),#0);
  for x:=0 to 7 do begin
    Mask:=Power(2,7-x);
    for y:=0 to 7 do
      Font[ChrNo,y]:=Font[ChrNo,y] or (Mask*Ord(CurChar[x,y]));
  end;
  GetCoords(ChrNo,x,y);
  WriteAt(x,y,Chr(ChrNo),1);
end;

procedure GetFileName(var Name:Str80);
var
  Buffer:record
    MaxLen:byte;
    Data:Str80;
  end;
begin
  Window(22,8,40,10);
  WriteAt(1,1,'Enter filename:',1);
  Writeln; TextColor(3);
  with Regs do begin
    AH:=$A;
    DS:=Seg(Buffer);
    DX:=Ofs(Buffer);
    Buffer.MaxLen:=19;
    Intr($21,Regs);
    Name:=Buffer.Data;
  end;
  ClrScr;
  Window(1,1,80,25);
end;

procedure SaveFont;
var
  FontName:Str80;
begin
  GetFileName(FontName);
  if FontName<>'' then begin
    Assign(FontFil,FontName); {$I-}
    ReWrite(FontFil);         {$I+}
    if IOresult=0 then begin
      Write(FontFil,Font);
      Close(FontFil);
    end;
  end;
end;

procedure SelectChar(var ChrNo:integer);
var
  Key,AltCh:char;
  x,y:integer;
  St,FontName:Str80;
begin
  GetCoords(ChrNo,x,y);
  repeat
    Key:=#255;
    if KeyPressed then Key:=UpCase(ReadKey);
    case Key of
      #0:if KeyPressed then begin
        WriteAt(x,y+1,#32,0);
        Key:=ReadKey;
        case Key of
          'H':if ChrNo>=168 then Dec(ChrNo,40);
          'P':if ChrNo<=215 then Inc(ChrNo,40);
          'K':if ChrNo>=129 then Dec(ChrNo);
          'M':if ChrNo<=254 then Inc(ChrNo);
          'G':ChrNo:=128;
          'O':ChrNo:=255;
        end;
      end;
      'C':begin
        FillChar(Font[ChrNo],SizeOf(Font[ChrNo]),#0);
        WriteAt(x,y,Chr(ChrNo),1);
      end;
      'D':begin
        FillChar(Font,SizeOf(Font),#0);
        ShowChars;
      end;
      'O':begin
        Move(OldFont^,NewFont^,SizeOf(Font));
        ShowChars;
      end;
      'L':begin
        GetFileName(FontName);
        if FontName<>'' then begin
          Assign(FontFil,FontName); {$I-}
          Reset(FontFil);           {$I+}
          if IOresult=0 then begin
            Read(FontFil,Font);
            Close(FontFil);
            ShowChars;
          end else Write(#7#7);
        end;
      end;
      'S':SaveFont;
    end;
    GetCoords(ChrNo,x,y);
    WriteAt(x,y+1,#94,3);
    WriteAt(14,4,Chr(ChrNo),3);
    Str(ChrNo:3,St);
    WriteAt(13,6,St,3);
    Str((ChrNo-128):3,St);
    AltCh:=Chr(ChrNo-128);
    if AltCh in [#7,#8,#10,#13] then AltCh:=#32;
    WriteAt(13,8,#39+AltCh+#39+':'+St,3);
  until Key in [#13,#27];
  Quit:=(Key=#27);
end;

procedure EditChar(ChrNo:integer);
var
  Key:char;
begin
  ShowCurChar(ChrNo);
  x:=0; y:=0;
  repeat
    Key:=#255;
    if KeyPressed then Key:=UpCase(ReadKey);
    case Key of
      #0:if KeyPressed then begin
        ShowBit(x,y);
        Key:=ReadKey;
        case Key of
          'H':begin Dec(y); if y<0 then y:=7; end;
          'P':begin Inc(y); if y>7 then y:=0; end;
          'K':begin Dec(x); if x<0 then x:=7; end;
          'M':begin Inc(x); if x>7 then x:=0; end;
          'R':CurChar[x,y]:=True;
          'S':CurChar[x,y]:=False;
        end;
      end;
      'C':for x:=0 to 7 do
        for y:=0 to 7 do begin
          CurChar[x,y]:=False;
          ShowBit(x,y);
        end;
    end;
    if Key in ['R','S'] then ShowBit(x,y);
    SetFillStyle(1,1);
    Bar(x*10+3,y*10+3,(x+1)*10-2,(y+1)*10-2);
  until Key in [#13,#27];
  if Key=#13 then CreateChar(ChrNo);
  ShowBit(x,y);
end;

begin
  GetIntVec ($1F,OldFont);
  NewFont:=Ptr(Seg(Font),Ofs(Font));
  SetIntVec ($1F,NewFont);
  Move(OldFont^,NewFont^,SizeOf(Font));
  RegisterCGA; InitCGA(CGAC1);
  DirectVideo:=False;
  InitScreen;
  ShowChars;
  ChrNo:=128;
  x:=0; y:=0;
  Quit:=False;
  SelectChar(ChrNo);
  while not Quit do begin
    EditChar(ChrNo);
    SelectChar(ChrNo);
  end;
  Window(22,9,40,10);
  WriteAt(1,1,'Save font first?',3);
  repeat Key:=UpCase(ReadKey); until Key in ['Y','N'];
  ClrScr;
  if Key = 'Y' then SaveFont;
(*  SetIntVec ($1F,OldFont);*)
end.
