/*
 * Produce an ADFS hard disc image
 */

#include <stdio.h>

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;

byte buffer[1280];

#define D(x) *(dword *)(&buffer[x])
#define W(x) *(word *)(&buffer[x])

main(int argc, char *argv[])
{
	int i, cs, c;
	FILE *f;
	int hd, cyl, sect;
	
	if (argc >= 4)
	{
		hd = strtoul (argv[1], NULL, 0);
		cyl = strtoul (argv[2], NULL, 0);
		sect = strtoul (argv[3], NULL, 0);
	}
	else if (argc == 1)
	{
		// Drive parameters
		hd = 4;
		cyl = 310;
		sect = 33;
	}
	else
	{
		printf ("Usage: %s [ head cyl sect ]\n", argv[0]);
		exit (1);
	}
	printf ("Creating an ADFS image with %d heads, %d cylinders, %d sectors...\n",
		hd, cyl, sect);
	
	memset (buffer, 0, 1280);
	D(0) = 7;
	D(252) = hd*cyl*sect;
	D(256) = W(252)-7;
	W(507) = 0x1675;
	W(509) = 0x300;
	
	cs = 0xff; c = 0;
	for (i = 255; i > 0; i--)
	{
		cs += buffer[i+255] + c;
		if (cs & 0x100)
		{
			cs &= 0xff;
			c = 1;
		}
		else
			c = 0;
	}
	buffer[511] = cs;
	cs = 0xff; c = 0;
	for (i = 255; i > 0; i--)
	{
		cs += buffer[i-1] + c;
		if (cs & 0x100)
		{
			cs &= 0xff;
			c = 1;
		}
		else
			c = 0;
	}
	buffer[255] = cs;
	
	printf ("CS %d %d\n", buffer[255], buffer[511]);
	
	f = fopen ("hd.out", "w");
	// Write map
	fwrite (buffer, 256, 2, f);
	
	memset (buffer, 0, 1280);
	D(1) = 0x6f677548;
	D(0x4fb) = 0x6f677548;
	buffer[0x4cc] = '$'; buffer[0x4cd] = 0xd;
	buffer[0x4d9] = '$'; buffer[0x4da] = 0xd;
	buffer[0x4d6] = 2;
	fwrite (buffer, 256, 5, f);
	
	fclose (f);
}

/* End of file. */
