/*
 * Dialogs used in GTK frontend
 */

#include <gtk/gtk.h>
#include "gtk_fe.h"

#include "DiscEmul.h"
#include "Registry.h"

GtkWidget *dlg, *vbox, *hbox1, *hbox2, *emulchoose, *okbtn, *cancelbtn,
	*lbl1, *lbl2, *text, *browsebtn, *ro_chk, *spt_rad10, *spt_rad16,
	*scroll;

extern "C"
{

struct dsInfo
{
	DiscEmul *de;
	int drvnum;
};
dsInfo *last_ds;

static void delDS (gpointer d)
{
	delete ((dsInfo *) d);
}

static void loaddisc_ok (GtkWidget *w, gpointer data)
{
	char *fname;
	int ro, spt;
	
	printf ("LoadDisc. OK\n");
	fname = gtk_entry_get_text (GTK_ENTRY (text));
	ro = GTK_TOGGLE_BUTTON (ro_chk)->active;
	if (GTK_TOGGLE_BUTTON (spt_rad10)->active)
		spt = 10;
	else
		spt = 16;
	last_ds->de->OpenDiscFile (fname, last_ds->drvnum, ro, spt);
	gtk_widget_destroy (dlg);
}

static void loaddisc_cancel (GtkWidget *w, gpointer data)
{
	gtk_widget_destroy (dlg);
}

static void loaddisc_cancelled (GtkWidget *w, gpointer data)
{
	gtkfe_resume_emul ();
}

static void select_lddisc (GtkWidget *w, gint row, gint column, GdkEventButton *ev, gpointer data)
{
	dsInfo *ds;
	
	ds = (dsInfo *) gtk_clist_get_row_data (GTK_CLIST (w), row);
	if (!ds || !ds->de->getDiscFName (ds->drvnum))
		gtk_entry_set_text (GTK_ENTRY (text), "");
	else
		gtk_entry_set_text (GTK_ENTRY (text), ds->de->getDiscFName (ds->drvnum));
	last_ds = ds;
}

void gtkfe_loaddisc (GtkWidget *w, gpointer data)
{
	ListElem<DiscEmul *> *l;
	char buf[512];
	gchar *col[1] = { (gchar *)&buf };
	int i, j;
	dsInfo *s;
	
	gtkfe_pause_emul ();
	
	dlg = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_title (GTK_WINDOW (dlg), "Load disc image...");
	/*gtk_window_set_policy (GTK_WINDOW (dlg), TRUE, TRUE, TRUE);
	gtk_widget_set_usize (dlg, 300, 150);*/
	
	gtk_signal_connect (GTK_OBJECT (dlg), "destroy",
			GTK_SIGNAL_FUNC (loaddisc_cancelled), NULL);
	
	vbox = gtk_vbox_new (FALSE, 0);
	
	lbl1 = gtk_label_new ("Select the drive to change image for:");
	gtk_widget_show (lbl1);
	gtk_box_pack_start (GTK_BOX (vbox), lbl1, FALSE, FALSE, 2);
	
	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC,
		GTK_POLICY_ALWAYS);
	emulchoose = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (emulchoose), GTK_SELECTION_BROWSE);
	gtk_clist_set_shadow_type (GTK_CLIST (emulchoose), GTK_SHADOW_NONE);
	last_ds = NULL;
	for (l = disc_emul_list.getFirst (), j = 0; l != NULL; l = l->getNext ())
	{
		for (i = 0; i < (**l)->getDrives (); i++)
		{
			snprintf (buf, 512, "%s - drive %d", (**l)->getDescrip (), i);
			s = new dsInfo;
			s->de = (**l);
			s->drvnum = i;
			gtk_clist_prepend (GTK_CLIST (emulchoose), col);
			gtk_clist_set_row_data_full (GTK_CLIST (emulchoose), 0, s, delDS);
			if (!j)
			{
				j = 1;
				gtk_clist_select_row (GTK_CLIST (emulchoose), 0, 0);
				last_ds = s;
			}
		}
	}
	gtk_signal_connect (GTK_OBJECT (emulchoose), "select_row",
			GTK_SIGNAL_FUNC (select_lddisc), NULL);
	gtk_widget_show (emulchoose);
	gtk_container_add (GTK_CONTAINER (scroll), emulchoose);
	gtk_widget_show (scroll);
	gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
	
	hbox1 = gtk_hbox_new (FALSE, 0);
	lbl2 = gtk_label_new ("Select file for drive:");
	gtk_widget_show (lbl2);
	gtk_box_pack_start (GTK_BOX (hbox1), lbl2, FALSE, FALSE, 4);
	text = gtk_entry_new ();
	if (!last_ds || !last_ds->de->getDiscFName (last_ds->drvnum))
		gtk_entry_set_text (GTK_ENTRY (text), "");
	else
		gtk_entry_set_text (GTK_ENTRY (text), last_ds->de->getDiscFName (last_ds->drvnum));
	gtk_widget_show (text);
	gtk_box_pack_start (GTK_BOX (hbox1), text, TRUE, TRUE, 4);
	browsebtn = gtk_button_new_with_label ("Browse...");
	gtk_widget_show (browsebtn);
	gtk_box_pack_start (GTK_BOX (hbox1), browsebtn, FALSE, FALSE, 4);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, FALSE, 4);
	
	ro_chk = gtk_check_button_new_with_label ("Open read only");
	gtk_widget_show (ro_chk);
	gtk_box_pack_start (GTK_BOX (vbox), ro_chk, FALSE, FALSE, 4);
	
	spt_rad10 = gtk_radio_button_new_with_label (NULL, "10 sectors per track (DFS)");
	gtk_widget_show (spt_rad10);
	gtk_box_pack_start (GTK_BOX (vbox), spt_rad10, FALSE, FALSE, 4);
	spt_rad16 = gtk_radio_button_new_with_label (
		gtk_radio_button_group (GTK_RADIO_BUTTON (spt_rad10)), "16 sectors per track (ADFS)");
	gtk_widget_show (spt_rad16);
	gtk_box_pack_start (GTK_BOX (vbox), spt_rad16, FALSE, FALSE, 4);
	
	hbox2 = gtk_hbox_new (TRUE, 0);
	okbtn = gtk_button_new_with_label ("OK");
	gtk_signal_connect (GTK_OBJECT (okbtn), "clicked",
			GTK_SIGNAL_FUNC (loaddisc_ok), NULL);
	gtk_widget_show (okbtn);
	gtk_box_pack_start (GTK_BOX (hbox2), okbtn, TRUE, TRUE, 4);
	cancelbtn = gtk_button_new_with_label ("Cancel");
	gtk_signal_connect (GTK_OBJECT (cancelbtn), "clicked",
			GTK_SIGNAL_FUNC (loaddisc_cancel), NULL);
	gtk_widget_show (cancelbtn);
	gtk_box_pack_start (GTK_BOX (hbox2), cancelbtn, TRUE, TRUE, 4);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 4);
	
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (dlg), vbox);
	gtk_widget_show (dlg);
}

};

/* End of file. */
