/*
 *  DLC - Utility for dynamic loading of classes
 *  Copyright (C) 1999 Martin Reinecke
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#include "dlc_server.h"
#include "basic.h"

int main()
  {
  char key;
  cout << endl;
  cout << "While this program is running, you can modify"<<endl;
  cout << "the method Derived::doit() in derived.cxx."<<endl;
  cout << "After that, compile it with 'make so'."<<endl;
  cout << "When you press <return> in this shell,"<<endl;
  cout << "the shared library will be loaded"<<endl;
  cout << "and Derived::doit() will be executed."<<endl;
  cout << endl;
  cout << "Waiting for <return> ...";
  cin.get (key);
  if (!DLC_Server.load ("./derived.so"))
    {
    cout << "Error opening derived.so. Exiting..." << endl;
    exit(1);
    }
  Basic *ptr= New<Basic> ("Derived");
  ptr->doit(); 
  delete ptr; 
  }
