# common variables and rules for all Makefiles of DLC
# please adjust for your system/compiler

COMPILER =	g++
LINKER =	g++
MAKEDEP =	g++ -E -MM -MG
MAKE =		make -s
CHECKIN =	ar urs
WARNFLAGS =	-W -Wall -Woverloaded-virtual -Wtraditional -ansi -Winline \
		-pedantic -Wcast-qual -Wcast-align -Wpointer-arith
# -Weffc++
OPTFLAGS =	-O2
SYSFLAGS =	-fpic
DEBUGFLAGS =	-s
FEATUREFLAGS =	-fno-exceptions
CFLAGS =	-c $(INCLUDES) $(WARNFLAGS) $(OPTFLAGS) $(SYSFLAGS) \
		$(FEATUREFLAGS) $(DEBUGFLAGS)
LFLAGS =	$(WARNFLAGS) $(OPTFLAGS) $(SYSFLAGS) \
		$(FEATUREFLAGS) $(DEBUGFLAGS)
SHAREFLAGS =	-shared $(LFLAGS)
INCLUDES =	-I$(DLCROOT)
OBJECTS =	$(SOURCES:.cxx=.o)
ENABLE_STRIPPING = YES

# you shouldn't need to change anything below this point

.PHONY: objclean depclean clean compmsg ocomp compile

%.o: %.cxx
	@echo "  Compiling" $*.cxx
	@$(COMPILER) $(CFLAGS) $*.cxx

.depend:
	@if test -n "$(SOURCES)"; then \
		$(MAKEDEP) $(INCLUDES) $(SOURCES) > .depend; \
	fi

objclean:
	@rm -f $(OBJECTS)

depclean:
	@rm -f .depend

clean:
	@echo Cleaning up in `pwd`
	@rm -f $(OBJECTS) $(DELETABLES) .depend
	@if test -n "$(SUBDIRS)"; then \
		for i in $(SUBDIRS)""; do \
			(cd $$i; $(MAKE) clean); \
		done \
	fi

compmsg:
	@echo ""	
	@echo Compiling in `pwd`	

ocomp: compmsg depclean $(OBJECTS) checkin

compile:
	@if test -n "$(OBJECTS)"; then \
		$(MAKE) ocomp; \
	fi
	@if test -n "$(SUBDIRS)"; then \
		for i in $(SUBDIRS)""; do \
			(cd $$i; $(MAKE) compile); \
		done \
	fi

-include .depend
