/*
 * Sound emulation (version 2)
 */

#ifndef SOUNDEMUL_H
#define SOUNDEMUL_H

#include "types.h"

class SoundEmul
{
protected:
	int chanfreq[4], chanvol[4];
	int chanactive[4];
	
	int chan_fi[4];
	
	// chan_lastflip is set to (number of samples since last complete
	// square wave)<<8 + extraneous fractionals
	int chan_lastflip[4];
	
	unsigned long last_cycle;
	unsigned long cycles_extraneous;
	
	int chan0_followfreq1;
	int noise_type;
	int last_chan;
	
	int devfd;
	
	void SetFreq (int chan);
	void SetVol (int chan, int volindex);
	
	void RenderSound (int samples_to_render);

public:
	SoundEmul (void);
	~SoundEmul (void);
	void Write (byte val);
	void Reset (void);
	void DoRenderSound (void);
};

#endif /* SOUNDEMUL_H */

/* End of file. */
