/*
 * Code to maintain a registry for hardware bits and pieces
 */

#ifndef REGISTRY_H
#define REGISTRY_H

#include "ulist.h"

class CompEmul;
class MMIO_Dev;
class DiscEmul;

struct ModuleInfo
{
	MMIO_Dev *instance;
	char *name;
};

extern CompEmul *cur_model;
extern UList<MMIO_Dev *> mmio_dev_list;
extern UList<ModuleInfo *> modules_list;
extern UList<DiscEmul *> disc_emul_list;

extern void Set_Model (CompEmul *mdl);
extern void Load_Model (char *name, char *args);

extern void Register_MMIO (MMIO_Dev *dev);
extern void Unregister_MMIO (MMIO_Dev *dev);
extern ModuleInfo *Register_Module (MMIO_Dev *dev, char *name);
extern void Unregister_Module (ModuleInfo *mod);
extern void Unregister_Module (MMIO_Dev *dev);
extern void Unregister_Module (char *name);
extern void Register_Disc (DiscEmul *disc);
extern void Unregister_Disc (DiscEmul *disc);

extern ModuleInfo *Load_Module (char *module, char *args, int add);
extern void Unload_Module (ModuleInfo *mod);
extern void Unload_Module (MMIO_Dev *dev);
extern void Unload_Module (char *name);

#endif /* REGISTRY_H */

/* End of file. */
