/*
 * Master 128 emulation
 */

#ifndef MASTER_H
#define MASTER_H

#include "CompEmul.h"
#include "VIA6522.h"
#include "MemEmul.h"

#define SYSVIA MasterSysVIA
#include "StdSysVIA.h"
#undef SYSVIA

#define USRVIA MasterUsrVIA
#include "StdUsrVIA.h"
#undef USRVIA

class ACIA;
class MasterEmul;

class MasterMem: public MemEmul
{
protected:
	MasterSysVIA *sysVIA;
	MasterUsrVIA *usrVIA;
	ACIA *acia;
	
	byte HAZEL[0x2000];
	byte LYNNE[0x5000];		// shadow RAM
	byte ANDY[0x1000];
	int ANDY_paged, HAZEL_paged;
	int ACCCON;
	int ROMSEL;
	int LYNNE_options;
	
	MasterEmul *parent;

public:
	MasterMem (MasterEmul *p);
	virtual ~MasterMem (void);
	
	inline void Write (int addr, byte val);
	inline byte Read (int addr);
};

class MasterEmul: public CompEmul
{
protected:
	friend class MasterMem;

public:
	MasterEmul (void);
	virtual ~MasterEmul (void);
	
	virtual void ExecThread (void);
};

#endif /* MASTER_H */

/* End of file. */
