/*
 * Main program for TBE emulator
 */

#include <stdio.h>

#include "utils.h"
#include "config.h"

#include "Configuration.h"

#include "DiscEmul.h"
#include "Registry.h"
#include "CompEmul.h"
#include "CPUEmul.h"
#include "MemEmul.h"

#include "gtk_fe.h"

#ifdef NEED_VERNAME
char *ver_name;
#define INIT_VER_NAME	{ \
		static char name[] = "$Name:  $"; \
		char *c; \
		for (ver_name = name; *ver_name != ':' && *ver_name != 0; ver_name++) ; ver_name++; \
		Assert (*ver_name != 0); \
		for (c = ver_name; *c != '$' && *c != 0; c++) ; \
		Assert (*c != 0); \
		for (c--; *c == ' '; c--) ; c++; \
		*c = 0; \
		if (c == ver_name) ver_name = "{nover}"; \
	}
#else
#define INIT_VER_NAME
#endif

int main (int argc, char *argv[])
{
	int i, j;
	
	// Command-line setup
	prelimProcessOpt (argc, argv);
#ifdef INTERFACE_GTK
	gtkfe_init (&argc, &argv);
#endif
	getEmulSetup (argc, argv);
	
	// Initialize debugging
	DebugInit ();
	
	// Print the banner
	INIT_VER_NAME;
	printf ("TBE -- Tom's Beeb Emulator.\nVersion %s\n\n", VERNAME);
	
	Load_Model (model, model_args);
	
	// Add the modules specified on the command-line and in configfiles
	for (i = 0; i < num_modules; i++)
		if (modules[i])
			Load_Module (modules[i], modules_args[i], 1);
	
	// Add the WD1770 controller
	switch (disctype)
	{
		case 0:
		printf ("No disc emulation.\n");
		//disc = NULL;
		break;
		
		case 1:
		fatal ("8271 emulation not yet supported.");
		
		case 2:
		Load_Module ("WD1770", "", 1);
		Load_Module ("DrvCtrl", "", 1);
		printf ("WD1770 disc emulation started OK.\n");
		break;
	}
	
	for (i = 0; i < num_roms; i++)
		cur_model->ReadROM (romslots[i], roms[i]);
	for (i = 0; i < num_rams; i++)
		cur_model->SetRAM (ramslots[i]);
	for (i = 0; i < num_discloads; i++)
	{
		ListElem<DiscEmul *> *l;
		
		for (j = 0, l = disc_emul_list.getFirst (); j < discloads[i].drv && l;
			j += (**l)->getDrives (), l = l->getNext ())
			;
		if (!l)
		{
			error ("Invalid drvnum %d in discload specification", discloads[i].drv);
			continue;
		}
		(**l)->OpenDiscFile (discloads[i].fname, discloads[i].drv - j,
			discloads[i].ro, discloads[i].spt);
	}
	
	cur_model->Reset ();
	
	for (i = 0; i < 0x10; i++)
		for (j = 0; j < 8; j++)
			kbmap[i][j] = 0;
	for (i = 0; i < 3; i++)
		mousebtns[i] = 0;
	mousemotx = mousemoty = 0;
	
#ifdef INTERFACE_GTK
	gtkfe_main ();
#endif
}

extern "C"
{
int kbmap[0x10][0x8];
int mousebtns[3], mousemotx, mousemoty;
KeyEventHandler KeyboardEvent = NULL;
void *KeyEventData;

void ExecThread (void)
{
	cur_model->ExecThread ();
}

void SetKeyEvent (KeyEventHandler handler, void *data)
{
	KeyboardEvent = handler;
	KeyEventData = data;
}

}		// extern "C"

/* End of file. */
