/*
 * B/B+ drive control for a WD1770
 */

#include "WD1770.h"
#include "dlc/dlc_register.h"

#include "Registry.h"
#include "DiscEmul.h"

DrvCtrl::DrvCtrl (void): MMIO_Dev (0xffff, 0xfe80)
{
	ListElem<DiscEmul *> *le;
	
	// Find the DiscEmul we need. It has flags & DISC_FLG_WD1770 set.
	for (le = disc_emul_list.getFirst (); le != NULL; le = le->getNext ())
		if ((**le)->flags & DISC_FLG_WD1770)
			break;
	if (le)
		disc = **le;
	else
		disc = NULL;
	
	printf ("Got disc '%s' for DrvCtrl\n", disc ? disc->getDescrip () : "");
	
	status = 1;
	
	addr.reg_mask = 0;
}

byte DrvCtrl::MMIO_Read (int addr)
{
	return status;
}

void DrvCtrl::MMIO_Write (int addr, byte val)
{
	int drv;
	
	// We implement the 1770 B+ drive control
	drv = (val & 0x01) ? 0 : ((val & 0x02) ? 1 : -1);
	if (drv != -1)
	{
		status &= ~0x3;
		status |= 1<<drv;
		
		disc->SelectDriveNum (drv);
	}
}

DLC_Register (DrvCtrl);

/* End of file. */
