/*
 * Display rendering functions
 */

#include "utils.h"

#include "Display.h"

#include <string.h>

static char mode7_charsets[][64*(127-32+1)] = {
	{
	#include "mode7n.dat"
	},
	{
	#include "mode7g.dat"
	},
	{
	#include "mode7sg.dat"
	}
};

#define space mode7_charsets[0]

int in_mode7 = 1;

int update_display = 1;

inline void SetPix (char *fb, int col)
{
	if (col)
	{
		*fb = 0xff;
		*(fb++) = 0xff;
	}
	else
	{
		*fb = 0;
		*(fb++) = 0;
	}
}

inline void Render_mode7_char (char *cell_fb, char *ch, int col)
{
	// Render one character at cell_fb.
	int i, j;
	
	for (i = 0; i < 10; i++)
	{
		for (j = 0; j < 6; j++)
			SetPix (cell_fb + (j * bytes_pixel), (*ch++) * col);
		cell_fb += pitch;
	}
}

inline void Render_mode7_line (int line, byte *data)
{
	int colour = 7;
	int charset = 0;
	int col = 0;
	byte ch;
	char *cell_fb = (line * 10 * pitch) + framebuf;
	int cp = 6 * bytes_pixel;
	
	do
	{
		// Normal chars
		ch = *(data++);
		if (ch >= 33 && ch <= 127)
		{
			Render_mode7_char (cell_fb, &mode7_charsets[charset][(ch - 32)*64], colour);
			col++;
			cell_fb += cp;
		}
		else
		{
			// Blank space
			Render_mode7_char (cell_fb, space, 7);
			col++;
			cell_fb += cp;
			
			// Effects
		/*	switch (ch)
			{
				case 128: case 129: case 130: case 131:
				case 132: case 133: case 134: case 135:
				// Set colour
				//colour = ch & 7;
			}*/
		}
	} while (col < 40);
}

inline void Render_mode7 (byte *data, byte *display)
{
	int l, i;
	byte *d, *di;
	
	if (update_display)
	{
		for (l = 0, d = data, di = display; l < 25; l++, d += 40,
			di += 40)
		{
			Render_mode7_line (l, d);
			memset (di, 0, 40);
		}
		update_display = 0;
	}
	else
	{
		for (l = 0, d = data, di = display; l < 25; l++, d += 40,
			di += 40)
		{
			/*for (i = 0; i < 10; i++)
				if (*((u32 *)(di + (4*i))))
					break;*/
			for (i = 0; i < 40; i++)
				if (di[i])
					break;
			if (i < 40)
			{
				Render_mode7_line (l, d);
				memset (di, 0, 40);
			}
		}
	}
}

void Render_Display (byte *data, byte *display)
{
	return;
	if (in_mode7)
	{
		Render_mode7 (data, display);
		screen_update ();
		return;
	}
}

/* End of file. */
