/*
 * Generic CPU emulation code.
 */

#ifndef CPUEMUL_H
#define CPUEMUL_H

#define NUM_COUNTERS 10

class CPUEmul
{
protected:
	// Cycle counters
	int counter[NUM_COUNTERS];
	int counteractive[NUM_COUNTERS];
	int cycles;

public:
	CPUEmul (void);
	void ExecInstruction (void) {};
	virtual void Trace (void) = 0;
	virtual void ResetCPU (void);
	virtual void SignalIRQ (int queue_anyway = 0) = 0;
	virtual void ClearIRQ (int queue_anyway_id) = 0;
	virtual void SignalNMI (void) = 0;
	virtual int GetPC (void) = 0;
	
	inline void ActivateCounter (int counter);
	inline int check_cycles (int ncycles, int counternum = -1);
};

void CPUEmul::ActivateCounter (int counter)
{
	counteractive[counter] = 1;
}

int CPUEmul::check_cycles (int ncycles, int counternum)
{
	int i;
	
	if (counternum == -1)	// Counter -1 also resets other counters
	{
		if (cycles >= ncycles)
		{
			cycles -= ncycles;
			for (i = 0; i < NUM_COUNTERS; i++)
				if (counteractive[i])
					counter[i] -= ncycles;
			return 1;
		}
		return 0;
	}
	if ((counter[counternum] + ncycles) <= cycles)
	{
		counter[counternum] += ncycles;
		counteractive[counternum] = 1;
		return 1;
	}
	return 0;
}

#endif /* CPUEMUL_H */

/* End of file. */
