/*
 * Acorn TUBE emulation classes
 */

#ifndef ACORNTUBE_H
#define ACORNTUBE_H

#include "MemEmul.h"
#include "utils.h"

#include "CompEmul.h"

class AcornTUBE: public MMIO_Dev
{
protected:
	ByteFIFO *PH_R1;
	int HP_R1;
	int PH_R2, HP_R2;
	ByteFIFO *PH_R3, *HP_R3;
	int PH_R3_byte, HP_R3_byte;
	int PH_R4, HP_R4;
	int status;
	enum status_flags
	{
		HOST_IRQ_R4 = 0x1,
		IRQ_R1 = 0x2,
		IRQ_R4 = 0x4,
		NMI_R3 = 0x8,
		FIFO_R3 = 0x10,
		PARA_RESET = 0x20,
	};
	
	CompEmul *paracomp;

public:
	AcornTUBE (void);
	virtual ~AcornTUBE (void);
	virtual byte MMIO_Read (int addr);
	virtual void MMIO_Write (int addr, byte val);
	virtual byte ReadParasiteReg (int addr);
	virtual void WriteParasiteReg (int addr, byte val); 
	
	virtual void SetParasite (CompEmul *parasite);
	
	virtual void Reset (void);
	
	virtual void AddOK (void);
};

#endif /* ACORNTUBE_H */

/* End of file. */
