/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* symbolic.c */

#include "symbolic.h"

/* This function takes a one byte value representing an instruction, 
 * and returns two strings, containing a symbolic representation of
 * its operation */ 

void symbolic(unsigned char ad, char *line1, char *line2)
{

switch (ad) {
	case 0 :  BRK; break;
	case 1 :  ORA; break;
	case 5 :  ORA; break;
	case 6 :  ASL; break;
	case 8 :  PHP; break;
	case 9 :  ORA; break;
	case 10 :  ASL; break;
	case 13 :  ORA; break;
	case 14 :  ASL; break;
	case 16 :  BPL; break;
	case 17 :  ORA; break;
	case 21 :  ORA; break;
	case 22 :  ASL; break;
	case 24 :  CLC; break;
	case 25 :  ORA; break;
	case 29 :  ORA; break;
	case 30 :  ASL; break;
	case 32 :  JSR; break;
	case 33 :  AND; break;
	case 36 :  BIT; break;
	case 37 :  AND; break;
	case 38 :  ROL; break;
	case 40 :  PLP; break;
	case 41 :  AND; break;
	case 42 :  ROL; break;
	case 44 :  BIT; break;
	case 45 :  AND; break;
	case 46 :  ROL; break;
	case 48 :  BMI; break;
	case 49 :  AND; break;
	case 53 :  AND; break;
	case 54 :  ROL; break;
	case 56 :  SEC; break;
	case 57 :  AND; break;
	case 61 :  AND; break;
	case 62 :  ROL; break;
	case 64 :  RTI; break;
	case 65 :  EOR; break;
	case 69 :  EOR; break;
	case 70 :  LSR; break;
	case 72 :  PHA; break;
	case 73 :  EOR; break;
	case 74 :  LSR; break;
	case 76 :  JMP; break;
	case 77 :  EOR; break;
	case 78 :  LSR; break;
	case 80 :  BVC; break; 
	case 81 :  EOR; break;
	case 85 :  EOR; break;
	case 86 :  LSR; break;
	case 88 :  CLI; break;
	case 89 :  EOR; break;
	case 93 :  EOR; break;
	case 94 :  LSR; break;
	case 96 :  RTS; break;
	case 97 :  ADC; break;
	case 101 :  ADC; break;
	case 102 :  ROR; break;
	case 104 :  PLA; break;
	case 105 :  ADC; break;
	case 106 :  ROR; break;
	case 108 :  JMP; break;
	case 109 :  ADC; break;
	case 110 :  ROR; break;
	case 112 :  BVS; break;
	case 113 :  ADC; break;
	case 117 :  ADC; break;
	case 118 :  ROR; break;
	case 120 :  SEI; break;
	case 121 :  ADC; break;
	case 124 :  JMP; break;
	case 125 :  ADC; break;
	case 126 :  ROR; break;
	case 129 :  STA; break;
	case 132 :  STY; break;
	case 133 :  STA; break;
	case 134 :  STX; break;
	case 136 :  DEY; break;
	case 138 :  TXA; break;
	case 140 :  STY; break;
	case 141 :  STA; break;
	case 142 :  STX; break;
	case 144 :  BCC; break;
	case 145 :  STA; break;
	case 148 :  STY; break;
	case 149 :  STA; break;
	case 150 :  STX; break;
	case 152 :  TYA; break;
	case 153 :  STA; break;
	case 154 :  TXS; break;
	case 157 :  STA; break;
	case 160 :  LDY; break;
	case 161 :  LDA; break;
	case 162 :  LDX; break;
	case 164 :  LDY; break;
	case 165 :  LDA; break;
	case 166 :  LDX; break;
	case 168 :  TAY; break;
	case 169 :  LDA; break;
	case 170 :  TAX; break;
	case 172 :  LDY; break;
	case 173 :  LDA; break;
	case 174 :  LDX; break;
	case 176 :  BCS; break;
	case 177 :  LDA; break;
	case 180 :  LDY; break;
	case 181 :  LDA; break;
	case 182 :  LDX; break;
	case 184 :  CLV; break;
	case 185 :  LDA; break;
	case 186 :  TSX; break;
	case 188 :  LDY; break;
	case 189 :  LDA; break;
	case 190 :  LDX; break;
	case 192 :  CPY; break;
	case 193 :  CMP; break;
	case 196 :  CPY; break;
	case 197 :  CMP; break;
	case 198 :  DEC; break;
	case 200 :  INY; break;
	case 201 :  CMP; break;
	case 202 :  DEX; break;
	case 204 :  CPY; break;
	case 205 :  CMP; break;
	case 206 :  DEC; break;
	case 208 :  BNE; break;
	case 209 :  CMP; break;
	case 213 :  CMP; break;
	case 214 :  DEC; break;
	case 216 :  CLD; break;
	case 217 :  CMP; break;
	case 221 :  CMP; break;
	case 222 :  DEC; break;
	case 224 :  CPX; break;
	case 225 :  SBC; break;
	case 228 :  CPX; break;
	case 229 :  SBC; break;
	case 230 :  INC; break;
	case 232 :  INX; break;
	case 233 :  SBC; break;
	case 234 :  NOP; break;
	case 236 :  CPX; break;
	case 237 :  SBC; break;
	case 238 :  INC; break;
	case 240 :  BEQ; break;
	case 241 :  SBC; break;
	case 245 :  SBC; break;
	case 246 :  INC; break;
	case 248 :  SED; break;
	case 249 :  SBC; break;
	case 253 :  SBC; break;
	case 254 :  INC; break;
	default :   UNK; break;
	}
}
/**************************************************************************/

