/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* load_images.c */

#include <stdio.h>
#include "memory.h"
#include "load.h"

extern char *progname;

void load_images()
{
FILE *fd, *fdrc;
int noread, returncode;
char image_name[30];
int bank_number = 0xf;

/* Attempt to load an operating system */			

if (fd = fopen(OSFILE,"r"))
	{
        noread = fread((M+0xc000), 1, 0x4000, fd);
        returncode = fclose(fd);
       	fprintf(stderr,"%s: Read in OS, 0x%x bytes\n",progname,noread);
	}
else
	fprintf(stderr,"%s: Can't open file %s\n",progname,OSFILE);

/* Attempt to load any additional OS data
This is required by the BBC OS so that screen mapping is
performed correctly, amongst other things */
	
if (fd = fopen(DUMPFILE,"r"))
	{
       	noread = fread((M), 1, 0xe00, fd);
       	returncode = fclose(fd);
	fprintf(stderr,"%s: Read Low OS Area, 0x%x bytes\n",progname, noread);
	}
else
	fprintf(stderr,"%s: Can't open %s\n",progname,DUMPFILE);



/* Try to open the .6502rc file, return otherwise */

if ((fdrc = fopen(".6502rc","r")) == NULL)
		return;

/* For each entry in the .6502rc file, load the ROM image
These images are placed in paged ROM banks */

while ((fscanf(fdrc,"%s",image_name) != EOF) && (bank_number>=0))
	{

	if (fd = fopen(image_name,"r"))
		{
        	noread = fread(&(paged_rom[bank_number][0]), 1, 16384, fd);
        	returncode = fclose(fd);
	        fprintf(stderr,"%s: Read in %s, 0x%x bytes\n",progname,image_name,noread);
		}
	else
		fprintf(stderr,"%s: Can't open %s\n",progname, image_name);

	bank_number--;
	}

returncode = fclose(fdrc);

}
/**************************************************************************/

