/*
 * Copyright (c) James Fidell 1994, 1995, 1996.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission. The
 * copyright holder makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>

#include "Config.h"
#include "Sound.h"

#ifdef	VOXWARE_SOUND
#include "VoxWare.h"
#endif

#if defined(VOXWARE_SOUND)
#define	SOUND_IMPLEMENTED
#endif


void
SoundWrite ( unsigned char ora )
{
#ifdef	SOUND_IMPLEMENTED

#ifdef	VOXWARE_SOUND
	VoxWareWrite ( ora );
#endif

#else	/* SOUND_IMPLEMENTED */

	/*
	 * Not really sure what to do here -- let's just ignore the whole
	 * thing...
	 */

#endif	/* SOUND_IMPLEMENTED */

	return;
}


byteval
SpeechRead()
{
	/*
	 * FIX ME
	 */

#ifdef	TODO
	fprintf ( stderr, "Speech read not yet implemented\n" );
#endif
	return 0x00;
}


void
SpeechWrite ( byteval data )
{
	/*
	 * FIX ME
	 */

#ifdef	TODO
	fprintf ( stderr, "Speech write not yet implemented\n" );
#endif
	return;
}


void
InitialiseSound()
{
#ifdef	SOUND_IMPLEMENTED

#ifdef	VOXWARE_SOUND
	InitialiseVoxWare();
#endif

#else	/* SOUND_IMPLEMENTED */

	fprintf ( stderr, "warning: sound is not implemented\n" );

#endif	/* SOUND_IMPLEMENTED */

	return;
}
