' read the opcodes
h=freefile
open "6502_opcodes.txt" for input as #h
for i=0 to 255
	line input #h,l
	l=chomp(l)
	split l by " " to op_name[i],addrmode[i],opcode[i],illstr
	illegal[i]=(lcase(illstr)="y")
next i
close #h

' read the instructions
h=freefile
open "instr_types.txt" for input as #h
do while not eof(h)
	line input #h,l
	l=trim(chomp(l))
	if left(l,2)<>"//" then
		split l by " " to instruction_name,instruction_type
		instruction_types{lcase(instruction_name)}=instruction_type
	end if
loop
close #h

' write out
print "#ifndef GENERIC6502INSTRUCTIONSET_H_\n"
print "#define GENERIC6502INSTRUCTIONSET_H_\n"
print "// Automatically generated by make_generic6502_type.bas\n"
print "// Don't bother editing!\n"
print "\n"
print "template<class ProcessorType>\n"
print "struct Generic6502InstructionSet {\n"
print "\ttypedef ProcessorType P;\n"
for i=0 to 255
	print "\ttypedef "
	if illegal[i] then
		print "P::Implied<P::InstrILL,P::ModeIMP>"
	else
		typ=instruction_types{lcase(op_name[i])}
		if typ=undef then
			print "FATAL: What type is \""&op_name[i]&"\"?\n"
			stop
		end if
		print "P::"&typ
		print "<"
		print "P::Instr"&ucase(op_name[i])
		print ","
		print "P::Mode"&ucase(addrmode[i])
		print ">"
	end if
	print " Opcode"& hexstr(i,2)
	print ";\n"
next i
print "};\n"
print "#endif\n"
end

sub hexstr(num,length)
	local temp

	temp=string(length-1,"0")
	temp&=hex(byval(num))
	hexstr=right(temp,length)
end sub
