#include "pch.h"
#include "mbRomsConfigDialog.h"

enum {
	id_fsels=1,
	id_ok,
	id_apply_reset,
};

mbRomsConfigDialog::RomControls::RomControls():
slot(-1),
sizer(0),
slot_number(0),
file_name(0),
select_file(0),
is_ram(0),
file_name_vd(0),
is_ram_vd(0)
{
}

#ifdef __WXDEBUG__
bool mbRomsConfigDialog::RomControls::AllOk() const {
	return this->sizer&&this->slot_number&&this->file_name&&this->select_file&&
		this->is_ram&&this->file_name_vd&&this->is_ram_vd;
}
#endif


mbRomsConfigDialog::mbRomsConfigDialog(wxWindow *parent,wxWindowID id,
	const mbRomsConfig &cfg):
wxDialog(parent,id,"Configure ROMs",wxDefaultPosition,wxDefaultSize,
	wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER),
cfg_(cfg),
//roms_sizer_(0),
//scrollw_(0),
os_file_name_vd_(0),
result_flags_(0)
{
	this->SetExtraStyle(this->GetExtraStyle()|wxWS_EX_VALIDATE_RECURSIVELY);
	this->RefreshRomControls();
	this->SetSize(cfg_.dlg_rect);
}

mbRomsConfigDialog::~mbRomsConfigDialog() {
	this->ResetRomControls();
}

void mbRomsConfigDialog::RefreshRomControls() {
	static const int border_size=6;
	unsigned i;

	//Hey, cool, manual dialog layout :(

	this->ResetRomControls();
	wxScrolledWindow *scrollw=new wxScrolledWindow(this,-1);
	wxBoxSizer *all_sz=new wxBoxSizer(wxVERTICAL);
	wxStaticBox *static_box=new wxStaticBox(this,-1,"Paged ROMs");
	wxStaticBoxSizer *box_interior=new wxStaticBoxSizer(static_box,wxVERTICAL);
	box_interior->Add(scrollw,1,wxGROW);

	for(i=0;i<16;++i) {
		RomControls *rc=new RomControls;
		rc->slot=15-i;
		mbRomsConfig::Rom *rom=&cfg_.roms[rc->slot];

		//BAsic control setup
		rc->file_name=new wxTextCtrl(scrollw,-1);
		rc->select_file=new wxButton(scrollw,id_fsels,"...",wxDefaultPosition,
			wxDefaultSize,wxBU_EXACTFIT);
		rc->is_ram=new wxCheckBox(scrollw,-1,"RAM");
		rc->slot_number=new wxStaticText(scrollw,-1,wxString::Format("%X",rc->slot));

		//Sizers
		int border=wxLEFT|wxRIGHT|wxTOP;
		rc->sizer=new wxBoxSizer(wxHORIZONTAL);
		rc->sizer->Add(rc->slot_number,0,border,border_size);
		rc->sizer->Add(rc->file_name,1,wxEXPAND|wxTOP|wxLEFT,border_size);
		rc->sizer->Add(rc->select_file,0,wxRIGHT|wxTOP,border_size);
		rc->sizer->Add(rc->is_ram,0,border|wxALIGN_CENTRE_VERTICAL,border_size);

		//Validators
		rc->file_name_vd=new wxTextValidator(wxFILTER_NONE,&rom->filename);
		rc->file_name->SetValidator(*rc->file_name_vd);
		rc->is_ram_vd=new wxGenericValidator(&rom->ram);
		rc->is_ram->SetValidator(*rc->is_ram_vd);

		rom_controls_.push_back(rc);
	}

	//Size the rom controls
	wxBoxSizer *roms_sizer=new wxBoxSizer(wxVERTICAL);//wxBoxSizer(wxVERTICAL);
	for(i=0;i<16;++i) {
		RomControls *rc=rom_controls_[i];
		roms_sizer->Add(rc->sizer,0,wxEXPAND);
	}

	//OS ROM selector
	wxBoxSizer *os_sz;
	{
		//Controls
		wxStaticText *os_rom=new wxStaticText(this,-1,"OS ROM");
		wxTextCtrl *os_filename=new wxTextCtrl(this,-1);
		wxButton *dotdotdot=new wxButton(this,id_fsels,"...",wxDefaultPosition,
			wxDefaultSize,wxBU_EXACTFIT);

		//Sizer
		os_sz=new wxBoxSizer(wxHORIZONTAL);
		os_sz->Add(os_rom,0,wxALL|wxALIGN_CENTRE_VERTICAL);
		os_sz->Add(os_filename,1,wxEXPAND|wxLEFT|wxTOP|wxBOTTOM,border_size);
		os_sz->Add(dotdotdot,0,wxALIGN_RIGHT|wxRIGHT|wxTOP|wxBOTTOM,border_size);

		//validators
		os_file_name_vd_=new wxTextValidator(wxFILTER_NONE,&cfg_.os_filename);
		os_filename->SetValidator(*os_file_name_vd_);
	}

	//Buttons
	wxBoxSizer *btns_sz;
	{
		wxButton *apply=new wxButton(this,id_apply_reset,"&Apply and Reset");
		wxButton *ok=new wxButton(this,id_ok,"OK");
		wxButton *cancel=new wxButton(this,wxID_CANCEL,"Cancel");

		ok->SetDefault();
		
		btns_sz=new wxBoxSizer(wxHORIZONTAL);
		btns_sz->Add(apply,0,wxALL|wxALIGN_RIGHT,border_size);
		btns_sz->Add(ok,0,wxALL|wxALIGN_RIGHT,border_size);
		btns_sz->Add(cancel,0,wxALL|wxALIGN_RIGHT,border_size);
	}

	//column containing everything
	wxStaticText *help_caption=new wxStaticText(this,0,
		"These options will not take effect unless \"Reset (Apply)\" is used.");
	all_sz->Add(help_caption,0,wxALL,border_size);
	all_sz->Add(box_interior,1,wxGROW|wxALL,border_size);
	all_sz->Add(os_sz,0,wxGROW|wxALL,border_size);
	all_sz->Add(btns_sz,0,wxALL|wxALIGN_RIGHT,border_size);
	
	//scroll
	scrollw->SetScrollbars(1,1,50,50);
	scrollw->SetSizer(roms_sizer);
//	roms_sizer->SetSizeHints(scrollw);

	this->SetSizer(all_sz);
	all_sz->SetSizeHints(this);

	this->RefreshDialog();
}

void mbRomsConfigDialog::ResetRomControls() {
//	if(scrollw_) {
//		scrollw_->Destroy();
//		scrollw_=0;
//	}
	delete os_file_name_vd_;
	os_file_name_vd_=0;
//	this->SetSizer(0);
//	roms_sizer_=0;
	for(unsigned i=0;i<rom_controls_.size();++i) {
		RomControls *rc=rom_controls_[i];
		delete rc->file_name_vd;
		delete rc->is_ram_vd;
		delete rc;
	}
	rom_controls_.clear();
}

void mbRomsConfigDialog::OnFileSelect(wxCommandEvent &event) {
	wxObject *obj=event.GetEventObject();
	unsigned i;
	for(i=0;i<rom_controls_.size();++i) {
		if(obj==rom_controls_[i]->select_file) {
			break;
		}
	}
	wxString *rom_name;
	wxString fsel_msg;

	if(i<rom_controls_.size()) {
		rom_name=&cfg_.roms[rom_controls_[i]->slot].filename;
		fsel_msg=wxString::Format("Select ROM for slot %u",i);
	} else {
		rom_name=&cfg_.os_filename;
		fsel_msg=wxString::Format("Select OS ROM");
	}
	wxString old_dir,old_name;
	wxFileName old=wxFileName::FileName(*rom_name);
	if(old.IsOk()) {
		old_name=old.GetFullName();
		old_dir=old.GetPath();
	}
	wxFileDialog fd(this,fsel_msg,old_dir,old_name,"All files|*.*",
		wxOPEN|wxHIDE_READONLY);
	if(fd.ShowModal()==wxID_OK) {
		*rom_name=fd.GetPath();
		this->RefreshDialog();
	}
}

void mbRomsConfigDialog::RefreshDialog() {
	this->TransferDataToWindow();
}

void mbRomsConfigDialog::OnOk(wxCommandEvent &event) {
	this->DataOk(wxID_OK);
}

void mbRomsConfigDialog::OnApplyReset(wxCommandEvent &event) {
	this->DataOk(wxID_APPLY);
}

void mbRomsConfigDialog::GetResult(mbRomsConfig *cfg) const {
	wxASSERT(cfg);
	*cfg=cfg_;
}

void mbRomsConfigDialog::DataOk(int result) {
	cfg_.dlg_rect=this->GetRect();
	this->TransferDataFromWindow();
	this->EndModal(result);
}

BEGIN_EVENT_TABLE(mbRomsConfigDialog,wxDialog)
	EVT_BUTTON(id_fsels,mbRomsConfigDialog::OnFileSelect)
	EVT_BUTTON(id_ok,mbRomsConfigDialog::OnOk)
	EVT_BUTTON(id_apply_reset,mbRomsConfigDialog::OnApplyReset)
//	EVT_BUTTON(id_cancel,mbRomsConfigDialog::OnCancel)
END_EVENT_TABLE()
