#include "pch.h"
#include "bbcDiscInterface.h"
#include <list>

typedef std::list<bbcDiscInterface *> AllInterfacesType;

static AllInterfacesType AllInterfaces() {
	AllInterfacesType all_interfaces;
	return all_interfaces;
}

bbcDiscInterface *bbcDiscInterfaceGetFromName(const char *name) {
	AllInterfacesType::iterator it=AllInterfaces().begin();
	AllInterfacesType::iterator all_end=AllInterfaces().end();
	for(;it!=all_end;++it) {
		if(stricmp((*it)->name,name)==0) {
			return *it;
		}
	}
	return 0;
}

bbcDiscInterface::bbcDiscInterface(const char *name_in,const char *long_name_in):
name(name_in),
long_name(long_name_in)
{
	AllInterfaces().push_back(this);
}

bbcDiscInterface::~bbcDiscInterface() {
	AllInterfacesType &all=AllInterfaces();
	AllInterfacesType::iterator it=std::find(all.begin(),all.end(),this);
	BASSERT(it!=all.end());
	all.erase(it);
}
