#ifndef bbcDEBUGTRACE_H_
#define bbcDEBUGTRACE_H_

#ifdef bbcDEBUG_TRACE

#include <deque>

class bbcDebugTrace {
public:
	bbcDebugTrace();
	~bbcDebugTrace();

	typedef bool (*ProgressFn)(int percent_done,void *context);
	bool WriteTrace(FILE *out,ProgressFn progress_fn,void *context) const;

	struct Instr {
		t65::Word pc;
		t65::byte bytes[3];
		t65::byte a,x,y,p,s;
	};

	struct Irq {
		int irqflags;
		struct Via {
			t65::byte ier,ifr,acr;
		};
		Via sys,usr;
		t65::byte fdc_status;
	};

	enum Type {
		ENT_IRQ,
		ENT_INSTR,
	};
	struct Ent {
		Type type;
		int cycles;
		int next_stop;
		union {
			Instr instr;
			Irq irq;
		};
	};

	Instr *NewInstr();
	Irq *NewIrq();

	typedef std::deque<Ent>::const_iterator const_iterator;

//	unsigned size() const;
//	const_iterator begin() const;
//	const_iterator end() const;
protected:
private:
	std::deque<Ent> ents_;
	Ent *NewEnt(Type type);
};
/*
inline unsigned bbcDebugTrace::size() const {
	return ents_.size();
}
*/
inline bbcDebugTrace::Instr *bbcDebugTrace::NewInstr() {
	return &this->NewEnt(ENT_INSTR)->instr;
}

inline bbcDebugTrace::Irq *bbcDebugTrace::NewIrq() {
	return &this->NewEnt(ENT_IRQ)->irq;
}
/*
inline bbcDebugTrace::const_iterator bbcDebugTrace::begin() const {
	return ents_.begin();
}

inline bbcDebugTrace::const_iterator bbcDebugTrace::end() const {
	return ents_.end();
}
*/
#endif//

#endif
