/*

	MakeUEF by Thomas Harte 2000

	Distributed under the GPL - see 'Copying' for details

*/
#include "defines.h"
#include "misc.h"
#include <stdlib.h>
#include <malloc.h>

void C_raw::SetSigned(bool arg)
{
	signd = arg;
}

void C_raw::SetFrequency(int frequency)
{
	freq = frequency;
}

void C_raw::NewBlock(void)
{
	if(!last)
	{
		pos = 0;
		target = fread(buffer, 1, BUFFER_SIZE, infile);
		last = feof(infile) ? true : false;

		if(!signd)
			buffer = to_signed_wave((unsigned char *)buffer, target);
	}
	else
		pos = -1;
}

bool C_raw::Open(char *name)
{
	if(infile = fopen(name, "rb"))
	{
		last = false;
		buffer = (char *)malloc(BUFFER_SIZE);
		NewBlock();
		return true;
	}
	else
	{
		error = "could not open named file\n";
		return false;
	}
}

bool C_raw::Close(void)
{
	free(buffer);
	fclose(infile);

	return true;
}

char C_raw::GetNextValue(void)
{
	char ret = -1;

	if(!Finished())
	{
		ret = buffer[pos];
		pos++;

		if(pos == target)
		{
			NewBlock();
		}

		return ret;
	}
	else
		return -1;
}

bool C_raw::Finished(void)
{
	return last && (pos == -1);
}
