/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include "mode7.h"
#include "TwkUser.h" // get Register definition

extern BYTE CursorOnFlag;
extern BYTE CursorBlinkingEnabled;
extern WORD ScreenStartAddress;
extern WORD CursorStartAddress;

char NormalChars[]=
{
#include "mode7n.dat"
};

char GraphicChars[]=
{
#include "mode7g.dat"
};

char SplitGraphicChars[]=
{
#include "mode7sg.dat"
};

static Register Mode7ScreenRegs[] =
	{
	{ 0x3c2, 0x0, 0xe3},
	{ 0x3d4, 0x0, 0x5f},
	{ 0x3d4, 0x1, 0x3b},
	{ 0x3d4, 0x2, 0x40},
	{ 0x3d4, 0x3, 0x82},
	{ 0x3d4, 0x4, 0x4a},
	{ 0x3d4, 0x5, 0x9a},
	{ 0x3d4, 0x6, 0x23},
	{ 0x3d4, 0x7, 0xb2},
	{ 0x3d4, 0x8, 0x0},
	{ 0x3d4, 0x9, 0x61},
	{ 0x3d4, 0x10, 0xa},
	{ 0x3d4, 0x11, 0xac},
	{ 0x3d4, 0x12, 0xf3},
	{ 0x3d4, 0x13, 0x1e},
	{ 0x3d4, 0x14, 0x40},
	{ 0x3d4, 0x15, 0x7},
	{ 0x3d4, 0x16, 0x1a},
	{ 0x3d4, 0x17, 0xe3},
	{ 0x3c4, 0x1, 0x1},
	{ 0x3c4, 0x4, 0xe},
	{ 0x3ce, 0x5, 0x40},
	{ 0x3ce, 0x6, 0x5},
	{ 0x3c0, 0x10, 0x41},
	{ 0x3c0, 0x12, 0xf},
	{ 0x3c0, 0x13, 0x0}
	};

static char Colours[8][3]={ {00,00,00},
                     {63,00,00},
                     {00,63,00},
                     {63,63,00},
                     {00,00,63},
                     {63,00,63},
                     {00,63,63},
                     {63,63,63} };



void InitMode7()
{
  int Count;
  union REGS regs;

  regs.w.ax=0x13;
  int386( 0x10, &regs, &regs );

  outRegArray(Mode7ScreenRegs,26);
    for (Count=0; Count<8; Count++)
    {
      outp(0x3c8,Count);
      outp(0x3c9,Colours[Count][0]);
      outp(0x3c9,Colours[Count][1]);
      outp(0x3c9,Colours[Count][2]);
    }
}


void TextMode()
{
  union REGS regs;

  regs.w.ax=0x3;
  int386( 0x10, &regs, &regs );
}

//Hold/release actually affects the way colour-change codes are displayed. 
//Normally they are blank; when hold graphics is set, the previous 
//character is displayed again. This allows contiguous blocks of colour.
//Thanks to Tom Seddon for that bit of information...

void DisplayMode7Screen(char * ScreenPtr,WORD WrapCounter)
{
  DWORD Char,PrevChar,Y;
  WORD  DHExisted,DHOn,GraphicsOn,BrokenGraphics,FlashOn,HoldOn,X;
  short CursorWrapValue;

  DoubleHeightOffset=0;  // no previous double height chars on first row

    if (CursorBlinkingEnabled && CursorOnFlag)
    {
        if (CursorStartAddress<ScreenStartAddress)
          CursorWrapValue=((0x8000-ScreenStartAddress)+(CursorStartAddress-ScreenStartAddress));
        else
          CursorWrapValue=(CursorStartAddress-ScreenStartAddress);
    }
    else
      CursorWrapValue=0x401; // dont display a cursor!

    for (Y=0; Y<(25*2400) ; Y+=2400)
    {
      //Start of row:
      //Normal height,
      //contiguous graphics,
      //Alpha white
      //Black background
      //steady
      //Release graphics
      DHExisted=0;
      DHOn=0;
      GraphicsOn=0;
      BrokenGraphics=0;
      Mode7ForeGroundColour=7; // white
      Mode7BackGroundColour=0; // white
      FlashOn=0;
      HoldOn=0;
      PlotDestination=(DWORD)0xa0000 + Y;

      PrevChar=' ';

        for (X=0; X<40; X++)
        {
          Char=*(ScreenPtr++) & 0x7f;
          WrapCounter--;
            if (WrapCounter==0)
              ScreenPtr-=0x400;
              
            switch (Char)
            {
              case 1  :
              case 2  :
              case 3  :
              case 4  :
              case 5  :
              case 6  :
              case 7  :
                        Mode7ForeGroundColour=Char;
                        GraphicsOn=0;
                        Char=PrevChar;
                        goto DrawChar;
              case 8  : FlashOn=1;
                        Char=PrevChar;
                        goto DrawChar;
              case 9  : FlashOn=0;
                        Char=PrevChar;
                        goto DrawChar;
        
              case 12 : DHOn=0;
                        Char=PrevChar;
                        goto DrawChar;
              case 13 : DHOn=1;
                        DHExisted=1;
                        Char=PrevChar;
                        goto DrawChar;
        
              case 17 :
              case 18 :
              case 19 :
              case 20 :
              case 21 :
              case 22 :
              case 23 :
                        Mode7ForeGroundColour=Char-16;
                        GraphicsOn=1;
                        Char=PrevChar;
                        goto DrawChar;

                        // conceal display
              case 24 : Mode7ForeGroundColour=Mode7BackGroundColour; 
                        Char=PrevChar;
                        goto DrawChar;
              case 25 : BrokenGraphics=0; // does not turn graphics on
                        Char=PrevChar;
                        goto DrawChar;
              case 26 : BrokenGraphics=1; //does not turn graphics on
                        Char=PrevChar;
                        goto DrawChar;
        
              case 28 : Mode7BackGroundColour=Black;
                        Char=PrevChar;
                        goto DrawChar;
              case 29 : Mode7BackGroundColour=Mode7ForeGroundColour;
                        Char=PrevChar;
                        goto DrawChar;
        
              case 30 : HoldOn=1;
                        Char=PrevChar;
                        goto DrawChar;
              case 31 : HoldOn=0; // fall thru

              case 0  :
              case 10 :
              case 11 :
              case 14 :
              case 15 :
              case 16 :
              case 27 :

              case 32 : Mode7PlotSpace();
                        break;
        
              
              default :
                            if (HoldOn)
                              PrevChar=Char;
                            else
                              PrevChar=' ';
              DrawChar:
                        if (Char==' ' || // if flash currently off
                            (FlashOn && !CursorOnFlag)) // flash at cursor rate
                          Mode7PlotSpace();
                        else // draw a character
                        {
                          Char-=32;
                          Char<<=6; // *64!
                            if (GraphicsOn)
                            {
                                if (BrokenGraphics)
                                  DataSource=((DWORD)SplitGraphicChars+Char);
                                else
                                  DataSource=((DWORD)GraphicChars+Char);
                            }
                            else
                               DataSource=((DWORD)NormalChars+Char);

                            if (DHOn)
                              Mode7PlotDoubleHeight();
                            else
                              Mode7PlotChar();
                        }
            }

          PlotDestination+=6;
        }

      CursorWrapValue-=40;
        if (CursorWrapValue<0)
        {
          PlotDestination=PlotDestination+(CursorWrapValue*6);
          CursorWrapValue=0x401; // only 1 cursor!
          DisplayMode7Cursor();
        }

        if (DHExisted)
          DoubleHeightOffset^=30;
        else
          DoubleHeightOffset=0;
    }
}
