/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>

extern DWORD VSYNCLineOffset;
extern int SystemInterruptPendingFlag;
extern int DrawEveryXFrames;
extern int DoScanLines;
extern int DoubleBuffering;
extern int Exact_Speed;
extern int VerticalSYNCTimer;
extern WORD ScreenStart;

// N.B. these relate to ScanText in main.c
enum SCAN { SCAN_NONE,SCAN_EVERY_8,SCAN_EVERY };

enum LATCH { LATCH_SOUNDWRITE   =0, // write enable of sound generator IC
             LATCH_SPEECHREAD   =1,
             LATCH_SPEECHWRITE  =2,
             LATCH_KEYBOARDWRITE=3,
             LATCH_SCREENBIT1   =4,
             LATCH_SCREENBIT2   =5,
             LATCH_CAPSLED      =6,
             LATCH_SHIFTLED     =7 };

void ResetSystemVIA();

BYTE ReadSystemVIA(WORD Address);

void WriteSystemVIA(WORD Address,BYTE Value);

int SysViaMinClock();

void CalcSystemVia(int Cycles);

void SetSysCB1(BYTE Button1,BYTE Button2);  // EOC from ADC

//light pen - forget about
void SetSysCB2();

// key pressed
void SetSysCA2(BYTE PositiveFlag);

void DumpSysVIA(FILE * FileHandle);


// IFR bit 7 set if 6522 generated the interrupt (sorted)


// what to do with shift reg?


// ACR register determines t1,t2 usage

// t1 - time out on single shot mode, PB7 gos high - set T1 interrupt flag
// generate interrupt if enabled
// t1 decrements at 1MHz
// t1 continues to decrement after 0 in one shot mode
// t1 interrupt flag must be cleared before it can be reset
//
// t1 free run mode time out:
// invert PB7 - set interrupt bit - reload timer with latches

// t2 - time out on single shot mode,  set T2 interrupt flag
// generate interrupt if enabled
// disable T2 interrupts
// aside T2 interrupts are re-enabled by writing T2CH
// t1 decrements at 1MHz
// t1 continues to decrement after 0 in one shot mode
// t1 interrupt flag must be cleared before it can be reset
// only one interrupt generated for each load of T1LH
//
// t2 - pulse counting mode
// t2 counts a predetermined number of -ve pulse on pb6
// t2 contains this number
// writing T2CH clears the interrupt flag and allows counter to
// decrement every PB6 pulse
// interrupt flag when T2 counts down past zero.


