/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <stdio.h>
#include "bbc.h"
#include "sb.h"

extern unsigned long TotalClockCycles; // used in dumping sound


#define CHANNEL0UPDATE 0
// #define __DUMPSOUND__ 1

static WORD SoundFrequency[4];
static BYTE SoundVolume[4];
static BYTE WhiteNoiseEnabled; //0=Periodic noise -  other=white noise
static BYTE NoiseFrequencyControl; // 0 = low
                                   // 1 = medium
                                   // 2 = high
                                   // 3 = tone generator 1 frequency.
static BYTE LastRegisterUpdated=0;

// Physical sound frequency=4000000/32*frequency sent to chip
// 4000000/32=125000, therefore
// Physical sound  frequency=125000/frequency sent to chip
// range of frequencies sent to chip = 0 to 0x3ff (1023)
// look out for divide by zero

// a volume of 0, means that the sound channel is OFF!

void ResetSound()
{
  SoundFrequency[1]=0x3ff;
  SoundFrequency[2]=0x3ff;
  SoundFrequency[3]=0x3ff;

  SoundVolume[0]=0;
  SoundVolume[1]=15;
  SoundVolume[2]=15;
  SoundVolume[3]=15;

  UpdateSound();
}


void Killsounds()
{
  SoundVolume[0]=0;
  SoundVolume[1]=0;
  SoundVolume[2]=0;
  SoundVolume[3]=0;
}


void WriteSound(BYTE Byte)
{
    if ((Byte & 128)==128)
    { // first byte
        switch ((Byte & 0x70))
        {
            // Frequency registers changes
          case 0x00 :
                      LastRegisterUpdated=3;
                      SoundFrequency[LastRegisterUpdated]&=0x3f0;
                      SoundFrequency[LastRegisterUpdated]|=(Byte & 0xf);
                      break;
          case 0x20 :
                      LastRegisterUpdated=2;
                      SoundFrequency[LastRegisterUpdated]&=0x3f0;
                      SoundFrequency[LastRegisterUpdated]|=(Byte & 0xf);
                      break;
          case 0x40 :
                      LastRegisterUpdated=1;
                      SoundFrequency[LastRegisterUpdated]&=0x3f0;
                      SoundFrequency[LastRegisterUpdated]|=(Byte & 0xf);
                      break;

          case 0x60 : // noise control;
                      LastRegisterUpdated=CHANNEL0UPDATE;
                      WhiteNoiseEnabled=(Byte & 4);
                      NoiseFrequencyControl=(Byte & 3);
                      break;

            // Volume registers ;
          case 0x10 :
                      LastRegisterUpdated=3;
                      SoundVolume[3]=((Byte & 0xf)^0xf);
                      break;
          case 0x30 :
                      LastRegisterUpdated=2;
                      SoundVolume[2]=((Byte & 0xf)^0xf);
                      break;
          case 0x70 :                  
                      LastRegisterUpdated=CHANNEL0UPDATE;
                      SoundVolume[0]=((Byte & 0xf)^0xf);
                        if (NoiseFrequencyControl<3)
                          break;
                      // fall thru if linked
          case 0x50 :
                      LastRegisterUpdated=1;
                      SoundVolume[1]=((Byte & 0xf)^0xf);
                      break;

		}
    }
    else
    { // second byte
      SoundFrequency[LastRegisterUpdated]&=0xf;
      SoundFrequency[LastRegisterUpdated]|=((Byte & 0x3f)<<4);
    }

#ifdef __DUMPSOUND__
    {
      FILE * FH=fopen("SOUND.LOG","at");
      fprintf(FH,"\nByte : 0x%2x (%d %d%d%d %d%d%d%d) (%d %d %d%d%d%d%d%d)   Last Reg %d\n",
              Byte,
              (Byte>>7 & 1),
              (Byte>>6 & 1),
              (Byte>>5 & 1),
              (Byte>>4 & 1),
              (Byte>>3 & 1),
              (Byte>>2 & 1),
              (Byte>>1 & 1),
              (Byte & 1),
              (Byte>>7 & 1),
              (Byte>>6 & 1),
              (Byte>>5 & 1),
              (Byte>>4 & 1),
              (Byte>>3 & 1),
              (Byte>>2 & 1),
              (Byte>>1 & 1),
              (Byte & 1),
              LastRegisterUpdated );
      DumpSound(FH);
      fclose(FH);
    }
#endif
}


void StopSound()
{
  int C;
  _disable();
    for (C=0; C<4; C++)
      ChannelOn[C]=0;
  _enable();
}


void UpdateSound()
{
  int C;

    if (!SoundBlasterExists)
      return;

 // sort periodic noise freq
    switch (NoiseFrequencyControl)
    {
      case 0 : SoundFrequency[0]=0x3ff;
               break;
      case 1 : SoundFrequency[0]=0x2ff;
               break;
      case 2 : SoundFrequency[0]=0x1ff;
               break;
      case 3 : SoundFrequency[0]=SoundFrequency[1];  // 3?
               break;
    }

  _disable();
    for (C=0; C<4; C++)
    {
      Vol[C]=SoundVolume[C];
      Freq[C]=SoundFrequency[C];
      ChannelOn[C]=1;

        if (C==0)
        {
            if (WhiteNoiseEnabled)
              ChannelOn[C]=WHITE_NOISE;
            else
              ChannelOn[C]=PERIODIC_NOISE;
        }

        if (Vol[C]==0 || Freq[C]<0x10)
          ChannelOn[C]=0;
    }
  _enable();
}


void DumpSound(FILE * FileHandle)
{
  char FreqType[4][12]={ "LOW","MEDIUM","HIGH","LINKED TO 1" };

    if (SoundVolume[3]+SoundVolume[2]+SoundVolume[1]+SoundVolume[0]==0)
    {
      fprintf(FileHandle," **** NO SOUND ****\n");
//      return;
    }

  fprintf(FileHandle,"\nChannel 3 frequency %d (%3x), Volume %d\n",SoundFrequency[3],SoundFrequency[3],SoundVolume[3]);
  fprintf(FileHandle,"Channel 2 frequency %d (%3x), Volume %d\n",SoundFrequency[2],SoundFrequency[2],SoundVolume[2]);
  fprintf(FileHandle,"Channel 1 frequency %d (%3x), Volume %d\n",SoundFrequency[1],SoundFrequency[1],SoundVolume[1]);
    if (WhiteNoiseEnabled)
      fprintf(FileHandle,"Channel 0 frequency %s, Volume %d, PERIODIC NOISE\n",
              FreqType[NoiseFrequencyControl],SoundVolume[0]);
    else
      fprintf(FileHandle,"Channel 0 Volume %d, WHITE NOISE\n",
              SoundVolume[0]);
}

