;* -------------------------------------------------------------------------- */
;*                                                                            */
;* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
;*                                                                            */
;* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
;* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
;* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
;* PURPOSE.                                                                   */
;*                                                                            */
;* This code, and no part of this code, may not be used in any                */
;* commercial or for-profit venture without the express written               */
;* permission of D.C.Devenport. (BeebInC@aol.com)                             */
;*                                                                            */
;* Credit must be given within any program that uses any of this code         */
;* OR in the accompanying documentation. (And mail me a copy :) )             */
;*                                                                            */
;*----------------------------------------------------------------------------*/
.486p
.model flat,c

; public shit

    public _LogicalScreen;
    public _PhysicalScreen;
    public _LogicalScreenBase;
    public _PhysicalScreenBase;
    public _ModeXScreenStart;
    public _ModeXLookup;
    public _ModeXLookup2;
    public _ModeXWrap;
    public _ModeXRowSize;
    public _ModeXScreenWrapRestart;

    public _NextModeXScreenStart;
    public _NextModeXWrap;

    public _DefaultModeXScreenStart;
    public _DefaultModeXWrap;

    public Plot20K_;
    public Plot10K_;
    public Plot8K_;
    public PlotMode3_;
    public ClearModeXScreen_;

    public Plot80Row_;
    public Plot40Row_;

    public Plot80Line_;
    public Plot40Line_;

    extrn _CharacterRowsToDisplay:byte;

    extrn _ScreenWidthInMemoryBytes:byte;
    extrn _ScreenWidthExtraInMemoryBytes:dword;

    extrn _ScreenWidthHalfExtraInMemoryBytes:dword;

    extrn _VSYNCLineOffset:dword;

; equates


; macros


_DATA           segment         para public 'DATA'

align 16

; data here

  _LogicalScreen           dd 0xa0280
  _PhysicalScreen          dd 0xa5500 ; not used...
  _LogicalScreenBase       dd 0xa0280
  _PhysicalScreenBase      dd 0xa5500
  _ModeXScreenStart        dd 0
  _ModeXLookup             dd 0
  _ModeXLookup2            dd 0
  _ModeXWrap               dd 0
  _ModeXRowSize            dd 0
  _ModeXScreenWrapRestart  dd 0

  _NextModeXScreenStart    dd 0 ; for single line drawing
  _NextModeXWrap           dd 0 ; for single line drawing

  _DefaultModeXScreenStart dd 0
  _DefaultModeXWrap        dd 0

_DATA           ends


_TEXT           segment         para public 'CODE'

		assume          CS:_text



Plot20K_ proc
    cmp byte ptr _CharacterRowsToDisplay,0
    je  noplot
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push edx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _DefaultModeXScreenStart
    mov ebx, dword ptr _ModeXLookup
    mov ebp, dword ptr _DefaultModeXWrap

    movzx edx,byte ptr _CharacterRowsToDisplay

outerloop:
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes
innerloop:
    lodsb
    xlatb
    stosb
    add edi,79 ;1
    lodsb
    xlatb
    stosb
    add edi,79 ;2
    lodsb
    xlatb
    stosb
    add edi,79 ;3
    lodsb
    xlatb
    stosb
    add edi,79 ;4

    lodsb
    xlatb
    stosb
    add edi,79 ;5
    lodsb
    xlatb
    stosb
    add edi,79 ;6
    lodsb
    xlatb
    stosb
    add edi,79 ;7
    lodsb
    xlatb
    stosb

    sub edi,560

    dec ecx
    jz  exitinnerloop

    sub ebp,8
    jnz innerloop

    mov esi,_ModeXScreenWrapRestart
    jmp innerloop

exitinnerloop:

    add edi,560
    add edi,dword ptr _ScreenWidthExtraInMemoryBytes

    dec edx
    jz exitouterloop

    sub ebp,8
    jnz outerloop

    mov esi,_ModeXScreenWrapRestart
    jmp outerloop

exitouterloop:

    pop edi
    pop esi
    pop ebp
    pop edx
    pop ecx
    pop ebx
    pop eax

noplot:
    ret
Plot20K_ endp



PlotMode3_ proc
    cmp byte ptr _CharacterRowsToDisplay,0
    je  noplot
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push edx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _DefaultModeXScreenStart
    mov ebp, dword ptr _DefaultModeXWrap
    mov ebx, dword ptr _ModeXLookup

    movzx edx,byte ptr _CharacterRowsToDisplay

m3_outerloop:
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes;
m3_innerloop:
    lodsb
    xlatb
    stosb
    add edi,79 ;1
    lodsb
    xlatb
    stosb
    add edi,79 ;2
    lodsb
    xlatb
    stosb
    add edi,79 ;3
    lodsb
    xlatb
    stosb
    add edi,79 ;4

    lodsb
    xlatb
    stosb
    add edi,79 ;5
    lodsb
    xlatb
    stosb
    add edi,79 ;6
    lodsb
    xlatb
    stosb
    add edi,79 ;7
    lodsb
    xlatb
    stosb

    sub edi,560

    dec ecx
    jz  m3_exitinnerloop

    sub ebp,8
    jnz m3_innerloop

    mov esi,_ModeXScreenWrapRestart
    jmp m3_innerloop

m3_exitinnerloop:

    add edi,560
    add edi,dword ptr _ScreenWidthExtraInMemoryBytes

    add edi,160 ; skip 2 lines

    dec edx
    jz m3_exitouterloop

    sub ebp,8
    jnz m3_outerloop

    mov esi,_ModeXScreenWrapRestart
    jmp m3_outerloop

m3_exitouterloop:

    pop edi
    pop esi
    pop ebp
    pop edx
    pop ecx
    pop ebx
    pop eax

    ret
PlotMode3_ endp



Plot10K_ proc
    cmp byte ptr _CharacterRowsToDisplay,0
    je  noplot
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push edx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _DefaultModeXScreenStart
    mov eax, dword ptr _ModeXLookup
    mov ebx, dword ptr _ModeXLookup2
    mov ebp, dword ptr _DefaultModeXWrap
    
    movzx edx,byte ptr _CharacterRowsToDisplay

ten_outerloop:
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes;
ten_innerloop:
    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;1

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;2

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;3

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;4

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;5

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;6

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;7

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub edi,560

    dec ecx
    jz  ten_exitinnerloop

    sub ebp,8
    jnz ten_innerloop

    mov esi,_ModeXScreenWrapRestart
    jmp ten_innerloop

ten_exitinnerloop:

    add edi,560
    add edi,dword ptr _ScreenWidthHalfExtraInMemoryBytes

    dec edx
    jz ten_exitouterloop

    sub ebp,8
    jnz ten_outerloop

    mov esi,_ModeXScreenWrapRestart
    jmp ten_outerloop

ten_exitouterloop:

    pop edi
    pop esi
    pop ebp
    pop edx
    pop ecx
    pop ebx
    pop eax

    ret
Plot10K_ endp




Plot8K_ proc
    cmp byte ptr _CharacterRowsToDisplay,0
    je  noplot
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push edx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _DefaultModeXScreenStart
    mov eax, dword ptr _ModeXLookup
    mov ebx, dword ptr _ModeXLookup2
    mov ebp, dword ptr _DefaultModeXWrap
    

    movzx edx,byte ptr _CharacterRowsToDisplay

eight_outerloop:
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes;
eight_innerloop:
    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;1

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;2

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;3

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;4

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;5

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;6

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;7

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub edi,560

    dec ecx
    jz  eight_exitinnerloop

    sub ebp,8
    jnz eight_innerloop

    mov esi,_ModeXScreenWrapRestart
    jmp eight_innerloop

eight_exitinnerloop:

    add edi,560
    add edi,dword ptr _ScreenWidthHalfExtraInMemoryBytes

    add edi,160 ; skip 2 lines

    dec edx
    jz eight_exitouterloop

    sub ebp,8
    jnz eight_outerloop

    mov esi,_ModeXScreenWrapRestart
    jmp eight_outerloop

eight_exitouterloop:

    pop edi
    pop esi
    pop ebp
    pop edx
    pop ecx
    pop ebx
    pop eax

    ret
Plot8K_ endp


ClearModeXScreen_ proc
    push eax
    push ecx
    push edx
    push edi

    mov  dx,3ceh  
    mov  ax,205h
    out dx,ax     ; write mode 2

    mov eax,0
    mov ecx,264*20 ; clear 264 lines!!
    mov edi, dword ptr _LogicalScreen

    rep stosd

    mov ax,105h   ; write mode 1
    out dx,ax

    pop edi
    pop edx
    pop ecx
    pop eax
    ret
ClearModeXScreen_ endp


Plot80Row_ proc
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot
    push eax
    push ebx
    push ecx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _ModeXScreenStart
    mov ebx, dword ptr _ModeXLookup
    mov ebp, dword ptr _ModeXWrap

    movzx ecx,byte ptr _ScreenWidthInMemoryBytes
inner80loop:
    lodsd
    xlatb
    stosb
    add edi,79 ;1
    shr eax,8
    xlatb
    stosb
    add edi,79 ;2
    shr eax,8
    xlatb
    stosb
    add edi,79 ;3
    shr eax,8
    xlatb
    stosb
    add edi,79 ;4

    lodsd
    xlatb
    stosb
    add edi,79 ;5
    shr eax,8
    xlatb
    stosb
    add edi,79 ;6
    shr eax,8
    xlatb
    stosb
    add edi,79 ;7
    shr eax,8
    xlatb
    stosb

    sub edi,560

    dec ecx
    jz  exit80innerloop

    sub ebp,8
    jnz inner80loop

    mov esi,_ModeXScreenWrapRestart
    jmp inner80loop

exit80innerloop:
    sub ebp,8
    jnz exitinner80loop1

    mov esi,_ModeXScreenWrapRestart
exitinner80loop1:

    add edi,dword ptr _ScreenWidthExtraInMemoryBytes
    add edi,dword ptr _ModeXRowSize;

    mov dword ptr _LogicalScreen,edi
    mov dword ptr _ModeXScreenStart,esi
    mov dword ptr _ModeXWrap,ebp

    pop edi
    pop esi
    pop ebp
    pop ecx
    pop ebx
    pop eax

    ret

Plot80Row_ endp


Plot40Row_ proc
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _ModeXScreenStart
    mov eax, dword ptr _ModeXLookup
    mov ebx, dword ptr _ModeXLookup2
    mov ebp, dword ptr _ModeXWrap
    
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes;
inner40loop:
    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;1

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;2

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;3

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;4

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;5

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;6

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half
    add edi,78 ;7

    lodsb
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub edi,560

    dec ecx
    jz  exitinner40loop

    sub ebp,8
    jnz inner40loop

    mov esi,_ModeXScreenWrapRestart
    jmp inner40loop

exitinner40loop:
    sub ebp,8
    jnz exitinner40loop1

    mov esi,_ModeXScreenWrapRestart
exitinner40loop1:

    add edi,dword ptr _ScreenWidthHalfExtraInMemoryBytes
    add edi,dword ptr _ModeXRowSize;

    mov dword ptr _LogicalScreen,edi
    mov dword ptr _ModeXScreenStart,esi
    mov dword ptr _ModeXWrap,ebp

    pop edi
    pop esi
    pop ebp
    pop ecx
    pop ebx
    pop eax

    ret
Plot40Row_ endp
















Plot80Line_ proc
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot
    push eax
    push ebx
    push ecx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _ModeXScreenStart
    mov ebx, dword ptr _ModeXLookup
    mov ebp, dword ptr _ModeXWrap

    movzx ecx,byte ptr _ScreenWidthInMemoryBytes
innerline80loop:
    lodsb         ; 1
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 2  
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 3
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 4
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 5
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 6
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 7
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    dec ecx
    jz  exitline80

    lodsb         ; 8
    add esi,7
    xlatb
    stosb

    sub ebp,8
    jz line80resetscreenwrap

    loop innerline80loop

exitline80:
    mov dword ptr _NextModeXScreenStart,esi
    mov dword ptr _NextModeXWrap,ebp

    pop edi
    pop esi
    pop ebp
    pop ecx
    pop ebx
    pop eax

    ret

line80resetscreenwrap:
    mov esi,_ModeXScreenWrapRestart
    add esi,_VSYNCLineOffset

    dec ecx
    jnz innerline80loop
    jmp exitline80

Plot80Line_ endp


Plot40Line_ proc
    cmp byte ptr _ScreenWidthInMemoryBytes,0
    je  noplot

    push eax
    push ebx
    push ecx
    push ebp
    push esi
    push edi

    mov edi, dword ptr _LogicalScreen
    mov esi, dword ptr _ModeXScreenStart
    mov eax, dword ptr _ModeXLookup
    mov ebx, dword ptr _ModeXLookup2
    mov ebp, dword ptr _ModeXWrap
    
    movzx ecx,byte ptr _ScreenWidthInMemoryBytes;
innerline40loop:
    lodsb       ; 1
    add esi,7
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub ebp,8
    jz line40resetscreenwrap

    dec ecx
    jz  exitline40

    lodsb       ; 2
    add esi,7
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub ebp,8
    jz line40resetscreenwrap

    dec ecx
    jz  exitline40

    lodsb       ; 3
    add esi,7
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub ebp,8
    jz line40resetscreenwrap

    dec ecx
    jz  exitline40


    lodsb       ; 4
    add esi,7
    mov bl,al
    mov al,[eax]
    stosb       ; left half
    mov al,[ebx]
    stosb       ; right half

    sub ebp,8
    jz line40resetscreenwrap

    loop innerline40loop

exitline40:

    mov dword ptr _NextModeXScreenStart,esi
    mov dword ptr _NextModeXWrap,ebp

    pop edi
    pop esi
    pop ebp
    pop ecx
    pop ebx
    pop eax

    ret

line40resetscreenwrap:
    mov esi,_ModeXScreenWrapRestart
    add esi,_VSYNCLineOffset
    loop innerline40loop
    jmp exitline40

Plot40Line_ endp


_TEXT           ends
		end
