/*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 6512CODE.H
//
// This is the code for the ecolink card itself
// release 1.0  30.06.1999                                                       
*/

#define microcode_length 0xB00

unsigned char microcode[]={
27, 120, 169, 0, 162, 32, 149, 0,
232, 208, 251, 162, 254, 154, 44, 
38, 176, 48, 251, 32, 126, 253, 
36, 7, 88, 173, 171, 64, 141, 
169, 64, 32, 63, 245, 174, 73, 
64, 240, 3, 32, 232, 255, 32, 
113, 254, 32, 39, 246, 32, 245, 
246, 173, 172, 64, 208, 225, 173, 
169, 64, 208, 243, 128, 218, 173, 
27, 64, 240, 13, 32, 44, 254, 
144, 8, 174, 27, 64, 208, 4, 
76, 32, 246, 96, 160, 1, 185, 
27, 64, 133, 56, 134, 58, 132, 
59, 32, 85, 247, 134, 42, 132, 
43, 160, 8, 177, 42, 48, 53, 
160, 9, 177, 42, 160, 0, 145, 
42, 32, 82, 254, 32, 58, 247, 
8, 32, 44, 254, 144, 251, 174, 
27, 64, 240, 13, 165, 56, 160, 
1, 217, 27, 64, 240, 8, 200, 
202, 208, 247, 104, 76, 32, 246, 
134, 58, 132, 59, 160, 8, 177, 
42, 16, 3, 104, 128, 68, 40, 
240, 59, 160, 10, 177, 42, 58, 
145, 42, 208, 48, 160, 0, 177, 
42, 133, 57, 165, 56, 72, 160, 
0, 165, 57, 145, 42, 160, 7, 
169, 254, 145, 42, 104, 32, 70, 
247, 160, 16, 177, 42, 240, 50, 
72, 32, 85, 247, 134, 42, 132, 
43, 162, 50, 160, 64, 32, 194, 
255, 128, 217, 128, 54, 160, 7, 
169, 255, 145, 42, 165, 56, 32, 
70, 247, 160, 16, 177, 42, 240, 
14, 162, 50, 160, 64, 32, 194, 
255, 164, 59, 153, 27, 64, 128, 
23, 164, 59, 166, 58, 202, 240, 
11, 200, 185, 27, 64, 136, 153, 
27, 64, 200, 128, 242, 206, 27, 
64, 198, 59, 164, 59, 166, 58, 
200, 202, 240, 3, 76, 84, 245, 
156, 172, 64, 32, 82, 254, 96, 
173, 73, 64, 240, 85, 32, 36, 
254, 144, 80, 174, 73, 64, 240, 
72, 160, 1, 185, 73, 64, 133, 
38, 134, 39, 132, 40, 32, 85, 
247, 134, 36, 132, 37, 160, 8, 
177, 36, 16, 40, 160, 0, 177, 
36, 48, 34, 160, 14, 177, 36, 
48, 28, 165, 38, 32, 70, 247, 
166, 39, 164, 40, 202, 240, 11, 
200, 185, 73, 64, 136, 153, 73, 
64, 200, 128, 242, 206, 73, 64, 
198, 40, 164, 40, 166, 39, 200, 
202, 208, 186, 32, 74, 254, 173, 
50, 64, 240, 110, 32, 44, 254, 
144, 105, 174, 50, 64, 240, 97, 
160, 1, 185, 50, 64, 133, 38, 
134, 39, 132, 40, 32, 85, 247, 
134, 36, 132, 37, 160, 8, 177, 
36, 16, 65, 165, 38, 32, 70, 
247, 166, 39, 164, 40, 202, 240, 
11, 200, 185, 50, 64, 136, 153, 
50, 64, 200, 128, 242, 206, 50, 
64, 160, 16, 177, 36, 72, 160, 
15, 177, 36, 32, 85, 247, 134, 
36, 132, 37, 170, 104, 160, 16, 
145, 36, 240, 13, 218, 32, 85, 
247, 134, 36, 132, 37, 104, 160, 
15, 145, 36, 198, 40, 164, 40, 
166, 39, 200, 202, 208, 161, 32, 
82, 254, 96, 173, 20, 2, 240, 
63, 156, 175, 64, 100, 7, 32, 
36, 254, 144, 43, 162, 20, 160, 
2, 32, 160, 255, 144, 31, 141, 
173, 64, 162, 73, 160, 64, 32, 
194, 255, 162, 128, 142, 174, 64, 
32, 74, 254, 36, 7, 100, 2, 
36, 2, 173, 173, 64, 208, 251, 
128, 209, 32, 74, 254, 156, 174, 
64, 44, 175, 64, 48, 251, 36, 
7, 96, 32, 141, 250, 160, 0, 
177, 42, 48, 252, 41, 64, 96, 
8, 120, 100, 7, 162, 20, 160, 
2, 32, 123, 255, 36, 7, 40, 
96, 72, 170, 202, 189, 98, 247, 
168, 189, 120, 247, 170, 104, 96, 
64, 69, 74, 79, 84, 90, 95, 
100, 105, 110, 115, 120, 125, 130, 
135, 140, 145, 150, 155, 160, 166, 
171, 176, 193, 210, 227, 244, 5, 
22, 39, 56, 73, 90, 107, 124, 
141, 158, 175, 192, 209, 226, 243, 
4, 21, 169, 1, 36, 17, 240, 
48, 165, 18, 205, 2, 2, 240, 
8, 201, 255, 208, 21, 169, 64, 
133, 74, 169, 168, 76, 219, 253, 
36, 17, 16, 24, 165, 18, 240, 
11, 73, 255, 240, 9, 169, 162, 
133, 16, 76, 226, 249, 133, 74, 
133, 47, 169, 211, 76, 219, 253, 
165, 17, 41, 129, 240, 6, 32, 
188, 253, 76, 226, 249, 76, 223, 
249, 164, 47, 165, 17, 16, 235, 
165, 18, 153, 62, 0, 200, 165, 
17, 48, 2, 208, 19, 165, 18, 
153, 62, 0, 200, 192, 12, 240, 
9, 132, 47, 165, 17, 208, 226, 
76, 222, 253, 169, 0, 133, 16, 
169, 132, 133, 17, 169, 2, 36, 
17, 240, 190, 16, 188, 165, 18, 
153, 62, 0, 169, 68, 133, 16, 
165, 65, 208, 3, 76, 7, 250, 
36, 74, 80, 4, 169, 7, 133, 
17, 218, 32, 36, 254, 144, 77, 
174, 73, 64, 240, 69, 160, 1, 
185, 73, 64, 133, 75, 218, 90, 
32, 85, 247, 134, 60, 132, 61, 
160, 8, 177, 60, 48, 41, 160, 
10, 177, 60, 48, 35, 160, 0, 
177, 60, 201, 127, 208, 27, 200, 
177, 60, 240, 4, 197, 65, 208, 
18, 200, 177, 60, 240, 26, 197, 
62, 208, 9, 200, 177, 60, 240, 
17, 197, 63, 240, 13, 122, 250, 
200, 202, 208, 189, 32, 74, 254, 
250, 76, 223, 248, 160, 14, 169, 
128, 145, 60, 133, 76, 32, 74, 
254, 122, 250, 250, 32, 72, 253, 
36, 74, 80, 3, 76, 233, 249, 
169, 68, 133, 16, 169, 167, 133, 
17, 169, 158, 160, 248, 76, 80, 
249, 169, 130, 133, 16, 169, 167, 
76, 219, 253, 169, 1, 36, 17, 
240, 50, 165, 18, 205, 2, 2, 
208, 43, 169, 185, 76, 219, 253, 
36, 17, 16, 34, 165, 18, 208, 
30, 169, 204, 160, 248, 36, 16, 
48, 3, 76, 216, 253, 36, 17, 
16, 15, 165, 18, 165, 18, 169, 
236, 160, 248, 36, 16, 48, 16, 
76, 216, 253, 165, 74, 16, 3, 
76, 58, 253, 32, 188, 253, 76, 
211, 249, 164, 47, 165, 17, 16, 
41, 165, 18, 145, 44, 200, 208, 
6, 230, 45, 198, 46, 240, 224, 
165, 17, 48, 2, 208, 22, 165, 
18, 145, 44, 200, 132, 47, 208, 
6, 230, 45, 198, 46, 240, 7, 
165, 17, 208, 216, 76, 222, 253, 
169, 132, 133, 17, 169, 0, 133, 
16, 132, 47, 169, 2, 36, 17, 
240, 180, 16, 16, 165, 46, 240, 
174, 165, 18, 164, 47, 145, 44, 
230, 47, 208, 2, 230, 45, 165, 
74, 16, 3, 76, 54, 253, 169, 
68, 133, 16, 169, 167, 133, 17, 
169, 137, 160, 249, 133, 48, 132, 
49, 165, 62, 36, 16, 80, 44, 
133, 18, 165, 63, 133, 18, 169, 
103, 160, 249, 76, 216, 253, 173, 
2, 2, 36, 16, 80, 24, 133, 
18, 169, 0, 133, 18, 165, 74, 
48, 11, 169, 63, 133, 17, 165, 
48, 164, 49, 76, 216, 253, 76, 
146, 252, 76, 211, 249, 165, 65, 
208, 3, 76, 117, 250, 165, 47, 
24, 101, 44, 144, 2, 230, 45, 
160, 4, 56, 229, 52, 145, 60, 
165, 45, 229, 53, 200, 145, 60, 
165, 65, 240, 40, 160, 3, 165, 
63, 145, 60, 136, 165, 62, 145, 
60, 136, 165, 65, 145, 60, 136, 
165, 64, 9, 128, 145, 60, 160, 
7, 169, 253, 145, 60, 218, 162, 
20, 160, 2, 165, 75, 32, 123, 
255, 250, 36, 76, 16, 8, 169, 
0, 133, 76, 160, 14, 145, 60, 
32, 200, 253, 169, 142, 160, 247, 
76, 216, 253, 218, 162, 4, 164, 
47, 189, 62, 0, 145, 44, 200, 
208, 6, 230, 45, 198, 46, 240, 
49, 232, 132, 47, 224, 12, 208, 
235, 250, 76, 144, 249, 164, 64, 
192, 129, 144, 39, 192, 137, 176, 
35, 192, 135, 176, 14, 152, 56, 
233, 129, 168, 173, 39, 176, 106, 
136, 16, 252, 176, 188, 164, 64, 
169, 250, 72, 185, 182, 249, 72, 
96, 230, 47, 224, 11, 240, 208, 
250, 76, 223, 248, 89, 65, 62, 
62, 62, 113, 113, 71, 76, 223, 
249, 32, 120, 250, 76, 136, 248, 
169, 1, 133, 46, 169, 252, 133, 
47, 169, 44, 133, 44, 169, 175, 
133, 45, 128, 3, 32, 120, 250, 
165, 74, 9, 128, 133, 74, 169, 
68, 133, 16, 169, 167, 133, 17, 
169, 117, 160, 250, 76, 80, 249, 
76, 223, 249, 76, 223, 249, 160, 
1, 185, 66, 0, 153, 52, 0, 
185, 70, 0, 153, 54, 0, 136, 
16, 241, 76, 101, 253, 96, 160, 
2, 177, 42, 141, 0, 2, 200, 
177, 42, 141, 1, 2, 160, 0, 
177, 42, 48, 3, 76, 32, 251, 
141, 4, 2, 170, 200, 177, 42, 
141, 5, 2, 208, 47, 224, 131, 
176, 23, 160, 4, 177, 42, 153, 
6, 2, 200, 177, 42, 153, 6, 
2, 200, 169, 0, 153, 6, 2, 
200, 153, 6, 2, 224, 129, 144, 
82, 224, 137, 176, 78, 160, 11, 
177, 42, 153, 251, 1, 200, 192, 
15, 144, 246, 169, 32, 36, 17, 
208, 75, 169, 253, 72, 169, 6, 
133, 51, 169, 0, 133, 50, 72, 
72, 160, 231, 169, 4, 8, 120, 
100, 7, 100, 7, 36, 17, 240, 
12, 165, 16, 169, 103, 133, 17, 
169, 16, 36, 16, 208, 48, 36, 
7, 40, 186, 254, 1, 1, 208, 
223, 254, 2, 1, 208, 218, 254, 
3, 1, 208, 213, 240, 4, 169, 
68, 208, 13, 169, 7, 133, 17, 
104, 104, 104, 169, 64, 208, 2, 
169, 67, 160, 0, 145, 42, 169, 
128, 141, 19, 2, 96, 132, 17, 
162, 68, 134, 16, 162, 202, 160, 
251, 142, 214, 253, 140, 215, 253, 
36, 7, 173, 5, 2, 208, 68, 
172, 4, 2, 185, 238, 250, 133, 
74, 185, 230, 250, 133, 51, 169, 
251, 72, 185, 246, 250, 72, 96, 
14, 14, 10, 10, 10, 6, 6, 
10, 129, 0, 0, 0, 0, 1, 
1, 129, 126, 126, 185, 185, 185, 
196, 196, 185, 24, 8, 160, 0, 
185, 6, 2, 40, 121, 10, 2, 
153, 10, 2, 200, 8, 192, 4, 
144, 240, 40, 128, 36, 173, 0, 
2, 45, 1, 2, 201, 255, 208, 
22, 169, 14, 133, 51, 169, 64, 
133, 74, 160, 17, 177, 42, 153, 
245, 1, 200, 192, 25, 144, 246, 
128, 15, 169, 0, 133, 74, 165, 
42, 133, 60, 165, 43, 133, 61, 
32, 72, 253, 40, 104, 104, 104, 
96, 164, 50, 36, 16, 80, 29, 
185, 0, 2, 133, 18, 200, 185, 
0, 2, 200, 132, 50, 133, 18, 
196, 51, 176, 28, 36, 16, 48, 
232, 76, 222, 253, 169, 66, 208, 
6, 169, 103, 133, 17, 169, 65, 
172, 2, 2, 72, 104, 200, 208, 
251, 76, 60, 253, 169, 63, 133, 
17, 169, 9, 160, 252, 76, 216, 
253, 169, 130, 133, 16, 36, 74, 
80, 3, 76, 54, 253, 169, 1, 
36, 74, 240, 3, 76, 233, 252, 
169, 34, 76, 219, 253, 169, 1, 
36, 17, 240, 193, 165, 18, 205, 
2, 2, 208, 22, 169, 52, 76, 
219, 253, 36, 17, 16, 13, 165, 
18, 208, 9, 169, 72, 36, 16, 
48, 6, 76, 219, 253, 76, 58, 
253, 36, 17, 16, 249, 165, 18, 
205, 0, 2, 208, 242, 165, 18, 
205, 1, 2, 208, 235, 169, 2, 
36, 17, 240, 229, 169, 167, 133, 
17, 169, 68, 133, 16, 169, 233, 
160, 252, 133, 48, 132, 49, 173, 
0, 2, 36, 16, 80, 19, 133, 
18, 173, 1, 2, 133, 18, 169, 
133, 160, 252, 76, 216, 253, 173, 
2, 2, 36, 16, 80, 27, 133, 
18, 169, 0, 133, 18, 169, 161, 
160, 252, 76, 216, 253, 164, 46, 
240, 47, 164, 47, 240, 4, 164, 
47, 240, 244, 36, 16, 80, 57, 
177, 44, 133, 18, 200, 208, 6, 
198, 46, 240, 24, 230, 45, 177, 
44, 133, 18, 200, 132, 47, 208, 
6, 198, 46, 240, 9, 230, 45, 
36, 16, 48, 222, 76, 222, 253, 
169, 63, 133, 17, 165, 74, 16, 
7, 169, 211, 160, 249, 76, 216, 
253, 165, 48, 164, 49, 76, 216, 
253, 165, 74, 16, 84, 76, 211, 
249, 169, 130, 133, 16, 169, 242, 
76, 219, 253, 169, 1, 36, 17, 
240, 66, 165, 18, 205, 2, 2, 
208, 59, 169, 6, 160, 253, 76, 
216, 253, 36, 17, 16, 48, 165, 
18, 208, 44, 169, 23, 36, 16, 
48, 3, 76, 219, 253, 36, 17, 
16, 31, 165, 18, 205, 0, 2, 
208, 24, 165, 18, 205, 1, 2, 
208, 17, 165, 74, 16, 3, 76, 
212, 248, 169, 2, 36, 17, 240, 
4, 169, 0, 240, 2, 169, 65, 
160, 0, 145, 42, 169, 128, 141, 
19, 2, 76, 211, 249, 169, 17, 
24, 101, 60, 133, 52, 169, 0, 
101, 61, 133, 53, 160, 4, 177, 
60, 200, 24, 101, 52, 133, 54, 
177, 60, 101, 53, 133, 55, 165, 
52, 56, 229, 54, 133, 47, 165, 
53, 233, 0, 133, 45, 165, 54, 
133, 44, 165, 55, 56, 229, 45, 
133, 46, 96, 32, 188, 253, 156, 
0, 64, 156, 2, 64, 156, 3, 
64, 156, 3, 2, 100, 76, 162, 
20, 160, 2, 32, 113, 255, 169, 
128, 141, 19, 2, 169, 0, 133, 
33, 32, 192, 254, 144, 8, 165, 
32, 240, 4, 201, 255, 208, 2, 
169, 1, 141, 2, 2, 169, 142, 
141, 214, 253, 169, 247, 141, 215, 
253, 96, 169, 193, 133, 16, 169, 
30, 133, 19, 169, 0, 133, 17, 
169, 130, 133, 16, 169, 103, 133, 
17, 96, 100, 7, 72, 90, 76, 
142, 247, 140, 215, 253, 141, 214, 
253, 122, 104, 36, 7, 64, 133, 
41, 104, 72, 41, 16, 208, 4, 
165, 41, 128, 3, 76, 1, 245, 
36, 1, 72, 218, 173, 1, 64, 
8, 41, 127, 170, 40, 48, 12, 
12, 0, 64, 208, 25, 169, 1, 
157, 1, 64, 128, 18, 189, 1, 
64, 201, 1, 208, 11, 138, 28, 
0, 64, 240, 5, 158, 1, 64, 
128, 0, 156, 1, 64, 250, 104, 
64, 72, 169, 1, 32, 52, 254, 
104, 96, 72, 169, 2, 32, 52, 
254, 104, 96, 218, 170, 8, 120, 
12, 0, 64, 208, 9, 169, 2, 
157, 1, 64, 40, 56, 128, 2, 
40, 24, 250, 96, 72, 169, 1, 
32, 90, 254, 104, 96, 72, 169, 
2, 32, 90, 254, 104, 96, 218, 
170, 8, 120, 189, 1, 64, 201, 
2, 208, 9, 138, 28, 0, 64, 
240, 3, 158, 1, 64, 40, 250, 
96, 173, 167, 64, 133, 33, 173, 
168, 64, 133, 32, 173, 165, 64, 
240, 63, 201, 2, 208, 5, 32, 
1, 255, 128, 26, 201, 1, 208, 
28, 32, 192, 254, 8, 173, 167, 
64, 208, 12, 165, 32, 240, 4, 
201, 255, 208, 4, 169, 1, 133, 
32, 40, 176, 8, 169, 254, 128, 
16, 169, 255, 128, 12, 165, 33, 
141, 167, 64, 165, 32, 141, 168, 
64, 169, 0, 141, 166, 64, 156, 
165, 64, 96, 160, 0, 100, 4, 
36, 5, 36, 4, 100, 5, 169, 
172, 32, 53, 255, 16, 12, 200, 
192, 250, 144, 2, 128, 27, 32, 
232, 255, 128, 229, 165, 33, 32, 
53, 255, 16, 2, 128, 13, 36, 
5, 36, 4, 100, 5, 169, 173, 
32, 53, 255, 16, 3, 24, 128, 
10, 32, 86, 255, 100, 5, 36, 
4, 36, 5, 56, 96, 160, 0, 
100, 4, 36, 5, 36, 4, 100, 
5, 169, 172, 32, 53, 255, 16, 
12, 200, 192, 250, 144, 2, 128, 
12, 32, 232, 255, 128, 229, 165, 
33, 32, 53, 255, 16, 3, 24, 
128, 12, 165, 32, 32, 53, 255, 
100, 5, 36, 4, 36, 5, 56, 
96, 162, 8, 100, 4, 42, 144, 
4, 36, 5, 128, 2, 100, 5, 
36, 4, 234, 234, 202, 208, 238, 
100, 4, 36, 5, 234, 234, 36, 
4, 36, 5, 100, 4, 96, 162, 
8, 100, 4, 36, 5, 234, 234, 
36, 4, 165, 5, 42, 38, 32, 
202, 208, 240, 100, 4, 36, 5, 
36, 4, 100, 4, 96, 134, 34, 
132, 35, 160, 0, 152, 145, 34, 
96, 72, 218, 90, 165, 34, 72, 
165, 35, 72, 134, 34, 132, 35, 
160, 0, 177, 34, 26, 145, 34, 
168, 186, 189, 5, 1, 145, 34, 
104, 133, 35, 104, 133, 34, 122, 
250, 104, 96, 134, 34, 132, 35, 
160, 0, 24, 177, 34, 240, 22, 
170, 58, 145, 34, 200, 177, 34, 
72, 202, 240, 9, 200, 177, 34, 
136, 145, 34, 200, 128, 244, 104, 
56, 96, 134, 34, 132, 35, 72, 
160, 0, 177, 34, 240, 24, 170, 
104, 200, 209, 34, 240, 5, 202, 
208, 248, 128, 13, 72, 90, 160, 
0, 177, 34, 58, 145, 34, 122, 
128, 206, 104, 24, 96, 72, 138, 
72, 162, 164, 72, 104, 202, 208, 
251, 104, 170, 104, 96, 0, 0, 
0, 0, 209, 253, 1, 245, 227, 
253
};

/*
MinorVersionNo DB 027                       ; Code version number

											; 6502 RESET ENTRY POINT
	DB  078           ; F501  SEI           ; Disable interrupts
	DB  0A9,000       ; F502  LDA #0        ; Clear zero page (skiping IO)
	DB  0A2,020       ; F504  LDX #32      
	DB  095,000       ; F506  STA &00,X    
	DB  0E8           ; F508  INX          
	DB  0D0,0FB       ; F509  BNE &F506    
	DB  0A2,0FE       ; F50B  LDX #254      ; Set up 6502 stack pointer
	DB  09A           ; F50D  TXS          
	DB  02C,026,0B0   ; F50E  BIT &B026     ; Wait for flag cleared from PC
        DB  030,0FB       ; F511  BMI &F50E    
	DB  020,07E,0FD   ; F513  JSR &FD7E    
	DB  024,007       ; F516  BIT &07       ; Enable 65C12 NMI
	DB  058           ; F518  CLI           ; Enable 65C12 IRQ

											; MAIN CODE LOOP
	DB  0AD,0AB,040   ; F519  LDA &40AB     ; TIMER_VALUE
	DB  08D,0A9,040   ; F51C  STA &40A9     ; TIMER_COUNTER
	DB  020,03F,0F5   ; F51F  JSR &F53F    
	DB  0AE,049,040   ; F522  LDX &4049     ; OPEN_RX_LIST index
	DB  0F0,003       ; F525  BEQ &F52A    
	DB  020,0E8,0FF   ; F527  JSR &FFE8     ; Delay
	DB  020,071,0FE   ; F52A  JSR &FE71    
	DB  020,027,0F6   ; F52D  JSR &F627    
	DB  020,0F5,0F6   ; F530  JSR &F6F5    
	DB  0AD,0AC,040   ; F533  LDA &40AC     ; TXCB_OPENED_FLAG
	DB  0D0,0E1       ; F536  BNE &F519    
	DB  0AD,0A9,040   ; F538  LDA &40A9     ; TIMER_COUNTER
	DB  0D0,0F3       ; F53B  BNE &F530    
	DB  080,0DA       ; F53D  BRA &F519


	DB  0AD,01B,040   ; F53F  LDA &401B     ; OPEN_TX_LIST index
	DB  0F0,00D       ; F542  BEQ &F551    
	DB  020,02C,0FE   ; F544  JSR &FE2C    
	DB  090,008       ; F547  BCC &F551    
	DB  0AE,01B,040   ; F549  LDX &401B     ; OPEN_TX_LIST index
	DB  0D0,004       ; F54C  BNE &F552    
	DB  04C,020,0F6   ; F54E  JMP &F620    
	DB  060           ; F551  RTS          

	DB  0A0,001       ; F552  LDY #1        ; Get buffer number
	DB  0B9,01B,040   ; F554  LDA &401B,Y  
	DB  085,038       ; F557  STA &38       ; Save buffer number
	DB  086,03A       ; F559  STX &3A       ; Preserve X
	DB  084,03B       ; F55B  STY &3B       ; Preserve Y
	DB  020,055,0F7   ; F55D  JSR &F755     ; Get buffer index for table A
	DB  086,02A       ; F560  STX &2A       ; Initialize pointer to table
	DB  084,02B       ; F562  STY &2B      
	DB  0A0,008       ; F564  LDY #8       
	DB  0B1,02A       ; F566  LDA (&2A),Y  
	DB  030,035       ; F568  BMI &F59F    
	DB  0A0,009       ; F56A  LDY #9       
	DB  0B1,02A       ; F56C  LDA (&2A),Y  
	DB  0A0,000       ; F56E  LDY #0       
	DB  091,02A       ; F570  STA (&2A),Y  
	DB  020,052,0FE   ; F572  JSR &FE52    
	DB  020,03A,0F7   ; F575  JSR &F73A    
	DB  008           ; F578  PHP          
	DB  020,02C,0FE   ; F579  JSR &FE2C    
	DB  090,0FB       ; F57C  BCC &F579    
	DB  0AE,01B,040   ; F57E  LDX &401B     ; OPEN_TX_LIST index
	DB  0F0,00D       ; F581  BEQ &F590    
	DB  0A5,038       ; F583  LDA &38      
	DB  0A0,001       ; F585  LDY #1       
	DB  0D9,01B,040   ; F587  CMP &401B,Y  
	DB  0F0,008       ; F58A  BEQ &F594    
	DB  0C8           ; F58C  INY          
	DB  0CA           ; F58D  DEX          
	DB  0D0,0F7       ; F58E  BNE &F587    
	DB  068           ; F590  PLA          
	DB  04C,020,0F6   ; F591  JMP &F620    
	DB  086,03A       ; F594  STX &3A      
	DB  084,03B       ; F596  STY &3B      
	DB  0A0,008       ; F598  LDY #8       
	DB  0B1,02A       ; F59A  LDA (&2A),Y  
	DB  010,003       ; F59C  BPL &F5A1    
	DB  068           ; F59E  PLA          
	DB  080,044       ; F59F  BRA &F5E5
	DB  028           ; F5A1  PLP
	DB  0F0,03B       ; F5A2  BEQ &F5DF    
	DB  0A0,00A       ; F5A4  LDY #10      
	DB  0B1,02A       ; F5A6  LDA (&2A),Y  
	DB  03A           ; F5A8  DEC A
	DB  091,02A       ; F5A9  STA (&2A),Y  
	DB  0D0,030       ; F5AB  BNE &F5DD    
	DB  0A0,000       ; F5AD  LDY #0       
	DB  0B1,02A       ; F5AF  LDA (&2A),Y  
	DB  085,039       ; F5B1  STA &39      
	DB  0A5,038       ; F5B3  LDA &38      
	DB  048           ; F5B5  PHA          
	DB  0A0,000       ; F5B6  LDY #0       
	DB  0A5,039       ; F5B8  LDA &39      
	DB  091,02A       ; F5BA  STA (&2A),Y  
	DB  0A0,007       ; F5BC  LDY #7       
	DB  0A9,0FE       ; F5BE  LDA #254     
	DB  091,02A       ; F5C0  STA (&2A),Y  
	DB  068           ; F5C2  PLA          
	DB  020,046,0F7   ; F5C3  JSR &F746    
	DB  0A0,010       ; F5C6  LDY #16      
	DB  0B1,02A       ; F5C8  LDA (&2A),Y  
	DB  0F0,032       ; F5CA  BEQ &F5FE    
	DB  048           ; F5CC  PHA          
	DB  020,055,0F7   ; F5CD  JSR &F755    
	DB  086,02A       ; F5D0  STX &2A      
	DB  084,02B       ; F5D2  STY &2B      
	DB  0A2,032       ; F5D4  LDX #50      
	DB  0A0,040       ; F5D6  LDY #64      
	DB  020,0C2,0FF   ; F5D8  JSR &FFC2    
	DB  080,0D9       ; F5DB  BRA &F5B6
	DB  080,036       ; F5DE  BRA &F615
	DB  0A0,007       ; F5DF  LDY #7       
	DB  0A9,0FF       ; F5E1  LDA #255     
	DB  091,02A       ; F5E3  STA (&2A),Y  
	DB  0A5,038       ; F5E5  LDA &38      
	DB  020,046,0F7   ; F5E7  JSR &F746    
	DB  0A0,010       ; F5EA  LDY #16      
	DB  0B1,02A       ; F5EC  LDA (&2A),Y  
	DB  0F0,00E       ; F5EE  BEQ &F5FE    
	DB  0A2,032       ; F5F0  LDX #50      
	DB  0A0,040       ; F5F2  LDY #64      
	DB  020,0C2,0FF   ; F5F4  JSR &FFC2    
	DB  0A4,03B       ; F5F7  LDY &3B      
	DB  099,01B,040   ; F5F9  STA &401B,Y  
	DB  080,017       ; F5FC  BRA &F615
	DB  0A4,03B       ; F5FE  LDY &3B      
	DB  0A6,03A       ; F600  LDX &3A      
	DB  0CA           ; F602  DEX          
	DB  0F0,00B       ; F603  BEQ &F610    
	DB  0C8           ; F605  INY          
	DB  0B9,01B,040   ; F606  LDA &401B,Y  
	DB  088           ; F609  DEY          
	DB  099,01B,040   ; F60A  STA &401B,Y  
	DB  0C8           ; F60D  INY          
	DB  080,0F2       ; F60E  BRA &F602
	DB  0CE,01B,040   ; F610  DEC &401B     ; OPEN_TX_LIST index - 1  
	DB  0C6,03B       ; F613  DEC &3B      
	DB  0A4,03B       ; F615  LDY &3B       ; Restore Y
	DB  0A6,03A       ; F617  LDX &3A       ; Restore X
	DB  0C8           ; F619  INY          
	DB  0CA           ; F61A  DEX          
	DB  0F0,003       ; F61B  BEQ &F620    
	DB  04C,054,0F5   ; F61D  JMP &F554     ; Next buffer

	DB  09C,0AC,040   ; F620  STZ &40AC		; TXCB_OPENED_FLAG
	DB  020,052,0FE   ; F623  JSR &FE52
	DB  060           ; F626  RTS


	DB  0AD,049,040   ; F627  LDA &4049     ; OPEN_RX_LIST index
	DB  0F0,055       ; F62A  BEQ &F681    
	DB  020,024,0FE   ; F62C  JSR &FE24    
	DB  090,050       ; F62F  BCC &F681    
	DB  0AE,049,040   ; F631  LDX &4049     ; OPEN_RX_LIST index
	DB  0F0,048       ; F634  BEQ &F67E    
	DB  0A0,001       ; F636  LDY #1       
	DB  0B9,049,040   ; F638  LDA &4049,Y  
	DB  085,026       ; F63B  STA &26      
	DB  086,027       ; F63D  STX &27      
	DB  084,028       ; F63F  STY &28      
	DB  020,055,0F7   ; F641  JSR &F755    
	DB  086,024       ; F644  STX &24      
	DB  084,025       ; F646  STY &25      
	DB  0A0,008       ; F648  LDY #8       
	DB  0B1,024       ; F64A  LDA (&24),Y  
	DB  010,028       ; F64C  BPL &F676    
	DB  0A0,000       ; F64E  LDY #0       
	DB  0B1,024       ; F650  LDA (&24),Y  
	DB  030,022       ; F652  BMI &F676    
	DB  0A0,00E       ; F654  LDY #14      
	DB  0B1,024       ; F656  LDA (&24),Y  
	DB  030,01C       ; F658  BMI &F676    
	DB  0A5,026       ; F65A  LDA &26      
	DB  020,046,0F7   ; F65C  JSR &F746    
	DB  0A6,027       ; F65F  LDX &27      
	DB  0A4,028       ; F661  LDY &28      
	DB  0CA           ; F663  DEX          
	DB  0F0,00B       ; F664  BEQ &F671    
	DB  0C8           ; F666  INY          
	DB  0B9,049,040   ; F667  LDA &4049,Y  
	DB  088           ; F66A  DEY          
	DB  099,049,040   ; F66B  STA &4049,Y  
	DB  0C8           ; F66E  INY          
	DB  080,0F2       ; F66F  BRA &F663
	DB  0CE,049,040   ; F671  DEC &4049     ; OPEN_RX_LIST index - 1
	DB  0C6,028       ; F674  DEC &28      
	DB  0A4,028       ; F676  LDY &28      
	DB  0A6,027       ; F678  LDX &27      
	DB  0C8           ; F67A  INY          
	DB  0CA           ; F67B  DEX          
	DB  0D0,0BA       ; F67C  BNE &F638    
	DB  020,04A,0FE   ; F67E  JSR &FE4A    
	DB  0AD,032,040   ; F681  LDA &4032     ; OPEN_TXCHAIN_LIST index
	DB  0F0,06E       ; F684  BEQ &F6F4    
	DB  020,02C,0FE   ; F686  JSR &FE2C    
	DB  090,069       ; F689  BCC &F6F4    
	DB  0AE,032,040   ; F68B  LDX &4032     ; OPEN_TXCHAIN_LIST index
	DB  0F0,061       ; F68E  BEQ &F6F1    
	DB  0A0,001       ; F690  LDY #1       
	DB  0B9,032,040   ; F692  LDA &4032,Y  
	DB  085,026       ; F695  STA &26      
	DB  086,027       ; F697  STX &27      
	DB  084,028       ; F699  STY &28      
	DB  020,055,0F7   ; F69B  JSR &F755    
	DB  086,024       ; F69E  STX &24      
	DB  084,025       ; F6A0  STY &25      
	DB  0A0,008       ; F6A2  LDY #8       
	DB  0B1,024       ; F6A4  LDA (&24),Y  
	DB  010,041       ; F6A6  BPL &F6E9    
	DB  0A5,026       ; F6A8  LDA &26      
	DB  020,046,0F7   ; F6AA  JSR &F746    
	DB  0A6,027       ; F6AD  LDX &27      
	DB  0A4,028       ; F6AF  LDY &28      
	DB  0CA           ; F6B1  DEX          
	DB  0F0,00B       ; F6B2  BEQ &F6BF    
	DB  0C8           ; F6B4  INY          
	DB  0B9,032,040   ; F6B5  LDA &4032,Y  
	DB  088           ; F6B8  DEY          
	DB  099,032,040   ; F6B9  STA &4032,Y  
	DB  0C8           ; F6BC  INY          
	DB  080,0F2       ; F6BD  BRA &F6B1
	DB  0CE,032,040   ; F6BF  DEC &4032     ; OPEN_TXCHAIN_LIST index - 1
	DB  0A0,010       ; F6C2  LDY #16      
	DB  0B1,024       ; F6C4  LDA (&24),Y  
	DB  048           ; F6C6  PHA          
	DB  0A0,00F       ; F6C7  LDY #15      
	DB  0B1,024       ; F6C9  LDA (&24),Y  
	DB  020,055,0F7   ; F6CB  JSR &F755    
	DB  086,024       ; F6CE  STX &24      
	DB  084,025       ; F6D0  STY &25      
	DB  0AA           ; F6D2  TAX          
	DB  068           ; F6D3  PLA          
	DB  0A0,010       ; F6D4  LDY #16      
	DB  091,024       ; F6D6  STA (&24),Y  
	DB  0F0,00D       ; F6D8  BEQ &F6E7    
	DB  0DA           ; F6DA  PHX
	DB  020,055,0F7   ; F6DB  JSR &F755    
	DB  086,024       ; F6DE  STX &24      
	DB  084,025       ; F6E0  STY &25      
	DB  068           ; F6E2  PLA          
	DB  0A0,00F       ; F6E3  LDY #15      
	DB  091,024       ; F6E5  STA (&24),Y  
	DB  0C6,028       ; F6E7  DEC &28      
	DB  0A4,028       ; F6E9  LDY &28      
	DB  0A6,027       ; F6EB  LDX &27      
	DB  0C8           ; F6ED  INY          
	DB  0CA           ; F6EE  DEX          
	DB  0D0,0A1       ; F6EF  BNE &F692    
	DB  020,052,0FE   ; F6F1  JSR &FE52    
	DB  060           ; F6F4  RTS          


	DB  0AD,014,002   ; F6F5  LDA &0214    
	DB  0F0,03F       ; F6F8  BEQ &F739    
	DB  09C,0AF,040   ; F6FA  STZ &40AF     ; IN_INTERRUPT routine flag
	DB  064,007       ; F6FD  STZ &07       ; Disable 65C12 NMI
	DB  020,024,0FE   ; F6FF  JSR &FE24    
	DB  090,02B       ; F702  BCC &F72F    
	DB  0A2,014       ; F704  LDX #20      
	DB  0A0,002       ; F706  LDY #2       
	DB  020,0A0,0FF   ; F708  JSR &FFA0    
	DB  090,01F       ; F70B  BCC &F72C    
	DB  08D,0AD,040   ; F70D  STA &40AD    ; COMPLETED_HANDLE to be passed 
	DB  0A2,049       ; F710  LDX #73      
	DB  0A0,040       ; F712  LDY #64      
	DB  020,0C2,0FF   ; F714  JSR &FFC2    
	DB  0A2,080       ; F717  LDX #128     
	DB  08E,0AE,040   ; F719  STX &40AE    
	DB  020,04A,0FE   ; F71C  JSR &FE4A    
	DB  024,007       ; F71F  BIT &07       ; Enable 65C12 NMI
	DB  064,002       ; F721  STZ &02       ; PC IRQ off
	DB  024,002       ; F723  BIT &02       ; PC IRQ on
	DB  0AD,0AD,040   ; F725  LDA &40AD     ; COMPLETED_HANDLE to be passed 
	DB  0D0,0FB       ; F728  BNE &F725    
	DB  080,0D1       ; F72A  BRA &F6FD
	DB  020,04A,0FE   ; F72C  JSR &FE4A
	DB  09C,0AE,040   ; F72F  STZ &40AE     
	DB  02C,0AF,040   ; F732  BIT &40AF     ; IN_INTERRUPT routine flag
	DB  030,0FB       ; F735  BMI &F732    
	DB  024,007       ; F737  BIT &07       ; Enable 65C12 NMI
	DB  060           ; F739  RTS          


	DB  020,08D,0FA   ; F73A  JSR &FA8D    
	DB  0A0,000       ; F73D  LDY #0       
	DB  0B1,02A       ; F73F  LDA (&2A),Y  
	DB  030,0FC       ; F741  BMI &F73F    
	DB  029,040       ; F743  AND #64      
	DB  060           ; F745  RTS          

	DB  008           ; F746  PHP          
	DB  078           ; F747  SEI          
	DB  064,007       ; F748  STZ &07       ; Disable 65C12 NMI
	DB  0A2,014       ; F74A  LDX #20      
	DB  0A0,002       ; F74C  LDY #2       
	DB  020,07B,0FF   ; F74E  JSR &FF7B    
	DB  024,007       ; F751  BIT &07       ; Enable 65C12 NMI
	DB  028           ; F753  PLP          
	DB  060           ; F754  RTS          

											; READ DATA FROM LOOKUP
	DB  048           ; F755  PHA           ; Preserve A
	DB  0AA           ; F756  TAX           ; A=index to table+1
	DB  0CA           ; F757  DEX          
	DB  0BD,062,0F7   ; F758  LDA &F762,X   ; Read first byte in Y
	DB  0A8           ; F75B  TAY          
	DB  0BD,078,0F7   ; F75C  LDA &F778,X   ; Read second byte in X
	DB  0AA           ; F75F  TAX          
	DB  068           ; F760  PLA           ; Restore A
	DB  060           ; F761  RTS          

											;       X Y
    DB  040           ; F762  RTI           ; 00 - B040 +1105
    DB  045,04A       ; F763  EOR &4A       ; 01 - C145 +1105
    DB  04F           ; F765  ???           ; 02 - D24A +1105
    DB  054           ; F766  ???           ; 03 - E34F +1105
    DB  05A           ; F767  ???           ; 04 - F454
    DB  05F           ; F768  ???           ; 05 - 055A +1105
    DB  064           ; F769  ???           ; 06 - 165F +1105
    DB  069,06E       ; F76A  ADC #110      ; 07 - 2764 +1105
    DB  073           ; F76C  ???           ; 08 - 3869 +1105
    DB  078           ; F76D  SEI           ; 09 - 496E +1105
    DB  07D,082,087   ; F76E  ADC &8782,X   ; 0A - 5A73 +1105
    DB  08C,091,096   ; F771  STY &9691     ; 0B - 6B78 +1105
    DB  09B           ; F774  ???           ; 0C - 7C7D +1105
    DB  0A0,0A6       ; F775  LDY #166      ; 0D - 8D82 +1105
    DB  0AB           ; F777  ???           ; 0E - 9E87 +1105
    DB  0B0,0C1       ; F778  BCS &F73B     ; 0F - AF8C
    DB  0D2           ; F77A  ???           ; 10 - C091 +1105
    DB  0E3           ; F77B  ???           ; 11 - D196 +1105
    DB  0F4           ; F77C  ???           ; 12 - E29B +1105
    DB  005,016       ; F77D  ORA &16       ; 13 - F3A0
	DB  027           ; F77F  ???           ; 14 - 04A6
	DB  038           ; F780  SEC           ; 15 - 15AB
	DB  049,05A       ; F781  EOR #90      
	DB  06B           ; F783  ???          
	DB  07C           ; F784  ???          
	DB  08D,09E,0AF   ; F785  STA &AF9E    
	DB  0C0,0D1       ; F788  CPY #209     
	DB  0E2           ; F78A  ???          
	DB  0F3           ; F78B  ???          
	DB  004           ; F78C  ???          
	DB  015           ; F78D  ???           ; Last byte in lookup table

											; MAIN NMI ENTRY
                                            ; WAITING FOR START OF FRAME
											; TEST STATION ID
	DB  0A9,001       ; F78E  LDA #1        ; Test ADLC status
	DB  024,011       ; F790  BIT &11
	DB  0F0,030       ; F792  BEQ &F7C4     ; Rx error?
	DB  0A5,012       ; F794  LDA &12       ; Read ADLC data (Station ID)
	DB  0CD,002,002   ; F796  CMP &0202     ; Compare local station ID
	DB  0F0,008       ; F799  BEQ &F7A3     ; Match? Continue listening
	DB  0C9,0FF       ; F79B  CMP #255      ; Not broadcast?
	DB  0D0,015       ; F79D  BNE &F7B4    
	DB  0A9,040       ; F79F  LDA #64       ; Flag broadcast packet (no ack)
	DB  085,04A       ; F7A1  STA &4A      
	DB  0A9,0A8       ; F7A3  LDA #168     
	DB  04C,0DB,0FD   ; F7A5  JMP &FDDB     ; Set new NMI vector = &F7A8

											; STATION ID CORRECT
											; TEST NETWORK ID
	DB  024,011       ; F7A8  BIT &11       ; Test ADLC status
	DB  010,018       ; F7AA  BPL &F7C4    
	DB  0A5,012       ; F7AC  LDA &12       ; Read ADLC data (Network ID)
	DB  0F0,00B       ; F7AE  BEQ &F7BB     ; Local netork?
	DB  049,0FF       ; F7B0  EOR #255      ; ...or broadcast?
	DB  0F0,009       ; F7B2  BEQ &F7BD    

											; ABORT PACKET
	DB  0A9,0A2       ; F7B4  LDA #162      ; Write ADLC control wait for...
    DB  085,010       ; F7B6  STA &10       ; ...start of next frame.
	DB  04C,0E2,0F9   ; F7B8  JMP &F9E2     ; Set new NMI vector = &F7A8

	DB  085,04A       ; F7BB  STA &4A       ; Clear broadcast flag
	DB  085,02F       ; F7BD  STA &2F       ; Clear byte counter
	DB  0A9,0D3       ; F7BF  LDA #211     
	DB  04C,0DB,0FD   ; F7C1  JMP &FDDB     ; Set new NMI vector = &F7D3

											; ADLC RX ERROR
	DB  0A5,011       ; F7C4  LDA &11       ; Test ADLC status
	DB  029,081       ; F7C6  AND #129     
    DB  0F0,006       ; F7C8  BEQ &F7D0     ; End of frame?
    DB  020,0BC,0FD   ; F7CA  JSR &FDBC     ; Reset ADLC
    DB  04C,0E2,0F9   ; F7CD  JMP &F9E2     ; Set vector wait for next frame
    DB  04C,0DF,0F9   ; F7D0  JMP &F9DF     ; Wait for next frame

											; INCOMING HEADER FOR THIS
											; STATION ID
                                            ; &3E = Remote station ID
                                            ; &3F = Remote network ID
                                            ; &40 = RPC number
                                            ; &41 = 0 if RPC or port number
                                            ; &42 =
                                            ; &43 =
                                            ; &44 =
                                            ; &45 =
                                            ; &46 =
                                            ; &47 =
                                            ; &48 =
                                            ; &49 =
                                            ; &4A =
	DB  0A4,02F       ; F7D3  LDY &2F       ; Get byte counter
	DB  0A5,011       ; F7D5  LDA &11       ; Test ADLC status
	DB  010,0EB       ; F7D7  BPL &F7C4     ; Error?
	DB  0A5,012       ; F7D9  LDA &12       ; Read ADLC data
	DB  099,03E,000   ; F7DB  STA &003E,Y   ; Save incomming header
	DB  0C8           ; F7DE  INY          
	DB  0A5,011       ; F7DF  LDA &11       ; Test ADLC status
    DB  030,002       ; F7E1  BMI &F7E5     ; More data availble?
    DB  0D0,013       ; F7E3  BNE &F7F8     ; End of frame or error?
	DB  0A5,012       ; F7E5  LDA &12       ; Read ADLC data
	DB  099,03E,000   ; F7E7  STA &003E,Y   ; Save incomming header
	DB  0C8           ; F7EA  INY          
	DB  0C0,00C       ; F7EB  CPY #12      
	DB  0F0,009       ; F7ED  BEQ &F7F8     ; Header complete?
	DB  084,02F       ; F7EF  STY &2F       ; Save byte counter
	DB  0A5,011       ; F7F1  LDA &11       ; Get ADLC status
	DB  0D0,0E2       ; F7F3  BNE &F7D7     ; More data or error?
	DB  04C,0DE,0FD   ; F7F5  JMP &FDDE     ; Exit NMI

                                            ; END OF INCOMMING FRAME
    DB  0A9,000       ; F7F8  LDA #0        ; Program ADLC hold line
	DB  085,010       ; F7FA  STA &10      
	DB  0A9,084       ; F7FC  LDA #132     
	DB  085,011       ; F7FE  STA &11      
	DB  0A9,002       ; F800  LDA #2        ; Test ADLC status
	DB  024,011       ; F802  BIT &11      
	DB  0F0,0BE       ; F804  BEQ &F7C4     ; Error?
	DB  010,0BC       ; F806  BPL &F7C4     ; Error?

	DB  0A5,012       ; F808  LDA &12       ; Read ADLC data
	DB  099,03E,000   ; F80A  STA &003E,Y   ; Save incomming header
	DB  0A9,044       ; F80D  LDA #68      
	DB  085,010       ; F80F  STA &10      
    DB  0A5,041       ; F811  LDA &41       ; Get port number
	DB  0D0,003       ; F813  BNE &F818    
    DB  04C,007,0FA   ; F815  JMP &FA07     ; Call is RPC

                                            ; NON RPC PACKET
                                            ; 00 - &7F valid RxCB      *
                                            ; 01 - Rx Port ID or 00    *
                                            ; 02 - Rx station ID or 00 *
                                            ; 03 - Rx network ID or 00 *
                                            ; 04 - Rx byte count
                                            ; 05 - Rx byte count
                                            ; 06
                                            ; 07
                                            ; 08 - Void if top bit set
                                            ; 09
                                            ; 0A - Void if top bit set
                                            ; 0B
                                            ; 0C
                                            ; 0D
                                            ; 0E - Top bit set on Rx
                                            ; 0F
                                            ; 10
                                            ; 11+++Data block
    DB  024,04A       ; F818  BIT &4A       ; Test for broadcast packet
	DB  050,004       ; F81A  BVC &F820    
    DB  0A9,007       ; F81C  LDA #7        ; Release ADLC?
	DB  085,011       ; F81E  STA &11      
    DB  0DA           ; F820  PHX           ; Preserve X
	DB  020,024,0FE   ; F821  JSR &FE24    
	DB  090,04D       ; F824  BCC &F873

    DB  0AE,049,040   ; F826  LDX &4049     ; Get OPEN_RX_LIST index
    DB  0F0,045       ; F829  BEQ &F870     ; No Open RxCBs?

    DB  0A0,001       ; F82B  LDY #1        ; Index to RxCB table
                                            ; Compare against RxCBs
    DB  0B9,049,040   ; F82D  LDA &4049,Y   ; Get RxCB buffer ID
	DB  085,04B       ; F830  STA &4B      
    DB  0DA           ; F832  PHX           ; Preserve X, Y
	DB  05A           ; F833  PHY
    DB  020,055,0F7   ; F834  JSR &F755     ; Get address of buffer
    DB  086,03C       ; F837  STX &3C       ; Pointer to buffer
	DB  084,03D       ; F839  STY &3D      
    DB  0A0,008       ; F83B  LDY #8
	DB  0B1,03C       ; F83D  LDA (&3C),Y  
    DB  030,029       ; F83F  BMI &F86A     ; Void RxCB?
	DB  0A0,00A       ; F841  LDY #10      
	DB  0B1,03C       ; F843  LDA (&3C),Y  
    DB  030,023       ; F845  BMI &F86A     ; Void RxCB?
	DB  0A0,000       ; F847  LDY #0       
	DB  0B1,03C       ; F849  LDA (&3C),Y  
	DB  0C9,07F       ; F84B  CMP #127     
    DB  0D0,01B       ; F84D  BNE &F86A     ; Void RxCB?
	DB  0C8           ; F84F  INY          
    DB  0B1,03C       ; F850  LDA (&3C),Y   ; Get RxCB port number
    DB  0F0,004       ; F852  BEQ &F858     ; Any port?
    DB  0C5,041       ; F854  CMP &41       ; Compare with packet header
    DB  0D0,012       ; F856  BNE &F86A     ; No match port number?
    DB  0C8           ; F858  INY           ; Get RxCB station ID
	DB  0B1,03C       ; F859  LDA (&3C),Y  
    DB  0F0,01A       ; F85B  BEQ &F877     ; Any station?
    DB  0C5,03E       ; F85D  CMP &3E       ; Compare with packet header
    DB  0D0,009       ; F85F  BNE &F86A     ; No match station ID?
    DB  0C8           ; F861  INY           ; Get RxCB network ID
	DB  0B1,03C       ; F862  LDA (&3C),Y  
    DB  0F0,011       ; F864  BEQ &F877     ; Any network?
    DB  0C5,03F       ; F866  CMP &3F       ; Compare with packet header
    DB  0F0,00D       ; F868  BEQ &F877     ; Match network ID?
    DB  07A           ; F86A  PLY           ; Packet doesn't match RxCB
	DB  0FA           ; F86B  PLX
    DB  0C8           ; F86C  INY           ; Next RxCB
	DB  0CA           ; F86D  DEX          
	DB  0D0,0BD       ; F86E  BNE &F82D

                                            ; NO MATCHING RXCB
	DB  020,04A,0FE   ; F870  JSR &FE4A    
	DB  0FA           ; F873  PLX
	DB  04C,0DF,0F8   ; F874  JMP &F8DF

                                            ; FOUND MATCHING RXCB
    DB  0A0,00E       ; F877  LDY #14       ; Set Rx flag
	DB  0A9,080       ; F879  LDA #128     
	DB  091,03C       ; F87B  STA (&3C),Y  
	DB  085,04C       ; F87D  STA &4C      
	DB  020,04A,0FE   ; F87F  JSR &FE4A    
    DB  07A           ; F882  PLY           ; Restore Y, X
	DB  0FA           ; F883  PLX
	DB  0FA           ; F884  PLX
	DB  020,048,0FD   ; F885  JSR &FD48    
    DB  024,04A       ; F888  BIT &4A       ; Bit 6 set if broadcast
    DB  050,003       ; F88A  BVC &F88F     ; Non broadcast?
	DB  04C,0E9,0F9   ; F88C  JMP &F9E9    
    DB  0A9,044       ; F88F  LDA #68       ; 
	DB  085,010       ; F891  STA &10      
	DB  0A9,0A7       ; F893  LDA #167     
	DB  085,011       ; F895  STA &11      
	DB  0A9,09E       ; F897  LDA #158     
	DB  0A0,0F8       ; F899  LDY #248     
    DB  04C,050,0F9   ; F89B  JMP &F950     ; Set new NMI vector = &F89E

	DB  0A9,082       ; F89E  LDA #130     
	DB  085,010       ; F8A0  STA &10      
	DB  0A9,0A7       ; F8A2  LDA #167     
    DB  04C,0DB,0FD   ; F8A4  JMP &FDDB     ; Set new NMI vector = &F8A7

    DB  0A9,001       ; F8A7  LDA #1        ; Check ADLC for error
	DB  024,011       ; F8A9  BIT &11      
	DB  0F0,032       ; F8AB  BEQ &F8DF    
    DB  0A5,012       ; F8AD  LDA &12       ; Read ADLC byte
    DB  0CD,002,002   ; F8AF  CMP &0202     ; Compare with station ID
    DB  0D0,02B       ; F8B2  BNE &F8DF     ; Station IDs match?
	DB  0A9,0B9       ; F8B4  LDA #185     
	DB  04C,0DB,0FD   ; F8B6  JMP &FDDB     ; Set new NMI vector = &F8B9

    DB  024,011       ; F8B9  BIT &11       ; Check ADLC for error
	DB  010,022       ; F8BB  BPL &F8DF    
    DB  0A5,012       ; F8BD  LDA &12       ; Read ADLC byte
    DB  0D0,01E       ; F8BF  BNE &F8DF     ; Check local network
	DB  0A9,0CC       ; F8C1  LDA #204     
	DB  0A0,0F8       ; F8C3  LDY #248     
    DB  024,010       ; F8C5  BIT &10       ; More data?
	DB  030,003       ; F8C7  BMI &F8CC    
	DB  04C,0D8,0FD   ; F8C9  JMP &FDD8     ; Set new NMI vector = &F8CC

                                            ; ACK RECEIVED FOR DATA PACKET
    DB  024,011       ; F8CC  BIT &11       ; Check ADLC for error
	DB  010,00F       ; F8CE  BPL &F8DF    
    DB  0A5,012       ; F8D0  LDA &12       ; Read ADLC byte (station)
    DB  0A5,012       ; F8D2  LDA &12       ; Read ADLC byte (network)
	DB  0A9,0EC       ; F8D4  LDA #236     
	DB  0A0,0F8       ; F8D6  LDY #248     
    DB  024,010       ; F8D8  BIT &10       ; More data?
	DB  030,010       ; F8DA  BMI &F8EC    
	DB  04C,0D8,0FD   ; F8DC  JMP &FDD8     ; Set new NMI vector = &F8EC

                                            ; 
	DB  0A5,04A       ; F8DF  LDA &4A      
	DB  010,003       ; F8E1  BPL &F8E6    
	DB  04C,03A,0FD   ; F8E3  JMP &FD3A    
	DB  020,0BC,0FD   ; F8E6  JSR &FDBC    
	DB  04C,0D3,0F9   ; F8E9  JMP &F9D3    

											; NMI handler
    DB  0A4,02F       ; F8EC  LDY &2F       ; Rx byte index
    DB  0A5,011       ; F8EE  LDA &11       ; Check ADLC for error
	DB  010,029       ; F8F0  BPL &F91B    
    DB  0A5,012       ; F8F2  LDA &12       ; Read byte from ADLC...
    DB  091,02C       ; F8F4  STA (&2C),Y   ; ...save in RxCB
    DB  0C8           ; F8F6  INY           ; Move to next byte
	DB  0D0,006       ; F8F7  BNE &F8FF    
	DB  0E6,02D       ; F8F9  INC &2D      
    DB  0C6,02E       ; F8FB  DEC &2E       ; DEC buffer page count
    DB  0F0,0E0       ; F8FD  BEQ &F8DF     ; Buffer overflow?
    DB  0A5,011       ; F8FF  LDA &11       ; Check ADLC
    DB  030,002       ; F901  BMI &F905     ; More data?
	DB  0D0,016       ; F903  BNE &F91B    
    DB  0A5,012       ; F905  LDA &12       ; Read byte from ADLC...
    DB  091,02C       ; F907  STA (&2C),Y   ; ...save in RxCB
    DB  0C8           ; F909  INY           ; Move to next byte
	DB  084,02F       ; F90A  STY &2F      
	DB  0D0,006       ; F90C  BNE &F914    
	DB  0E6,02D       ; F90E  INC &2D      
    DB  0C6,02E       ; F910  DEC &2E       ; DEC buffer page count
    DB  0F0,007       ; F912  BEQ &F91B     ; Buffer overflow?
    DB  0A5,011       ; F914  LDA &11       ; More data?
	DB  0D0,0D8       ; F916  BNE &F8F0    
	DB  04C,0DE,0FD   ; F918  JMP &FDDE     ; Exit NMI

    DB  0A9,084       ; F91B  LDA #132      ; Program ADLC
	DB  085,011       ; F91D  STA &11      
	DB  0A9,000       ; F91F  LDA #0       
	DB  085,010       ; F921  STA &10      
    DB  084,02F       ; F923  STY &2F       ; Save Rx byte index
    DB  0A9,002       ; F925  LDA #2        ; Test ADLC last byte flag
	DB  024,011       ; F927  BIT &11      
    DB  0F0,0B4       ; F929  BEQ &F8DF     ; ADLC error (not last byte)
    DB  010,010       ; F92B  BPL &F93D     ; No more data?
    DB  0A5,02E       ; F92D  LDA &2E       ; Buffer overflow?
	DB  0F0,0AE       ; F92F  BEQ &F8DF    
    DB  0A5,012       ; F931  LDA &12       ; Read byte from ADLC...
    DB  0A4,02F       ; F933  LDY &2F       ; ...save in Rx CB
	DB  091,02C       ; F935  STA (&2C),Y  
    DB  0E6,02F       ; F937  INC &2F       ; Move to next byte
	DB  0D0,002       ; F939  BNE &F93D    
	DB  0E6,02D       ; F93B  INC &2D
                                            ; Buffer complete
	DB  0A5,04A       ; F93D  LDA &4A      
	DB  010,003       ; F93F  BPL &F944    
	DB  04C,036,0FD   ; F941  JMP &FD36    
    DB  0A9,044       ; F944  LDA #68       ; Program ADLC
	DB  085,010       ; F946  STA &10      
	DB  0A9,0A7       ; F948  LDA #167     
	DB  085,011       ; F94A  STA &11      
	DB  0A9,089       ; F94C  LDA #137     
	DB  0A0,0F9       ; F94E  LDY #249     
	DB  085,030       ; F950  STA &30      
    DB  084,031       ; F952  STY &31       ; Temp NMI vector = &F989

                                            ; SEND ACK TO RxCB
    DB  0A5,03E       ; F954  LDA &3E       ; Dest station ID
    DB  024,010       ; F956  BIT &10       ; Check ADLC status
    DB  050,02C       ; F958  BVC &F986     ; Error?
    DB  085,012       ; F95A  STA &12       ; Transmit station ID
    DB  0A5,03F       ; F95C  LDA &3F       ; Dest network ID
    DB  085,012       ; F95E  STA &12       ; Transmit station ID
	DB  0A9,067       ; F960  LDA #103     
	DB  0A0,0F9       ; F962  LDY #249     
	DB  04C,0D8,0FD   ; F964  JMP &FDD8     ; Set new NMI vector = &F967

                                            ; SEND ACK TO RxCB
    DB  0AD,002,002   ; F967  LDA &0202     ; Source station ID
    DB  024,010       ; F96A  BIT &10       ; Check ADLC status
    DB  050,018       ; F96C  BVC &F986     ; Error?
    DB  085,012       ; F96E  STA &12       ; Transmit station ID
    DB  0A9,000       ; F970  LDA #0        ; Local network ID
    DB  085,012       ; F972  STA &12       ; Transmit network ID
    DB  0A5,04A       ; F974  LDA &4A       ; B7 set if RPC call
	DB  030,00B       ; F976  BMI &F983    
    DB  0A9,03F       ; F978  LDA #63       ; Program ADLC
	DB  085,011       ; F97A  STA &11      
	DB  0A5,030       ; F97C  LDA &30      
	DB  0A4,031       ; F97E  LDY &31      
	DB  04C,0D8,0FD   ; F980  JMP &FDD8     ; Set new NMI vector = &????
                                            ; F989 =
                                            ; F89E =
                                            ; FA75 =

    DB  04C,092,0FC   ; F983  JMP &FC92     ; RPC handler
	DB  04C,0D3,0F9   ; F986  JMP &F9D3

	DB  0A5,041       ; F989  LDA &41      
	DB  0D0,003       ; F98B  BNE &F990
	DB  04C,075,0FA   ; F98D  JMP &FA75

    DB  0A5,02F       ; F990  LDA &2F       ; Byte offset
    DB  018           ; F992  CLC           ; Add to pointer
	DB  065,02C       ; F993  ADC &2C      
	DB  090,002       ; F995  BCC &F999    
	DB  0E6,02D       ; F997  INC &2D      
	DB  0A0,004       ; F999  LDY #4       
    DB  038           ; F99B  SEC           ; Subtract start of buffer
	DB  0E5,034       ; F99C  SBC &34      
    DB  091,03C       ; F99E  STA (&3C),Y   ; Save Rx length LSB
	DB  0A5,02D       ; F9A0  LDA &2D      
	DB  0E5,035       ; F9A2  SBC &35      
	DB  0C8           ; F9A4  INY          
    DB  091,03C       ; F9A5  STA (&3C),Y   ; Save Rx length MSB
	DB  0A5,041       ; F9A7  LDA &41      
    DB  0F0,028       ; F9A9  BEQ &F9D3     ; RPC call?
    DB  0A0,003       ; F9AB  LDY #3       
    DB  0A5,03F       ; F9AD  LDA &3F       ; Save Rx network ID
	DB  091,03C       ; F9AF  STA (&3C),Y  
	DB  088           ; F9B1  DEY          
    DB  0A5,03E       ; F9B2  LDA &3E       ; Save Rx station ID
	DB  091,03C       ; F9B4  STA (&3C),Y  
	DB  088           ; F9B6  DEY          
    DB  0A5,041       ; F9B7  LDA &41       ; Save Rx port ID
	DB  091,03C       ; F9B9  STA (&3C),Y  
	DB  088           ; F9BB  DEY          
    DB  0A5,040       ; F9BC  LDA &40       ; Save Rx RPC no
	DB  009,080       ; F9BE  ORA #128     
	DB  091,03C       ; F9C0  STA (&3C),Y  
	DB  0A0,007       ; F9C2  LDY #7       
	DB  0A9,0FD       ; F9C4  LDA #253     
	DB  091,03C       ; F9C6  STA (&3C),Y  
	DB  0DA           ; F9C8  PLX
	DB  0A2,014       ; F9C9  LDX #20      
	DB  0A0,002       ; F9CB  LDY #2       
	DB  0A5,04B       ; F9CD  LDA &4B      
	DB  020,07B,0FF   ; F9CF  JSR &FF7B    
	DB  0FA           ; F9D2  PLX
	DB  024,04C       ; F9D3  BIT &4C      
	DB  010,008       ; F9D5  BPL &F9DF    
	DB  0A9,000       ; F9D7  LDA #0       
	DB  085,04C       ; F9D9  STA &4C      
	DB  0A0,00E       ; F9DB  LDY #14      
	DB  091,03C       ; F9DD  STA (&3C),Y  
    DB  020,0C8,0FD   ; F9DF  JSR &FDC8     ; Set ADLC wait start frame
	DB  0A9,08E       ; F9E2  LDA #142     
	DB  0A0,0F7       ; F9E4  LDY #247     
	DB  04C,0D8,0FD   ; F9E6  JMP &FDD8     ; Set new NMI vector = &F78E

                                            ; BROADCAST RECEIVED OKAY
	DB  0DA           ; F9E9  PHX
	DB  0A2,004       ; F9EA  LDX #4       
	DB  0A4,02F       ; F9EC  LDY &2F      
	DB  0BD,03E,000   ; F9EE  LDA &003E,X  
	DB  091,02C       ; F9F1  STA (&2C),Y  
	DB  0C8           ; F9F3  INY          
	DB  0D0,006       ; F9F4  BNE &F9FC    
	DB  0E6,02D       ; F9F6  INC &2D      
	DB  0C6,02E       ; F9F8  DEC &2E      
	DB  0F0,031       ; F9FA  BEQ &FA2D    
	DB  0E8           ; F9FC  INX          
	DB  084,02F       ; F9FD  STY &2F      
	DB  0E0,00C       ; F9FF  CPX #12      
	DB  0D0,0EB       ; FA01  BNE &F9EE    
	DB  0FA           ; FA03  PLX
	DB  04C,090,0F9   ; FA04  JMP &F990

                                            ; DISTINGISH RPC TYPE
    DB  0A4,040       ; FA07  LDY &40       ; Get RPC type
    DB  0C0,081       ; FA09  CPY #129      ; Illegal RPC?
	DB  090,027       ; FA0B  BCC &FA34    
    DB  0C0,089       ; FA0D  CPY #137      ; Illegal RPC?
	DB  0B0,023       ; FA0F  BCS &FA34    
    DB  0C0,087       ; FA11  CPY #135      ; Continue or Machine Type?
	DB  0B0,00E       ; FA13  BCS &FA23    
    DB  098           ; FA15  TYA           ; Get RPC enable bit offset
	DB  038           ; FA16  SEC          
	DB  0E9,081       ; FA17  SBC #129     
	DB  0A8           ; FA19  TAY          
    DB  0AD,027,0B0   ; FA1A  LDA &B027     ; Get RPC enabled flags
    DB  06A           ; FA1D  ROR A         ; Extract appropriate flag
	DB  088           ; FA1E  DEY          
	DB  010,0FC       ; FA1F  BPL &FA1D    
    DB  0B0,0BC       ; FA21  BCS &F9DF     ; RPC disabled (wait next frame)

                                            ; RPC CONTINUE or RPC MACHINE TYPE
    DB  0A4,040       ; FA23  LDY &40       ; Get RPC type
    DB  0A9,0FA       ; FA25  LDA #250      ; High byte of routine = &FA
	DB  048           ; FA27  PHA          
    DB  0B9,0B6,0F9   ; FA28  LDA &F9B6,Y   ; Index to low byte
	DB  048           ; FA2B  PHA          
	DB  060           ; FA2C  RTS

	DB  0E6,02F       ; FA2D  INC &2F      
	DB  0E0,00B       ; FA2F  CPX #11      
	DB  0F0,0D0       ; FA31  BEQ &FA03    
	DB  0FA           ; FA33  PLX
	DB  04C,0DF,0F8   ; FA34  JMP &F8DF

                                            ; JUMP TABLE FOR RPC CALL
    DB  059           ; FA37  EQUB &59      ; RPC129 = Peek         &FA59
    DB  041           ; FA38  EQUB &41      ; RPC130 = Poke         &FA41
    DB  03E           ; FA39  EQUB &3E      ; RPC131 = JSR          &FA3E
    DB  03E           ; FA3A  EQUB &3E      ; RPC132 = Proc call    &FA3E
    DB  03E           ; FA3B  EQUB &3E      ; RPC133 = OS proc      &FA3E
    DB  071           ; FA3C  EQUB &71      ; RPC134 = Halt         &FA71
    DB  071           ; FA3D  EQUB &71      ; RPC135 = Continue     &FA71
    DB  047           ; FA3E  EQUB &47      ; RPC136 = Machine Type &FA47

                                            ; RPC131-133 NOT IMPLEMENTED
    DB  04C,0DF,0F9   ; FA3F  JMP &F9DF     ; Wait for next frame

                                            ; RPC130 POKE MEMORY
    DB  020,078,0FA   ; FA42  JSR &FA78     ; Get address from header
    DB  04C,088,0F8   ; FA45  JMP &F888

                                            ; RPC136 MACHINE TYPE
    DB  0A9,001       ; FA48  LDA #1       
    DB  085,02E       ; FA4A  STA &2E      
	DB  0A9,0FC       ; FA4C  LDA #252     
	DB  085,02F       ; FA4E  STA &2F      
	DB  0A9,02C       ; FA50  LDA #44      
	DB  085,02C       ; FA52  STA &2C      
	DB  0A9,0AF       ; FA54  LDA #175     
	DB  085,02D       ; FA56  STA &2D      
	DB  080,003       ; FA58  BRA &FA5D

                                            ; RPC129 PEEK MEMORY
    DB  020,078,0FA   ; FA5A  JSR &FA78     ; Get address from header
    DB  0A5,04A       ; FA5D  LDA &4A       ; Set RPC flag
	DB  009,080       ; FA5F  ORA #128     
	DB  085,04A       ; FA61  STA &4A      
    DB  0A9,044       ; FA63  LDA #68       ; Program ADLC
	DB  085,010       ; FA65  STA &10      
	DB  0A9,0A7       ; FA67  LDA #167     
	DB  085,011       ; FA69  STA &11      
	DB  0A9,075       ; FA6B  LDA #117     
	DB  0A0,0FA       ; FA6D  LDY #250     
    DB  04C,050,0F9   ; FA6F  JMP &F950     ; Temp NMI vector = &FA75

    DB  04C,0DF,0F9   ; FA72  JMP &F9DF     ; ADLC wait start frame
    DB  04C,0DF,0F9   ; FA75  JMP &F9DF     ; ADLC wait start frame

                                            ; READ ADDRESSES FROM RPC
	DB  0A0,001       ; FA78  LDY #1       
	DB  0B9,042,000   ; FA7A  LDA &0042,Y  
	DB  099,034,000   ; FA7D  STA &0034,Y  
	DB  0B9,046,000   ; FA80  LDA &0046,Y  
	DB  099,036,000   ; FA83  STA &0036,Y  
	DB  088           ; FA86  DEY          
	DB  010,0F1       ; FA87  BPL &FA7A    
	DB  04C,065,0FD   ; FA89  JMP &FD65

	DB  060           ; FA8C  RTS          
	DB  0A0,002       ; FA8D  LDY #2       
	DB  0B1,02A       ; FA8F  LDA (&2A),Y  
	DB  08D,000,002   ; FA91  STA &0200    
	DB  0C8           ; FA94  INY          
	DB  0B1,02A       ; FA95  LDA (&2A),Y  
	DB  08D,001,002   ; FA97  STA &0201    
	DB  0A0,000       ; FA9A  LDY #0       
	DB  0B1,02A       ; FA9C  LDA (&2A),Y  
	DB  030,003       ; FA9E  BMI &FAA3    
	DB  04C,020,0FB   ; FAA0  JMP &FB20    
	DB  08D,004,002   ; FAA3  STA &0204    
	DB  0AA           ; FAA6  TAX          
	DB  0C8           ; FAA7  INY          
	DB  0B1,02A       ; FAA8  LDA (&2A),Y  
	DB  08D,005,002   ; FAAA  STA &0205    
	DB  0D0,02F       ; FAAD  BNE &FADE    
	DB  0E0,083       ; FAAF  CPX #131     
	DB  0B0,017       ; FAB1  BCS &FACA    
	DB  0A0,004       ; FAB3  LDY #4       
	DB  0B1,02A       ; FAB5  LDA (&2A),Y  
	DB  099,006,002   ; FAB7  STA &0206,Y  
	DB  0C8           ; FABA  INY          
	DB  0B1,02A       ; FABB  LDA (&2A),Y  
	DB  099,006,002   ; FABD  STA &0206,Y  
	DB  0C8           ; FAC0  INY          
	DB  0A9,000       ; FAC1  LDA #0       
	DB  099,006,002   ; FAC3  STA &0206,Y  
	DB  0C8           ; FAC6  INY          
	DB  099,006,002   ; FAC7  STA &0206,Y  
	DB  0E0,081       ; FACA  CPX #129     
	DB  090,052       ; FACC  BCC &FB20    
	DB  0E0,089       ; FACE  CPX #137     
	DB  0B0,04E       ; FAD0  BCS &FB20    
	DB  0A0,00B       ; FAD2  LDY #11      
	DB  0B1,02A       ; FAD4  LDA (&2A),Y  
	DB  099,0FB,001   ; FAD6  STA &01FB,Y  
	DB  0C8           ; FAD9  INY          
	DB  0C0,00F       ; FADA  CPY #15      
	DB  090,0F6       ; FADC  BCC &FAD4    
	DB  0A9,020       ; FADE  LDA #32      
	DB  024,011       ; FAE0  BIT &11      
	DB  0D0,04B       ; FAE2  BNE &FB2F    
	DB  0A9,0FD       ; FAE4  LDA #253     
	DB  048           ; FAE6  PHA          
	DB  0A9,006       ; FAE7  LDA #6       
	DB  085,033       ; FAE9  STA &33      
	DB  0A9,000       ; FAEB  LDA #0       
	DB  085,032       ; FAED  STA &32      
	DB  048           ; FAEF  PHA          
	DB  048           ; FAF0  PHA          
	DB  0A0,0E7       ; FAF1  LDY #231     
	DB  0A9,004       ; FAF3  LDA #4       
	DB  008           ; FAF5  PHP          
	DB  078           ; FAF6  SEI          
	DB  064,007       ; FAF7  STZ &07       ; Disable 65C12 NMI
	DB  064,007       ; FAF9  STZ &07       ; Disable 65C12 NMI
	DB  024,011       ; FAFB  BIT &11      
	DB  0F0,00C       ; FAFD  BEQ &FB0B    
	DB  0A5,010       ; FAFF  LDA &10      
	DB  0A9,067       ; FB01  LDA #103     
	DB  085,011       ; FB03  STA &11      
	DB  0A9,010       ; FB05  LDA #16      
	DB  024,010       ; FB07  BIT &10      
	DB  0D0,030       ; FB09  BNE &FB3B    
	DB  024,007       ; FB0B  BIT &07       ; Enable 65C12 NMI
	DB  028           ; FB0D  PLP          
	DB  0BA           ; FB0E  TSX          
	DB  0FE,001,001   ; FB0F  INC &0101,X  
	DB  0D0,0DF       ; FB12  BNE &FAF3    
	DB  0FE,002,001   ; FB14  INC &0102,X  
	DB  0D0,0DA       ; FB17  BNE &FAF3    
	DB  0FE,003,001   ; FB19  INC &0103,X  
	DB  0D0,0D5       ; FB1C  BNE &FAF3    
	DB  0F0,004       ; FB1E  BEQ &FB24    
	DB  0A9,044       ; FB20  LDA #68      
	DB  0D0,00D       ; FB22  BNE &FB31    
	DB  0A9,007       ; FB24  LDA #7       
	DB  085,011       ; FB26  STA &11      
	DB  068           ; FB28  PLA          
	DB  068           ; FB29  PLA          
	DB  068           ; FB2A  PLA          
	DB  0A9,040       ; FB2B  LDA #64      
	DB  0D0,002       ; FB2D  BNE &FB31    
	DB  0A9,043       ; FB2F  LDA #67      
	DB  0A0,000       ; FB31  LDY #0       
	DB  091,02A       ; FB33  STA (&2A),Y  
	DB  0A9,080       ; FB35  LDA #128     
	DB  08D,013,002   ; FB37  STA &0213    
	DB  060           ; FB3A  RTS          
	DB  084,011       ; FB3B  STY &11      
	DB  0A2,044       ; FB3D  LDX #68      
	DB  086,010       ; FB3F  STX &10      
	DB  0A2,0CA       ; FB41  LDX #202     
	DB  0A0,0FB       ; FB43  LDY #251     
    DB  08E,0D6,0FD   ; FB45  STX &FDD6     ; Set NMI vecotor = &FBCA
	DB  08C,0D7,0FD   ; FB48  STY &FDD7    
	DB  024,007       ; FB4B  BIT &07       ; Enable 65C12 NMI
	DB  0AD,005,002   ; FB4D  LDA &0205    
	DB  0D0,044       ; FB50  BNE &FB96    
    DB  0AC,004,002   ; FB52  LDY &0204     ; RPC call ID
	DB  0B9,0EE,0FA   ; FB55  LDA &FAEE,Y  
	DB  085,04A       ; FB58  STA &4A      
	DB  0B9,0E6,0FA   ; FB5A  LDA &FAE6,Y  
	DB  085,033       ; FB5D  STA &33      
    DB  0A9,0FB       ; FB5F  LDA #251      ; High byte vector = &FB
	DB  048           ; FB61  PHA          
    DB  0B9,0F6,0FA   ; FB62  LDA &FAF6,Y   ; Low byte vector from table
	DB  048           ; FB65  PHA          
	DB  060           ; FB66  RTS          

                                            ; FAE6 TABLE (HEADER BYTE COUNT)
    DB  00E           ; FB67  EQUB &0E      ; RPC129 = Peek   
    DB  00E           ; FB68  EQUB &0E      ; RPC130 = Poke   
    DB  00A           ; FB69  EQUB &0A      ; RPC131 = JSR      
    DB  00A           ; FB6A  EQUB &0A      ; RPC132 = Proc call
    DB  00A           ; FB6B  EQUB &0A      ; RPC133 = OS proc  
    DB  006           ; FB6C  EQUB &06      ; RPC134 = Halt     
    DB  006           ; FB7D  EQUB &06      ; RPC135 = Continue 
    DB  00A           ; FB6E  EQUB &0A      ; RPC136 = Machine Type

                                            ; FAEE TABLE
    DB  081           ; FB6F  EQUB &81      ; RPC129 = Peek
    DB  000           ; FB70  EQUB &00      ; RPC130 = Poke
    DB  000           ; FB71  EQUB &00      ; RPC131 = JSR
    DB  000           ; FB72  EQUB &00      ; RPC132 = Proc call
    DB  000           ; FB73  EQUB &00      ; RPC133 = OS proc
    DB  001           ; FB74  EQUB &01      ; RPC134 = Halt
    DB  001           ; FB75  EQUB &01      ; RPC135 = Continue
    DB  081           ; FB76  EQUB &81      ; RPC136 = Machine Type

                                            ; FAF6 TABLE
    DB  07E           ; FB77  EQUB &7E      ; RPC129 = Peek         &FB7E
    DB  07E           ; FB78  EQUB &7E      ; RPC130 = Poke         &FB7E
    DB  0B9           ; FB79  EQUB &B9      ; RPC131 = JSR          &FBB9
    DB  0B9           ; FB7A  EQUB &B9      ; RPC132 = Proc call    &FBB9
    DB  0B9           ; FB7B  EQUB &B9      ; RPC133 = OS proc      &FBB9
    DB  0C4           ; FB7C  EQUB &C4      ; RPC134 = Halt         &FBC4
    DB  0C4           ; FB7D  EQUB &C4      ; RPC135 = Continue     &FBC4
    DB  0B9           ; FB7E  EQUB &B9      ; RPC136 = Machine Type &FBB9

                                            ; PEEK/POKE RPC
    DB  018           ; FB7F  CLC          
    DB  008           ; FB80  PHP
	DB  0A0,000       ; FB81  LDY #0       
	DB  0B9,006,002   ; FB83  LDA &0206,Y  
	DB  028           ; FB86  PLP          
	DB  079,00A,002   ; FB87  ADC &020A,Y  
	DB  099,00A,002   ; FB8A  STA &020A,Y  
	DB  0C8           ; FB8D  INY          
	DB  008           ; FB8E  PHP          
	DB  0C0,004       ; FB8F  CPY #4       
	DB  090,0F0       ; FB91  BCC &FB83    
	DB  028           ; FB93  PLP          
	DB  080,024       ; FB94  BRA &FBBA

	DB  0AD,000,002   ; FB96  LDA &0200
	DB  02D,001,002   ; FB99  AND &0201    
	DB  0C9,0FF       ; FB9C  CMP #255     
	DB  0D0,016       ; FB9E  BNE &FBB6    
	DB  0A9,00E       ; FBA0  LDA #14      
	DB  085,033       ; FBA2  STA &33      
	DB  0A9,040       ; FBA4  LDA #64      
	DB  085,04A       ; FBA6  STA &4A      
	DB  0A0,011       ; FBA8  LDY #17      
	DB  0B1,02A       ; FBAA  LDA (&2A),Y  
	DB  099,0F5,001   ; FBAC  STA &01F5,Y  
	DB  0C8           ; FBAF  INY          
	DB  0C0,019       ; FBB0  CPY #25      
	DB  090,0F6       ; FBB2  BCC &FBAA    
	DB  080,00F       ; FBB4  BRA &FBC5
	DB  0A9,000       ; FBB6  LDA #0
	DB  085,04A       ; FBB8  STA &4A

                                            ; CALL RPC
	DB  0A5,02A       ; FBBA  LDA &2A      
	DB  085,03C       ; FBBC  STA &3C      
	DB  0A5,02B       ; FBBE  LDA &2B      
	DB  085,03D       ; FBC0  STA &3D      
	DB  020,048,0FD   ; FBC2  JSR &FD48

                                            ; HALT/CONTINUE RPC
	DB  028           ; FBC5  PLP          
	DB  068           ; FBC6  PLA          
	DB  068           ; FBC7  PLA          
	DB  068           ; FBC8  PLA          
	DB  060           ; FBC9  RTS
                                            ; TRANSMIT HEADER FRAME
	DB  0A4,032       ; FBCA  LDY &32     
	DB  024,010       ; FBCC  BIT &10   
	DB  050,01D       ; FBCE  BVC &FBED
	DB  0B9,000,002   ; FBD0  LDA &0200,Y
	
	DB  085,012       ; FBD3  STA &12      
	DB  0C8           ; FBD5  INY          
	DB  0B9,000,002   ; FBD6  LDA &0200,Y  
	DB  0C8           ; FBD9  INY          
	DB  084,032       ; FBDA  STY &32      
	DB  085,012       ; FBDC  STA &12      
	DB  0C4,033       ; FBDE  CPY &33      
	DB  0B0,01C       ; FBE0  BCS &FBFE    
	DB  024,010       ; FBE2  BIT &10      
	DB  030,0E8       ; FBE4  BMI &FBCE    
	DB  04C,0DE,0FD   ; FBE6  JMP &FDDE     ; Exit NMI

	DB  0A9,042       ; FBE9  LDA #66      
	DB  0D0,006       ; FBEB  BNE &FBF3

                                            ; COLISSION BACKOFF PERIOD
	DB  0A9,067       ; FBED  LDA #103     
	DB  085,011       ; FBEF  STA &11      
	DB  0A9,041       ; FBF1  LDA #65      
	DB  0AC,002,002   ; FBF3  LDY &0202    
	DB  048           ; FBF6  PHA          
	DB  068           ; FBF7  PLA          
	DB  0C8           ; FBF8  INY          
	DB  0D0,0FB       ; FBF9  BNE &FBF6    
	DB  04C,03C,0FD   ; FBFB  JMP &FD3C

	DB  0A9,03F       ; FBFE  LDA #63      
	DB  085,011       ; FC00  STA &11      
	DB  0A9,009       ; FC02  LDA #9       
	DB  0A0,0FC       ; FC04  LDY #252     
	DB  04C,0D8,0FD   ; FC06  JMP &FDD8     ; Set new NMI vector = &FC09

	DB  0A9,082       ; FC09  LDA #130     
	DB  085,010       ; FC0B  STA &10      
	DB  024,04A       ; FC0D  BIT &4A      
	DB  050,003       ; FC0F  BVC &FC14    
	DB  04C,036,0FD   ; FC11  JMP &FD36    
	DB  0A9,001       ; FC14  LDA #1       
	DB  024,04A       ; FC16  BIT &4A      
	DB  0F0,003       ; FC18  BEQ &FC1D    
	DB  04C,0E9,0FC   ; FC1A  JMP &FCE9    
	DB  0A9,022       ; FC1D  LDA #34      
	DB  04C,0DB,0FD   ; FC1F  JMP &FDDB     ; Set new NMI vector = &FC22

	DB  0A9,001       ; FC22  LDA #1       
	DB  024,011       ; FC24  BIT &11      
	DB  0F0,0C1       ; FC26  BEQ &FBE9    
	DB  0A5,012       ; FC28  LDA &12      
	DB  0CD,002,002   ; FC2A  CMP &0202    
	DB  0D0,016       ; FC2D  BNE &FC45    
	DB  0A9,034       ; FC2F  LDA #52      
	DB  04C,0DB,0FD   ; FC31  JMP &FDDB     ; Set new NMI vector = &FC34

	DB  024,011       ; FC34  BIT &11      
	DB  010,00D       ; FC36  BPL &FC45    
	DB  0A5,012       ; FC38  LDA &12      
	DB  0D0,009       ; FC3A  BNE &FC45    
	DB  0A9,048       ; FC3C  LDA #72      
	DB  024,010       ; FC3E  BIT &10      
	DB  030,006       ; FC40  BMI &FC48    
	DB  04C,0DB,0FD   ; FC42  JMP &FDDB     ; Set new NMI vector = &FC48

	DB  04C,03A,0FD   ; FC45  JMP &FD3A    

	DB  024,011       ; FC48  BIT &11      
	DB  010,0F9       ; FC4A  BPL &FC45    
	DB  0A5,012       ; FC4C  LDA &12      
	DB  0CD,000,002   ; FC4E  CMP &0200    
	DB  0D0,0F2       ; FC51  BNE &FC45    
	DB  0A5,012       ; FC53  LDA &12      
	DB  0CD,001,002   ; FC55  CMP &0201    
	DB  0D0,0EB       ; FC58  BNE &FC45    
	DB  0A9,002       ; FC5A  LDA #2       
	DB  024,011       ; FC5C  BIT &11      
	DB  0F0,0E5       ; FC5E  BEQ &FC45    
	DB  0A9,0A7       ; FC60  LDA #167     
	DB  085,011       ; FC62  STA &11      
	DB  0A9,044       ; FC64  LDA #68      
	DB  085,010       ; FC66  STA &10      
	DB  0A9,0E9       ; FC68  LDA #233     
	DB  0A0,0FC       ; FC6A  LDY #252     
	DB  085,030       ; FC6C  STA &30      
    DB  084,031       ; FC6E  STY &31       ; Temp NMI vector = &FCE9
	DB  0AD,000,002   ; FC70  LDA &0200    
	DB  024,010       ; FC73  BIT &10      
	DB  050,013       ; FC75  BVC &FC8A    
	DB  085,012       ; FC77  STA &12      
	DB  0AD,001,002   ; FC79  LDA &0201    
	DB  085,012       ; FC7C  STA &12      
	DB  0A9,085       ; FC7E  LDA #133     
	DB  0A0,0FC       ; FC80  LDY #252     
	DB  04C,0D8,0FD   ; FC82  JMP &FDD8     ; Set new NMI vector = &FC85

	DB  0AD,002,002   ; FC85  LDA &0202    
	DB  024,010       ; FC88  BIT &10      
	DB  050,01B       ; FC8A  BVC &FCA7    
	DB  085,012       ; FC8C  STA &12      
	DB  0A9,000       ; FC8E  LDA #0       
	DB  085,012       ; FC90  STA &12      
	DB  0A9,0A1       ; FC92  LDA #161     
	DB  0A0,0FC       ; FC94  LDY #252     
	DB  04C,0D8,0FD   ; FC96  JMP &FDD8     ; Set new NMI vector = &FCA1

	DB  0A4,02E       ; FC99  LDY &2E      
	DB  0F0,02F       ; FC9B  BEQ &FCCC    
	DB  0A4,02F       ; FC9D  LDY &2F      
	DB  0F0,004       ; FC9F  BEQ &FCA5    
	DB  0A4,02F       ; FCA1  LDY &2F      
	DB  0F0,0F4       ; FCA3  BEQ &FC99    
	DB  024,010       ; FCA5  BIT &10      
	DB  050,039       ; FCA7  BVC &FCE2    
	DB  0B1,02C       ; FCA9  LDA (&2C),Y  
	DB  085,012       ; FCAB  STA &12      
	DB  0C8           ; FCAD  INY          
	DB  0D0,006       ; FCAE  BNE &FCB6    
	DB  0C6,02E       ; FCB0  DEC &2E      
	DB  0F0,018       ; FCB2  BEQ &FCCC    
	DB  0E6,02D       ; FCB4  INC &2D      
	DB  0B1,02C       ; FCB6  LDA (&2C),Y  
	DB  085,012       ; FCB8  STA &12      
	DB  0C8           ; FCBA  INY          
	DB  084,02F       ; FCBB  STY &2F      
	DB  0D0,006       ; FCBD  BNE &FCC5    
	DB  0C6,02E       ; FCBF  DEC &2E      
	DB  0F0,009       ; FCC1  BEQ &FCCC    
	DB  0E6,02D       ; FCC3  INC &2D      
	DB  024,010       ; FCC5  BIT &10      
	DB  030,0DE       ; FCC7  BMI &FCA7    
	DB  04C,0DE,0FD   ; FCC9  JMP &FDDE     ; Exit NMI

	DB  0A9,03F       ; FCCC  LDA #63      
	DB  085,011       ; FCCE  STA &11      
	DB  0A5,04A       ; FCD0  LDA &4A      
	DB  010,007       ; FCD2  BPL &FCDB    
	DB  0A9,0D3       ; FCD4  LDA #211     
	DB  0A0,0F9       ; FCD6  LDY #249     
	DB  04C,0D8,0FD   ; FCD8  JMP &FDD8     ; Set new NMI vector = &F9D3

	DB  0A5,030       ; FCDB  LDA &30      
	DB  0A4,031       ; FCDD  LDY &31      
	DB  04C,0D8,0FD   ; FCDF  JMP &FDD8     ; Set new NMI vector = &????

	DB  0A5,04A       ; FCE2  LDA &4A      
	DB  010,054       ; FCE4  BPL &FD3A    
	DB  04C,0D3,0F9   ; FCE6  JMP &F9D3

	DB  0A9,082       ; FCE9  LDA #130     
	DB  085,010       ; FCEB  STA &10      
	DB  0A9,0F2       ; FCED  LDA #242     
	DB  04C,0DB,0FD   ; FCEF  JMP &FDDB     ; Set new NMI vector = &F8F2

	DB  0A9,001       ; FCF2  LDA #1       
	DB  024,011       ; FCF4  BIT &11      
	DB  0F0,042       ; FCF6  BEQ &FD3A    
	DB  0A5,012       ; FCF8  LDA &12      
	DB  0CD,002,002   ; FCFA  CMP &0202    
	DB  0D0,03B       ; FCFD  BNE &FD3A    
	DB  0A9,006       ; FCFF  LDA #6       
	DB  0A0,0FD       ; FD01  LDY #253     
	DB  04C,0D8,0FD   ; FD03  JMP &FDD8     ; Set new NMI vector = &FD06

	DB  024,011       ; FD06  BIT &11      
	DB  010,030       ; FD08  BPL &FD3A    
	DB  0A5,012       ; FD0A  LDA &12      
	DB  0D0,02C       ; FD0C  BNE &FD3A    
	DB  0A9,017       ; FD0E  LDA #23      
	DB  024,010       ; FD10  BIT &10      
	DB  030,003       ; FD12  BMI &FD17    
	DB  04C,0DB,0FD   ; FD14  JMP &FDDB     ; Set new NMI vector = &FD17
	
	DB  024,011       ; FD17  BIT &11      
	DB  010,01F       ; FD19  BPL &FD3A    
	DB  0A5,012       ; FD1B  LDA &12      
	DB  0CD,000,002   ; FD1D  CMP &0200    
	DB  0D0,018       ; FD20  BNE &FD3A    
	DB  0A5,012       ; FD22  LDA &12      
	DB  0CD,001,002   ; FD24  CMP &0201    
	DB  0D0,011       ; FD27  BNE &FD3A    
	DB  0A5,04A       ; FD29  LDA &4A      
	DB  010,003       ; FD2B  BPL &FD30    
	DB  04C,0D4,0F8   ; FD2D  JMP &F8D4    
	DB  0A9,002       ; FD30  LDA #2       
	DB  024,011       ; FD32  BIT &11      
	DB  0F0,004       ; FD34  BEQ &FD3A    
	DB  0A9,000       ; FD36  LDA #0       
	DB  0F0,002       ; FD38  BEQ &FD3C    
	DB  0A9,041       ; FD3A  LDA #65      
	DB  0A0,000       ; FD3C  LDY #0       
	DB  091,02A       ; FD3E  STA (&2A),Y  
	DB  0A9,080       ; FD40  LDA #128     
	DB  08D,013,002   ; FD42  STA &0213    
	DB  04C,0D3,0F9   ; FD45  JMP &F9D3

                                            ; ADVANCE POINTER TO RX DATA BLOCK
    DB  0A9,011       ; FD48  LDA #17       ; Add &11 to pointer at &3C
	DB  018           ; FD4A  CLC          
	DB  065,03C       ; FD4B  ADC &3C      
	DB  085,034       ; FD4D  STA &34      
	DB  0A9,000       ; FD4F  LDA #0       
	DB  065,03D       ; FD51  ADC &3D      
	DB  085,035       ; FD53  STA &35      
	DB  0A0,004       ; FD55  LDY #4       
	DB  0B1,03C       ; FD57  LDA (&3C),Y  
	DB  0C8           ; FD59  INY          
	DB  018           ; FD5A  CLC          
	DB  065,034       ; FD5B  ADC &34      
	DB  085,036       ; FD5D  STA &36      
	DB  0B1,03C       ; FD5F  LDA (&3C),Y  
	DB  065,035       ; FD61  ADC &35      
	DB  085,037       ; FD63  STA &37

	DB  0A5,034       ; FD65  LDA &34      
	DB  038           ; FD67  SEC          
	DB  0E5,036       ; FD68  SBC &36      
	DB  085,02F       ; FD6A  STA &2F      
	DB  0A5,035       ; FD6C  LDA &35      
	DB  0E9,000       ; FD6E  SBC #0       
	DB  085,02D       ; FD70  STA &2D      
	DB  0A5,036       ; FD72  LDA &36      
	DB  085,02C       ; FD74  STA &2C      
	DB  0A5,037       ; FD76  LDA &37      
	DB  038           ; FD78  SEC          
	DB  0E5,02D       ; FD79  SBC &2D      
	DB  085,02E       ; FD7B  STA &2E      
	DB  060           ; FD7D  RTS          

	DB  020,0BC,0FD   ; FD7E  JSR &FDBC    
	DB  09C,000,040   ; FD81  STZ &4000
	DB  09C,002,040   ; FD84  STZ &4002
	DB  09C,003,040   ; FD87  STZ &4003
	DB  09C,003,002   ; FD8A  STZ &0203
	DB  064,04C       ; FD8D  STZ &4C
	DB  0A2,014       ; FD8F  LDX #&14
	DB  0A0,002       ; FD91  LDY #2       
	DB  020,071,0FF   ; FD93  JSR &FF71    
	DB  0A9,080       ; FD96  LDA #128     
	DB  08D,013,002   ; FD98  STA &0213    
	DB  0A9,000       ; FD9B  LDA #0        ; Read EEPROM location &00 STATION ID
	DB  085,021       ; FD9D  STA &21      
	DB  020,0C0,0FE   ; FD9F  JSR &FEC0     ; Read EEPROM byte
	DB  090,008       ; FDA2  BCC &FDAC     ; Read error?
	DB  0A5,020       ; FDA4  LDA &20       ; Values 00 and FF are invalid for the station
	DB  0F0,004       ; FDA6  BEQ &FDAC    
	DB  0C9,0FF       ; FDA8  CMP #255     
	DB  0D0,002       ; FDAA  BNE &FDAE    
	DB  0A9,001       ; FDAC  LDA #1       
	DB  08D,002,002   ; FDAE  STA &0202     ; Save byte read
	DB  0A9,08E       ; FDB1  LDA #142      ; Set new NMI vector = &F78E
	DB  08D,0D6,0FD   ; FDB3  STA &FDD6    
	DB  0A9,0F7       ; FDB6  LDA #247     
	DB  08D,0D7,0FD   ; FDB8  STA &FDD7    
	DB  060           ; FDBB  RTS          

                                            ; RESET ADLC?
    DB  0A9,0C1       ; FDBC  LDA #193      ; Write control reg 1
	DB  085,010       ; FDBE  STA &10      
    DB  0A9,01E       ; FDC0  LDA #30       ; Write ADLC Tx frame terminate
	DB  085,013       ; FDC2  STA &13      
    DB  0A9,000       ; FDC4  LDA #0        ; Write control reg 2,3
	DB  085,011       ; FDC6  STA &11

                                            ; SET ADLC WAIT START FRAME
    DB  0A9,082       ; FDC8  LDA #130      ; Write control reg 1
	DB  085,010       ; FDCA  STA &10      
    DB  0A9,067       ; FDCC  LDA #103      ; Write control reg 2,3
	DB  085,011       ; FDCE  STA &11      
	DB  060           ; FDD0  RTS          

											; 6502 NMI routine
	DB  064,007       ; FDD1  STZ &07       ; Disable 65C12 NMI
	DB  048           ; FDD3  PHA           ; Preserve A, Y
	DB  05A           ; FDD4  PHY
	DB  04C,08E,0F7   ; FDD5  JMP &F78E     ; Jump to NMI handler
	DB  08C,0D7,0FD   ; FDD8  STY &FDD7     ; Return new handler in Y, A
	DB  08D,0D6,0FD   ; FDDB  STA &FDD6    
	DB  07A           ; FDDE  PLY           ; Restore Y, A
	DB  068           ; FDDF  PLA          
	DB  024,007       ; FDE0  BIT &07       ; Enable 65C12 NMI
	DB  040           ; FDE2  RTI


											; 65C12 IRQ/BRK ROUTINE
	DB  085,029       ; FDE3  STA &29       ; Temp store for A
	DB  068           ; FDE5  PLA           ; Get 6502 P flags
	DB  048           ; FDE6  PHA  
	DB  029,010       ; FDE7  AND #16       ; Test for BRK flag
	DB  0D0,004       ; FDE9  BNE &FDEF    
	DB  0A5,029       ; FDEB  LDA &29       ; Restore temp A
	DB  080,003       ; FDED  BRA &FDF2

	DB  04C,001,0F5   ; FDEF  JMP &F501     ; Jump to 65C12 reset vector

											; 65C12 IRQ ROUTINE
	DB  024,001       ; FDF2  BIT &01       ; Disable 65C12 IRQ
	DB  048           ; FDF4  PHA           ; Preserve A, X
	DB  0DA           ; FDF5  PHX
	DB  0AD,001,040   ; FDF6  LDA &4001     ; Read command byte
	DB  008           ; FDF9  PHP          
	DB  029,07F       ; FDFA  AND #127     
	DB  0AA           ; FDFC  TAX          
	DB  028           ; FDFD  PLP          
	DB  030,00C       ; FDFE  BMI &FE0C    
	DB  00C,000,040   ; FE00  TSB &4000
	DB  0D0,019       ; FE03  BNE &FE1E    
	DB  0A9,001       ; FE05  LDA #1        ; Set flag
	DB  09D,001,040   ; FE07  STA &4001,X  
	DB  080,012       ; FE0A  BRA &FE1E
											; Read command
	DB  0BD,001,040   ; FE0C  LDA &4001,X  
	DB  0C9,001       ; FE0F  CMP #1       
	DB  0D0,00B       ; FE11  BNE &FE1E    
	DB  08A           ; FE13  TXA          
	DB  01C,000,040   ; FE14  TRB &4000
	DB  0F0,005       ; FE17  BEQ &FE1E    
	DB  09E,001,040   ; FE19  STZ &4001
	DB  080,000       ; FE1C  BRA &2E1E
	DB  09C,001,040   ; FE1E  STZ &4001
	DB  0FA           ; FE21  PLX           ; Restore X, A
	DB  068           ; FE22  PLA          
	DB  040           ; FE23  RTI          

	DB  048           ; FE24  PHA          
	DB  0A9,001       ; FE25  LDA #1       
	DB  020,034,0FE   ; FE27  JSR &FE34    
	DB  068           ; FE2A  PLA          
	DB  060           ; FE2B  RTS          

	DB  048           ; FE2C  PHA          
	DB  0A9,002       ; FE2D  LDA #2       
	DB  020,034,0FE   ; FE2F  JSR &FE34    
	DB  068           ; FE32  PLA          
	DB  060           ; FE33  RTS          

	DB  0DA           ; FE34  PHX
	DB  0AA           ; FE35  TAX          
	DB  008           ; FE36  PHP          
	DB  078           ; FE37  SEI          
	DB  00C,000,040   ; FE38  TSB &4000
	DB  0D0,009       ; FE3B  BNE &FE46    
	DB  0A9,002       ; FE3D  LDA #2       
	DB  09D,001,040   ; FE3F  STA &4001,X  
	DB  028           ; FE42  PLP          
	DB  038           ; FE43  SEC          
	DB  080,002       ; FE44  BRA &FE48
	DB  028           ; FE46  PLP          
	DB  018           ; FE47  CLC          
	DB  0FA           ; FE48  PLX
	DB  060           ; FE49  RTS          

	DB  048           ; FE4A  PHA          
	DB  0A9,001       ; FE4B  LDA #1       
	DB  020,05A,0FE   ; FE4D  JSR &FE5A    
	DB  068           ; FE50  PLA          
	DB  060           ; FE51  RTS          

	DB  048           ; FE52  PHA          
	DB  0A9,002       ; FE53  LDA #2       
	DB  020,05A,0FE   ; FE55  JSR &FE5A    
	DB  068           ; FE58  PLA          
	DB  060           ; FE59  RTS          

	DB  0DA           ; FE5A  PLX
	DB  0AA           ; FE5B  TAX          
	DB  008           ; FE5C  PHP          
	DB  078           ; FE5D  SEI          
	DB  0BD,001,040   ; FE5E  LDA &4001,X  
	DB  0C9,002       ; FE61  CMP #2       
	DB  0D0,009       ; FE63  BNE &FE6E    
	DB  08A           ; FE65  TXA          
	DB  01C,000,040   ; FE66  TRB &4000
	DB  0F0,003       ; FE69  BEQ &FE6E    
	DB  09E,001,040   ; FE6B  STZ &4001,X
	DB  028           ; FE6E  PLP          
	DB  0FA           ; FE6F  PLX
	DB  060           ; FE70  RTS          

											; READ/WRITE EEPROM CALL FROM
											; PC PASSED CB AT &40A5:
											;   40A5 - Command:
											;           00 = Do nothing
											;           01 = Read EEPROM
											;           02 = Write EEPROM
											;   40A6 - Return code
											;           00 = Success
											;           FE = Read/write error
											;           FF = Invalid command
											;   40A7 - EEPROM address
											;   40A8 - EEPROM data
	DB  0AD,0A7,040   ; FE71  LDA &40A7     ; EEPROM address to read
	DB  085,021       ; FE74  STA &21      
	DB  0AD,0A8,040   ; FE76  LDA &40A8     ; EEPROM data to write
	DB  085,020       ; FE79  STA &20      
	DB  0AD,0A5,040   ; FE7B  LDA &40A5     ; Command number
	DB  0F0,03F       ; FE7E  BEQ &FEBF     ; 00 is invalid command
	DB  0C9,002       ; FE80  CMP #2        ; 02 is write EEPROM
	DB  0D0,005       ; FE82  BNE &FE89    
	DB  020,001,0FF   ; FE84  JSR &FF01     ; Write byte &20 to EEPROM loc &21
	DB  080,01A       ; FE87  BRA &FEA3
	DB  0C9,001       ; FE89  CMP #1        ; 01 is read EEPROM
	DB  0D0,01C       ; FE8B  BNE &FEA9     ; Invalid function?
	DB  020,0C0,0FE   ; FE8D  JSR &FEC0     ; Read byte to &20 EEPROM offset &21
	DB  008           ; FE90  PHP           ; Result of read
	DB  0AD,0A7,040   ; FE91  LDA &40A7     ; Reading first byte ? (StationID)
	DB  0D0,00C       ; FE94  BNE &FEA2    
	DB  0A5,020       ; FE96  LDA &20       ; Check byte 00 <> 0 or 255 as is invalid for Station
	DB  0F0,004       ; FE98  BEQ &FE9E    
	DB  0C9,0FF       ; FE9A  CMP #255     
	DB  0D0,004       ; FE9C  BNE &FEA2    
	DB  0A9,001       ; FE9E  LDA #1        ; Return 1 as location 00
	DB  085,020       ; FEA0  STA &20      
	DB  028           ; FEA2  PLP           ; C=1 means success
	DB  0B0,008       ; FEA3  BCS &FEAD     ; Operation successful?
	DB  0A9,0FE       ; FEA5  LDA #254      ; Error return code
	DB  080,010       ; FEA7  BRA &FEB9
	DB  0A9,0FF       ; FEA9  LDA #255      ; Invlaid function return code
	DB  080,00C       ; FEAB  BRA &FEB9

	DB  0A5,021       ; FEAD  LDA &21       ; Pass back location...
	DB  08D,0A7,040   ; FEAF  STA &40A7    
	DB  0A5,020       ; FEB2  LDA &20       ; ...and data read/written
	DB  08D,0A8,040   ; FEB4  STA &40A8    
	DB  0A9,000       ; FEB7  LDA #0        ; And set return code=0000
	DB  08D,0A6,040   ; FEB9  STA &40A6    
	DB  09C,0A5,040   ; FEBC  STZ &40A5
	DB  060           ; FEBF  RTS          

											; READ BYTE FROM EPROM
											; &21 CONTAINS OFFSET TO READ
											; &20 CONTAINS BYTE READ
	DB  0A0,000       ; FEC0  LDY #0       
	DB  064,004       ; FEC2  STZ &04       ; Serial clock low
	DB  024,005       ; FEC4  BIT &05       ; Serial data high
	DB  024,004       ; FEC6  BIT &04       ; Serial clock high
	DB  064,005       ; FEC8  STZ &05       ; Serial data low

	DB  0A9,0AC       ; FECA  LDA #&AC      ; Command=&AC Set offset
	DB  020,035,0FF   ; FECC  JSR &FF35     ; Write byte to EEPROM
	DB  010,00C       ; FECF  BPL &FEDD     ; Write successful?
	DB  0C8           ; FED1  INY           ; Retry 250 times before fail
	DB  0C0,0FA       ; FED2  CPY #250     
	DB  090,002       ; FED4  BCC &FED8    
	DB  080,01B       ; FED6  BRA &FEF3     ; Read failed

	DB  020,0E8,0FF   ; FED8  JSR &FFE8     ; Delay...
	DB  080,0E5       ; FEDB  BRA &FEC2     ; ...and retry

	DB  0A5,021       ; FEDD  LDA &21       ; Offset of byte to read
	DB  020,035,0FF   ; FEDF  JSR &FF35     ; Write byte to EEPROM
	DB  010,002       ; FEE2  BPL &FEE6     ; Write successful?
	DB  080,00D       ; FEE4  BRA &FEF3     ; Read failed

	DB  024,005       ; FEE6  BIT &05       ; Serial data high
	DB  024,004       ; FEE8  BIT &04       ; Serial clock high
	DB  064,005       ; FEEA  STZ &05       ; Serial data low
	DB  0A9,0AD       ; FEEC  LDA #&AD      ; Command=&AD Read byte
	DB  020,035,0FF   ; FEEE  JSR &FF35     ; Write byte to EEPROM
	DB  010,003       ; FEF1  BPL &FEF6     ; Write successful?
	DB  018           ; FEF3  CLC           ; Flag failure
	DB  080,00A       ; FEF4  BRA &FF00

	DB  020,056,0FF   ; FEF6  JSR &FF56     ; Read byte from EEPROM
	DB  064,005       ; FEF9  STZ &05       ; Serial data low
	DB  024,004       ; FEFB  BIT &04       ; Serial clock high
	DB  024,005       ; FEFD  BIT &05       ; Serial data high
	DB  038           ; FEFF  SEC           ; Flag success
	DB  060           ; FF00  RTS          

											; WRITE BYTE TO EPROM
											; &21 CONTAINS OFFSET TO WRITE
											; &20 CONTAINS BYTE TO WRITE
	DB  0A0,000       ; FF01  LDY #0       
	DB  064,004       ; FF03  STZ &04       ; Serial clock low
	DB  024,005       ; FF05  BIT &05       ; Serial data high
	DB  024,004       ; FF07  BIT &04       ; Serial clock high
	DB  064,005       ; FF09  STZ &05       ; Serial data low
	DB  0A9,0AC       ; FF0B  LDA #&AC      ; Command=&AC Write byte
	DB  020,035,0FF   ; FF0D  JSR &FF35     ; Write byte to EEPROM
	DB  010,00C       ; FF10  BPL &FF1E     ; Write successful?
	DB  0C8           ; FF12  INY           ; Retry 250 times before fail
	DB  0C0,0FA       ; FF13  CPY #250     
	DB  090,002       ; FF15  BCC &FF19
	DB  080,00C       ; FF17  BRA &FF25     ; Write failed

	DB  020,0E8,0FF   ; FF19  JSR &FFE8     ; Delay...
	DB  080,0E5       ; FF1C  BRA &FF03     ; ...and retry

	DB  0A5,021       ; FF1E  LDA &21       ; Offset of byte to write
	DB  020,035,0FF   ; FF20  JSR &FF35     ; Write byte to EEPROM
	DB  010,003       ; FF23  BPL &FF28     ; Write successful?
	DB  018           ; FF25  CLC           ; Flag failure
	DB  080,00C       ; FF26  BRA &FF34

	DB  0A5,020       ; FF28  LDA &20       ; Data to write
	DB  020,035,0FF   ; FF2A  JSR &FF35     ; Write byte to EEPROM
	DB  064,005       ; FF2D  STZ &05       ; Serial data low
	DB  024,004       ; FF2F  BIT &04       ; Serial clock high
	DB  024,005       ; FF31  BIT &05       ; Serial data high
	DB  038           ; FF33  SEC           ; Flag success
	DB  060           ; FF34  RTS          


											; WRITE BYTE TO EEPROM FROM A
	DB  0A2,008       ; FF35  LDX #8        ; Bit count in X
	DB  064,004       ; FF37  STZ &04       ; Serial clock low
	DB  02A           ; FF39  ROL A         ; Get bit
	DB  090,004       ; FF3A  BCC &FF40
	DB  024,005       ; FF3C  BIT &05       ; Serial data high
	DB  080,002       ; FF3E  BRA &FF42
	DB  064,005       ; FF40  STZ &05       ; Serial data low
	DB  024,004       ; FF42  BIT &04       ; Serial clock high (write bit)
	DB  0EA           ; FF44  NOP           ; Delay
	DB  0EA           ; FF45  NOP          
	DB  0CA           ; FF46  DEX           ; Do next bit
	DB  0D0,0EE       ; FF47  BNE &FF37    
	DB  064,004       ; FF49  STZ &04       ; Serial clock low
	DB  024,005       ; FF4B  BIT &05       ; Serial data high
	DB  0EA           ; FF4D  NOP           ; Delay
	DB  0EA           ; FF4E  NOP           
	DB  024,004       ; FF4F  BIT &04       ; Serial clock high
	DB  024,005       ; FF51  BIT &05       ; Serial data high (read flag)
	DB  064,004       ; FF53  STZ &04       ; Serial clock low
	DB  060           ; FF55  RTS          

											; READ BYTE FROM EEPROM TO &20
	DB  0A2,008       ; FF56  LDX #8        ; Bit count in X
	DB  064,004       ; FF58  STZ &04       ; Serial clock low
	DB  024,005       ; FF5A  BIT &05       ; Serial data high
	DB  0EA           ; FF5C  NOP          
	DB  0EA           ; FF5D  NOP          
	DB  024,004       ; FF5E  BIT &04       ; Serial clock high
	DB  0A5,005       ; FF60  LDA &05       ; Serial data high (read bit)
	DB  02A           ; FF62  ROL A         ; Bit out into C
	DB  026,020       ; FF63  ROL &20       ; Rotate bits into temp store
	DB  0CA           ; FF65  DEX           ; Next bit
	DB  0D0,0F0       ; FF66  BNE &FF58    
	DB  064,004       ; FF68  STZ &04       ; Serial clock low
	DB  024,005       ; FF6A  BIT &05       ; Serial data high
	DB  024,004       ; FF6C  BIT &04       ; Serial clock high
	DB  064,004       ; FF6E  STZ &04       ; Serial clock low
	DB  060           ; FF70  RTS          


	DB  086,022       ; FF71  STX &22      
	DB  084,023       ; FF73  STY &23      
	DB  0A0,000       ; FF75  LDY #0       
	DB  098           ; FF77  TYA          
	DB  091,022       ; FF78  STA (&22),Y  
	DB  060           ; FF7A  RTS          

	DB  048           ; FF7B  PHA          
	DB  0DA           ; FF7C  PHX
	DB  05A           ; FF7D  PHY
	DB  0A5,022       ; FF7E  LDA &22      
	DB  048           ; FF80  PHA          
	DB  0A5,023       ; FF81  LDA &23      
	DB  048           ; FF83  PHA          
	DB  086,022       ; FF84  STX &22      
	DB  084,023       ; FF86  STY &23      
	DB  0A0,000       ; FF88  LDY #0       
	DB  0B1,022       ; FF8A  LDA (&22),Y  
	DB  01A           ; FF8C  INC A
	DB  091,022       ; FF8D  STA (&22),Y  
	DB  0A8           ; FF8F  TAY          
	DB  0BA           ; FF90  TSX          
	DB  0BD,005,001   ; FF91  LDA &0105,X  
	DB  091,022       ; FF94  STA (&22),Y  
	DB  068           ; FF96  PLA          
	DB  085,023       ; FF97  STA &23      
	DB  068           ; FF99  PLA          
	DB  085,022       ; FF9A  STA &22      
	DB  07A           ; FF9C  PLY
	DB  0FA           ; FF9D  PLX
	DB  068           ; FF9E  PLA          
	DB  060           ; FF9F  RTS          

	DB  086,022       ; FFA0  STX &22      
	DB  084,023       ; FFA2  STY &23      
	DB  0A0,000       ; FFA4  LDY #0       
	DB  018           ; FFA6  CLC          
	DB  0B1,022       ; FFA7  LDA (&22),Y  
	DB  0F0,016       ; FFA9  BEQ &FFC1    
	DB  0AA           ; FFAB  TAX          
	DB  03A           ; FFAC  DEC A
	DB  091,022       ; FFAD  STA (&22),Y  
	DB  0C8           ; FFAF  INY          
	DB  0B1,022       ; FFB0  LDA (&22),Y  
	DB  048           ; FFB2  PHA          
	DB  0CA           ; FFB3  DEX          
	DB  0F0,009       ; FFB4  BEQ &FFBF    
	DB  0C8           ; FFB6  INY          
	DB  0B1,022       ; FFB7  LDA (&22),Y  
	DB  088           ; FFB9  DEY          
	DB  091,022       ; FFBA  STA (&22),Y  
	DB  0C8           ; FFBC  INY          
	DB  080,0FA       ; FFBD  BRA &FFB3
	DB  068           ; FFBF  PLA          
	DB  038           ; FFC0  SEC          
	DB  060           ; FFC1  RTS          
	DB  086,022       ; FFC2  STX &22      
	DB  084,023       ; FFC4  STY &23      
	DB  048           ; FFC6  PHA          
	DB  0A0,000       ; FFC7  LDY #0       
	DB  0B1,022       ; FFC9  LDA (&22),Y  
	DB  0F0,018       ; FFCB  BEQ &FFE5    
	DB  0AA           ; FFCD  TAX          
	DB  068           ; FFCE  PLA          
	DB  0C8           ; FFCF  INY          
	DB  0D1,022       ; FFD0  CMP (&22),Y  
	DB  0F0,005       ; FFD2  BEQ &FFD9    
	DB  0CA           ; FFD4  DEX          
	DB  0D0,0F8       ; FFD5  BNE &FFCF    
	DB  080,00D       ; FFD7  BRA &FFE6
	DB  048           ; FFD9  PHA
	DB  05A           ; FFDA  PHY
	DB  0A0,000       ; FFDB  LDY #0       
	DB  0B1,022       ; FFDD  LDA (&22),Y  
	DB  03A           ; FFDF  DEC A
	DB  091,022       ; FFE0  STA (&22),Y  
	DB  07A           ; FFE2  PLY
	DB  080,0CE       ; FFE3  BRA &FFB3
	DB  068           ; FFE5  PLA
	DB  018           ; FFE6  CLC
	DB  060           ; FFE7  RTS          

											; DELAY
	DB  048           ; FFE8  PHA          
	DB  08A           ; FFE9  TXA          
	DB  048           ; FFEA  PHA          
	DB  0A2,0A4       ; FFEB  LDX #164     
	DB  048           ; FFED  PHA          
	DB  068           ; FFEE  PLA          
	DB  0CA           ; FFEF  DEX          
	DB  0D0,0FB       ; FFF0  BNE &FFED    
	DB  068           ; FFF2  PLA          
	DB  0AA           ; FFF3  TAX          
	DB  068           ; FFF4  PLA          
	DB  060           ; FFF5  RTS          

	DB  000           ; FFF6  BRK         
	DB  000           ; FFF7  BRK          
	DB  000           ; FFF8  BRK          
	DB  000           ; FFF9  BRK          
	DB  0D1,0FD       ; FFFA  CMP (&FD),Y       ; NMI vector
	DB  001,0F5       ; FFFC  ORA (&F5),X       ; Power up reset vector
	DB  0E3,0FD       ; FFFE  ??? &FD           ; IRQ vector
*/
