/*
This file is part of VoidHawk.

VoidHawk is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

VoidHawk is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with VoidHawk.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef struct
{
    char vivo;
    char disparado;
    char pintar;

    Vector2D posicion;
    Vector2D oldPos;
} Flanger;

#define FLANGER_ANCHO          20
#define FLANGER_ALTO           10
#define FLANGER_ANCHO_MUNDO    2000
#define FLANGER_ALTO_MUNDO     1000

#define FLANGER_VEL_X          200

#define FLANGER_DANYO          20


#define SWEEPER_MAX_CAMINO     8

typedef struct
{
    char vida;
    char pintar;

    Flanger flanger;
    char actual;
    Vector2D camino[SWEEPER_MAX_CAMINO];

    Vector2D posicion;
    Vector2D oldPos;
    Vector2D velocidad;
} Sweeper;

#define SWEEPER_ANCHO          4
#define SWEEPER_ALTO           8
#define SWEEPER_ANCHO_MUNDO    400
#define SWEEPER_ALTO_MUNDO     800

#define SWEEPER_MIN_X          4000
#define SWEEPER_MIN_Y          2000
#define SWEEPER_MAX_X          3600
#define SWEEPER_MAX_Y          15200

#define SWEEPER_VEL_MAX        150

#define SWEEPER_VIDA           30

#define SWEEPER_ACELERACION    17
#define SWEEPER_ACELERACION_Y  35

#define SWEEPER_NEAR_X         100
#define SWEEPER_NEAR_Y         200

#define SWEEPER_MAX_FORCE      70
#define SWEEPER_SEEK_FORCE     50
#define SWEEPER_AVOID_FORCE    60
#define SWEEPER_MAX_SEE_AHEAD  3
