/*
This file is part of VoidHawk.

VoidHawk is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

VoidHawk is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with VoidHawk.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef struct
{
    char vivo;
    char pintar;

    Vector2D posicion;
    Vector2D oldPos;
    Vector2D velocidad;
} Phaser;

#define PHASER_ANCHO           4
#define PHASER_ALTO            10
#define PHASER_ANCHO_MUNDO     400
#define PHASER_ALTO_MUNDO      1000

#define PHASER_MAX_X           7600

#define PHASER_VEL_MAX         250
#define PHASER_VEL_MAX_FINAL   500
#define PHASER_ACELERACION     21

#define PHASER_DANYO           30

typedef struct
{
    char vida;
    char pintar;

    char estado;
    Vector2D objetivo;
    Rayo rayo;

    Vector2D posicion;
    Vector2D oldPos;
    Vector2D velocidad;
} Drone;

#define DRONE_ANCHO            4
#define DRONE_ALTO             8
#define DRONE_ANCHO_MUNDO      400
#define DRONE_ALTO_MUNDO       800

#define DRONE_VEL_MAX          50
#define DRONE_VEL_MAX_KAMIKAZE 150

#define DRONE_VIDA             30
#define DRONE_DANYO            10

#define DRONE_SEEK_FORCE       50


#define CARRIER_MAX_DRONES     4

typedef struct
{
    char vida;
    char pintar;

    char estado;
    char dronesVivos;
    char direccion;
    char escudo;
    Phaser phaser;
    Drone drones[CARRIER_MAX_DRONES];

    Vector2D posicion;
    Vector2D oldPos;
    Vector2D velocidad;
} Carrier;


#define CARRIER_ANCHO          5
#define CARRIER_ALTO           20
#define CARRIER_ANCHO_MUNDO    500
#define CARRIER_ALTO_MUNDO     2000

#define CARRIER_POS_X          6500
#define CARRIER_POS_Y          6000

#define CARRIER_MIN_Y          4000
#define CARRIER_MAX_Y          16000

#define CARRIER_VEL_MAX        200

#define CARRIER_VIDA           100

#define CARRIER_ACELERACION    20

#define CARRIER_NEAR_X         100
#define CARRIER_NEAR_Y         200
