// churromain.c
// Esqueleto de juegos de la churrera
// Copyleft 2010 The Mojon Twins

// Renombrar a tujuego.c o lo que sea para que quede ms bello
// y to la pesca.

#pragma output STACKPTR=49151

#include <cpcrslib.h>				// Biblioteca de juego por Artaburu.
#include <cpcwyzlib.h>				// Replayer AY por WYZ, adaptado por Artaburu.
#include "sound.h"					// Configuracin del replayer AY.

#define WYZ_CANAL_EFECTOS 2

// Globales muy globalizadas

unsigned char enoffs;
unsigned char enoffsmasi;

// Aux

extern char asm_number[1];
extern unsigned int asm_int [1];
extern unsigned int asm_int_2 [1];
extern unsigned int seed [1];
unsigned char half_life;

// CPC

struct sprite { 			// estructura mnima para usar la librera de dibujar sprites capturando el fondo.
	int sp0;				// 2 bytes	01
	int sp1;				// 2 bytes	23
	int coord0; 			// 2 bytes	45	 posicin en superbuffer
	int coord1; 			// 2 bytes	67	 posicin anterior en superbuffer
	unsigned char cx, cy;	// 2 bytes	89	 coordenadas nuevas
	unsigned char ox, oy;	// 2 bytes	AB	 coordenadas actuales
	unsigned char move; 	// 1 byte	 C	  si NO es 0, el sprite se mueve.
	unsigned char move1;	// 1 byte	 D	  si NO es 0, el sprite se mueve.
	// Si es 8 en cuanto se mueva se pone a 0 y ya no se mueve ms hasta nueva orden.
} ;

struct sprite sp_player;
struct sprite sp_enem1;
struct sprite sp_enem2;
struct sprite sp_enem3;

extern unsigned char tile_0 []; // Tiles en tilemapconf

//

#asm
._asm_number 
	defb 0
._asm_int
	defw 0
._asm_int_2
	defw 0
._seed	
	defw 0
#endasm

// Cosas del juego:
/*
void halt_me (void) {
	#asm
		halt				;unas esperas para que se actualicen los colores
		halt
		halt
		halt
		halt
	#endasm
}
*/
unsigned char palettes [] = {
	20, 22, 31, 3,
	20, 24, 14, 11,
	20, 24, 23, 19
};

void set_inks (unsigned char n) {
	
	/*
	Tabla de conversin de paletas
	
	firm	hard
	0		20
	1		4
	2		21
	3		28
	4		24
	5		29
	6		12
	7		5
	8		13
	9		22
	10		6
	11		23
	12		30
	13		0
	14		31
	15		14
	16		7
	17		15
	18		18
	19		2
	20		19
	21		26
	22		25
	23		27
	24		10
	25		3
	26		11
	*/
		
	unsigned char i;
	
	for (i = 0; i < 4; i ++) {
		cpc_SetColour (i, palettes[i + (n << 2)]);
	}
}

void set_black () {
	unsigned char i;
	for (i = 0; i < 4; i ++)
		cpc_SetColour (i, 20);
}

void interrupciones(void) {
	// Manejador de interrupciones por Artaburu
	
	#asm
		di
		ld hl,($0039)
		ld (_int_original),HL   //guardo el salto original

		ld HL,_interrupcion
		ld ($0039),HL
		ei
		jp term
	._int_original  
		defw 0
	._interrupcion
		ei
		ret
	.term
	#endasm
}

#define KEY_IZQ 		0
#define KEY_DER 		1
#define KEY_ARR 		2
#define KEY_ABA 		3
#define KEY_FIR 		4
#define KEY_ESC 		5

#define KEY_JOY_IZQ		6
#define KEY_JOY_DER		7
#define KEY_JOY_ARR		8
#define KEY_JOY_ABA		9
#define KEY_JOY_FIR		10

#include "pantallas.h"
#include "config.h"
#include "mapa.h"
#include "sprites.h"
#include "enems.h"
//#include "beeper.h"
#define peta_el_beeper(n)	cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, n);
#include "engine.h"

extern unsigned char cad_ending [0];
#asm
	._cad_ending
		defm "TREASURE: 00"
		defb 0
#endasm

// Y el main

void main (void) {
	int j;
	unsigned char *allpurposepuntero;
	unsigned char i;
	unsigned char playing;
	unsigned char maincounter;
	signed int x, y;				// Cambio 304 pxels (TM)
	unsigned char success;
	
	// Inicializacin
	
	interrupciones ();
	//halt_me ();

	//halt_me ();
	cpc_SetMode (1);
		
	// Inicializamos el player de wyz:
	
	cpc_WyzInitPlayer (wyz_sound_table, wyz_pattern_table, wyz_effects_table, wyz_song_table);
	
	// Batera por el canal C
	
	cpc_WyzConfigurePlayer (0);		
	
	// Borde 
	
	cpc_SetColour (16, 20);
	
	// Redefinimos las teclas
	
	cpc_AssignKey (KEY_IZQ, 0x4101);		// CUR LEFT
	cpc_AssignKey (KEY_DER, 0x4002);		// CUR RIGHT
	cpc_AssignKey (KEY_ARR, 0x4001);		// CUR UP
	cpc_AssignKey (KEY_ABA, 0x4004);		// CUR DOWN
	cpc_AssignKey (KEY_FIR, 0x4580);		// SPACE
	
	cpc_AssignKey (KEY_JOY_IZQ, 0x4904);		// JOY LEFT
	cpc_AssignKey (KEY_JOY_DER, 0x4908);		// JOY RIGHT
	cpc_AssignKey (KEY_JOY_ARR, 0x4901);		// JOY UP
	cpc_AssignKey (KEY_JOY_ABA, 0x4902);		// JOY DOWN
	cpc_AssignKey (KEY_JOY_FIR, 0x4910);		// JOY FIRE
	
	cpc_AssignKey (KEY_ESC, 0x4804);		// ESC
	
	while (1) {
		// Aqu la pantalla de ttulo
		
		unpack ((unsigned int) (s_title));
		print_Text (80, 192, "PRESS ANY KEY TO PLAY");
		set_inks (1);
		
		uncompress_and_play_me (0);
		
		espera_activa (32767);
		
		cpc_WyzSetPlayerOff ();
		
		// Empezamos.
		
		unpack ((unsigned int) (s_marco));
		set_inks (1);
		
		playing = 1;
		init_player ();
		init_hotspots ();
		init_cerrojos ();
		
		for (i = 0; i < 20; i++) { 
			moneas [i*18] = 0;
			moneas [i*18+1] = 0;
		}
			
		n_pant = SCR_INICIO;
		maincounter = 0;
		
		player.lastn_pant = n_pant;
		camiseta.n_pant = 99;		
		half_life = 0;
		
		draw_scr ();
		draw_life ();
		draw_objs ();
		draw_keys ();
		draw_n (16, 23, player.coins);
		
		// Initialize CPCRSLIB sprites
		/*
		sp_player.sp0 = (int) (spr_0);
		sp_player.sp1 = (int) (spr_0);
		sp_player.move = 0;
		sp_player.cx = sp_player.ox = (unsigned char) (player.x >> 8);
		sp_player.cy = sp_player.oy = (unsigned char) (player.y >> 6);
		
		sp_enem1.sp0 = (int) (spr_13);
		sp_enem1.sp1 = (int) (spr_13);
		sp_enem1.move = 0;
		sp_enem1.cx = sp_enem1.ox = 0;
		sp_enem1.cy = sp_enem1.oy = 0;
		
		sp_enem2.sp0 = (int) (spr_13);
		sp_enem2.sp1 = (int) (spr_13);
		sp_enem2.move = 0;
		sp_enem2.cx = sp_enem2.ox = 0;
		sp_enem2.cy = sp_enem2.oy = 0;
		
		sp_enem3.sp0 = (int) (spr_13);
		sp_enem3.sp1 = (int) (spr_13);
		sp_enem3.move = 0;
		sp_enem3.cx = sp_enem3.ox = 0;
		sp_enem3.cy = sp_enem3.oy = 0;
		*/
		// Ok
		/*
		//sp_player.move = 0;
		sp_player.ox = (unsigned char) (player.x >> 8);
		sp_player.oy = (unsigned char) (player.y >> 6);
		//sp_enem1.move = 0;
		sp_enem1.ox = 0;
		sp_enem1.oy = 0;
		//sp_enem2.move = 0;
		sp_enem2.ox = 0;
		sp_enem2.oy = 0;
		//sp_enem3.move = 0;
		sp_enem3.ox = 0;
		sp_enem3.oy = 0;
		*/
		
		uncompress_and_play_me (1);
		
		while (playing) {
			maincounter ++;
			half_life = !half_life;
			
			if (cpc_TestKey (KEY_ESC)) {
				
				for (i = 1; i < 9; i ++) {
		            peta_el_beeper (i);
		            for (x = 0; x < 5000; x ++)
		                y = y - 1;
       			}
			}
			
			// Mover player
			
			if (player.estado & EST_MUR) {
				death_sequence ();

				// Esto acaba cuando el jugador sale de la pantalla:
	
				//AQUI
			} else if (!(player.estado & EST_IDLE)) {
				move ();
			}
			
			// Mover enemigos
			
			mueve_bicharracos ();
			
			// Parpadeos / Idle
						
			if (player.estado & EST_PARP) {
				player.ct_estado --;
				if (player.ct_estado == 0) {
					//player.estado &= ~EST_PARP;
					player.estado ^= EST_PARP;
				}
			}
			
			if (player.estado == EST_IDLE) {
				player.ct_estado --;
				if (player.ct_estado == 0) {
					player.estado = EST_PARP;
					player.ct_estado = 32;
					peta_el_beeper (5);
				}
			}
			
			//draw_n (0, 23, player.ct_estado);
			
			// Precalc para clculos (eh?)
			
			x = player.x >> 6;
			y = player.y >> 6;
			
			// Render
			
			if ( (half_life && (player.estado & EST_PARP)) || (player.estado & EST_IDLE) )
				sp_player.sp0 = (int) (spr_18);
			else
				sp_player.sp0 = (int) (player.next_frame);
			sp_player.cx = player.x >> 8;
			if (player.y < 9216)
				sp_player.cy = player.y >> 6;
			
			sp_enem1.sp0 = (int) (en_an [0].next_frame);
			sp_enem1.cx = (unsigned char) (malotes [enoffs].x >> 2);
			sp_enem1.cy = malotes [enoffs].y;
		
			sp_enem2.sp0 = (int) (en_an [1].next_frame);
			sp_enem2.cx = (unsigned char) (malotes [enoffs + 1].x >> 2);
			sp_enem2.cy = malotes [enoffs + 1].y;
		
			sp_enem3.sp0 = (int) (en_an [2].next_frame);
			sp_enem3.cx = (unsigned char) (malotes [enoffs + 2].x >> 2);
			sp_enem3.cy = malotes [enoffs + 2].y;
			
			cpc_PutSpTileMap ((int) (sp_player));
			cpc_PutSpTileMap ((int) (sp_enem1));
			cpc_PutSpTileMap ((int) (sp_enem2));
			cpc_PutSpTileMap ((int) (sp_enem3));
			
			cpc_UpdScr ();
			
			cpc_PutMaskSpTileMap2b ((int) (sp_player));
			if (malotes [enoffs].t != 0) cpc_PutMaskSpTileMap2b ((int) (sp_enem1));
			if (malotes [enoffs + 1].t != 0) cpc_PutMaskSpTileMap2b ((int) (sp_enem2));
			if (malotes [enoffs + 2].t != 0) cpc_PutMaskSpTileMap2b ((int) (sp_enem3));
			
			// Update
			
			cpc_ShowTouchedTiles ();
			cpc_ResetTouchedTiles ();
			
			// Coger objetos
			
			if (x >= hotspot_x - 15 && x <= hotspot_x + 15 && y >= hotspot_y - 15 && y <= hotspot_y + 15) {
				// restauramos el tile de fondo
				draw_coloured_tile_inv (hotspot_x >> 3, hotspot_y >> 3, map_buff [(hotspot_x >> 4) + 19 * (hotspot_y >> 4)]);
				// Desactivamos el hotspot:
				hotspot_x = hotspot_y = 999;
				// Sumamos una pelotateni o una llave?
				if (hotspots [n_pant].tipo == 1) {
					player.objs ++;
					draw_objs ();	
					hotspots [n_pant].act = 0;
				} else if (hotspots [n_pant].tipo == 2) {
					player.keys ++;
					draw_keys ();
					hotspots [n_pant].act = 0;
				} 
				// PLOP!!
				peta_el_beeper (3);			
			}
			
			// Camiseta
			
			if (camiseta.n_pant == n_pant) {
				if (x >= camiseta.x - 12 && x <= camiseta.x + 12 && y >= camiseta.y - 12 && y <= camiseta.y + 12) {
					player.estado &= ~EST_NUDE;
					player.estado |= EST_PARP;
					player.ct_estado = 32;
					camiseta.n_pant = 99;
					borra_camiseta ();
					peta_el_beeper (3);
				}
			}
			
			// Comprobaciones
			if (player.y >= 9216) {
				if (player.life > 0) {
					player.estado = EST_IDLE;
					player.x = player.lastx;
					player.y = player.lasty;
					player.vx = player.vy = 0;
					if (n_pant != player.lastn_pant) {
						n_pant = player.lastn_pant;
						draw_scr ();	
					} else {
						player.ct_estado = 16;						// Tiempo de inmunidad.
					}
					peta_el_beeper (0);
					peta_el_beeper (2);
				}
			}
			
			if (player.x == 0 && (cpc_TestKey (KEY_IZQ) || cpc_TestKey (KEY_JOY_IZQ))) {
				n_pant --;
				draw_scr ();	
				player.x = 18432;
			}
			
			if (player.x == 18432 && (cpc_TestKey (KEY_DER) || cpc_TestKey (KEY_JOY_DER))) {		// 14336 = 224 * 64
				n_pant ++;
				
				// llegarse al final
				// consistir en salir por la derecha en la pantalla 39, of course.
				if (n_pant == 40) {
					// Final!
					cpc_WyzSetPlayerOff ();
					unpack ((unsigned int) (s_ending));
					set_inks (1);
					
					print_Text (80, 136, "YOU_MANAGED_TO_ESCAPE");
										
					// Un texto u otro dependiendo de las monedas
					/*if (player.coins == 320) {
						print_Text (44, 148, "WHOAH!_YOU_GOT_ALL_THE_COINS!");
					} else */if (player.coins > 255) {
						print_Text (56, 148, "AND_YOU_DID_IT_PRETTY_WELL");
					} else {
						print_Text (44, 148, "LEAVING_MOST_YER_MONEY_BEHIND");
					}
					
					cad_ending [10] = 48 + player.objs / 10;
					cad_ending [11] = 48 + player.objs % 10;
					/*
					cad_ending [20] = 48 + player.coins / 100;
					cad_ending [21] = 48 + (player.coins % 100) / 10;
					cad_ending [22] = 48 + player.coins % 10;
					*/
					print_Text (116, 160, cad_ending);
					
					espera_activa (9900);
					playing = 0;
				} else {
					draw_scr ();
					player.x = 0;
				}
			}
			
			x = (x >> 2) << 2;
			if (n_pant > 19) {
				if (player.vy < 0) {
					if ((y & 15) == 0 && (x & 15) == 0 && qtile (x >> 4, (y >> 4) - 1) == 30) {
						n_pant -= MAP_W;
						cpc_WyzSetPlayerOff ();
						draw_scr ();
						uncompress_and_play_me (1);
						player.y = 7168;
					}
				}
			} else {
				if (cpc_TestKey (KEY_ABA) || cpc_TestKey (KEY_JOY_ABA)) {
					if ((y & 15) == 0 && (x & 15) == 0 && qtile (x >> 4, (y >> 4) + 1) == 14) {
						n_pant += MAP_W;
						cpc_WyzSetPlayerOff ();
						draw_scr ();
						uncompress_and_play_me (2);
						player.y = 1024;
					}
				}
			}
			
			
			/*
			if (player.objs == PLAYER_NUM_OBJETOS) {
				
				cpc_WyzSetPlayerOff ();
				
				success = 0;
				if (n_pant == pant_final) {
					if ((player.x >> 10) == PLAYER_FIN_X && (player.y >> 10) == PLAYER_FIN_Y) 
						success = 1;
				} else if (pant_final == 99) {
					success = 1;
				}
				if (success) {
					cortina ();
					game_ending ();
					playing = 0;
					cortina ();
				}
			}
			*/
						
			// game over
			
			if (player.life == 0) {			
				cpc_WyzSetPlayerOff ();
				print_Text (124, 96, "GAME_OVER");
				espera_activa (500);
				playing = 0;
			}
		}	
	}
}
