// Motor.h
// Contiene las cosas del motor para la churrera, a saber:

// 1.- Inicializaciones (de enemigos y de cosas varias).
// 2.- Movimiento del prota.
// 3.- Movimiento de los enemigos/plataformas moviles.
// 4.- Dibujado de la pantalla (depacking/render).

#define EST_NORMAL 		0
#define EST_NUDE		1
#define EST_PARP 		2
#define EST_MUR 		4
#define EST_IDLE 		8
#define sgni(n)			(n < 0 ? -1 : 1)
#define abs(n)			(n < 0 ? -n : n)
#define mksgn(s,n)		(s < 0 ? -n : n)

typedef struct {
	signed int x, y, cx;
	signed int vx, vy;
	signed char g, ax, rx;
	unsigned char salto, cont_salto;
	unsigned char *next_frame;
	unsigned char saltando;
	unsigned char frame, subframe, facing;
	unsigned char estado;
	unsigned char ct_estado;
	unsigned char gotten;
	unsigned char life, objs, keys;
	signed int lastx, lasty;
	unsigned char lastn_pant;
	unsigned int coins;
} INERCIA;

INERCIA player;
unsigned char *anim_frames_uwol [] = {spr_4, spr_3, spr_4, spr_5, spr_1, spr_0, spr_1, spr_2};

typedef struct {
	unsigned char *next_frame;
} ANIMADO;

ANIMADO en_an [3];

typedef struct {
	signed int x, y; 
	unsigned char n_pant, ct;
} OBJECTUELO;

OBJECTUELO camiseta;

unsigned char cur_scr_coins [16];

// atributos de la pantalla: Contiene informacin
// sobre qu tipo de tile hay en cada casilla
unsigned char map_attr [190];
unsigned char map_buff [190];

// posicin del objeto (hotspot). Para no objeto,
// se colocan a 240,240, que est siempre fuera de pantalla.
signed int hotspot_x;
signed int hotspot_y;

unsigned char pant_final;

unsigned char n_pant;

// Funciones:

// Especial para CPC para poner textos

void print_Text (unsigned char x, unsigned char y, unsigned char *texto) {
	x = x >> 2;
	while ( (*texto) != 0 ) {
		cpc_PutTile2x8 ((unsigned int *) (tile_0 + (((*texto) - 32) << 4)), (unsigned char *) x, (unsigned char *) y);
		x += 2;
		texto ++;	
	}
}

void srand (unsigned int new_seed) {
	seed [0] = new_seed;	
}

unsigned char rand () {
	unsigned char res;
	
	#asm
		.rand16
			ld	hl, _seed
			ld	a, (hl)
			ld	e, a
			inc	hl
			ld	a, (hl)
			ld	d, a
			
			;; Ahora DE = [SEED]
						
			ld	a,	d
			ld	h,	e
			ld	l,	253
			or	a
			sbc	hl,	de
			sbc	a, 	0
			sbc	hl,	de
			ld	d, 	0
			sbc	a, 	d
			ld	e,	a
			sbc	hl,	de
			jr	nc,	nextrand
			inc	hl
		.nextrand
			ld	d,	h
			ld	e,	l
			ld	hl, _seed
			ld	a,	e
			ld	(hl), a
			inc	hl
			ld	a,	d
			ld	(hl), a
			
			;; Ahora [SEED] = HL
		
			ld 	hl, _asm_int
			ld	a,	e	
			ld	(hl), a
			inc	hl
			ld	a,	d
			ld	(hl), a
			
			;; Ahora [ASM_INT] = HL
	#endasm
	
	res = asm_int [0];

	return res;
}

// Game

void espera_activa (int espera) {
	
	// jL
	
	// Esta funcin espera un rato o hasta que se pulse una tecla.
	// Si se pulsa una tecla, devuelve 0
	
	// Esta funcin slo funciona en Spectrum.
	// en CPC no hay una interrupcin cada 20ms, asn que esto no
	// sirve "pa n".
	
	unsigned int i;
	
	for (i = 0; i < espera; i ++) {
		#asm
			halt
		#endasm
		if (cpc_AnyKeyPressed ()) 
			break;	
	}
}

void attr (char x, char y) {
	// x + 19 * y = x + (16 + 2 + 1) * y = x + 16 * y + 2 * y + y = x + (y << 4) + (y << 1) + y
	if (x < 0 || y < 0) return 8;
	return map_attr [x + (y << 4) + (y << 1) + y];	
}

void qtile (unsigned char x, unsigned char y) {
	// x + 19 * y = x + (16 + 2 + 1) * y = x + 16 * y + 2 * y + y = x + (y << 4) + (y << 1) + y
	return map_buff [x + (y << 4) + (y << 1) + y];	
}

void draw_n (unsigned char x, unsigned char y, int n) {
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + n / 100) << 4)), (unsigned char *) (x + x), (unsigned char *) (y << 3));
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + (n % 100) / 10) << 4)), (unsigned char *) (x + x + 2), (unsigned char *) (y << 3));
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + n % 10) << 4)), (unsigned char *) (x + x + 4), (unsigned char *) (y << 3));
}

void draw_life () {
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + player.life % 10) << 4)), (unsigned char *) ((LIFE_X << 1)), (unsigned char *) ((LIFE_Y << 3)));
}

void draw_objs () {
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + player.objs / 10) << 4)), (unsigned char *) ((OBJECTS_X << 1)), (unsigned char *) ((OBJECTS_Y << 3)));
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + player.objs % 10) << 4)), (unsigned char *) ((OBJECTS_X << 1) + 2), (unsigned char *) ((OBJECTS_Y << 3)));
}

void draw_keys () {
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + player.keys / 10) << 4)), (unsigned char *) ((KEYS_X << 1)), (unsigned char *) ((KEYS_Y << 3)));
	cpc_PutTile2x8 ((unsigned int *) (tile_0 + ((16 + player.keys % 10) << 4)), (unsigned char *) ((KEYS_X << 1) + 2), (unsigned char *) ((KEYS_Y << 3)));
}

void draw_coloured_tile (unsigned char x, unsigned char y, unsigned char t) {
	t = 64 + (t << 2);
	cpc_SetTile (x, y, t);
	cpc_SetTile (x + 1, y, t + 1);
	cpc_SetTile (x, y + 1, t + 2);
	cpc_SetTile (x + 1, y + 1, t + 3);
}

void draw_coloured_tile_shadow (unsigned char x, unsigned char y, unsigned char t) {
	unsigned char xx, yy;
	unsigned char atr;
	
	atr = comportamiento_tiles [t];
	xx = (unsigned char) (x >> 1);
	yy = (unsigned char) (y >> 1);
	t = 64 + (t << 2);
	cpc_SetTile (x, y, atr == 0 && attr (xx - 1, yy - 1) == 8 ? 0 : t);
	cpc_SetTile (x + 1, y, atr == 0 && attr (xx, yy - 1) == 8 ? 0 : t + 1);
	cpc_SetTile (x, y + 1, atr == 0 && attr (xx - 1, yy) == 8 ? 0 : t + 2);
	cpc_SetTile (x + 1, y + 1, t + 3);	
}

void draw_coloured_tile_inv (unsigned char x, unsigned char y, unsigned char t) {
	
	t = 64 + (t << 2);
	cpc_SetTouchTileXY (x, y, t);
	cpc_SetTouchTileXY (x + 1, y, t + 1);
	cpc_SetTouchTileXY (x, y + 1, t + 2);
	cpc_SetTouchTileXY (x + 1, y + 1, t + 3);
}

void clear_cerrojo (unsigned char np, unsigned char x, unsigned char y) {
	unsigned char i;
	
	// search & toggle
		
	for (i = 0; i < MAX_CERROJOS; i ++) 
		if (cerrojos [i].x == x && cerrojos [i].y == y && cerrojos [i].np == np)
			cerrojos [i].st = 0;
}

void init_cerrojos () {
	unsigned char i;
	
	// Activa todos los cerrojos
	
	for (i = 0; i < MAX_CERROJOS; i ++)
		cerrojos [i].st = 1;	
}

void borra_camiseta () {
	draw_coloured_tile_inv (camiseta.x >> 3, camiseta.y >> 3,  map_buff [(camiseta.x >> 4) + 19 * (camiseta.y >> 4)]);
	camiseta.n_pant = 99;
}

void matar_uwol (unsigned char rebote) {
	if (player.life > 0) {
		if (player.estado & EST_NUDE) {
			player.life --;	
			draw_life ();
			player.estado = EST_MUR;
			player.vy = -PLAYER_MAX_VY_SALTANDO;
			borra_camiseta ();
		} else {
			player.estado = EST_NUDE;
			do {
				camiseta.x = (rand () % 19) << 4;
				camiseta.y = (rand () % 10) << 4;
				camiseta.ct = 128;
				camiseta.n_pant = n_pant;
			} while (attr (camiseta.x >> 4, camiseta.y >> 4) == 8 );
			draw_coloured_tile_inv (camiseta.x >> 3, camiseta.y >> 3, 35);
		}
		player.estado |= EST_PARP;
		player.ct_estado = 32;
		peta_el_beeper (1);

		// El jugador "rebota" una poca.

		player.vy = - 4 * (player.salto);
		if (rebote == 0) 
			player.vx = ((player.x >> 6) - malotes [enoffsmasi].x) * 16;
	}
}

unsigned char move () {
	unsigned char xx, yy;
	unsigned int x, y;				// Cambio 304 pxels (TM)
	unsigned char i, allpurp;
	unsigned int idx;
	unsigned char d;
	signed int xM, yM;
	unsigned int coin_descriptor;
	
	/* Por partes. Primero el movimiento vertical. La ecuacin de movimien-
	   to viene a ser, en cada ciclo:

	   1.- vy = vy + g
	   2.- y = y + vy

	   O sea la velocidad afectada por la gravedad. 
	   Para no colarnos con los nmeros, ponemos limitadores:
	*/

	if (player.vy < PLAYER_MAX_VY_CAYENDO)
		player.vy += player.g;
	else
		player.vy = PLAYER_MAX_VY_CAYENDO;

	if (player.gotten) player.vy = 0;
		
	player.y += player.vy;
	
	// Safe
		
	if (player.y < 0)
		player.y = 0;
		
	if (player.y > 9216)
		player.y = 9216;
	
	/* El problema es que no es tan fcil... Hay que ver si no nos chocamos.
	   Si esto pasa, hay que "recular" hasta el borde del obstculo.

	   Por eso miramos el signo de vy, para que los clculos sean ms sencillos.
	   De paso vamos a precalcular un par de cosas para que esto vaya ms rpido.
	*/

	// dividimos entre 64 para pixels, y luego entre 16 para tiles.
	
	x = player.x >> 6;
	y = player.y >> 6;
	xx = (unsigned char) (x >> 4);
	yy = (unsigned char) (y >> 4);
	
	// Moneas (slo si n_pant > 19)
	
	if (n_pant > 19) {
		if (attr (xx, yy) == 2 || 
			((x & 15) != 0 && attr (xx + 1, yy) == 2) ||
			((y & 15) != 0 && attr (xx, yy + 1) == 2) ||
			((x & 15) != 0 && (y & 15) != 0 && attr (xx + 1, yy + 1) == 2)) {
	
			allpurp = n_pant - 20;
			idx = (allpurp << 4) + (allpurp << 1);		// allpurp * 18 = allpurp * 16 + allpurp * 2.
			coin_descriptor = (moneas [idx] << 8) + moneas [idx + 1];
			for (i = 0; i < 16; i ++) {
				if (! (coin_descriptor & (1 << i))) {
					d = cur_scr_coins [i];
					if (d != 255) {
						xM = (d / 10) << 4;
						yM = (d % 10) << 4;
						if (x >= xM - 15 && x <= xM + 15 && y >= yM - 15 && y <= yM + 15) {
							xM = xM >> 4;
							yM = yM >> 4;						
							map_attr [xM + (yM << 4) + (yM << 1) + yM] = comportamiento_tiles [map_buff [xM + (yM << 4) + (yM << 1) + yM]];
							draw_coloured_tile_inv (xM + xM, yM + yM, map_buff [xM + (yM << 4) + (yM << 1) + yM]);
							peta_el_beeper (5);
							player.coins ++;
							draw_n (16, 23, player.coins);
							coin_descriptor = coin_descriptor | (1 << i);
							moneas [idx] = (coin_descriptor >> 8);
							moneas [idx + 1] = (coin_descriptor & 255);
							break;
						}
					}
				}
			}
		}	
	}
	
	// Ya	

	if (player.vy < 0) { 			// estamos ascendiendo
		//if (player.y >= 1024)
			if (attr (xx, yy) > 7 || ((x & 15) != 0 && attr (xx + 1, yy) > 7)) {
				// paramos y ajustamos:
				player.vy = 0;
				player.y = (yy + 1) << 10;
			}
	} else if (player.vy > 0) { 	// estamos descendiendo
		if (player.y < 9216)
			if (attr (xx, yy + 1) > 3 || ((x & 15) != 0 && attr (xx + 1, yy + 1) > 3))
			{
				// paramos y ajustamos:
				player.vy = 0;
				player.y = yy << 10;
			}
	}

	// Update
	
	y = player.y >> 6;
	yy = (unsigned char) (y >> 4);
	
	// Parntesis, aprovechando las variables para ahorrar... 
	// Tiles que te matan. 
	// Joer, qu ofuscao... Pero es corto y bello.
	
	if (attr (xx, yy) == 1 || 
		((x & 15) != 0 && attr (xx + 1, yy) == 1) ||
		((y & 15) != 0 && attr (xx, yy + 1) == 1) ||
		((x & 15) != 0 && (y & 15) != 0 && attr (xx + 1, yy + 1) == 1)) {

		// Muerte directa en los pinchos:
		if (player.estado < EST_PARP) {
			player.estado |= EST_NUDE;
			matar_uwol (1);
		} else {
			player.vy = - 4 * (player.salto);
		}
	}
	
	/* Salto: El salto se reduce a dar un valor negativo a vy. Esta es la forma ms
	   sencilla. Sin embargo, para ms control, usamos el tipo de salto "mario bros".
	   Para ello, en cada pulsacin dejaremos decrementar vy hasta un mnimo, y de-
	   tectando que no se vuelva a pulsar cuando estemos en el aire. Juego de banderas ;)
	*/

	if ( (cpc_TestKey (KEY_ARR) || cpc_TestKey (KEY_FIR) || cpc_TestKey (KEY_JOY_ARR) || cpc_TestKey (KEY_JOY_FIR)) && ((player.vy == 0 && player.saltando == 0 && (attr (xx, yy + 1) > 3 || ((x & 15) != 0 && attr (xx + 1, yy + 1) > 3))) || player.gotten)) {
		player.saltando = 1;
		player.cont_salto = 0;
		peta_el_beeper (7);
		// CPC: Ajusto a mltiplo de 4 pxels
		player.x = (player.x >> 8) << 8;
		// Ajuste bestia de cojones, 6+2.

		// Para restaurar tras la muerte, guardamos la posicin del ltimo salto.
		// Una plataforma no cuenta como "posicin segura".		
		if (!player.gotten) {
			player.lastx = player.x;
			player.lasty = player.y;
			player.lastn_pant = n_pant;
		}
	}

	if ( (cpc_TestKey (KEY_ARR) || cpc_TestKey (KEY_FIR) || cpc_TestKey (KEY_JOY_ARR) || cpc_TestKey (KEY_JOY_FIR)) && player.saltando ) {
		player.vy -= (player.salto + PLAYER_INCR_SALTO - (player.cont_salto>>1));
		if (player.vy < -PLAYER_MAX_VY_SALTANDO) player.vy = -PLAYER_MAX_VY_SALTANDO;
		player.cont_salto ++;
		if (player.cont_salto == 8)
			player.saltando = 0;
	}

	if ( !cpc_TestKey (KEY_ARR) && !cpc_TestKey (KEY_FIR) && !cpc_TestKey (KEY_JOY_ARR) && !cpc_TestKey (KEY_JOY_FIR) )
		player.saltando = 0;
	
	// ------ ok con el movimiento vertical.

	/* Movimiento horizontal:

	   Mientras se pulse una tecla de direccin, 
	   
	   x = x + vx
	   vx = vx + ax

	   Si no se pulsa nada:

	   x = x + vx
	   vx = vx - rx
	*/

	if ( ! (cpc_TestKey (KEY_IZQ) || cpc_TestKey (KEY_DER) || cpc_TestKey (KEY_JOY_IZQ) || cpc_TestKey (KEY_JOY_DER)))
		if (player.vx > 0) {
			player.vx -= player.rx;
			if (player.vx < 0)
				player.vx = 0;
		} else if (player.vx < 0) {
			player.vx += player.rx;
			if (player.vx > 0)
				player.vx = 0;
		}

	if (cpc_TestKey (KEY_IZQ) || cpc_TestKey (KEY_JOY_IZQ))
		if (player.vx > -PLAYER_MAX_VX) {
			player.facing = 0;
			player.vx -= player.ax;
		}

	if (cpc_TestKey (KEY_DER) || cpc_TestKey (KEY_JOY_DER))
		if (player.vx < PLAYER_MAX_VX) {
			player.vx += player.ax;
			player.facing = 4;
		}

	player.x = player.x + player.vx;
	
	// Safe
	
	if (player.x < 0)
		player.x = 0;
		
	if (player.x > 18432)
		player.x = 18432;
		
	/* Ahora, como antes, vemos si nos chocamos con algo, y en ese caso
	   paramos y reculamos */

	x = player.x >> 6;
	y = player.y >> 6;
	xx = (unsigned char) (x >> 4);
	yy = (unsigned char) (y >> 4);
	
	if (player.vx < 0) {
		if (attr (xx, yy) > 7 || ((y & 15) != 0 && attr (xx, yy + 1) > 7)) {
			// paramos y ajustamos:
			player.vx = 0;
			player.x = (xx + 1) << 10;
		}
	} else if (player.vx > 0) {
		if (attr (xx + 1, yy) > 7 || ((y & 15) != 0 && attr (xx + 1, yy + 1) > 7)) {
			// paramos y ajustamos:
			player.vx = 0;
			player.x = xx << 10;
		}
	} else if (!player.gotten) {
		// CPC: Ajusto a mltiplo de 4 pxels
		player.x = (player.x >> 8) << 8;
		// Ajuste bestia de cojones, 6+2.	
	}

	// Abrir cerrojo
	if ((x & 15) == 0 && (y & 15) == 0) {
		if (qtile (xx + 1, yy) == 15 && player.keys > 0) {
			map_attr [19 * yy + xx + 1] = 0;
			map_buff [19 * yy + xx + 1] = 0;
			clear_cerrojo (n_pant, xx + 1, yy);
			draw_coloured_tile_inv (xx + xx + 2, yy + yy, 0);
			player.keys --;
			draw_keys ();
			peta_el_beeper (3);
		} else if (qtile (xx - 1, yy) == 15 && player.keys > 0) {
			map_attr [19 * yy + xx - 1] = 0;
			map_buff [19 * yy + xx - 1] = 0;
			clear_cerrojo (n_pant, xx - 1, yy);
			draw_coloured_tile_inv (xx + xx - 2, yy + yy, 0);
			player.keys --;
			draw_keys ();
			peta_el_beeper (3);
		}
	}
	
	// Calculamos el frame que hay que poner:
 
	if (player.vy != 0) {
		player.next_frame = anim_frames_uwol [3 + player.facing];
	} else {
		if (player.vx == 0) {
			player.next_frame = anim_frames_uwol [player.facing];
		} else {
			player.subframe ++;
			
			if (player.subframe == 4) {
				player.subframe = 0;
				player.frame = (player.frame + 1) & 3;
				//step ();
			}
			player.next_frame = anim_frames_uwol [player.facing + player.frame];
		}	
	}
	
	if (player.estado & EST_NUDE) {
		player.next_frame += 780; 		// Advance 780 bytes (6 sprite data packs)	
	}
}

void init_player () {
	// Inicializa player con los valores iniciales
	// (de ah lo de inicializar).
	
	player.x = 			PLAYER_INI_X << 10;
	player.y = 			PLAYER_INI_Y << 10;
	player.lastx = 		PLAYER_INI_X << 10;
	player.lasty = 		PLAYER_INI_Y << 10;
	player.vy = 		0;
	player.g = 			PLAYER_G; 
	player.vx = 		0;
	player.ax = 		PLAYER_AX;
	player.rx = 		PLAYER_RX;
	player.salto = 		PLAYER_VY_INICIAL_SALTO;
	player.cont_salto = 1;
	player.saltando = 	0;
	player.frame = 		0;
	player.subframe = 	0;
	player.facing = 	4;
	player.estado = 	EST_NORMAL;
	player.life = 		PLAYER_LIFE;
	player.objs =		0;
	player.keys = 		0;
	player.coins = 		0;
	
	pant_final = SCR_FIN;
}

void init_hotspots () {
	unsigned char i;
	for (i = 0; i < MAP_W * MAP_H; i ++)
		hotspots [i].act = 1;
}

void procesa_tile (unsigned char x, unsigned char y,unsigned char location, unsigned char t) {
	map_attr [location] = comportamiento_tiles [t];
	if ((rand () & 15) < 2 && map_buff [location - 16] == 0) {
		if (t == 0) t = 37;
		if (t == 16) t = 38;
	}

	if (n_pant < 20) {		
		draw_coloured_tile_shadow (x, y, t);
	} else {
		draw_coloured_tile (x, y, t);	
	}
		
	map_buff [location] = t;
}

void draw_scr () {
	// Desempaqueta y dibuja una pantalla, actualiza el array map_attr
	// y hace algunas otras cosillas ms (cambiar sprites de enemigos/plataformas, etc)
	
	unsigned char x = 0, y = 0;
	unsigned char i, d, t1, t2;
	unsigned int idx = n_pant * 95;
	unsigned char location = 0;
	unsigned int coin_descriptor;
	
	#asm
		ld bc, $7fc1
		out (c),c 
	#endasm
	
	// Aqu ira la copia de la pgina 7 al buffer...
	
	#asm
		ld bc, $7fc0
		out (c),c 
	#endasm
	
	for (i = 0; i < 95; i ++) {
		d = mapa [idx++];
		t1 = d >> 4;
		t2 = d & 15;
		
		if (n_pant > 19) {
			t1 = t1 + 16;
			t2 = t2 + 16;
		}
		
		procesa_tile (x, y, location, t1);
		x += 2;
		if (x == 38) {
			x = 0;
			y += 2;
		}	
		location ++;
		
		procesa_tile (x, y, location, t2);
		x += 2;
		if (x == 38) {
			x = 0;
			y += 2;
		}	
		location ++;
	}
	
	// Hay objeto en esta pantalla?
	
	hotspot_x = hotspot_y = 9999;
	if (hotspots [n_pant].act == 1) {
		if (hotspots [n_pant].tipo != 0) {
			// Convertimos la posicin almacenada en pxels
			hotspot_x = (hotspots [n_pant].xy / 10) << 4;
			hotspot_y = (hotspots [n_pant].xy % 10) << 4;
			// Pintamos el incono del objeto
			draw_coloured_tile (hotspot_x >> 3, hotspot_y >> 3, 32 + hotspots [n_pant].tipo);
		}
	}
	
	// Pintamos las monedas, si aplica
	if (n_pant > 19) {
		idx = 18 * (n_pant - 20);
		coin_descriptor = (moneas [idx] << 8) + moneas [idx + 1];
		idx += 2;
		for (i = 0; i < 16; i ++) {
			cur_scr_coins [i] = moneas [idx];
			if (! (coin_descriptor & (1 << i))) {
				d = moneas [idx];
				if (d != 255) {
					x = d / 10;
					y = d % 10;
					map_attr [x + (y << 4) + (y << 1) + y] = 2;
					draw_coloured_tile (x + x, y + y, 32);
				}
			}
			idx ++;
		}
	}

	// Hay una camiseta activa en esta pantalla?
	if (camiseta.n_pant == n_pant) {
		draw_coloured_tile (camiseta.x >> 3, camiseta.y >> 3, 35);
	}
		
	// Borramos los cerrojos abiertos
	
	for (i = 0; i < MAX_CERROJOS; i ++) {
		if (cerrojos [i].np == n_pant && !cerrojos [i].st) {
			draw_coloured_tile (cerrojos [i].x + cerrojos [i].x, cerrojos [i].y + cerrojos [i].y, 0);
			location = 19 * cerrojos [i].y + cerrojos [i].x;
			map_attr [location] = 0;
			map_buff [location] = 0;
		}
	}
	
	// Movemos y cambiamos a los enemigos segn el tipo que tengan
	enoffs = n_pant * 3;
	
	for (i = 0; i < 3; i ++) {
		switch (malotes [enoffs + i].t) {
			case 1:
				en_an [i].next_frame = spr_13;
				break;
			case 2:
				en_an [i].next_frame = spr_14;
				break;
			case 3:
				en_an [i].next_frame = spr_15;
				break;
			case 4:
				en_an [i].next_frame = spr_17;
				break;
			case 5:
				malotes [enoffs + i].x1 = malotes [enoffs + i].x2 << 6;
				malotes [enoffs + i].y1 = malotes [enoffs + i].y2 << 6;
				en_an [i].next_frame = spr_16;
		}
	}

	cpc_ResetTouchedTiles ();	
	cpc_ShowTileMap (0);
	if (n_pant < 10)
		set_inks (1);
	else if (n_pant < 20)
		set_inks (2);
	else
		set_inks (0);

}

void mueve_bicharracos () {
	// Vamos a mover un frame todos los bicharracos activos.
	
	unsigned char i, xx, yy;
	unsigned int x, y;
	
	player.gotten = 0;
	
	for (i = 0; i < 3; i ++) {
		enoffsmasi = enoffs + i;
		if (malotes [enoffsmasi].t != 0) {
			
			if (malotes [enoffsmasi].t != 5) {
				// Franky, Vampy, Wolfy, plataforma
				malotes [enoffsmasi].x += malotes [enoffsmasi].mx;
				malotes [enoffsmasi].y += malotes [enoffsmasi].my;

				// Lmites de trayectoria.
			
				if (malotes [enoffsmasi].x == malotes [enoffsmasi].x1 || malotes [enoffsmasi].x == malotes [enoffsmasi].x2)
					malotes [enoffsmasi].mx = -malotes [enoffsmasi].mx;
				if (malotes [enoffsmasi].y == malotes [enoffsmasi].y1 || malotes [enoffsmasi].y == malotes [enoffsmasi].y2)
					malotes [enoffsmasi].my = -malotes [enoffsmasi].my;
			} else {
				// Fanty!!
				/*	Para reaprovechar todo lo posible y compatibilizar todo lo posible,
					fanty funciona as:
					
					Sus coordenadas "reales" son .x1 y .y1 (pivote 1). Estas contienen
					valores con precisin 1/64 de pxel, como Uwol. En cada frame, se
					copian a .x y .y dividiendo entre 64 ( >> 6 ) para que funcionen en
					el render y en las detecciones de colisin.
					
					Dirty yet clever - uh?
				*/
				if (malotes[enoffsmasi].mx < 120 && player.x > malotes[enoffsmasi].x1)
					malotes[enoffsmasi].mx += FANTY_A;
				else if (malotes[enoffsmasi].mx > -120 && player.x < malotes[enoffsmasi].x1)
					malotes[enoffsmasi].mx -= FANTY_A;
				
				if (malotes[enoffsmasi].my < 120 && player.y > malotes[enoffsmasi].y1)
					malotes[enoffsmasi].my += FANTY_A;
				else if (malotes[enoffsmasi].my > -120 && player.y < malotes[enoffsmasi].y1)
					malotes[enoffsmasi].my -= FANTY_A;

				malotes [enoffsmasi].x1 += malotes [enoffsmasi].mx;
				malotes [enoffsmasi].y1 += malotes [enoffsmasi].my;
				
				if (malotes [enoffsmasi].x1 < 0) malotes [enoffsmasi].x1 = 0;
				if (malotes [enoffsmasi].y1 < 0) malotes [enoffsmasi].y1 = 0;
				if (malotes [enoffsmasi].x1 > 18432) malotes [enoffsmasi].x1 = 18432;
				if (malotes [enoffsmasi].y1 > 9216) malotes [enoffsmasi].y1 = 9216;
				
				malotes [enoffsmasi].x = malotes [enoffsmasi].x1 >> 6;
				malotes [enoffsmasi].y = malotes [enoffsmasi].y1 >> 6;
			}
			
			if (player.estado < EST_PARP) {	
				// Arrastrar plataforma:
				x = player.x >> 6;
				y = player.y >> 6;
				if (malotes [enoffsmasi].t == 4) {
					xx = player.x >> 10;
					// Vertical
					if (malotes [enoffsmasi].my < 0) {
						// Subir.
						if (x >= malotes [enoffsmasi].x - 15 && x <= malotes [enoffsmasi].x + 15 && y >= malotes [enoffsmasi].y - 16 && y <= malotes [enoffsmasi].y - 11 && player.vy >= -(PLAYER_INCR_SALTO)) {
							player.gotten = 1;
							player.y = (malotes [enoffsmasi].y - 16) << 6;
							player.vy = 0;						
							yy = player.y >> 10;
							// No nos estaremos metiendo en un tile no?
							if (player.y > 1024)
								if (attr (xx, yy) > 1 || ((x & 15) != 0 && attr (xx + 1, yy) > 1)) {
									// ajustamos:
									player.y = (yy + 1) << 10;
								}
						}
					} else if (malotes [enoffsmasi].my > 0) {
						// bajar
						if (x >= malotes [enoffsmasi].x - 15 && x <= malotes [enoffsmasi].x + 15 && y >= malotes [enoffsmasi].y - 20 && y <= malotes [enoffsmasi].y - 14 && player.vy >= 0) {
							player.gotten = 1;
							player.y = (malotes [enoffsmasi].y - 16) << 6;
							player.vy = 0;
							yy = player.y >> 10;
							// No nos estaremos metiendo en un tile no?
							if (player.y < 9216)
								if (attr (xx, yy + 1) > 1 || ((x & 15) != 0 && attr (xx + 1, yy + 1) > 1)) {
									// ajustamos:
									player.y = yy << 10;
								}
						}
					}
					y = player.y >> 6;
					yy = player.y >> 10;
					// Horizontal
					if (malotes [enoffsmasi].mx != 0 && x >= malotes [enoffsmasi].x - 15 && x <= malotes [enoffsmasi].x + 15 && y >= malotes [enoffsmasi].y - 16 && y <= malotes [enoffsmasi].y - 11 && player.vy >= 0) {
						player.gotten = 1;
						player.y = (malotes [enoffsmasi].y - 16) << 6;
						yy = player.y >> 10;
						x = x + malotes [enoffsmasi].mx;
						player.x = x << 6;
						xx = player.x >> 10;
						if (malotes [enoffsmasi].mx < 0) {
							if (attr (xx, yy) > 1 || ((y & 15) != 0 && attr (xx, yy + 1) > 1)) {
								// paramos y ajustamos:
								player.vx = 0;
								player.x = (xx + 1) << 10;
							}
						} else if (malotes [enoffsmasi].mx > 0) {
							if (attr (xx + 1, yy) > 1 || ((y & 15) != 0 && attr (xx + 1, yy + 1) > 1)) {
								// paramos y ajustamos:
								player.vx = 0;
								player.x = xx << 10;
							}
						}					
					}
				// Colisin matadora
				} else if (malotes [enoffsmasi].x >= x - 13 && malotes [enoffsmasi].x <= x + 13 && malotes [enoffsmasi].y >= y - 12 && malotes [enoffsmasi].y <= y + 12) {
					matar_uwol (0);
				}
			}
		}
	}
}

void death_sequence () {
	player.next_frame = spr_12;
	
	if (player.vy < 1024)
		player.vy += player.g;
	else
		player.vy = 1024;

	player.y += player.vy;
	if (player.y < 0) player.y = 0;
}
