// Msica y sonidos para Phantomas Tales #1: Marsport.
// ===================================================

extern unsigned char wyz_sound_table [];
extern unsigned char wyz_pattern_table [];
extern unsigned char wyz_effects_table [];
extern unsigned char wyz_song_table [];
extern unsigned char song_0[];
extern unsigned char song_1[];
extern unsigned char song_2[];
extern unsigned char song_3[];
extern unsigned char song_4[];

// REMEMBER: Las canciones ms largas deben descomprimirse previamente
// sobre el buffer de tiles (en $100) - (ver wyz_song_table).

#asm
	._wyz_sound_table
				defw 	_sound1, _sound2, _sound3
		
	._wyz_pattern_table
				defw	_pattern1, _pattern2, _pattern3, _pattern4, _pattern5, _pattern6
	
	._wyz_effects_table
				defw	_effect0, _effect1, _effect2, _effect3, _effect4, _effect5, _effect6, _effect7, _effect8
	
	._wyz_song_table
				defw 	$100, _song_1, $100, _song_3, $100, _test_song

; ***********************************************
;	Datos (sonidos, patrones, efectos y msicas)
; ***********************************************

; Sonidos:
	._sound1	defb	0,60,10,0,87,0,255
	._sound2	defb	162,47,0,93,21,0,255
	._sound3	defb	0,14,12,255
	
; Patrones (o pautas):
	._pattern1	defb	13,44,75,8,9,10,9,132
	._pattern2	defb	40,73,9,9,40,8,8,7,130
	._pattern3	defb	43,9,7,8,8,129
	._pattern4	defb	7,8,7,5,129
	._pattern5	defb	18,45,75,8,9,10,9,132
	._pattern6	defb	19,45,75,8,9,10,9,132
	
; Efectos de sonido:

	; [0] Cada del salto
	._effect0	defb 	$51,$1A
				defb 	$E8,$1B
				defb 	$80,$2B
				defb 	$FF   
				
	; [1] Quitar vida
	._effect1	defb 	$25,$1C
				defb 	$30,$2E
				defb	$00,$00
				defb	$A8,$0A
				defb	$C5,$1A
				defb	$00,$00
				defb	$37,$1C
				defb	$C5,$1C
				defb	$00,$00
				defb	$25,$18
				defb	$30,$26
				defb	$FF
				
	; [2] Arrastrar en cinta
	._effect2	defb	80h,2Eh,00h
				defb	00h,0Ah,04h
				defb	FFh	
				
	; [3] Coger tesoro
	._effect3	defb	$1F,$0B
				defb	$1A,$0C
				defb	$1F,$0D
				defb	$16,$0E
				defb	$1F,$0E
				defb	$0D,$0D
				defb	$1F,$0C
				defb	$0D,$0B
				defb	$00,$00
				defb	$00,$00
				defb	$1F,$08
				defb	$1A,$09
				defb	$1F,$0A
				defb	$16,$0B
				defb	$1F,$0B
				defb	$0D,$0A
				defb	$1F,$09
				defb	$0D,$07
				defb	$00,$00
				defb	$00,$00
				defb	$1F,$06
				defb	$1A,$07
				defb	$1F,$08
				defb	$16,$08
				defb	$1F,$07
				defb	$0D,$06
				defb	$1F,$05
				defb	$FF
	
	; [4] ?
	._effect4	defb	00h,0Ch,03h
				defb	FFh	
				
	; [5] Coger vida
	._effect5	defb	$1A,$0E
				defb	$1A,$0E
				defb	$00,$00
				defb	$1A,$0A
				defb	$1A,$0A
				defb	$00,$00
				defb	$1A,$0C
				defb	$1A,$0C
				defb	$00,$00
				defb	$1A,$08
				defb	$1A,$08
				defb	$FF
				
	; [6] ?
	._effect6	defb	00h,2Ch,00h
				defb	00h,0Ah,04h
				defb	FFh	
				
	; [7] Salto largo
	._effect7	defb	$C3,$0E
				defb	$CC,$0D
				defb	$D5,$0A
				defb	$DE,$06
				defb	$35,$03
				defb	$50,$0B
				defb	$47,$0C
				defb	$3E,$08
				defb	$FF
				
	; [8] Salto alto
	._effect8	defb	$58,$0D
				defb	$50,$0B
				defb	$47,$0A
				defb	$3E,$06
				defb	$35,$03
				defb	$50,$09
				defb	$47,$0A
				defb	$3E,$07
				defb	$FF	
	
; Msicas:

	; [0] Astro Ganga (pantalla de ttulo)
	._song_0
				BINARY "ganga.exo"
	
	; [1] Astro Ganga Intro (Douko Kadeeee)
	._song_1
				BINARY "ganga_intro.mus"
	
	; [2] Ingame: Moonlite Aliens
	._song_2
				BINARY "moonlite.exo"
	
	; [3] Game Over
	._song_3
				BINARY "ganga_gameover.mus"
	
	; [4] Ending: The Duck and the Moon
	._song_4
				;BINARY "quezesto.exo"
	
	; [5] Test song: Para probar los canales y qu se come la batera y los efectos
	._test_song
				;BINARY "test-channels.mus"
	
#endasm

/* 
"I fought the law"

Breakin rocks in the hot sun
I fought the law and the law won (twice)
I needed money cause I had none
I fought the law and the law won (twice)

I left my baby and it feels so bad
Guess my race is run
Shes the best girl that I ever had
I fought the law and the law won
I fought the law and the

Robbin people with a six-gun
I fought the law and the law won (twice)
I lost my girl and I lost my fun
I fought the law and the law won (twice)

I left my baby and it feels so bad
Guess my race is run
Shes the best girl that I ever had
I fought the law and the law won
I fought the law and the

I fought the law and the law won (7 times)
I fought the law and the ...
*/
