// ************************************
// Phantomas Tales 1: marsport para CPC
// ************************************

// Mi primer juego para CPC, a ver qu tal sale. Emplea esto, del maestro Artaburu:

#include "cpcrslib.h"

// Y esto, del maestro WYZ:

#include "cpcwyzlib.h"

// Para compilar esto hay que meter el archivo TileMapConf.asm en el linkado. Esto es sencillo
// si empleamos en condiciones el zcc:

// zcc +cpc TileMapConf.asm -create-app -make-app -O3 -unsigned -o marscpc.bin marscpc.c -lcpcrslib lcpcwyzlib -zorg=8900

// *******************************************************************************************************************

// Definiciones constantes

#define KEY_IZQ 0
#define KEY_DER 1
#define KEY_SAL 2
#define KEY_SLA 3

#define WYZ_CANAL_EFECTOS 2						// 0 = A, 1 = B, 2 = C

// Definiciones extern:

extern unsigned char bloques [];				// Mapeado supertiles->tiles
extern unsigned char paleta1 [];				// Paleta de tintas para el juego
extern unsigned char map_data [];				// Mapeado del juego
extern char asm_number[1];						// Interfaz guarro ASM<->C
extern unsigned char exo_scr_titulo [];			// Pantalla comprimida: ttulo.
extern unsigned char exo_scr_menu [];			// Pantalla comprimida: fondo de men.
extern unsigned char exo_scr_final [];			// Pantalla comprimida: final del juego.

// Sprites

#include "sp_phant.h"							// Phantomas
#include "sp_enem.h"							// Enemigos

// Datos

#include "marsene.h"							// Enemigos y hotspots

// Msica y efectos

#include "sound.h"

// Variables globales y buffers:

unsigned char map_buffer [135]; 				// Buffer temporal que describe cmo funciona cada tile de la pantalla actual.

// Cadenas

extern unsigned char cad_score [];
extern unsigned char cad_life [];
extern unsigned char cad_game_over1 [];
extern unsigned char cad_game_over2 [];
extern unsigned char cad_menu_1 [];
extern unsigned char cad_menu_2 [];
extern unsigned char cad_menu_3 [];
extern unsigned char cad_menu_4 [];
extern unsigned char cad_menu_5 [];
extern unsigned char cad_menu_6 [];
extern unsigned char cad_final_1 [];
extern unsigned char cad_final_2 [];
extern unsigned char cad_final_3 [];
extern unsigned char cad_final_4 [];

#asm
	._cad_score
		defm "00"
		defb 0
	._cad_life
		defm "000"
		defb 0
	._cad_game_over1
		defm ";GAME;OVER;"
		defb 0
	._cad_game_over2
		defm ";;;;;;;;;;;"
		defb 0
	._cad_menu_1
		defm "PRESS;ANY;KEY;TO;PLAY"
		defb 0
	._cad_menu_2
		defm "BYTES:;NATH;;GFX:;ANJU<;NATH<;KEND"
		defb 0
	._cad_menu_3 
		defm "MUSIC:;ANJU;;SFX:;WYZ"
		defb 0
	._cad_menu_4
		defm "POWERED;BY;CPCRSLIB;BY;ARTABURU"
		defb 0
	._cad_menu_5
		defm "POWERED;BY;PSG;PLAYER;BY;WYZ"
		defb 0
	._cad_menu_6
		defm "THE;MOJON;TWINS;2009"
		defb 0
	._cad_final_1
		defm "CONGRATZ"
		defb 0
	._cad_final_2
		defm "YOU;DID;IT"
		defb 0
	._cad_final_3
		defm "SEE;YA;IN"
		defb 0
	._cad_final_4
		defm "TALES;2"
		defb 0
#endasm

// Comportamiento de cada tile:
// 0 nada
// 1 mata
// 2 plataforma
// 3 solido
// 4 <-
// 5 ->

char behaviour [] = {
	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	4, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
};

unsigned char halflife = 0;
unsigned char prefalling;
unsigned char enoffs;
unsigned char hsx, hsy;
unsigned char backtile;
unsigned char frontile;

//Structs para sprites, enemigos, etctera...

typedef struct {
	unsigned char x, y;
	unsigned char mx, my;
	unsigned char sal;
	unsigned char nu;
	unsigned char frame;
	unsigned char facing;
	unsigned char life;
	unsigned char score;
	unsigned char kpress;
	unsigned char *current_frame, *next_frame;
} PHANTOMAS;
PHANTOMAS phantomas;

typedef struct {
	unsigned char frame;
	unsigned char count;
	unsigned char *current_frame, *next_frame;
} ANIMADO;
ANIMADO en_an [3];

// Funciones auxiliares

unsigned char rand () {
	unsigned char res;

	#asm
	._Rand8 ld	a,9 	; Seed is usually 0
			ld	b,a
			add a,a
			add a,a
			add a,b
			inc a		; another possibility is ADD A,7
			ld (_Rand8+1),a
			ld (_asm_number), a
	#endasm

	res = asm_number [0];

	return res;
}

// Funciones del juego

void draw_supertile (unsigned char x, unsigned char y, unsigned char super_tile) {
	super_tile = super_tile << 2;
	cpc_SetTile (x, y, bloques [super_tile]);
	cpc_SetTile (x + 1, y, bloques [super_tile + 1]);
	cpc_SetTile (x, y + 1, bloques [super_tile + 2]);
	cpc_SetTile (x + 1, y + 1, bloques [super_tile + 3]);
}

void draw_supertile_stars (unsigned char x, unsigned char y, unsigned char super_tile) {
	super_tile = super_tile << 2;
	cpc_SetTile (x, y, rand() < 32 ? 136 : 0);
	cpc_SetTile (x + 1, y, rand() < 32 ? 136 : 0);
	cpc_SetTile (x, y + 1, rand() < 32 ? 136 : 0);
	cpc_SetTile (x + 1, y + 1, rand() < 32 ? 136 : 0);
}

void draw_supertile_inv (unsigned char x, unsigned char y, unsigned char super_tile) {
	super_tile = super_tile << 2;
	cpc_SetTouchTileXY (x, y, bloques [super_tile]);
	cpc_SetTouchTileXY (x + 1, y, bloques [super_tile + 1]);
	cpc_SetTouchTileXY (x, y + 1, bloques [super_tile + 2]);
	cpc_SetTouchTileXY (x + 1, y + 1, bloques [super_tile + 3]);
}

void mueve_bicharracos () {
	// Vamos a mover un frame todos los bicharracos activos.
	
	unsigned char i, enoffsmasi;
	
	for (i = 0; i < 3; i ++) {
		enoffsmasi = enoffs + i;
		if (malotes [enoffsmasi].t != 0) {
			malotes [enoffsmasi].x += malotes [enoffsmasi].mx;
			if (malotes [enoffsmasi].x == malotes [enoffsmasi].x1 || malotes [enoffsmasi].x == malotes [enoffsmasi].x2)
				malotes [enoffsmasi].mx = -malotes [enoffsmasi].mx;
			malotes [enoffsmasi].y += malotes [enoffsmasi].my;
			if (malotes [enoffsmasi].y == malotes [enoffsmasi].y1 || malotes [enoffsmasi].y == malotes [enoffsmasi].y2)
				malotes [enoffsmasi].my = -malotes [enoffsmasi].my;
				
			en_an [i].count ++; 
			if (en_an [i].count == 4) {
				en_an [i].count = 0;
				en_an [i].frame = !en_an [i].frame;
				
				switch (malotes [enoffsmasi].t) {
					case 1:
						en_an [i].next_frame = en_an [i].frame ? sp_enemg_0 : sp_enemg_1;
						break;
					case 2:
						en_an [i].next_frame = en_an [i].frame ? sp_enemg_2 : sp_enemg_3;
						break;
					case 3:
						en_an [i].next_frame = en_an [i].frame ? sp_enemg_4 : sp_enemg_5;
				}	
			}
		}
	}
}

void draw_screen (unsigned char pant) {
	unsigned char i, x = 0, y = 0, super_tile; //offset_tile;
	unsigned int index;

	index = ((int)pant) * 135;
	for (i = 0; i < 135; i ++) {
		super_tile = map_data [index + i] - 1;
		map_buffer [i] = behaviour [super_tile];

		if (super_tile)
			draw_supertile (x, y, super_tile);
		else
			draw_supertile_stars (x, y, super_tile);

		x += 2;
		if (x == 30) { x = 0; y += 2; }
	}
	
	// Vemos si hay que poner un objeto en el hotspot. Si no, vemos si ponemos o no una energa 
	// en una casilla transpasable cualquiera de la pantalla.
	
	/*
	hsy = 255; 						// suficiente para que NUNCA coincida :D
	frontile = 0;
	if (hotspots [pant].act) {
		frontile = 15;
		x = hotspots [pant].xy >> 4;
		y = hotspots [pant].xy & 15;
	} else if ((rand () & 3) == 2 && pant != 12) {	
		frontile = 14;				// Si no hay objeto, cada RAND veces ponemos una energa:
		do {
			x = rand () % 15;
			y = rand () %  9;
		} while (map_buffer [(y << 4) - y + x] > 2);
	}
	
	if (frontile != 0) {
		backtile = map_data [index + (y << 4) - y + x];
		hsx = x << 4;
		hsy = y << 4;
		x = x + x;
		y = y + y;
		draw_supertile (x, y, frontile);
	}
	*/
	
	// [UPD20090227]
	// Ahora en los hotspots donde no hay regalo, habr una recarga de energa,
	// para complicar el juego. 
		
	if (hotspots [pant].act != 2) {
		x = hotspots [pant].xy >> 4;
		y = hotspots [pant].xy & 15;
		frontile = hotspots [pant].act ? 15 : 14;
		backtile = map_data [index + (y << 4) - y + x];
		hsx = x << 4;
		hsy = y << 4;
		x = x + x;
		y = y + y;
		draw_supertile (x, y, frontile);
	} else {
		frontile = 0;
		hsy = 255;
	}
	
	// Invalido y muestro los datos en el tilemap.
	
	cpc_ResetTouchedTiles ();
	cpc_ShowTileMap (0);
		
	// Movemos y cambiamos a los enemigos segn el tipo que tengan
	
	enoffs = pant * 3;
	
	for (i = 0; i < 3; i ++) {
		en_an [i].frame = 0;
		en_an [i].count = 0;
		switch (malotes [enoffs + i].t) {
			case 0:
				// sp_MoveSprAbs (sp_en [i], spritesClip, 0, 22, 0, 0, 0);
				break;
			case 1:
				en_an [i].next_frame = sp_enemg_0;
				break;
			case 2:
				en_an [i].next_frame = sp_enemg_2;
				break;
			case 3:
				en_an [i].next_frame = sp_enemg_4;
				break;
		}
	}
}

void draw_life () {
	unsigned char aux, aux2;
	
	aux = phantomas.life / 100;
	cad_life [0] = 48 + aux;
	aux2 = phantomas.life - 100 * aux;
	cad_life [1] = aux2 / 10 + 48;
	cad_life [2] = aux2 - 10 * (aux2 / 10) + 48;

	cpc_PrintGphStrXY ((unsigned int *) (cad_life), (unsigned char *) (134), (unsigned char *) (172));
}

void draw_score () {
	unsigned char aux;
	aux = phantomas.score / 10;
	cad_score [0] = 48 + aux;
	cad_score [1] = phantomas.score - 10 * aux + 48;
	
	cpc_PrintGphStrXY ((unsigned int *) (cad_score), (unsigned char *) (144), (unsigned char *) (172));
}

void mueve () {
	unsigned char i;
	unsigned char xx, yy;
	unsigned char mapidx;
	unsigned char falling;
	unsigned char allpurp;

	xx = phantomas.x >> 4;
	yy = phantomas.y >> 4;
	mapidx = (yy << 4) - yy + xx; // mapidx = 15 * yy + xx;

	// Tiles que te matan
	allpurp = 0;
	if ((phantomas.x & 15) == 0) {
		if ((phantomas.y & 15) == 0) {
			if (map_buffer [mapidx] == 1)		// [x, y]
				allpurp = 1;
		} else {
			if (map_buffer [mapidx] == 1 ||
				map_buffer [mapidx + 15] == 1)	// [x, y] || [x, y + 1]
				allpurp = 1;
		}
	} else {
		if ((phantomas.y & 15) == 0) {
			if (map_buffer [mapidx] == 1 ||
				map_buffer [mapidx + 1] == 1)	// [x, y] || [x + 1, y]
				allpurp = 1;
		} else {
			if (map_buffer [mapidx] == 1 ||
				map_buffer [mapidx + 1] == 1 ||
				map_buffer [mapidx + 15] == 1 ||
				map_buffer [mapidx + 16] == 1)	// [x, y] || [x + 1, y] || [x, y + 1] || [x + 1, y + 1]
				allpurp = 1;
		}
	}

	if (allpurp && halflife) {
		cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 1);
		phantomas.life --;
		draw_life ();
	}

	// Empezamos con el movimiento.
	// Esto est tan optimizado que ya ni entiendo de qu va XD (mentira).

	if (phantomas.sal == 0) {

		// caemos?
		falling = 0;

		if (phantomas.y < 128) {
			if ((phantomas.y & 15) == 0) {
				if ((phantomas.x & 15) == 0) {
					if (map_buffer [mapidx + 15] < 2) {
						falling = 1;
					}
				} else {
					if (map_buffer [mapidx + 15] < 2 && map_buffer [mapidx + 16] < 2) {
						falling = 1;
					}
				}
			} else {
				falling = 1;
			}
		}

		if (prefalling != falling && !falling)
			cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 0);

		prefalling = falling;

		if (!falling) {
			// Cambio: Muevo, y si es ilegal, deshago hasta el borde.

			if (cpc_TestKey (KEY_IZQ)) {
				if (((phantomas.x >> 2) << 2) == phantomas.x)
					phantomas.frame = (phantomas.frame + 1) & 3;
				phantomas.x -= 2;
				phantomas.facing = 1;
					
				xx = phantomas.x >> 4;
				mapidx = (yy << 4) - yy + xx; // mapidx = 15 * yy + xx;

				// Vemos si colisionamos a la izquierda.
				if ((phantomas.y & 15) == 0) {
					if (map_buffer [mapidx] > 2) {
						// Ajustamos al borde del tile siguiente
						phantomas.x = ((phantomas.x >> 4) << 4) + 16;
					}
				} else {
					if (map_buffer [mapidx] > 2 || map_buffer [mapidx + 15] > 2) {
						// Ajustamos al borde del tile siguiente
						phantomas.x = ((phantomas.x >> 4) << 4) + 16;
					}
				}
			}

			if (cpc_TestKey (KEY_DER)) {
				phantomas.x += 2;
				phantomas.facing = 0;
				
				xx = phantomas.x >> 4;
				mapidx = (yy << 4) - yy + xx; // mapidx = 15 * yy + xx;

				// Vemos si colisionamos a la derecha
				if ((phantomas.y & 15) == 0) {
					if (map_buffer [mapidx + 1] > 2) {
						// Ajustamos al borde del tile
						phantomas.x = ((phantomas.x >> 4) << 4);
					}
				} else {
					if (map_buffer [mapidx + 1] > 2 || map_buffer [mapidx + 16] > 2) {
						// Ajustamos al borde del tile
						phantomas.x = ((phantomas.x >> 4) << 4);
					}
				}
				
				if (((phantomas.x >> 2) << 2) == phantomas.x)
					phantomas.frame = (phantomas.frame + 1) & 3;
			}

			// Salto
			if (!phantomas.kpress) {
				if (cpc_TestKey (KEY_SAL)) {
					// salto alto
					phantomas.x = ((phantomas.x >> 2) << 2); // Esto es feo, pero ahorra mucho cdigo y ni se nota :o)
					phantomas.y = ((phantomas.y >> 4) << 4);
					phantomas.mx = 2;
					phantomas.my = 4;
					phantomas.nu = 0;
					phantomas.sal = 1;
					phantomas.kpress = 1;
					cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 8);
				} else if (cpc_TestKey (KEY_SLA)) {
					// salto largo
					phantomas.x = ((phantomas.x >> 2) << 2); // Esto es feo, pero ahorra mucho cdigo y ni se nota :o)
					phantomas.y = ((phantomas.y >> 4) << 4);
					phantomas.mx = 4;
					phantomas.my = 2;
					phantomas.nu = 0;
					phantomas.sal = 1;
					phantomas.kpress = 1;
					cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 7);
				}
			}

			if (!cpc_TestKey (KEY_SAL) && !cpc_TestKey (KEY_SLA)) {
				phantomas.kpress = 0;
			}

			// Autodeslizamiento en los rodillos arrastrantes buenaente
			if (!phantomas.sal) {
				xx = phantomas.x >> 4;
				mapidx = (yy << 4) - yy + xx; // mapidx = 15 * yy + xx;

				if ((phantomas.x & 15) == 0) {
					if (map_buffer [mapidx + 15] == 4 && map_buffer [mapidx - 1] < 3) {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 2);
						phantomas.x --;
					} else if (map_buffer [mapidx + 15] == 5 && map_buffer [mapidx + 1] < 3) {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 2);
						phantomas.x ++;
					}
				} else {
					if (map_buffer [mapidx + 15] == 4 || map_buffer [mapidx + 16] == 4) {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 2);
						phantomas.x --;
					}
					if (map_buffer [mapidx + 15] == 5 || map_buffer [mapidx + 16] == 5) {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 2);
						phantomas.x ++;
					}
				}
			}
		} else {
			phantomas.y += 4;
			phantomas.y = (phantomas.y >> 2) << 2;
			phantomas.x = ((phantomas.x >> 2) << 2);
		}
	} else {
		// Salto. si nu < 8 sube, y luego baja hasta que nu = 16
		// phantomas.x = (phantomas.x >> 2) << 2;

		// Vertical
		if (phantomas.nu < 8) {
			if (phantomas.y > 0) {
				if ((phantomas.y & 15) == 0) {
					if ((phantomas.x & 15) == 0) {
						if (map_buffer [mapidx - 15] < 3) {
							phantomas.y -= phantomas.my;
						}
					} else {
						if (map_buffer [mapidx - 15] < 3 && map_buffer [mapidx - 14] < 3) {
							phantomas.y -= phantomas.my;
						}
					}
				} else {
					phantomas.y -= phantomas.my;
				}
			}
		} else {
			if ((phantomas.y & 15) == 0) {
				if ((phantomas.x & 15) == 0) {
					if (map_buffer [mapidx + 15] < 2) {
						phantomas.y += phantomas.my;
					} else {
						phantomas.sal = 0;
						phantomas.y = ((phantomas.y >> 4) << 4);
						phantomas.x = ((phantomas.x >> 2) << 2);
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 0);
					}
				} else {
					if (map_buffer [mapidx + 15] < 2 && map_buffer [mapidx + 16] < 2) {
						phantomas.y += phantomas.my;
					} else {
						phantomas.sal = 0;
						phantomas.y = ((phantomas.y >> 4) << 4);
						phantomas.x = ((phantomas.x >> 2) << 2);
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 0);
					}
				}
			} else {
				phantomas.y += phantomas.my;
			}
		}

		yy = phantomas.y >> 4;
		mapidx = 15 * yy + xx;

		// Horizontal

		if (phantomas.facing) {
			if (phantomas.x > 0) {
				if ((phantomas.x & 15) == 0) {
					if ((phantomas.y & 15) == 0) {
						if (map_buffer [mapidx - 1] < 3) {
							phantomas.x -= phantomas.mx;
						}
					} else {
						if (map_buffer [mapidx - 1] < 3 && map_buffer [mapidx + 14] < 3) {
							phantomas.x -= phantomas.mx;
						}
					}
				} else {
					phantomas.x -= phantomas.mx;
				}
			}
		} else {
			if (phantomas.x < 224) {
				if ((phantomas.x & 15) == 0) {
					if ((phantomas.y & 15) == 0) {
						if (map_buffer [mapidx + 1] < 3) {
							phantomas.x += phantomas.mx;
						}
					} else {
						if (map_buffer [mapidx + 1] < 3 && map_buffer [mapidx + 16] < 3) {
							phantomas.x += phantomas.mx;
						}
					}
				} else {
					phantomas.x += phantomas.mx;
				}
			}
		}

		phantomas.nu ++;
		if (phantomas.nu == 16) { 
			phantomas.sal = 0;
			phantomas.x = ((phantomas.x >> 2) << 2);
		}
	}

	if (phantomas.sal || falling) {
		if (phantomas.facing)
			phantomas.next_frame = sp_phant_3;
		else
			phantomas.next_frame = sp_phant_7;
	} else {
		if (phantomas.facing) {
			if (phantomas.frame == 1)
				phantomas.next_frame = sp_phant_1;
			else if (phantomas.frame == 3)
				phantomas.next_frame = sp_phant_2;
			else
				phantomas.next_frame = sp_phant_0;
		} else {
			if (phantomas.frame == 1)
				phantomas.next_frame = sp_phant_5;
			else if (phantomas.frame == 3)
				phantomas.next_frame = sp_phant_6;
			else
				phantomas.next_frame = sp_phant_4;
		}
	}
}

void set_inks () {
	unsigned char i;
	// Ponemos las tintas:
	for (i = 0; i < 16; i ++)
		cpc_SetColour (i, paleta1 [i]);
}

void set_black () {
	unsigned char i;
	// Ponemos t negror:
	for (i = 0; i < 16; i ++) {
		cpc_SetColour (i, 0);
	}
}

void set_text_inks (unsigned char i1,unsigned char i2,unsigned char i3,unsigned char i4) {
	// Definimos el color del texto
	// Color Valor
	// 0	0
	// 1	128
	// 2	8
	// 3	136
	// 4	32
	// 5	160
	// 6	40
	// 7	168
	// 8	2
	// 9	130
	// 10	10
	// 11	138
	// 12	34
	// 13	162
	// 14	42
	// 15	170		
	cpc_SetInkGphStr ((unsigned char *) (0), (unsigned char *) (i1));
	cpc_SetInkGphStr ((unsigned char *) (1), (unsigned char *) (i2));
	cpc_SetInkGphStr ((unsigned char *) (2), (unsigned char *) (i3));
	cpc_SetInkGphStr ((unsigned char *) (3), (unsigned char *) (i4));
}

void menu (void) {
	// A esto le llamo men por llamarle de alguna forma, porque de men tiene lo que yo de bogavante.
	// Juas...
	
	set_black ();
	cpc_UnExo ((unsigned int *) (exo_scr_menu), (unsigned int *) (0xc000));
	set_inks ();
	
	set_text_inks (0, 138, 128, 34);
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_1), (unsigned char *) (19), (unsigned char *) (96));
	set_text_inks (0, 10, 168, 100);
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_6), (unsigned char *) (20), (unsigned char *) (184));
	
	set_text_inks (0, 8, 32, 8);
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_2), (unsigned char *) (6), (unsigned char *) (138));
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_3), (unsigned char *) (19), (unsigned char *) (146));
	
	set_text_inks (0, 170, 162, 170);
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_4), (unsigned char *) (9), (unsigned char *) (162));
	cpc_PrintGphStrXY ((unsigned int *) (cad_menu_5), (unsigned char *) (12), (unsigned char *) (170));
	
	while (cpc_AnyKeyPressed());
	while (!cpc_AnyKeyPressed());
}

void final (void) {
	cpc_UnExo ((unsigned int *) (exo_scr_final), (unsigned int *) (0xc000));
	
	// Descomprimimos la cancin en el buffer de tiles
	cpc_UnExo ((unsigned int *) (song_2), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (0);
	cpc_WyzSetPlayerOn ();
	
	// Poner un textopocho
	set_text_inks (0, 138, 128, 34);
	cpc_PrintGphStrXY ((unsigned int *) (cad_final_1), (unsigned char *) (2), (unsigned char *) (22));
	cpc_PrintGphStrXY ((unsigned int *) (cad_final_2), (unsigned char *) (2), (unsigned char *) (38));
	cpc_PrintGphStrXY ((unsigned int *) (cad_final_3), (unsigned char *) (2), (unsigned char *) (54));
	set_text_inks (0, 10, 168, 100);
	cpc_PrintGphStrXY ((unsigned int *) (cad_final_4), (unsigned char *) (2), (unsigned char *) (70));
	
	// Esperar una tecla
	while (cpc_AnyKeyPressed());
	while (!cpc_AnyKeyPressed());
		
	// Apagar
	cpc_WyzSetPlayerOff ();
}

void game_over (void) {
	unsigned char i, j, k;
	
	// La explosin la voy a hacer haciendo el guarrete con la paleta
	// Por favor, no miren el cdigo de queso y espagueti de aqu abajo:
	
	for (i = 0; i < 250; i ++) {
		cpc_SetColour (1, (i & 1) ? 0 : 6);
		#asm
			halt
		#endasm
		cpc_SetColour (1, (i & 1) ? 6 : 0);
		#asm
			halt
		#endasm
	}
	
	cpc_WyzLoadSong (3);
	cpc_WyzSetPlayerOn ();
	
	// En CPC el halt ese no funciona igual que en Spectrum, cachoperro.
	
	// Game over text y pulsar una tecla.
	set_text_inks (0, 10, 40, 10);
	cpc_PrintGphStrXY ((unsigned int *) (cad_game_over2), (unsigned char *) (29), (unsigned char *) (88));
	cpc_PrintGphStrXY ((unsigned int *) (cad_game_over1), (unsigned char *) (29), (unsigned char *) (96));
	cpc_PrintGphStrXY ((unsigned int *) (cad_game_over2), (unsigned char *) (29), (unsigned char *) (104));
	
	// retardo cutre:
	for (k = 0; k < 2; k ++)
		for (i = 0; i < 200; i ++)
			for (j = 0; j < 255; j ++) { ; }
	
	cpc_WyzSetPlayerOff ();
}
	
void interrupciones(void) {
	// Manejador de interrupciones por Artaburu
	
	#asm
		di
		ld hl,($0039)
		ld (_int_original),HL   //guardo el salto original

		ld HL,_interrupcion
		ld ($0039),HL
		ei
		jp term
	._int_original  
		defw 0
	._interrupcion
		ei
		ret
	.term
	#endasm
}
	
// Main

void main (void) {
	unsigned char i, j, x, y, mx, my;
	unsigned char pant;
	unsigned char flag1;

	// Estructura para sprites de CPCSRLIB
	// REMEMBER: Las coordenadas ?x en la estructura de Sprite es en BYTES (2 ladrillos)

	struct sprite { 			// estructura mnima para usar la librera de dibujar sprites capturando el fondo.
		int sp0;				// 2 bytes	01
		int sp1;				// 2 bytes	23
		int coord0; 			// 2 bytes	45	 posicin en superbuffer
		int coord1; 			// 2 bytes	67	 posicin anterior en superbuffer
		unsigned char cx, cy;	// 2 bytes	89   coordenadas nuevas
		unsigned char ox, oy;	// 2 bytes	AB   coordenadas actuales
		unsigned char move; 	// 1 byte    C    si NO es 0, el sprite se mueve.
		unsigned char move1;	// 1 byte    D    si NO es 0, el sprite se mueve.
		// Si es 8 en cuanto se mueva se pone a 0 y ya no se mueve ms hasta nueva orden.
	} ;

	struct sprite sp_phantomas;
	struct sprite sp_enem_1;
	struct sprite sp_enem_2;
	struct sprite sp_enem_3;
	
	struct sprite sp_aux;

	// Establecemos el modo 0:

	interrupciones ();
	
	cpc_SetMode (0);
	set_inks ();
	cpc_SetColour (16, 20);
	
	// Inicializamos el player de wyz:
	
	cpc_WyzInitPlayer (wyz_sound_table, wyz_pattern_table, wyz_effects_table, wyz_song_table);
	
	// Batera por el canal C:
	
	cpc_WyzConfigurePlayer (0);
	
	// Definimos las teclas: O P Q A
	// TODO: Revisar esto, que un testkey hace que todo se cuelgue.
	/*
	cpc_AssignKey (KEY_IZQ, 0x4404);		// O
	cpc_AssignKey (KEY_DER, 0x4308);		// P
	cpc_AssignKey (KEY_SAL, 0x4808);		// Q
	cpc_AssignKey (KEY_SLA, 0x4820);		// A
	*/

	cpc_AssignKey (KEY_IZQ, 0x4101);		// CUR LEFT
	cpc_AssignKey (KEY_DER, 0x4002);		// CUR RIGHT
	cpc_AssignKey (KEY_SAL, 0x4001);		// CUR UP
	cpc_AssignKey (KEY_SLA, 0x4004);		// CUR DOWN

	while (1) {
		// Descomprimimos la msica antes de cargarla
		
		// Nueva rutina, para establecer el buffer desde dentro
		cpc_WyzSetBuffer (0x9800);	
		
		cpc_UnExo ((unsigned int *) (song_0),(unsigned int *) (0x0100));
		cpc_WyzLoadSong (0);
		cpc_WyzSetPlayerOn ();
		menu ();
		cpc_WyzSetPlayerOff ();
		
		pant = 12;	// Un pon.

		// Inicializamos a Phantomas:
		phantomas.x = 20;
		phantomas.y = 16;
		phantomas.sal = 0;
		phantomas.nu = 0;
		phantomas.next_frame = sp_phant_0;
		phantomas.facing = 0;
		phantomas.frame = 0;
		phantomas.kpress = 0;
		phantomas.score = 0;
		phantomas.life = 255;

		// Creamos los sprites:

		sp_phantomas.sp0 = (int) (sp_enemg_0);
		sp_phantomas.sp1 = (int) (sp_enemg_0);
		sp_phantomas.cx = phantomas.x >> 2;
		sp_phantomas.cy = phantomas.y;
		sp_phantomas.ox = phantomas.x >> 2;
		sp_phantomas.oy = phantomas.y;
		sp_phantomas.move = 0;
		
		sp_enem_1.sp0 = (int) (sp_enemg_0);
		sp_enem_1.sp1 = (int) (sp_enemg_0);
		sp_enem_1.cx = 0;
		sp_enem_1.cy = 0;
		sp_enem_1.ox = 0;
		sp_enem_1.oy = 0;
		sp_enem_1.move = 0;
		
		sp_enem_2.sp0 = (int) (sp_enemg_0);
		sp_enem_2.sp1 = (int) (sp_enemg_0);
		sp_enem_2.cx = 0;
		sp_enem_2.cy = 0;
		sp_enem_2.ox = 0;
		sp_enem_2.oy = 0;
		sp_enem_2.move = 0;
		
		sp_enem_3.sp0 = (int) (sp_enemg_0);
		sp_enem_3.sp1 = (int) (sp_enemg_0);
		sp_enem_3.cx = 0;
		sp_enem_3.cy = 0;
		sp_enem_3.ox = 0;
		sp_enem_3.oy = 0;
		sp_enem_3.move = 0;
		
		// Vamos a colocar unos objetos por ah, como quien no quiere la cosa:
		for (i = 0; i < 30; i ++) 
			hotspots [i].act = 0;
			
		for (i = 0; i < 20; i ++) {
			do {
				j = rand () % 30;
			} while (hotspots [j].act || j == 12);
			hotspots [j].act = 1;
		}
		
		hotspots [12].act = 2;
		
		// Descomprimimos el marco
		set_black ();
		cpc_UnExo ((unsigned int *) (exo_scr_titulo),(unsigned int *) (0xc000));
		set_inks ();

		// Descomprimimos la cancin en el buffer de tiles
		cpc_UnExo ((unsigned int *) (song_2), (unsigned int *) (0x0100));
		cpc_WyzLoadSong (0);
		
		// Definimos el color del texto
		
		set_text_inks (0x80, 10, 8, 10);
				
		// Pintamos la nueva pantalla
		draw_screen (pant);
		draw_life ();
		draw_score ();

		flag1 = !phantomas.life;
		
		cpc_WyzSetPlayerOn ();
		
		while (!flag1) {
			halflife = !halflife;

			// Movimiento:

			mueve ();
			mueve_bicharracos ();
			
			// Guarro:
			if (phantomas.y > 128) phantomas.y = 128;
			
			// Lgica: Cambio de pantalla:
			
			if ((cpc_TestKey (KEY_IZQ) || (phantomas.sal && phantomas.facing)) && (phantomas.x <= 1 || phantomas.x > 250)) {
				phantomas.x = 224;
				pant --;
				draw_screen (pant);
			} else if ((cpc_TestKey (KEY_DER) || (phantomas.sal && !phantomas.facing)) && phantomas.x >= 224) {
				phantomas.x = 0;
				pant ++;
				draw_screen (pant);
			} else if (phantomas.sal && phantomas.y == 0 && phantomas.nu < 8) {
				phantomas.y = 128;
				//phantomas.nu --;
				pant -= 6;
				draw_screen (pant);
			} else if ((!phantomas.sal || (phantomas.sal && phantomas.nu > 7)) && phantomas.y >= 128 && pant < 24) {
				phantomas.y = 0;
				pant += 6;
				draw_screen (pant);
			}

			// Lgica :: Coger objetos
			
			if ( phantomas.x >= (hsx > 15 ? hsx - 15 : 0) && phantomas.x <= hsx + 15 && phantomas.y >= (hsy > 15 ? hsy - 15 : 0) && phantomas.y <= hsy + 15 ) {
				// aux = (backtile << 2);
								
				// Hay que pintar el tile de 'atr'
				x = hsx >> 3;
				y = hsy >> 3;
				
				draw_supertile_inv (x, y, backtile - 1);
				
				hotspots [pant].act = 2;
				
				if (frontile == 15) {
					phantomas.score ++;		// Uno ms pa'l bote
					draw_score ();	
					cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 3);
				} else {
					phantomas.life = phantomas.life > 223 ? 255 : (phantomas.life + 32);
					draw_life ();
					cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 5);
				}
				
				// rpido y feo, como todo:
				hsy = 255;		
				
				// Podra haberme puesto a comprobar que hotspots [pant].act == 0 en el if de arriba, pero es
				// tontera meter una comprobacin ms slo porque "quede ms bonito" :-P 'est les 8 bits!
			}
			
			// Lgica :: Colisin con otros enemigos.
			
			// PF - por la forma que tienen los sprites, voy a hacerlo por bounding box. Con que lo pete
			// un poco ms pequeo que el rectngulo real (por ejemplo, 14x14 pxels) esto da el pego que te cagas.
			
			for (i = 0; i < 3; i ++) {
				// if (malotes [enoffs + i].t != 0) {		// Esto slo es necesario si hay habitaciones con menos de 3. Lo dejo para el Helmet ;)
					if (phantomas.x >= malotes [enoffs + i].x - 13 && phantomas.x <= malotes [enoffs + i].x + 13 && phantomas.y >= malotes [enoffs + i].y - (malotes [enoffs + i].y ? 13 : 0) && phantomas.y <= malotes [enoffs + i].y + 13 && halflife) {
						phantomas.life --;
						draw_life ();
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 1);
					}					
				// }
			}
			
			// Lgica :: Comprobacin de final de juego: gameover o ganar.
			flag1 = !phantomas.life || (phantomas.score == 20);
			
			// Cambios en la estructura de sprites:
			// (coordenadas, frame, etctera)

			sp_phantomas.sp0 = (int) (phantomas.next_frame);
			sp_phantomas.cx = phantomas.x >> 2;
			sp_phantomas.cy = phantomas.y;
			
			sp_enem_1.sp0 = (int) (en_an [0].next_frame);	
			sp_enem_1.cx = (malotes [enoffs].x) >> 2;
			sp_enem_1.cy = malotes [enoffs].y;
			
			sp_enem_2.sp0 = (int) (en_an [1].next_frame);	
			sp_enem_2.cx = (malotes [enoffs + 1].x) >> 2;
			sp_enem_2.cy = malotes [enoffs + 1].y;
			
			sp_enem_3.sp0 = (int) (en_an [2].next_frame);	
			sp_enem_3.cx = (malotes [enoffs + 2].x) >> 2;
			sp_enem_3.cy = malotes [enoffs + 2].y;
			
			// Render
			
			cpc_PutSpTileMap ((int) (sp_phantomas));
			cpc_PutSpTileMap ((int) (sp_enem_1));
			cpc_PutSpTileMap ((int) (sp_enem_2));
			cpc_PutSpTileMap ((int) (sp_enem_3));
			cpc_UpdScr ();
			cpc_PutTrSp8x16TileMap2b ((int) (sp_phantomas));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_1));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_2));
			cpc_PutTrSp8x16TileMap2b ((int) (sp_enem_3));
			
			cpc_ShowTouchedTiles ();
			cpc_ResetTouchedTiles ();
		}
		
		cpc_WyzSetPlayerOff ();
		
		if (phantomas.score < 20) {
			game_over ();
		} else {
			final ();	
		}
	}
}

// Datos externos (referenciados por punteros extern):

#asm
	._bloques
		defb 0,1,2,3
		defb 4,5,6,7
		defb 8,9,10,11
		defb 12,13,14,15
		defb 16,17,18,19
		defb 20,21,22,23
		defb 24,25,26,27
		defb 28,29,30,31
		defb 32,33,34,35
		defb 36,37,38,39
		defb 40,41,42,43
		defb 44,45,46,47
		defb 48,49,50,51
		defb 52,53,54,55
		defb 56,57,58,59
		defb 60,61,62,63
		defb 64,65,66,67
		defb 68,69,70,71
		defb 72,73,74,75
		defb 76,77,78,79
		defb 80,81,82,83
		defb 84,85,86,87
		defb 88,89,90,91
		defb 92,93,94,95
		defb 96,97,98,99
		defb 100,101,102,103
		defb 104,105,106,107
		defb 108,109,110,111
		defb 112,113,114,115
		defb 116,117,118,119
		defb 120,121,122,123
		defb 124,125,126,127
		defb 128,129,130,131
		defb 132,133,134,135
		defb 136,137,138,139
		defb 140,141,142,143
		defb 144,145,146,147
		defb 148,149,150,151
		defb 152,153,154,155
		defb 156,157,158,159
		defb 160,161,162,163
		defb 164,165,166,167
		defb 168,169,170,171
		defb 172,173,174,175
		defb 176,177,178,179
		defb 180,181,182,183
		defb 184,185,186,187
		defb 188,189,190,191

	._paleta1
		defb 20,12,15,5,24,4,21,23,26,27,11,10,28,22,14,18

	._asm_number
		defb 0

	._asm_int
		defw 0
		
	._exo_scr_titulo
		BINARY "titulo-c.bin"

	._exo_scr_menu
		BINARY "menu-c.bin"
		
	._exo_scr_final
		BINARY "final-c.bin"
				
#endasm

#include "map.h"
