// Paletas

// Aqu se define qu paleta se usa en cada pantalla 
// Y el valor de las tintas para cada paleta.

unsigned char que_paleta [] = {
	1, 1, 2, 4, 4, 4, 4, 4, 4, 4,
	6, 1, 2, 3, 3, 3, 2, 4, 4, 4,
	1, 1, 2, 3, 3, 3, 2, 5, 5, 5,
	1, 1, 2, 3, 3, 3, 2, 5, 5, 5,
	1, 1, 2, 3, 3, 3, 2, 5, 5, 5,
	1, 1, 2, 3, 3, 3, 0, 0, 5, 5,
	1, 1, 2, 2, 2, 2, 0, 0, 5, 5,
	1, 1, 2, 2, 0, 0, 0, 0, 5, 5,
	2, 2, 2, 2, 0, 0, 0, 5, 5, 5,
	4, 4, 4, 4, 4, 4, 4, 4, 5, 5
};

/*
	Estas eran las paletas originales con los nmeros de firmware.
	Las he tenido que transformar en paletas hardware por el tema
	de las interrupciones.

	Tabla de conversin de paletas
	
	firm	hard
	0		20
	1		4
	2		21
	3		28
	4		24
	5		29
	6		12
	7		5
	8		13
	9		22
	10		6
	11		23
	12		30
	13		0
	14		31
	15		14
	16		7
	17		15
	18		18
	19		2
	20		19
	21		26
	22		25
	23		27
	24		10
	25		3
	26		11
*/

unsigned char paletas [] = {
	// Paleta 0: zona "azul claro" del mapa; negro/rojo oscuro/verde oscuro/naranja.
	20, 28, 22, 14,		// 0, 3, 9, 15,
	
	// Paleta 1: zona "azul" del mapa, paleta con amarillos
	20, 0, 3, 11,		// 0, 13, 25, 26,
	
	// Paleta 2: zona "verde" del mapa, paleta con verdes
	20, 6, 2, 11,		// 0, 10, 19, 26,
	
	// Paleta 3: zona "blanca" del mapa, paleta con moraditos
	20, 24, 7, 3,		// 0, 4, 16, 25,
	
	// Paleta 4: zona "roja" del mapa, paleta con rojos
	20, 28, 12, 7,		// 0, 3, 6, 16,
	
	// Paleta 5: zona "amarilla" del mapa, paleta con azules
	20, 4, 21, 23,		// 0, 1, 2, 11,
	
	// Paleta 6: pantalla especial, paleta CGA
	20, 13, 19, 11,		// 0, 8, 20, 26,
	
	// Paleta 7: t negro (mientras descomprime)
	20, 20, 20, 20,		// 0, 0, 0, 0,
	
	// Paleta 8: pantallas fijas
	20, 24, 23, 3,		// 0, 4, 11, 25,
	
	// Paleta 9: pantalla del men
	20, 24, 5, 11		// 0, 4, 7, 26
};

