/*********************************
	Nanako Descends to Hell CPC
 *********************************/
 
// Probando la cpcrslib en Modo 1.
// Arta es un puto genio.
// Mi segundo juego para CPC

#include "cpcrslib.h"
#include "cpcwyzlib.h"
#include "tilprites.h"
#include "map.h"
#include "paletas.h"
#include "sound.h"

/*******
 Defines
 *******/
 
// Estados:

#define STATE_IDLE		0
#define STATE_WLEFT 	1
#define STATE_WRIGHT	2
#define STATE_WUP		3
#define STATE_WDOWN 	4
#define STATE_DEAD		5
#define STATE_APARECE	6

// Direccin de Nanako:

#define FACING_LEFT 	0
#define FACING_RIGHT	1
#define FACING_UP		2
#define FACING_DOWN 	3

// Teclas:

#define KEY_IZQ 		0
#define KEY_DER 		1
#define KEY_ARR 		2
#define KEY_ABA 		3
#define KEY_FIR 		4
#define KEY_ESC 		5

// Lmites de tablas, etc.

#define NUM_PERSISTENCIAS	15
#define WYZ_CANAL_EFECTOS 	1						// 0 = A, 1 = B, 2 = C

/****************************************************
 Estructuras, globales, externas y dems definiciones
 ****************************************************/

// Structs

typedef struct {
	unsigned char state;	// 0 idle, 1 left, 2 right, 3 up, 4 down;
	unsigned char x, y, ct;
	unsigned char cx, cy;
	char lives, score;
	unsigned char o1, o2, o3, o4;
	unsigned char frame;
	unsigned char paso;
	unsigned char facing;
	unsigned char colliding;
} PERZONAE;

typedef struct {
	unsigned char pant;
	unsigned char x, y;
} PERSISTENCIA;

// Globales

unsigned char map_buffer [49];
unsigned char map_buffer_r [49];
unsigned char halflife = 0;
PERZONAE nanako;
PERZONAE bisho;
int buffer_nanako [9];
int buffer_bisho [9];
unsigned char tiene_bisho;
PERSISTENCIA persistencias [NUM_PERSISTENCIAS];
unsigned char aftergame = 0;
unsigned char oldpal;

// Extern globals

extern char asm_number[1];
extern unsigned char s_menu [];
extern unsigned char s_marco [];
extern unsigned char s_gover [];
extern unsigned char s_final [];
extern unsigned char objetos_marcador_0_DATA[];
extern unsigned char objetos_marcador_1_DATA[];
extern unsigned char objetos_marcador_2_DATA[];
extern unsigned char objetos_marcador_3_DATA[];
extern unsigned char objetos_marcador_4_DATA[];
unsigned char *objetos_marcador [] = {
	objetos_marcador_0_DATA, 
	objetos_marcador_1_DATA, 
	objetos_marcador_2_DATA, 
	objetos_marcador_3_DATA, 
	objetos_marcador_4_DATA
};
extern unsigned char numeracos_marcador_0_DATA[];
extern unsigned char numeracos_marcador_1_DATA[];
extern unsigned char numeracos_marcador_2_DATA[];
extern unsigned char numeracos_marcador_3_DATA[];
extern unsigned char numeracos_marcador_4_DATA[];
extern unsigned char numeracos_marcador_5_DATA[];
/*
extern unsigned char numeracos_marcador_6_DATA[];
extern unsigned char numeracos_marcador_7_DATA[];
extern unsigned char numeracos_marcador_8_DATA[];
extern unsigned char numeracos_marcador_9_DATA[];
*/
unsigned char *numeracos_marcador [] = {
	numeracos_marcador_0_DATA, 
	numeracos_marcador_1_DATA, 
	numeracos_marcador_2_DATA, 
	numeracos_marcador_3_DATA, 
	numeracos_marcador_4_DATA, 
	numeracos_marcador_5_DATA/*, 
	numeracos_marcador_6_DATA, 
	numeracos_marcador_7_DATA, 
	numeracos_marcador_8_DATA, 
	numeracos_marcador_9_DATA*/
};
		
// Extern data

#asm
._asm_number 
	defb 0
._asm_int_2
	defw 0
#endasm

// Comportamiento de cada tile:
//	0 nada
//	1 solido
//	2 aguachirri

char behaviour [] = {
	0, 0, 2, 2, 1, 1, 1, 1, 1, 2,
	2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

// Objetos:
// 0 nada
// 1 agua bendita
// 2 cortafro (XD)
// 3 jacha
// 4 tesoro
// 5 slot vaco

char objetos [] = {
	0, 0, 0, 0, 2, 4, 3, 0, 0, 0,
	3, 5, 0, 0, 0, 0, 0, 2, 3, 0,
	2, 0, 0, 4, 2, 3, 0, 0, 4, 3,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 1, 0,
	0, 4, 0, 0, 0, 0, 0, 0, 0, 3,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	0, 3, 0, 0, 0, 0, 0, 2, 0, 2,
	0, 0, 0, 0, 2, 0, 0, 0, 1, 0,
	1, 1, 0, 0, 0, 0, 0, 0, 1, 2
};

char objetos_g [100];
char objetos_t [] = {0, 44, 45, 46, 43, 48};

/********************
 Funciones auxiliares
 ********************/
 
unsigned char rand () {
	unsigned char res;

	#asm
	._Rand8 ld	a,9 	; Seed is usually 0
			ld	b,a
			add a,a
			add a,a
			add a,b
			inc a		; another possibility is ADD A,7
			ld (_Rand8+1),a
			ld (_asm_number), a
	#endasm

	res = asm_number [0];

	return res;
}

/*********************************
 Funciones de pintado de tilprites
 *********************************/

void put_3x3tilprite (unsigned char x, unsigned char y, unsigned char id) {
	int ct;
	
	// ct = id * 9
	// Fjate: id * 9 = id * 8 + id = (id << 3) + id
	
	ct = (id << 3) + id;
	
	cpc_SetTile (x	  , y	 , tilprites [ct ++]);
	cpc_SetTile (x + 1, y	 , tilprites [ct ++]);
	cpc_SetTile (x + 2, y	 , tilprites [ct ++]);
	
	cpc_SetTile (x	  , y + 1, tilprites [ct ++]);
	cpc_SetTile (x + 1, y + 1, tilprites [ct ++]);
	cpc_SetTile (x + 2, y + 1, tilprites [ct ++]);
	
	cpc_SetTile (x	  , y + 2, tilprites [ct ++]);
	cpc_SetTile (x + 1, y + 2, tilprites [ct ++]);
	cpc_SetTile (x + 2, y + 2, tilprites [ct ++]);
}

void put_3x3tilprite_touch (unsigned char x, unsigned char y, unsigned char id) {
	int ct;
	
	// ct = id * 9
	// Fjate: id * 9 = id * 8 + id = (id << 3) + id
	
	ct = (id << 3) + id;
	
	cpc_SetTouchTileXY (x	  , y	 , tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 1, y	 , tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 2, y	 , tilprites [ct ++]);
	
	cpc_SetTouchTileXY (x	  , y + 1, tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 1, y + 1, tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 2, y + 1, tilprites [ct ++]);
	
	cpc_SetTouchTileXY (x	  , y + 2, tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 1, y + 2, tilprites [ct ++]);
	cpc_SetTouchTileXY (x + 2, y + 2, tilprites [ct ++]);
}

/*
void put_2x2tilprite (unsigned char x, unsigned char y, unsigned char id) {
	unsigned char ct;
	
	ct = id << 2;	// id * 4;
 
	cpc_SetTile (x	  , y	 , minitilprites [ct ++]);
	cpc_SetTile (x + 1, y	 , minitilprites [ct ++]);
	cpc_SetTile (x	  , y + 1, minitilprites [ct ++]);
	cpc_SetTile (x + 1, y + 1, minitilprites [ct ++]);
}
*/

/********************************
 Funciones de render de pantallas
 ********************************/
 
void draw_marcador () {
	cpc_PutTile4x16 ( (unsigned int *) (objetos_marcador [nanako.o1 - 1]), (unsigned char *) (12), (unsigned char *) (180));
	cpc_PutTile4x16 ( (unsigned int *) (objetos_marcador [nanako.o2 - 1]), (unsigned char *) (18), (unsigned char *) (180));
	cpc_PutTile4x16 ( (unsigned int *) (objetos_marcador [nanako.o3 - 1]), (unsigned char *) (24), (unsigned char *) (180));
	cpc_PutTile4x16 ( (unsigned int *) (objetos_marcador [nanako.o4 - 1]), (unsigned char *) (30), (unsigned char *) (180));
}

void draw_lives () {
	cpc_PutTile2x8 ( (unsigned int *) (numeracos_marcador [0]), (unsigned char *) (44), (unsigned char *) (188));
	cpc_PutTile2x8 ( (unsigned int *) (numeracos_marcador [nanako.lives]), (unsigned char *) (46), (unsigned char *) (188));
}

void set_stored_palette (unsigned char paleta) {
	unsigned char i;
	
	paleta = paleta << 2;
	
	for (i = 0; i < 4; i ++)
		//cpc_SetInk (i, paletas [paleta + i]);		
		cpc_SetColour (i, paletas [paleta + i]);		
}

void set_palette (char pant) {
	set_stored_palette (que_paleta [pant]);
}

void clear_persistencias () {
	// Limpia el buffer de persistencias
	unsigned char i;
	for (i = 0; i < NUM_PERSISTENCIAS; i ++)
		persistencias [i].pant = 101;						// Fuera de rango. Sucio, feo, pero frkimente eficiente.
}

void add_persistencia (unsigned char pant, unsigned char x, unsigned char y) {
	// Aade una persistencia al mapa.	
	unsigned char i;
	for (i = 0; i < NUM_PERSISTENCIAS; i ++) {
		if (persistencias [i].pant == 101) {
			persistencias [i].pant = pant;
			persistencias [i].x = x;
			persistencias [i].y = y;
			break;	
		}
	}
}

void draw_screen (char pant) {
	// Dibuja la pantalla que recibe como parmetro.
	
	unsigned char x = 0, y = 0;
	unsigned char i, tile, tilel2, beh;
	unsigned int index, indexmasi, ct;
	
	// Calculamos el offset real de la pantalla que queremos dibujar.
	index = ((int)pant) * 49;

	for (i = 0; i < 49; i ++) {
		indexmasi = index + i;
		tile = map_buffer_r [i] = map_data [indexmasi];
		beh = map_buffer [i] = behaviour [tile - 1];		// Como te dejes un tile a 0 esto EXPLOTA.
		
		put_3x3tilprite (x, y, tile);
		
		if (!beh)
			if ((rand () & 7) == 3) 
				cpc_SetTile (x + (rand () % 3), y + (rand () % 3), 245);
		
		x += 3; 
		if (x == 21) {
			x = 0;
			y += 3;
		}
	}
	
	// Pintar objeto, si lo hay:
	
	if (objetos_g [pant]) {
		put_3x3tilprite (9, 9, objetos_t [objetos_g [pant]]);
		map_buffer [24] = 3;	
	}

	// Al azar, una de cada cuatro pantallas tiene un bisho.
	// Es posible que cambie esto en el futuro para que el bisho "aparezca"
	// en la pantalla estando ya en ella, como en el saimazoom.
	
	tiene_bisho = 0;
	
	if (pant != 95)
		if ( (rand () & 7) <= 3 ) {
			tiene_bisho = 1;
			do {
				bisho.x = 1 + (rand () % 5);
				bisho.y = 1 + (rand () % 5);
			} while (map_buffer [7 * bisho.y + bisho.x] != 0);
			
			bisho.cx = bisho.x = 3 * bisho.x;
			bisho.cy = bisho.y = 3 * bisho.y;
			
			bisho.frame = 61 + 2 * (rand () % 5);
			bisho.ct = 0;
			
			cpc_GetTiles (bisho.x, bisho.y, 3, 3, (int) (buffer_bisho));
			
			bisho.state = STATE_IDLE;
		}

	// Control de persistencias: rboles cortados o verjas rotas:

	for (i = 0; i < NUM_PERSISTENCIAS; i ++)
		if (persistencias [i].pant == pant) {
			beh = 7 * (persistencias [i].y / 3) + (persistencias [i].x / 3);
			map_buffer [beh] = 0;
			map_buffer_r [beh] = 1;
			put_3x3tilprite (persistencias [i].x, persistencias [i].y, 1);
		}
}

/***********************
 Funciones de movimiento
 ***********************/

void mueve_bicharracos () {
	unsigned char i;
	unsigned char xx, yy;
	unsigned char mapidx;
	
	if (tiene_bisho) {
		if (bisho.state == STATE_IDLE) {
			xx = bisho.x / 3; yy = bisho.y / 3;
			mapidx = 7 * yy + xx;
			bisho.ct = 0;
			
			i = rand () % 15;
			
			switch (i) {
				case 1:
					if (map_buffer [mapidx - 1] == 0 && bisho.x > 0) {
						bisho.state = STATE_WLEFT;
					}
					break;
				case 2:
					if (map_buffer [mapidx + 1] == 0 && bisho.x < 18) {
						bisho.state = STATE_WRIGHT;
					}
					break;
				case 3:
					if (map_buffer [mapidx - 7] == 0 && bisho.y > 0) {
						bisho.state = STATE_WUP;
					}
					break;
				case 4:
					if (map_buffer [mapidx + 7] == 0 && bisho.y < 18) {
						bisho.state = STATE_WDOWN;
					}
			}
		} else {
			switch (bisho.state) {
				case STATE_WLEFT:
					bisho.x --;
					break;
				case STATE_WRIGHT:
					bisho.x ++;
					break;
				case STATE_WUP:
					bisho.y --;
					break;
				case STATE_WDOWN:	
					bisho.y ++;
					break;
			}
			
			bisho.ct ++;
			if (bisho.ct == 3)
				bisho.state = STATE_IDLE;
		}
		
		bisho.paso = !bisho.paso;	// As parece que se estn haciendo pip tol rato
	}
}
 
void mueve () {
	unsigned char i;
	unsigned char xx, yy;
	unsigned char mapidx;
	
	nanako.colliding = 0;

	if (nanako.state == STATE_IDLE) {
		xx = nanako.x / 3; yy = nanako.y / 3;
		mapidx = 7 * yy + xx;
		nanako.ct = 0;
			
		if (cpc_TestKey (KEY_IZQ)) {
			nanako.facing = FACING_LEFT;
			if (map_buffer [mapidx - 1] == 0 && nanako.x > 0) {
				nanako.state = STATE_WLEFT;
				nanako.frame = 53;
			} else
				nanako.colliding = map_buffer_r [mapidx - 1];
		}
				
		if (cpc_TestKey (KEY_DER)) {
			nanako.facing = FACING_RIGHT;
			if (map_buffer [mapidx + 1] == 0 && nanako.x < 18) {
				nanako.state = STATE_WRIGHT;
				nanako.frame = 51;
			} else
				nanako.colliding = map_buffer_r [mapidx + 1];
		}
				
		if (cpc_TestKey (KEY_ARR)) {
			nanako.facing = FACING_UP;
			if (map_buffer [mapidx - 7] == 0 && nanako.y > 0) {
				nanako.state = STATE_WUP;
				nanako.frame = 57;
			} else
				nanako.colliding = map_buffer_r [mapidx - 7];
		}
				
		if (cpc_TestKey (KEY_ABA)) {
			nanako.facing = FACING_DOWN;
			if (map_buffer [mapidx + 7] == 0 && nanako.y < 18) {
				nanako.state = STATE_WDOWN;
				nanako.frame = 55;
			} else
				nanako.colliding = map_buffer_r [mapidx + 7];
		}
			
		if (nanako.state == STATE_IDLE) 
			nanako.paso = 0;
	} else {		
		switch (nanako.state) {
			case STATE_WLEFT:
				nanako.x --;
				break;
			case STATE_WRIGHT:
				nanako.x ++;
				break;
			case STATE_WUP:
				nanako.y --;
				break;
			case STATE_WDOWN:	
				nanako.y ++;
				break;
		}
		
		nanako.ct ++;
		if (nanako.ct == 3)
			nanako.state = STATE_IDLE;
			
		nanako.paso = !nanako.paso;
	}
}

void TouchTiles (unsigned char x, unsigned char y) {
	cpc_TouchTileXY (x	  , y	 );
	cpc_TouchTileXY (x + 1, y	 );
	cpc_TouchTileXY (x + 2, y	 );
	cpc_TouchTileXY (x	  , y + 1);
	cpc_TouchTileXY (x + 1, y + 1);
	cpc_TouchTileXY (x + 2, y + 1);
	cpc_TouchTileXY (x	  , y + 2);
	cpc_TouchTileXY (x + 1, y + 2);
	cpc_TouchTileXY (x + 2, y + 2);
}

/*************************
 Funciones de presentacin
 *************************/

void halt_me (void) {
	#asm
		halt				;unas esperas para que se actualicen los colores
		halt
		halt
		halt
		halt
	#endasm
}
 
void menu (void) {
	// Descomprimimos la cancin en el buffer de tiles
	cpc_UnExo ((unsigned int *) (song_1), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (1);
	cpc_WyzSetPlayerOn ();
	
	cpc_UnExo ((unsigned int *) (s_menu), (unsigned int *) (0xc000));
	set_stored_palette (9);
	halt_me ();
	
	while (cpc_AnyKeyPressed());
	while (!cpc_AnyKeyPressed()) {
		halflife = !halflife;
		
		#asm 
			halt
			halt
		#endasm
		
		if (halflife) {
			cpc_RRI (0xe000, 40, 79);
			cpc_RRI (0xe4b0, 32, 79);
		}
		
		cpc_RRI (0xe5f0, 32, 79);			
	}
	
	cpc_WyzSetPlayerOff ();
}

void game_over (void) {
	unsigned char i, j, k;
	
	// Descomprimimos la cancin en el buffer de tiles
	cpc_UnExo ((unsigned int *) (song_3), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (3);
	cpc_WyzSetPlayerOn ();
	
	cpc_UnExo ((unsigned int *) (s_gover), (unsigned int *) (0xc000));
	set_stored_palette (8);
	halt_me ();
	
	// Esperar hasta que acabe la msica
	
	// retardo cutre:
	for (k = 0; k < 2; k ++)
		for (i = 0; i < 180; i ++)
			for (j = 0; j < 255; j ++) { ; }
			
	cpc_WyzSetPlayerOff ();
	
	while (cpc_AnyKeyPressed());
	while (!cpc_AnyKeyPressed());
}

void final (void) {
	// Descomprimimos la cancin en el buffer de tiles
	cpc_UnExo ((unsigned int *) (song_0), (unsigned int *) (0x0100));
	cpc_WyzLoadSong (0);
	cpc_WyzSetPlayerOn ();
	
	cpc_UnExo ((unsigned int *) (s_final), (unsigned int *) (0xc000));
	set_stored_palette (8);
	halt_me ();
	
	while (cpc_AnyKeyPressed());
	while (!cpc_AnyKeyPressed());
	
	cpc_WyzSetPlayerOff ();
}

void interrupciones(void) {
	// Manejador de interrupciones por Artaburu
	
	#asm
		di
		ld hl,($0039)
		ld (_int_original),HL   //guardo el salto original

		ld HL,_interrupcion
		ld ($0039),HL
		ei
		jp term
	._int_original  
		defw 0
	._interrupcion
		ei
		ret
	.term
	#endasm
}

// *****************************************************************
// *****************************************************************
// *****************************************************************
// *****************************************************************
// *****************************************************************

void main (void) {
	unsigned char i, j, x, y;
	unsigned char flag1 = 0;
	unsigned char pant, npant;
	unsigned char changing, win, aux;
	int retardame;
	
	aftergame = 0;
	
	interrupciones ();
	halt_me ();
	
	set_stored_palette (7);
	halt_me ();
	cpc_SetMode (1);
	
	// Inicializamos el player de wyz:
	
	cpc_WyzInitPlayer (wyz_sound_table, wyz_pattern_table, wyz_effects_table, wyz_song_table);
	
	// Batera por el canal B:
	
	cpc_WyzConfigurePlayer (0);
	
	cpc_WyzSetBuffer (0xA500);
		
	//cpc_SetBorder (0);
	cpc_SetColour (16, 20);
	
	// Redefinimos las teclas
	
	cpc_AssignKey (KEY_IZQ, 0x4101);		// CUR LEFT
	cpc_AssignKey (KEY_DER, 0x4002);		// CUR RIGHT
	cpc_AssignKey (KEY_ARR, 0x4001);		// CUR UP
	cpc_AssignKey (KEY_ABA, 0x4004);		// CUR DOWN
	cpc_AssignKey (KEY_FIR, 0x4580);		// SPACE
	cpc_AssignKey (KEY_ESC, 0x4804);		// ESC
	
	// Bucle del juego
	
	while (1) {
		
		menu ();
		
		set_stored_palette (7);
		halt_me ();
		
		// Un pon
		
		npant = pant = 95;	
		flag1 = 0;
		
		// Inicializa Nanako
		
		nanako.cx = nanako.x = 9;
		nanako.cy = nanako.y = 15;
		nanako.state = STATE_IDLE;
		nanako.ct = 0;
		nanako.lives = 5;
		nanako.frame = 51;
		nanako.paso = 0;
		nanako.o1 = nanako.o2 = nanako.o3 = nanako.o4 = 5;
		changing = 0;
		win = 0;
		
		// Inicializa objetos
		
		for (i = 0; i < 100; i ++)
			objetos_g [i] = objetos [i];
		
		// Marco del juego
		
		cpc_UnExo ((unsigned int *) (s_marco), (unsigned int *) (0xc000));
		
		// Pinto la pantalla
		
		cpc_ResetTouchedTiles ();
		draw_screen (pant); 
		cpc_ShowTileMap (0);
		
		// Pongo la paleta correspondiente:
		
		set_palette (pant);
		oldpal = que_paleta [pant];
		
		// Pinto los marcadores
		
		draw_marcador ();
		draw_lives ();
		
		// Tomo el fondo de Nanako
		
		cpc_GetTiles (nanako.x, nanako.y, 3, 3, (int) (buffer_nanako));
		
		// Borro el buffer de persistencias
		
		clear_persistencias ();
		
		// Descomprimimos la cancin en el buffer de tiles
		cpc_UnExo ((unsigned int *) (song_2), (unsigned int *) (0x0100));
		cpc_WyzLoadSong (2);
		cpc_WyzSetPlayerOn ();
		
		while (!flag1) {
			if (cpc_TestKey (KEY_ESC)) 
				flag1 = 1;
			
			halflife = !halflife;
			
			// ***************************************************************
			// Cambio de pantalla:
			// ***************************************************************
			
			if (cpc_TestKey (KEY_IZQ) && nanako.x == 0) {
				nanako.x = 18;
				npant --;
				nanako.frame = 53;
			}
			
			if (cpc_TestKey (KEY_DER) && nanako.x == 18) {
				nanako.x = 0;
				npant ++;
				nanako.frame = 51;
			}
			
			if (cpc_TestKey (KEY_ARR) && nanako.y == 0) {
				nanako.y = 18;
				npant -= 10;
				nanako.frame = 57;
			}
				
			if (cpc_TestKey (KEY_ABA) && nanako.y == 18) {
				nanako.y = 0;
				npant += 10;
				nanako.frame = 55;
			}
				
			if (pant != npant) {
				pant = npant;
				
				cpc_ResetTouchedTiles ();
				draw_screen (pant);
				cpc_ShowTileMap (0);
				
				// Pongo la paleta correspondiente:
				
				if (que_paleta [pant] != oldpal) {
					set_palette (pant);
					oldpal = que_paleta [pant];
				}
		
				// Tomo el fondo de Nanako
		
				cpc_GetTiles (nanako.x, nanako.y, 3, 3, (int) (buffer_nanako));
				
				nanako.cx = nanako.x;
				nanako.cy = nanako.y;
			}
			
			// ***************************************************************
			// Cambio de objeto:
			// ***************************************************************
			
			if (objetos_g [pant]) {
				if (
						(cpc_TestKey (KEY_IZQ) && nanako.x == 12 && nanako.y == 9 ) ||
						(cpc_TestKey (KEY_DER) && nanako.x == 6 && nanako.y == 9 ) ||
						(cpc_TestKey (KEY_ARR) && nanako.x == 9 && nanako.y == 12 ) ||
						(cpc_TestKey (KEY_ABA) && nanako.x == 9 && nanako.y == 6 )
				) {
					if (!changing) {
						changing = 1;		// Para que haya que depulsar la tecla
						
						// Mira lo que hacemos:
						// AUX = OBJETO
						// OBJETO = O4
						// O4 = O3
						// O3 = O2
						// O2 = O1
						// O1 = AUX
						
						aux = objetos_g [pant];
						
						if (aux == 4)
							cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 0);
						else
							cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 1);
						
						objetos_g [pant] = nanako.o4;
						nanako.o4 = nanako.o3;
						nanako.o3 = nanako.o2;
						nanako.o2 = nanako.o1;
						nanako.o1 = aux;
						
						put_3x3tilprite_touch (9, 9, objetos_t [objetos_g [pant]]);
						draw_marcador ();
					}
				} else {
					changing = 0;
				}			
			}

			// ***************************************************************
			// Mover todos los tiestos
			// ***************************************************************

			mueve ();
			mueve_bicharracos ();
			
			// ***************************************************************
			// Uso de objetos en objetos fijos.
			// ***************************************************************
			
			if (nanako.colliding && cpc_TestKey (KEY_FIR)) {
				aux = 0;
				
				// Reja <-> Cortafro
				if (nanako.colliding == 40) {
					if (nanako.o1 == 2) {
						aux = 1;
						nanako.o1 = 5;
					} else if (nanako.o2 == 2) {
						aux = 1;
						nanako.o2 = 5;
					} else if (nanako.o3 == 2) {
						aux = 1;
						nanako.o3 = 5;
					} else if (nanako.o4 == 2) {
						aux = 1;
						nanako.o4 = 5;
					}
				}
				
				// rboles <-> Jacha
				if (nanako.colliding >= 12 && nanako.colliding <= 15) {
					if (nanako.o1 == 3) {
						aux = 2;
						nanako.o1 = 5;
					} else if (nanako.o2 == 3) {
						aux = 2;
						nanako.o2 = 5;
					} else if (nanako.o3 == 3) {
						aux = 2;
						nanako.o3 = 5;
					} else if (nanako.o4 == 3) {
						aux = 2;
						nanako.o4 = 5;
					}
				}
				
				// fer:
				if (aux != 0) {
					// Nos cargamos el tile que sea:
					
					if (aux == 1)
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 2);
					else
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 3);
					
					switch (nanako.facing) {
						case FACING_LEFT:
							x = nanako.x - 3;
							y = nanako.y; 
							break;
						case FACING_RIGHT:
							x = nanako.x + 3;
							y = nanako.y;
							break;
						case FACING_UP:
							x = nanako.x;
							y = nanako.y - 3;
							break;
						case FACING_DOWN:
							x = nanako.x;
							y = nanako.y + 3;
					}
					
					j = 7 * (y / 3) + (x / 3);
					map_buffer [j] = 0;
					map_buffer_r [j] = 1;
					
					put_3x3tilprite_touch (x, y, 1);
					draw_marcador ();
					add_persistencia (pant, x, y);
				}
			}
			
			// ***************************************************************
			// Hacer comprobaciones:
			// ***************************************************************
			
			// Vemos si te das un morrazo contra un bisho
			
			if (tiene_bisho) {
				if (bisho.x == nanako.x && bisho.y == nanako.y) {
					aux = 0;
					if (nanako.o1 == 1) {
						aux = 1;
						nanako.o1 = 5;
					} else if (nanako.o2 == 1) {
						aux = 1;
						nanako.o2 = 5;
					} else if (nanako.o3 == 1) {
						aux = 1;
						nanako.o3 = 5;
					} else if (nanako.o4 == 1) {
						aux = 1;
						nanako.o4 = 5;
					}
					
					if (aux) {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 4);
						draw_marcador ();	
					} else {
						cpc_WyzStartEffect (WYZ_CANAL_EFECTOS, 5);
						if (nanako.lives == 0) {
							flag1 = 1;
						} else {
							nanako.lives --;
							draw_lives ();
						}
					}
					
					cpc_PutTiles (bisho.cx, bisho.cy, 3, 3, (int) (buffer_bisho));
					// Hay que cambiar esto cuando haya una funcin en cpcrslib que lo haga:
					TouchTiles (bisho.cx, bisho.cy);
					
					tiene_bisho = 0;
				}
			}
			
			// Vemos si nos terminamos el juego. La condicin es estar en la
			// pantalla inicial (nmero 95) y que los cuatro objetos sean el 4
			// (o sea, el tesoro).
			
			if (pant == 95)
				if (nanako.o1 == 4)
					if (nanako.o2 == 4)
						if (nanako.o3 == 4)
							if (nanako.o4 == 4)  {
								win = 1;
								flag1 = 1;
							}
			
			// ***************************************************************
			// Dibujar tilprites:
			// ***************************************************************
			
			// RestoreBk
			cpc_PutTiles (nanako.cx, nanako.cy, 3, 3, (int) (buffer_nanako));
			TouchTiles (nanako.cx, nanako.cy);
			
			if (tiene_bisho) {
				cpc_PutTiles (bisho.cx, bisho.cy, 3, 3, (int) (buffer_bisho));
				TouchTiles (bisho.cx, bisho.cy);
			}
			
			// GetBk
			cpc_GetTiles (nanako.x, nanako.y, 3, 3, (int) (buffer_nanako));
			
			if (tiene_bisho)
				cpc_GetTiles (bisho.x, bisho.y, 3, 3, (int) (buffer_bisho));	
			
			// PutSprite
			put_3x3tilprite_touch (nanako.x, nanako.y, nanako.frame + nanako.paso);
			
			nanako.cx = nanako.x;
			nanako.cy = nanako.y;
			
			if (tiene_bisho) {
				put_3x3tilprite_touch (bisho.x, bisho.y, bisho.frame + bisho.paso);
	
				bisho.cx = bisho.x;
				bisho.cy = bisho.y;
			}
			
			// Si no hay bicho, vamos a meter un retardo "a ojo".
			if (!tiene_bisho) {
				for (retardame = 0; retardame < 250; retardame ++);
			}
			
			// ***************************************************************
			// Blit to screen
			// ***************************************************************
			
			cpc_UpdScr();					// Clear superbuffer
			cpc_ShowTouchedTiles ();		// Ensea lo que ha cambiado
			cpc_ResetTouchedTiles ();		// Borra la lista de cambios
		}
		
		aftergame = 1;
		set_stored_palette (7);
		
		halt_me ();
		halt_me ();
		
		cpc_WyzSetPlayerOff ();
		
		if (win) {
			final ();
		} else {
			game_over ();
		}

		set_stored_palette (7);
		halt_me ();
		halt_me ();
	}
}

// Yeeha.-
// Sprites para el marcador, pantallas comprimidas, gaitas escocesas y calamares en vinagre:

#asm
	
	._objetos_marcador_0_DATA
		defb $3F, $0, $0, $4F
		defb $6E, $F7, $FE, $27
		defb $EF, $73, $EC, $5F
		defb $DF, $B8, $D1, $2F
		defb $DF, $53, $EC, $9F
		defb $CE, $B7, $FE, $27
		defb $DC, $1F, $FF, $93
		defb $CD, $3F, $FF, $AA
		defb $45, $5F, $BF, $AA
		defb $CD, $3F, $1F, $AA
		defb $DC, $5F, $BF, $A2
		defb $8E, $2F, $FF, $37
		defb $4E, $97, $5E, $37
		defb $AF, $70, $E0, $7F
		defb $5F, $73, $EC, $EF
		defb $2F, $88, $11, $CF
	
	._objetos_marcador_1_DATA
		defb $3F, $FF, $4E, $1
		defb $7F, $FF, $98, $EC
		defb $EF, $F, $73, $EA
		defb $DF, $EE, $F7, $E6
		defb $DF, $9C, $FE, $EC
		defb $DF, $39, $FD, $CD
		defb $11, $BB, $FB, $D9
		defb $E, $73, $F7, $A3
		defb $9, $76, $FE, $37
		defb $9, $75, $EC, $2F
		defb $9, $7B, $81, $BF
		defb $7, $84, $7, $3F
		defb $8, $7, $27, $BF
		defb $AE, $8, $B, $7F
		defb $4E, $8, $3B, $EF
		defb $2F, $7, $3B, $CF
	
	._objetos_marcador_2_DATA
		defb $2E, $E0, $4E, $E4
		defb $6E, $60, $98, $EE
		defb $EE, $E0, $73, $7E
		defb $CE, $61, $FF, $FF
		defb $CE, $E1, $7F, $BF
		defb $CE, $61, $BF, $FF
		defb $CE, $E1, $7F, $BF
		defb $CE, $61, $3F, $FF
		defb $46, $E0, $53, $7E
		defb $CE, $60, $18, $EE
		defb $CE, $A0, $AE, $E4
		defb $8E, $60, $F, $11
		defb $4E, $A0, $AF, $BF
		defb $AE, $60, $F, $7F
		defb $4E, $A0, $FF, $EF
		defb $2E, $E0, $FF, $CF
	
	._objetos_marcador_3_DATA
		defb $3F, $CC, $13, $4F
		defb $7F, $B8, $C1, $AF
		defb $67, $18, $C1, $5F
		defb $57, $B8, $D1, $2F
		defb $57, $10, $C0, $9F
		defb $46, $E0, $70, $27
		defb $46, $C1, $B8, $17
		defb $46, $D1, $38, $27
		defb $57, $22, $44, $BF
		defb $DF, $66, $66, $2F
		defb $CE, $EE, $77, $37
		defb $8E, $CD, $3B, $37
		defb $4E, $CD, $BB, $37
		defb $AE, $EE, $77, $77
		defb $5F, $77, $EE, $EF
		defb $2F, $BB, $DD, $CF
	
	._objetos_marcador_4_DATA
		defb $3F, $FF, $5F, $4F
		defb $7F, $FF, $AF, $AF
		defb $EF, $F, $F, $5F
		defb $DF, $FF, $DF, $2F
		defb $DF, $AF, $AF, $9F
		defb $DF, $5F, $5F, $2F
		defb $DF, $AF, $AF, $9F
		defb $DF, $5F, $4F, $2F
		defb $57, $AF, $AF, $BF
		defb $DF, $5F, $F, $2F
		defb $DF, $AF, $AF, $BF
		defb $9F, $4F, $F, $3F
		defb $4F, $AF, $AF, $BF
		defb $AF, $F, $F, $7F
		defb $5F, $FF, $FF, $EF
		defb $2F, $AF, $FF, $CF

	._numeracos_marcador_0_DATA
		defb $33, $EE
		defb $22, $22
		defb $22, $22
		defb $22, $22
		defb $2, $2
		defb $2, $2
		defb $3, $E
		defb $0, $0

	._numeracos_marcador_1_DATA
		defb $0, $CC
		defb $0, $44
		defb $0, $44
		defb $0, $44
		defb $0, $4
		defb $0, $4
		defb $0, $4
		defb $0, $0
		
	._numeracos_marcador_2_DATA
		defb $33, $EE
		defb $22, $22
		defb $0, $22
		defb $33, $EE
		defb $2, $0
		defb $2, $2
		defb $3, $E
		defb $0, $0
		
	._numeracos_marcador_3_DATA
		defb $33, $EE
		defb $22, $44
		defb $0, $44
		defb $11, $CC
		defb $0, $4
		defb $2, $4
		defb $3, $E
		defb $0, $0
		
	._numeracos_marcador_4_DATA
		defb $22, $0
		defb $22, $0
		defb $22, $44
		defb $33, $EE
		defb $0, $4
		defb $0, $4
		defb $0, $E
		defb $0, $0

	._numeracos_marcador_5_DATA
		defb $33, $EE
		defb $22, $0
		defb $22, $0
		defb $33, $EE
		defb $0, $2
		defb $2, $2
		defb $3, $E
		defb $0, $0
/*
	._numeracos_marcador_6_DATA
		defb $33, $EE
		defb $22, $0
		defb $22, $0
		defb $33, $EE
		defb $2, $2
		defb $2, $2
		defb $3, $E
		defb $0, $0
		
	._numeracos_marcador_7_DATA
		defb $33, $EE
		defb $22, $44
		defb $0, $44
		defb $0, $44
		defb $0, $4
		defb $0, $4
		defb $0, $E
		defb $0, $0
		
	._numeracos_marcador_8_DATA
		defb $33, $EE
		defb $22, $22
		defb $22, $22
		defb $33, $EE
		defb $2, $2
		defb $2, $2
		defb $3, $E
		defb $0, $0
		
	._numeracos_marcador_9_DATA
		defb $33, $EE
		defb $22, $22
		defb $22, $22
		defb $33, $EE
		defb $0, $2
		defb $2, $2
		defb $3, $E
		defb $0, $0
*/	
	._s_menu
		BINARY "s_menu.bin"
	._s_marco
		BINARY "s_marco.bin"
	._s_gover
		BINARY "s_gover.bin"
	._s_final
		BINARY "s_final.bin"
#endasm

/* Cosas nuevas de CPCRSLIB para el men

Ya est la nueva rutina. Se llama cpc_RRI(posicin inicial, alto, ancho)
y te rotar lo que quieras, por ejemplo:
cpc_RRI(0xc050,16,50); (ADD Y X)

Ya ves que hay que usar como posicin inicial el valor de la memoria de pantalla.
Todava no lo voy a liberar as que te cuelgo la librera aqu:

http://www.amstrad.es/pruebas/cpcrslib200309(0).rar

Por cierto, he metido tambin la simtrica cpc_RLI por si quieres hacer ms cosillas.

cpc_RLI(0xc050+50,16,50); //este lo mueve pa'l otro lao.

*/


