; TILEMAPCONF PARA NANAKO DESCENDS TO HELL / CPC
; (C) 2009 THE MOJON TWINS

	XLIB TileMapConf
	
	XDEF tiles
	XDEF pantalla_juego
	XDEF tiles_tocados
	XDEF posiciones_pantalla
	XDEF posiciones_super_buffer
	
	XDEF posicion_inicial_area_visible
	XDEF posicion_inicial_superbuffer
	XDEF ancho_pantalla_bytes
	XDEF alto_pantalla_bytes
	XDEF ancho_pantalla_bytes_visible
	
	XDEF tile11

	XDEF mascara1
	XDEF mascara2
	
	; Voy a definir como mscara de los sprites el color 2
	
	; 0: $00, $00
	; 1: $80, $40
	; 2: $04, $08
	; 3: $44, $88
	; 4: $10, $20
	; 5: $50, $A0
	; 6: $14, $28
	; 7: $54, $A8
	; 8: $01, $02
	; 9: $41, $82
	; 10: $05, $0A
	; 11: $45, $8A
	; 12: $11, $22
	
	defc mascara1 = $04 ;
	defc mascara2 = $08 ;
	
	; Esto no se usa en este juego: NO HAY SPRITES.
	
; VALORES QUE DEFINEN EL BUFFER Y LA PANTALLA
	defc posicion_inicial_area_visible = $e05a ; del Excel de Arta: y = 12, x = 40 (5 chars, 10 bytes)
	defc posicion_inicial_superbuffer = $100
	
	defc T_WIDTH = 	21 ;32 ;28 ;32 ;28 ;16			;max=40		;dimensiones de la pantalla en tiles
	defc T_HEIGHT = 21 ;16							;max=20
		
	defc ancho_pantalla_bytes = 2*T_WIDTH ; 2*T_WIDTH;		; El ancho de pantalla influye determinantemente en 
															; numerosas rutinas que hay que actualizar si se cambia
															; OJO con el modo
	defc alto_pantalla_bytes = 8*T_HEIGHT ;
	
	defc ancho_pantalla_bytes_visible = 2*T_WIDTH ;32  ; 64;		;dentro del area definida, cuanto se debe mostrar. 2*T_WIDTH

;El tamao del buffer es ancho_pantalla_bytes*alto_pantalla_bytes


.TileMapConf

.posiciones_pantalla		; Posiciones en las que se dibujan los tiles
	defw posicion_inicial_area_visible+$50*0
	defw posicion_inicial_area_visible+$50*1  
	defw posicion_inicial_area_visible+$50*2
	defw posicion_inicial_area_visible+$50*3
	defw posicion_inicial_area_visible+$50*4
	defw posicion_inicial_area_visible+$50*5 
	defw posicion_inicial_area_visible+$50*6 
	defw posicion_inicial_area_visible+$50*7 
	defw posicion_inicial_area_visible+$50*8 
	defw posicion_inicial_area_visible+$50*9 
	defw posicion_inicial_area_visible+$50*10 
	defw posicion_inicial_area_visible+$50*11 
	defw posicion_inicial_area_visible+$50*12 
	defw posicion_inicial_area_visible+$50*13 
	defw posicion_inicial_area_visible+$50*14 
	defw posicion_inicial_area_visible+$50*15
	defw posicion_inicial_area_visible+$50*16
	defw posicion_inicial_area_visible+$50*17
	defw posicion_inicial_area_visible+$50*18
	defw posicion_inicial_area_visible+$50*19
	defw posicion_inicial_area_visible+$50*20
	;defw posicion_inicial_area_visible+$50*21
	;defw posicion_inicial_area_visible+$50*22
	;defw posicion_inicial_area_visible+$50*23

.posiciones_super_buffer	; muestra el inicio de cada lnea

	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*0
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*1
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*2
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*3
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*4
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*5
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*6
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*7
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*8
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*9
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*10
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*11
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*12
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*13
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*14
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*15
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*16
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*17
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*18
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*19
	defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*20
	;defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*21
	;defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*22
	;defw posicion_inicial_superbuffer+8*ancho_pantalla_bytes*23

;Rutinas para transferir bloques independientes a la pantalla

;Se busca el subbloque de 8x8 correspondiente a las coordenadas x,y
;el bloque se calcula dividiendo la coordenada x /8

.pantalla_actual 
	defw 0

.pantalla_juego  ;en tiles
	defs T_WIDTH*T_HEIGHT
	defb $FF	;Este byte es importante, marca el fin de la pantalla.

.tiles_tocados defs 150 ;150	;cuando un tile es tocado, se marca en esta tabla para luego restaurarlo. Es una tabla sin duplicados.

.tiles ;Son de 2x8 bytes

; Extraidos con Img2CPC de Augusto Ruiz
; Y modificado a manubrio para quitar los datos 
; que no se necesitan (dimensiones del tile).

; Data from file nanako--set-import-8x8.png (256x64)... Mode 1.
._tiles_nanako0
._tiles_nanako0_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako1
._tiles_nanako1_DATA
	defb $0, $0
	defb $0, $40
	defb $80, $0
	defb $10, $0
	defb $0, $20
	defb $20, $0
	defb $0, $0
	defb $0, $80
._tiles_nanako2
._tiles_nanako2_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $10, $0
	defb $0, $0
	defb $0, $0
	defb $80, $80
	defb $0, $0
._tiles_nanako3
._tiles_nanako3_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $0, $0
	defb $20, $0
	defb $0, $0
	defb $0, $40
	defb $0, $0
._tiles_nanako4
._tiles_nanako4_DATA
	defb $0, $0
	defb $43, $3C
	defb $87, $87
	defb $4B, $4B
	defb $A5, $A5
	defb $D2, $F
	defb $E1, $B4
	defb $F0, $F0
._tiles_nanako5
._tiles_nanako5_DATA
	defb $0, $0
	defb $0, $B4
	defb $49, $F
	defb $49, $87
	defb $1C, $4B
	defb $E0, $A5
	defb $E0, $D2
	defb $C0, $61
._tiles_nanako6
._tiles_nanako6_DATA
	defb $0, $0
	defb $A5, $84
	defb $F, $68
	defb $1E, $A4
	defb $87, $E
	defb $4B, $E
	defb $F0, $68
	defb $F0, $A4
._tiles_nanako7
._tiles_nanako7_DATA
	defb $0, $0
	defb $B4, $10
	defb $F, $A1
	defb $5A, $3
	defb $F, $92
	defb $A5, $83
	defb $5A, $A1
	defb $B4, $90
._tiles_nanako8
._tiles_nanako8_DATA
	defb $0, $0
	defb $3C, $F
	defb $5A, $4B
	defb $F0, $96
	defb $D2, $D2
	defb $A5, $87
	defb $1E, $1E
	defb $A5, $A5
._tiles_nanako9
._tiles_nanako9_DATA
	defb $0, $0
	defb $C0, $43
	defb $A4, $A5
	defb $4A, $C3
	defb $86, $A5
	defb $4A, $F0
	defb $2C, $B4
	defb $C0, $70
._tiles_nanako10
._tiles_nanako10_DATA
	defb $0, $0
	defb $30, $5A
	defb $61, $87
	defb $52, $D2
	defb $61, $87
	defb $70, $5A
	defb $70, $A5
	defb $30, $D2
._tiles_nanako11
._tiles_nanako11_DATA
	defb $0, $0
	defb $2C, $30
	defb $F, $43
	defb $1E, $52
	defb $1E, $61
	defb $3C, $70
	defb $96, $70
	defb $2C, $30
._tiles_nanako12
._tiles_nanako12_DATA
	defb $0, $0
	defb $5A, $5A
	defb $F, $F
	defb $4B, $F
	defb $A5, $A5
	defb $5A, $4B
	defb $A5, $F
	defb $E1, $96
._tiles_nanako13
._tiles_nanako13_DATA
	defb $0, $0
	defb $1, $0
	defb $1, $C
	defb $3, $48
	defb $0, $C
	defb $0, $84
	defb $0, $2C
	defb $0, $86
._tiles_nanako14
._tiles_nanako14_DATA
	defb $0, $C
	defb $0, $84
	defb $0, $C
	defb $0, $84
	defb $0, $48
	defb $0, $80
	defb $0, $8
	defb $0, $80
._tiles_nanako15
._tiles_nanako15_DATA
	defb $0, $0
	defb $0, $0
	defb $21, $0
	defb $7, $80
	defb $43, $8
	defb $12, $0
	defb $24, $24
	defb $42, $6
._tiles_nanako16
._tiles_nanako16_DATA
	defb $0, $86
	defb $0, $6
	defb $0, $42
	defb $0, $24
	defb $0, $52
	defb $0, $61
	defb $0, $30
	defb $0, $30
._tiles_nanako17
._tiles_nanako17_DATA
	defb $0, $80
	defb $0, $80
	defb $10, $8
	defb $1, $80
	defb $10, $8
	defb $10, $80
	defb $10, $80
	defb $10, $80
._tiles_nanako18
._tiles_nanako18_DATA
	defb $6, $42
	defb $42, $6
	defb $4, $42
	defb $48, $6
	defb $84, $48
	defb $C0, $84
	defb $C0, $48
	defb $81, $80
._tiles_nanako19
._tiles_nanako19_DATA
	defb $0, $30
	defb $0, $B8
	defb $22, $10
	defb $22, $54
	defb $22, $44
	defb $0, $33
	defb $11, $0
	defb $0, $44
._tiles_nanako20
._tiles_nanako20_DATA
	defb $10, $90
	defb $10, $90
	defb $90, $90
	defb $90, $90
	defb $0, $0
	defb $88, $44
	defb $11, $88
	defb $0, $0
._tiles_nanako21
._tiles_nanako21_DATA
	defb $90, $8
	defb $90, $80
	defb $92, $0
	defb $30, $44
	defb $30, $11
	defb $88, $88
	defb $77, $22
	defb $0, $0
._tiles_nanako22
._tiles_nanako22_DATA
	defb $0, $0
	defb $22, $88
	defb $44, $10
	defb $44, $70
	defb $0, $A5
	defb $10, $5A
	defb $10, $F
	defb $21, $F
._tiles_nanako23
._tiles_nanako23_DATA
	defb $0, $0
	defb $0, $30
	defb $E0, $F0
	defb $F0, $E1
	defb $E0, $D2
	defb $68, $A5
	defb $84, $43
	defb $68, $80
._tiles_nanako24
._tiles_nanako24_DATA
	defb $0, $0
	defb $80, $44
	defb $E0, $22
	defb $B4, $0
	defb $4B, $80
	defb $F, $48
	defb $F, $48
	defb $10, $2C
._tiles_nanako25
._tiles_nanako25_DATA
	defb $21, $1E
	defb $21, $48
	defb $21, $92
	defb $20, $2D
	defb $21, $F
	defb $21, $F
	defb $21, $F
	defb $10, $F
._tiles_nanako26
._tiles_nanako26_DATA
	defb $0, $61
	defb $F0, $52
	defb $78, $25
	defb $B4, $70
	defb $4A, $B0
	defb $A4, $80
	defb $58, $D0
	defb $1C, $D0
._tiles_nanako27
._tiles_nanako27_DATA
	defb $A4, $24
	defb $F, $28
	defb $F, $3C
	defb $F, $1E
	defb $87, $1E
	defb $61, $1E
	defb $90, $2C
	defb $4B, $24
._tiles_nanako28
._tiles_nanako28_DATA
	defb $10, $F
	defb $0, $87
	defb $0, $87
	defb $22, $43
	defb $22, $30
	defb $11, $0
	defb $0, $AA
	defb $0, $0
._tiles_nanako29
._tiles_nanako29_DATA
	defb $1C, $68
	defb $29, $A4
	defb $1A, $E
	defb $25, $1E
	defb $4B, $E
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
._tiles_nanako30
._tiles_nanako30_DATA
	defb $87, $48
	defb $F, $48
	defb $F, $80
	defb $1E, $0
	defb $E0, $22
	defb $0, $44
	defb $11, $88
	defb $0, $0
._tiles_nanako31
._tiles_nanako31_DATA
	defb $20, $40
	defb $72, $E4
	defb $F6, $F6
	defb $F4, $F2
	defb $F4, $F2
	defb $F6, $F6
	defb $73, $EC
	defb $30, $C0
._tiles_nanako32
._tiles_nanako32_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $3
	defb $0, $34
	defb $0, $68
	defb $1, $C0
	defb $11, $80
._tiles_nanako33
._tiles_nanako33_DATA
	defb $0, $0
	defb $0, $0
	defb $F, $8
	defb $F4, $C
	defb $F4, $86
	defb $44, $D2
	defb $0, $61
	defb $44, $21
._tiles_nanako34
._tiles_nanako34_DATA
	defb $0, $0
	defb $0, $0
	defb $C4, $42
	defb $42, $84
	defb $52, $8
	defb $21, $8
	defb $21, $8
	defb $90, $8
._tiles_nanako35
._tiles_nanako35_DATA
	defb $10, $0
	defb $0, $0
	defb $C4, $0
	defb $43, $0
	defb $30, $C
	defb $10, $87
	defb $31, $78
	defb $10, $90
._tiles_nanako36
._tiles_nanako36_DATA
	defb $0, $30
	defb $0, $21
	defb $0, $70
	defb $0, $61
	defb $0, $70
	defb $0, $E1
	defb $18, $D2
	defb $B4, $A5
._tiles_nanako37
._tiles_nanako37_DATA
	defb $58, $0
	defb $69, $0
	defb $4A, $0
	defb $E, $0
	defb $C, $0
	defb $C, $0
	defb $8, $0
	defb $0, $0
._tiles_nanako38
._tiles_nanako38_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $20, $20
	defb $0, $0
	defb $0, $0
	defb $10, $48
	defb $0, $B4
._tiles_nanako39
._tiles_nanako39_DATA
	defb $90, $4A
	defb $60, $86
	defb $90, $4
	defb $90, $4
	defb $60, $C
	defb $81, $2C
	defb $D2, $2D
	defb $A5, $1E
._tiles_nanako40
._tiles_nanako40_DATA
	defb $0, $0
	defb $0, $0
	defb $20, $20
	defb $0, $0
	defb $0, $0
	defb $12, $0
	defb $A4, $20
	defb $48, $0
._tiles_nanako41
._tiles_nanako41_DATA
	defb $0, $0
	defb $84, $0
	defb $46, $0
	defb $65, $0
	defb $21, $0
	defb $21, $0
	defb $30, $8
	defb $21, $80
._tiles_nanako42
._tiles_nanako42_DATA
	defb $0, $0
	defb $40, $88
	defb $5, $0
	defb $42, $0
	defb $4, $0
	defb $84, $22
	defb $8, $75
	defb $80, $32
._tiles_nanako43
._tiles_nanako43_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $4
	defb $0, $44
	defb $0, $AE
	defb $0, $44
	defb $0, $4
	defb $0, $4
._tiles_nanako44
._tiles_nanako44_DATA
	defb $30, $18
	defb $10, $18
	defb $10, $A5
	defb $0, $87
	defb $0, $C3
	defb $20, $87
	defb $0, $C3
	defb $0, $61
._tiles_nanako45
._tiles_nanako45_DATA
	defb $8, $10
	defb $18, $30
	defb $0, $21
	defb $0, $61
	defb $0, $43
	defb $8, $A5
	defb $1C, $78
	defb $2D, $C0
._tiles_nanako46
._tiles_nanako46_DATA
	defb $8, $4
	defb $8, $C0
	defb $0, $48
	defb $21, $80
	defb $3C, $0
	defb $C0, $0
	defb $0, $0
	defb $0, $80
._tiles_nanako47
._tiles_nanako47_DATA
	defb $0, $30
	defb $0, $10
	defb $0, $90
	defb $20, $10
	defb $52, $10
	defb $52, $E1
	defb $21, $4B
	defb $0, $0
._tiles_nanako48
._tiles_nanako48_DATA
	defb $1E, $80
	defb $B4, $80
	defb $96, $80
	defb $B4, $D0
	defb $1E, $69
	defb $2D, $96
	defb $C3, $78
	defb $0, $0
._tiles_nanako49
._tiles_nanako49_DATA
	defb $0, $0
	defb $0, $0
	defb $10, $8
	defb $80, $84
	defb $48, $84
	defb $3C, $48
	defb $C3, $80
	defb $0, $0
._tiles_nanako50
._tiles_nanako50_DATA
	defb $10, $E4
	defb $30, $EE
	defb $31, $FE
	defb $70, $FF
	defb $71, $FC
	defb $F2, $C8
	defb $E0, $90
	defb $F0, $31
._tiles_nanako51
._tiles_nanako51_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $C8, $0
	defb $CC, $72
._tiles_nanako52
._tiles_nanako52_DATA
	defb $0, $0
	defb $0, $80
	defb $10, $88
	defb $30, $80
	defb $30, $88
	defb $71, $C8
	defb $72, $CC
	defb $F1, $EC
._tiles_nanako53
._tiles_nanako53_DATA
	defb $70, $73
	defb $F2, $F7
	defb $71, $FF
	defb $F2, $FF
	defb $71, $FF
	defb $30, $FF
	defb $71, $F7
	defb $30, $FA
._tiles_nanako54
._tiles_nanako54_DATA
	defb $EE, $F6
	defb $FE, $FF
	defb $FC, $F7
	defb $FE, $FB
	defb $FC, $F7
	defb $F8, $FB
	defb $F4, $F5
	defb $D8, $F2
._tiles_nanako55
._tiles_nanako55_DATA
	defb $F2, $FC
	defb $F1, $EC
	defb $F0, $FC
	defb $F1, $E4
	defb $F0, $F8
	defb $F8, $E0
	defb $F0, $F0
	defb $B8, $E0
._tiles_nanako56
._tiles_nanako56_DATA
	defb $50, $F5
	defb $20, $F0
	defb $10, $70
	defb $0, $B0
	defb $40, $50
	defb $E0, $B0
	defb $40, $50
	defb $E0, $0
._tiles_nanako57
._tiles_nanako57_DATA
	defb $A0, $F1
	defb $10, $70
	defb $0, $A0
	defb $80, $10
	defb $40, $20
	defb $A0, $0
	defb $50, $50
	defb $0, $0
._tiles_nanako58
._tiles_nanako58_DATA
	defb $10, $F0
	defb $30, $E0
	defb $70, $D0
	defb $F0, $A0
	defb $50, $C0
	defb $B0, $A0
	defb $30, $C0
	defb $10, $10
._tiles_nanako59
._tiles_nanako59_DATA
	defb $0, $0
	defb $F, $68
	defb $2D, $B4
	defb $F, $68
	defb $2D, $A4
	defb $F, $68
	defb $F, $94
	defb $1E, $58
._tiles_nanako60
._tiles_nanako60_DATA
	defb $0, $0
	defb $30, $1E
	defb $61, $F
	defb $D2, $F
	defb $87, $F
	defb $C3, $F
	defb $87, $87
	defb $C3, $F
._tiles_nanako61
._tiles_nanako61_DATA
	defb $0, $0
	defb $10, $F
	defb $A1, $87
	defb $38, $4B
	defb $D0, $87
	defb $58, $4B
	defb $D0, $87
	defb $68, $D2
._tiles_nanako62
._tiles_nanako62_DATA
	defb $A5, $D0
	defb $5A, $38
	defb $B4, $B0
	defb $F0, $10
	defb $0, $0
	defb $10, $F0
	defb $B0, $5A
	defb $A1, $87
._tiles_nanako63
._tiles_nanako63_DATA
	defb $A5, $87
	defb $5A, $F
	defb $A5, $A5
	defb $F0, $F0
	defb $0, $0
	defb $F0, $10
	defb $5A, $B0
	defb $2D, $B0
._tiles_nanako64
._tiles_nanako64_DATA
	defb $A4, $A5
	defb $68, $D2
	defb $B4, $61
	defb $E0, $30
	defb $0, $0
	defb $F0, $F0
	defb $5A, $5A
	defb $87, $F
._tiles_nanako65
._tiles_nanako65_DATA
	defb $58, $4B
	defb $D0, $87
	defb $58, $F
	defb $E0, $A5
	defb $68, $C3
	defb $A4, $A5
	defb $78, $52
	defb $A4, $21
._tiles_nanako66
._tiles_nanako66_DATA
	defb $1E, $58
	defb $F, $94
	defb $1E, $58
	defb $87, $94
	defb $1E, $68
	defb $F, $A4
	defb $5A, $68
	defb $F0, $C0
._tiles_nanako67
._tiles_nanako67_DATA
	defb $4B, $F
	defb $A5, $F
	defb $4B, $1E
	defb $A5, $87
	defb $C3, $F
	defb $87, $87
	defb $D2, $1E
	defb $61, $A5
._tiles_nanako68
._tiles_nanako68_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $0, $30
	defb $0, $71
	defb $0, $73
	defb $0, $F1
._tiles_nanako69
._tiles_nanako69_DATA
	defb $0, $0
	defb $70, $0
	defb $F1, $F0
	defb $F0, $FD
	defb $FA, $F7
	defb $FF, $F3
	defb $FF, $F9
	defb $FF, $FC
._tiles_nanako70
._tiles_nanako70_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $C8, $0
	defb $EC, $0
	defb $FE, $80
	defb $FD, $C0
._tiles_nanako71
._tiles_nanako71_DATA
	defb $0, $F3
	defb $10, $F5
	defb $10, $F2
	defb $31, $F1
	defb $32, $F8
	defb $31, $F4
	defb $33, $FE
	defb $31, $FF
._tiles_nanako72
._tiles_nanako72_DATA
	defb $FF, $FA
	defb $FF, $FD
	defb $FA, $FA
	defb $F5, $F4
	defb $F2, $F8
	defb $F0, $F1
	defb $F0, $F0
	defb $F0, $F5
._tiles_nanako73
._tiles_nanako73_DATA
	defb $FE, $C8
	defb $F7, $E0
	defb $F3, $E8
	defb $F7, $E0
	defb $FA, $E8
	defb $F4, $E4
	defb $FA, $E2
	defb $FD, $F4
._tiles_nanako74

._tiles_nanako74_DATA
	defb $30, $FA
	defb $35, $F5
	defb $10, $FA
	defb $0, $F0
	defb $4, $A0
	defb $3, $10
	defb $0, $4
	defb $0, $0
._tiles_nanako75

._tiles_nanako75_DATA
	defb $F8, $FF
	defb $F4, $F7
	defb $F0, $FA
	defb $50, $F5
	defb $A0, $F0
	defb $50, $50
	defb $0, $0
	defb $4, $1
._tiles_nanako76

._tiles_nanako76_DATA
	defb $FE, $FA
	defb $FF, $FE
	defb $FA, $EA
	defb $F5, $E4
	defb $F0, $C8
	defb $50, $1
	defb $0, $4
	defb $1, $8
._tiles_nanako77

._tiles_nanako77_DATA
	defb $0, $70
	defb $10, $F7
	defb $31, $EF
	defb $73, $FF
	defb $73, $FF
	defb $71, $EF
	defb $70, $F7
	defb $70, $F0
._tiles_nanako78

._tiles_nanako78_DATA
	defb $F0, $F0
	defb $FF, $FF
	defb $AF, $AF
	defb $DF, $5F
	defb $FF, $EF
	defb $DF, $5F
	defb $FF, $FF
	defb $F0, $F0
._tiles_nanako79

._tiles_nanako79_DATA
	defb $E0, $0
	defb $FE, $80
	defb $1F, $C8
	defb $4F, $6C
	defb $8F, $6C
	defb $5F, $E8
	defb $FE, $E4
	defb $F1, $EC
._tiles_nanako80

._tiles_nanako80_DATA
	defb $30, $F2
	defb $10, $F1
	defb $10, $F0
	defb $10, $7A
	defb $10, $E5
	defb $10, $5B
	defb $10, $F7
	defb $10, $5B
._tiles_nanako81

._tiles_nanako81_DATA
	defb $FB, $FF
	defb $F5, $F7
	defb $F0, $F0
	defb $FA, $FF
	defb $EF, $7F
	defb $5F, $AF
	defb $FF, $FF
	defb $5F, $AF
._tiles_nanako82

._tiles_nanako82_DATA
	defb $FF, $C8
	defb $FE, $80
	defb $F1, $80
	defb $EF, $80
	defb $7F, $80
	defb $AF, $80
	defb $FF, $80
	defb $AF, $80
._tiles_nanako83

._tiles_nanako83_DATA
	defb $10, $D7
	defb $10, $5B
	defb $10, $F7
	defb $30, $D3
	defb $70, $F0
	defb $70, $F0
	defb $30, $F0
	defb $10, $F1
._tiles_nanako84

._tiles_nanako84_DATA
	defb $FF, $FF
	defb $5F, $AF
	defb $FF, $FF
	defb $5F, $AF
	defb $FF, $FF
	defb $F0, $F0
	defb $FB, $FF
	defb $F5, $F7
._tiles_nanako85

._tiles_nanako85_DATA
	defb $BF, $80
	defb $AF, $80
	defb $FF, $80
	defb $BE, $C8
	defb $F1, $EC
	defb $FF, $EC
	defb $FF, $C8
	defb $FE, $80
._tiles_nanako86

._tiles_nanako86_DATA
	defb $3, $C
	defb $25, $E
	defb $F, $E
	defb $A5, $2C
	defb $5A, $68
	defb $E1, $C1
	defb $30, $D0
	defb $0, $0
._tiles_nanako87

._tiles_nanako87_DATA
	defb $0, $0
	defb $43, $3
	defb $96, $29
	defb $F, $94
	defb $1E, $D0
	defb $A5, $C0
	defb $F0, $80
	defb $60, $0
._tiles_nanako88

._tiles_nanako88_DATA
	defb $0, $E
	defb $2C, $16
	defb $96, $34
	defb $4B, $70
	defb $A5, $34
	defb $D2, $70
	defb $60, $70
	defb $0, $20
._tiles_nanako89

._tiles_nanako89_DATA
	defb $0, $12
	defb $E, $25
	defb $87, $70
	defb $5A, $70
	defb $A5, $70
	defb $78, $30
	defb $E0, $10
	defb $0, $0
._tiles_nanako90

._tiles_nanako90_DATA
	defb $3, $2C
	defb $A5, $E
	defb $4B, $4A
	defb $A5, $A4
	defb $D2, $68
	defb $A5, $D0
	defb $F0, $80
	defb $0, $0
._tiles_nanako91

._tiles_nanako91_DATA
	defb $0, $0
	defb $52, $30
	defb $87, $B0
	defb $A5, $49
	defb $5A, $58
	defb $B4, $C0
	defb $F0, $80
	defb $0, $0
._tiles_nanako92

._tiles_nanako92_DATA
	defb $52, $30
	defb $A5, $B0
	defb $D2, $D0
	defb $E0, $90
	defb $50, $40
	defb $A0, $80
	defb $40, $0
	defb $0, $0
._tiles_nanako93

._tiles_nanako93_DATA
	defb $A4, $30
	defb $5A, $50
	defb $F0, $20
	defb $50, $50
	defb $B0, $30
	defb $60, $40
	defb $0, $20
	defb $0, $0
._tiles_nanako94

._tiles_nanako94_DATA
	defb $21, $C0
	defb $52, $68
	defb $E1, $E0
	defb $50, $E0
	defb $A0, $C0
	defb $50, $90
	defb $0, $40
	defb $0, $0
._tiles_nanako95

._tiles_nanako95_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $0, $31
	defb $0, $73
._tiles_nanako96

._tiles_nanako96_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $30, $C0
	defb $F3, $FC
	defb $FF, $FF
	defb $FF, $FF
	defb $FF, $FF
._tiles_nanako97

._tiles_nanako97_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $C8, $0
	defb $EC, $0
._tiles_nanako98

._tiles_nanako98_DATA
	defb $0, $73
	defb $0, $F5
	defb $0, $F3
	defb $0, $F5
	defb $0, $F3
	defb $0, $F1
	defb $0, $F0
	defb $0, $F0
._tiles_nanako99

._tiles_nanako99_DATA
	defb $F3, $F4
	defb $F5, $F5
	defb $F3, $F4
	defb $F5, $F5
	defb $FF, $FF
	defb $FF, $FF
	defb $FA, $FF
	defb $F5, $F5
._tiles_nanako100

._tiles_nanako100_DATA
	defb $EC, $0
	defb $F6, $0
	defb $FE, $0
	defb $FE, $0
	defb $FE, $0
	defb $FE, $0
	defb $FE, $0
	defb $FE, $0
._tiles_nanako101

._tiles_nanako101_DATA
	defb $0, $F0
	defb $0, $87
	defb $10, $4B
	defb $21, $A5
	defb $70, $D2
	defb $0, $0
	defb $70, $E1
	defb $70, $D2
._tiles_nanako102

._tiles_nanako102_DATA
	defb $F0, $F0
	defb $F, $F
	defb $F, $2D
	defb $87, $87
	defb $2D, $F
	defb $0, $0
	defb $96, $78
	defb $C3, $2D
._tiles_nanako103

._tiles_nanako103_DATA
	defb $F0, $0
	defb $1E, $0
	defb $F, $80
	defb $4B, $48
	defb $F, $2C
	defb $0, $0
	defb $2D, $E0
	defb $4B, $68
._tiles_nanako104

._tiles_nanako104_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $31
	defb $0, $30
	defb $0, $31
._tiles_nanako105

._tiles_nanako105_DATA
	defb $0, $0
	defb $31, $CC
	defb $30, $CC
	defb $31, $CC
	defb $30, $CC
	defb $EF, $7F
	defb $DC, $B7
	defb $D4, $B7
._tiles_nanako106

._tiles_nanako106_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $CC, $0
	defb $CC, $0
	defb $CC, $0
._tiles_nanako107

._tiles_nanako107_DATA
	defb $0, $30
	defb $0, $3
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako108

._tiles_nanako108_DATA
	defb $E2, $76
	defb $3D, $CF
	defb $31, $CC
	defb $30, $CC
	defb $31, $CC
	defb $30, $CC
	defb $31, $CC
	defb $30, $CC
._tiles_nanako109

._tiles_nanako109_DATA
	defb $C8, $0
	defb $C, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako110

._tiles_nanako110_DATA
	defb $10, $E0
	defb $31, $F4
	defb $72, $F2
	defb $F4, $F5
	defb $F4, $F8
	defb $F5, $F3
	defb $F5, $F0
	defb $F4, $F5
._tiles_nanako111

._tiles_nanako111_DATA
	defb $0, $30
	defb $0, $73
	defb $0, $73
	defb $80, $31
	defb $E0, $31
	defb $FE, $31
	defb $F3, $F3
	defb $F5, $F6
._tiles_nanako112

._tiles_nanako112_DATA
	defb $E0, $0
	defb $FE, $0
	defb $F3, $80
	defb $F9, $C8
	defb $F4, $EC
	defb $F2, $E4
	defb $F2, $E0
	defb $70, $E4
._tiles_nanako113

._tiles_nanako113_DATA
	defb $F1, $F5
	defb $F4, $F7
	defb $40, $73
	defb $0, $F0
	defb $10, $FD
	defb $71, $F9
	defb $F5, $D0
	defb $F6, $91
._tiles_nanako114

._tiles_nanako114_DATA
	defb $F5, $E0
	defb $FD, $E8
	defb $FD, $F2
	defb $F3, $FD
	defb $FF, $FA
	defb $F5, $F9
	defb $FA, $FC
	defb $F0, $EC
._tiles_nanako115

._tiles_nanako115_DATA
	defb $72, $E0
	defb $20, $E4
	defb $0, $40
	defb $80, $0
	defb $C0, $0
	defb $C0, $0
	defb $E8, $0
	defb $F4, $0
._tiles_nanako116

._tiles_nanako116_DATA
	defb $60, $11
	defb $0, $32
	defb $0, $31
	defb $0, $70
	defb $11, $BF
	defb $10, $BF
	defb $11, $FF
	defb $10, $FA
._tiles_nanako117

._tiles_nanako117_DATA
	defb $FF, $E4
	defb $F8, $FE
	defb $C8, $F6
	defb $80, $30
	defb $7F, $5F
	defb $FF, $7F
	defb $FF, $FF
	defb $FA, $FA
._tiles_nanako118

._tiles_nanako118_DATA
	defb $72, $0
	defb $60, $0
	defb $0, $0
	defb $0, $0
	defb $F8, $80
	defb $F8, $80
	defb $F8, $80
	defb $F8, $80
._tiles_nanako119

._tiles_nanako119_DATA
	defb $0, $0
	defb $0, $0
	defb $22, $88
	defb $75, $C4
	defb $22, $88
	defb $22, $88
	defb $22, $88
	defb $22, $44
._tiles_nanako120

._tiles_nanako120_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $44, $44
	defb $EA, $D9
	defb $44, $55
	defb $44, $55
	defb $44, $99
._tiles_nanako121

._tiles_nanako121_DATA
	defb $0, $0
	defb $44, $0
	defb $EA, $0
	defb $44, $22
	defb $44, $75
	defb $22, $22
	defb $22, $22
	defb $22, $0
._tiles_nanako122

._tiles_nanako122_DATA
	defb $22, $44
	defb $AF, $5F
	defb $22, $44
	defb $22, $44
	defb $22, $4
	defb $2, $44
	defb $22, $46
	defb $22, $26
._tiles_nanako123

._tiles_nanako123_DATA
	defb $44, $99
	defb $4F, $9F
	defb $44, $99
	defb $4, $99
	defb $44, $99
	defb $4, $99
	defb $44, $89
	defb $44, $19
._tiles_nanako124

._tiles_nanako124_DATA
	defb $22, $22
	defb $2F, $AF
	defb $22, $22
	defb $22, $22
	defb $22, $22
	defb $2, $26
	defb $22, $46
	defb $22, $46
._tiles_nanako125

._tiles_nanako125_DATA
	defb $22, $26
	defb $2, $22
	defb $22, $22
	defb $2, $22
	defb $22, $22
	defb $2, $2
	defb $F2, $F2
	defb $F, $F
._tiles_nanako126

._tiles_nanako126_DATA
	defb $45, $99
	defb $45, $99
	defb $55, $9
	defb $15, $11
	defb $45, $11
	defb $55, $11
	defb $F5, $F1
	defb $F, $F
._tiles_nanako127

._tiles_nanako127_DATA
	defb $22, $44
	defb $22, $44
	defb $2, $44
	defb $22, $44
	defb $22, $4
	defb $22, $44
	defb $F2, $F4
	defb $F, $F
._tiles_nanako128

._tiles_nanako128_DATA
	defb $A0, $A0
	defb $50, $14
	defb $A4, $29
	defb $58, $50
	defb $A0, $A0
	defb $14, $5
	defb $82, $A0
	defb $50, $50
._tiles_nanako129

._tiles_nanako129_DATA
	defb $A0, $A0
	defb $50, $50
	defb $29, $28
	defb $50, $50
	defb $A0, $A0
	defb $52, $14
	defb $A0, $83
	defb $50, $50
._tiles_nanako130

._tiles_nanako130_DATA
	defb $A0, $A0
	defb $50, $50
	defb $82, $A
	defb $58, $41
	defb $A0, $A0
	defb $50, $58
	defb $A0, $82
	defb $50, $50
._tiles_nanako131

._tiles_nanako131_DATA
	defb $A0, $A0
	defb $52, $52
	defb $A0, $A0
	defb $50, $52
	defb $82, $A0
	defb $50, $14
	defb $A0, $A0
	defb $52, $14
._tiles_nanako132

._tiles_nanako132_DATA
	defb $A0, $28
	defb $52, $14
	defb $A4, $A0
	defb $50, $50
	defb $A0, $A4
	defb $52, $52
	defb $A0, $A0
	defb $52, $14
._tiles_nanako133

._tiles_nanako133_DATA
	defb $A4, $A0
	defb $14, $14
	defb $A0, $A4
	defb $50, $50
	defb $28, $A4
	defb $14, $58
	defb $A4, $A4
	defb $14, $58
._tiles_nanako134

._tiles_nanako134_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $90
	defb $0, $A0
	defb $10, $0
	defb $10, $0
	defb $10, $10
._tiles_nanako135

._tiles_nanako135_DATA
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $20, $20
	defb $0, $0
	defb $10, $BB
	defb $31, $BB
._tiles_nanako136

._tiles_nanako136_DATA
	defb $C0, $0
	defb $20, $0
	defb $10, $0
	defb $90, $0
	defb $40, $80
	defb $0, $80
	defb $66, $0
	defb $66, $0
._tiles_nanako137

._tiles_nanako137_DATA
	defb $20, $31
	defb $20, $31
	defb $20, $10
	defb $40, $0
	defb $40, $0
	defb $40, $31
	defb $20, $F7
	defb $0, $EC
._tiles_nanako138

._tiles_nanako138_DATA
	defb $73, $FB
	defb $73, $FF
	defb $73, $FC
	defb $73, $FF
	defb $30, $C0
	defb $7F, $EF
	defb $BF, $FF
	defb $87, $4F
._tiles_nanako139

._tiles_nanako139_DATA
	defb $E6, $0
	defb $EE, $0
	defb $EC, $0
	defb $D8, $0
	defb $0, $80
	defb $0, $80
	defb $F4, $0
	defb $F6, $0
._tiles_nanako140

._tiles_nanako140_DATA
	defb $10, $C8
	defb $11, $88
	defb $31, $80
	defb $11, $10
	defb $0, $11
	defb $0, $31
	defb $0, $33
	defb $0, $31
._tiles_nanako141

._tiles_nanako141_DATA
	defb $F, $F
	defb $F7, $FF
	defb $F, $F
	defb $ED, $3D
	defb $FE, $73
	defb $EC, $33
	defb $C8, $33
	defb $EC, $33
._tiles_nanako142

._tiles_nanako142_DATA
	defb $3B, $80
	defb $31, $88
	defb $11, $80
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $C8, $0
	defb $EC, $0
._tiles_nanako143

._tiles_nanako143_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $90
	defb $10, $20
	defb $10, $0
	defb $20, $0
._tiles_nanako144

._tiles_nanako144_DATA
	defb $0, $0
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $0, $40
	defb $20, $20
	defb $0, $0
	defb $10, $BB
._tiles_nanako145

._tiles_nanako145_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $10, $0
	defb $90, $0
	defb $40, $80
	defb $0, $80
	defb $66, $0
._tiles_nanako146

._tiles_nanako146_DATA
	defb $20, $10
	defb $20, $31
	defb $40, $31
	defb $40, $10
	defb $80, $0
	defb $40, $0
	defb $30, $31
	defb $0, $F7
._tiles_nanako147

._tiles_nanako147_DATA
	defb $31, $BB
	defb $73, $FB
	defb $73, $FF
	defb $73, $FC
	defb $73, $FF
	defb $30, $C0
	defb $7F, $EF
	defb $BF, $FF
._tiles_nanako148

._tiles_nanako148_DATA
	defb $66, $0
	defb $E6, $0
	defb $EE, $0
	defb $EC, $0
	defb $D8, $0
	defb $0, $80
	defb $10, $0
	defb $F6, $0
._tiles_nanako149

._tiles_nanako149_DATA
	defb $31, $EC
	defb $73, $80
	defb $20, $0
	defb $0, $0
	defb $0, $10
	defb $0, $31
	defb $0, $72
	defb $0, $77
._tiles_nanako150

._tiles_nanako150_DATA
	defb $87, $4F
	defb $F, $F
	defb $F7, $FF
	defb $F, $F
	defb $EF, $3D
	defb $FF, $7B
	defb $80, $10
	defb $C8, $0
._tiles_nanako151

._tiles_nanako151_DATA
	defb $F3, $80
	defb $39, $EC
	defb $0, $C8
	defb $0, $0
	defb $80, $80
	defb $FD, $80
	defb $F7, $0
	defb $31, $0
._tiles_nanako152

._tiles_nanako152_DATA
	defb $0, $30
	defb $0, $40
	defb $0, $80
	defb $0, $90
	defb $10, $20
	defb $10, $0
	defb $0, $66
	defb $0, $66
._tiles_nanako153

._tiles_nanako153_DATA
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $20, $0
	defb $40, $40
	defb $0, $0
	defb $DD, $80
	defb $DD, $C8
._tiles_nanako154

._tiles_nanako154_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $90, $0
	defb $50, $0
	defb $0, $80
	defb $0, $80
	defb $80, $80
._tiles_nanako155

._tiles_nanako155_DATA
	defb $0, $76
	defb $0, $77
	defb $0, $73
	defb $0, $B1
	defb $10, $0
	defb $10, $0
	defb $0, $F2
	defb $0, $F6
._tiles_nanako156

._tiles_nanako156_DATA
	defb $FD, $EC
	defb $FF, $EC
	defb $F3, $EC
	defb $FF, $EC
	defb $30, $C0
	defb $7F, $EF
	defb $FF, $DF
	defb $2F, $1E
._tiles_nanako157

._tiles_nanako157_DATA
	defb $C8, $40
	defb $C8, $40
	defb $80, $40
	defb $0, $20
	defb $0, $20
	defb $C8, $20
	defb $FE, $40
	defb $73, $0
._tiles_nanako158

._tiles_nanako158_DATA
	defb $10, $CD
	defb $11, $C8
	defb $10, $88
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $0, $31
	defb $0, $73
._tiles_nanako159

._tiles_nanako159_DATA
	defb $F, $F
	defb $FF, $FE
	defb $F, $F
	defb $CB, $7B
	defb $EC, $F7
	defb $CC, $73
	defb $CC, $31
	defb $CC, $73
._tiles_nanako160

._tiles_nanako160_DATA
	defb $31, $80
	defb $11, $88
	defb $10, $C8
	defb $80, $88
	defb $88, $0
	defb $C8, $0
	defb $CC, $0
	defb $C8, $0
._tiles_nanako161

._tiles_nanako161_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $80
	defb $0, $90
	defb $10, $20
	defb $10, $0
	defb $0, $66
._tiles_nanako162

._tiles_nanako162_DATA
	defb $0, $0
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $20, $0
	defb $40, $40
	defb $0, $0
	defb $DD, $80
._tiles_nanako163

._tiles_nanako163_DATA
	defb $0, $0
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $90, $0
	defb $40, $80
	defb $0, $80
	defb $0, $40
._tiles_nanako164

._tiles_nanako164_DATA
	defb $0, $66
	defb $0, $76
	defb $0, $77
	defb $0, $73
	defb $0, $B1
	defb $10, $0
	defb $0, $80
	defb $0, $F6
._tiles_nanako165

._tiles_nanako165_DATA
	defb $DD, $C8
	defb $FD, $EC
	defb $FF, $EC
	defb $F3, $EC
	defb $FF, $EC
	defb $30, $C0
	defb $7F, $EF
	defb $FF, $DF
._tiles_nanako166

._tiles_nanako166_DATA
	defb $80, $40
	defb $C8, $40
	defb $C8, $20
	defb $80, $20
	defb $0, $10
	defb $0, $20
	defb $C8, $C0
	defb $FE, $0
._tiles_nanako167

._tiles_nanako167_DATA
	defb $10, $FC
	defb $73, $C9
	defb $31, $0
	defb $0, $0
	defb $10, $10
	defb $10, $FB
	defb $0, $FE
	defb $0, $C8
._tiles_nanako168

._tiles_nanako168_DATA
	defb $2F, $1E
	defb $F, $F
	defb $FF, $FE
	defb $F, $F
	defb $CB, $7F
	defb $ED, $FF
	defb $80, $10
	defb $0, $31
._tiles_nanako169

._tiles_nanako169_DATA
	defb $73, $C8
	defb $10, $EC
	defb $0, $40
	defb $0, $0
	defb $80, $0
	defb $C8, $0
	defb $E4, $0
	defb $EE, $0
._tiles_nanako170

._tiles_nanako170_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $80
	defb $10, $0
	defb $10, $0
	defb $10, $10
	defb $20, $51
._tiles_nanako171

._tiles_nanako171_DATA
	defb $F0, $F0
	defb $0, $0
	defb $40, $10
	defb $90, $0
	defb $0, $0
	defb $31, $C8
	defb $BB, $DD
	defb $BB, $DD
._tiles_nanako172

._tiles_nanako172_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $90, $0
	defb $0, $80
	defb $0, $80
	defb $80, $80
	defb $A8, $40
._tiles_nanako173

._tiles_nanako173_DATA
	defb $20, $75
	defb $20, $75
	defb $20, $50
	defb $40, $0
	defb $40, $10
	defb $50, $73
	defb $20, $F7
	defb $0, $76
._tiles_nanako174

._tiles_nanako174_DATA
	defb $FB, $FD
	defb $FF, $FF
	defb $FE, $F7
	defb $F7, $FE
	defb $BC, $D3
	defb $7F, $EF
	defb $7F, $EF
	defb $1F, $8F
._tiles_nanako175

._tiles_nanako175_DATA
	defb $EA, $40
	defb $EA, $40
	defb $A0, $40
	defb $0, $20
	defb $80, $20
	defb $CC, $A0
	defb $FE, $40
	defb $E6, $0
._tiles_nanako176

._tiles_nanako176_DATA
	defb $0, $64
	defb $0, $62
	defb $0, $64
	defb $0, $0
	defb $0, $0
	defb $0, $11
	defb $0, $11
	defb $0, $11
._tiles_nanako177

._tiles_nanako177_DATA
	defb $F, $F
	defb $F7, $FE
	defb $F, $F
	defb $CF, $F7
	defb $EF, $77
	defb $C8, $72
	defb $80, $20
	defb $EC, $0
._tiles_nanako178

._tiles_nanako178_DATA
	defb $73, $0
	defb $31, $88
	defb $11, $80
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako179

._tiles_nanako179_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $90
	defb $10, $0
	defb $10, $0
	defb $10, $10
	defb $20, $51
._tiles_nanako180

._tiles_nanako180_DATA
	defb $F0, $F0
	defb $0, $0
	defb $80, $20
	defb $0, $90
	defb $0, $0
	defb $31, $C8
	defb $BB, $DD
	defb $BB, $DD
._tiles_nanako181

._tiles_nanako181_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $10, $0
	defb $0, $80
	defb $0, $80
	defb $80, $80
	defb $A8, $40
._tiles_nanako182

._tiles_nanako182_DATA
	defb $20, $75
	defb $20, $75
	defb $20, $50
	defb $40, $0
	defb $40, $10
	defb $50, $33
	defb $20, $F7
	defb $0, $76
._tiles_nanako183

._tiles_nanako183_DATA
	defb $FB, $FD
	defb $FF, $FF
	defb $FE, $F7
	defb $F7, $FE
	defb $BC, $D3
	defb $7F, $EF
	defb $7F, $EF
	defb $1F, $8F
._tiles_nanako184

._tiles_nanako184_DATA
	defb $EA, $40
	defb $EA, $40
	defb $A0, $40
	defb $0, $20
	defb $80, $20
	defb $EC, $A0
	defb $FE, $40
	defb $E6, $0
._tiles_nanako185

._tiles_nanako185_DATA
	defb $0, $EC
	defb $11, $C8
	defb $10, $88
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako186

._tiles_nanako186_DATA
	defb $F, $F
	defb $F7, $FE
	defb $F, $F
	defb $FE, $3F
	defb $EE, $7F
	defb $E4, $31
	defb $40, $10
	defb $0, $73
._tiles_nanako187

._tiles_nanako187_DATA
	defb $62, $0
	defb $64, $0
	defb $62, $0
	defb $0, $0
	defb $0, $0
	defb $88, $0
	defb $88, $0
	defb $88, $0
._tiles_nanako188

._tiles_nanako188_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $80
	defb $10, $10
	defb $10, $30
	defb $10, $30
	defb $20, $0
._tiles_nanako189

._tiles_nanako189_DATA
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $10, $30
	defb $D0, $F0
	defb $60, $D0
	defb $0, $10
._tiles_nanako190

._tiles_nanako190_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $10, $0
	defb $40, $80
	defb $A0, $80
	defb $0, $80
	defb $80, $40
._tiles_nanako191

._tiles_nanako191_DATA
	defb $20, $0
	defb $20, $0
	defb $20, $0
	defb $40, $0
	defb $40, $0
	defb $40, $0
	defb $20, $A0
	defb $10, $72
._tiles_nanako192

._tiles_nanako192_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $40, $20
	defb $E4, $76
._tiles_nanako193

._tiles_nanako193_DATA
	defb $0, $40
	defb $0, $40
	defb $0, $40
	defb $0, $20
	defb $0, $20
	defb $0, $A0
	defb $50, $40
	defb $A0, $0
._tiles_nanako194

._tiles_nanako194_DATA
	defb $10, $EE
	defb $11, $C8
	defb $11, $88
	defb $0, $10
	defb $0, $11
	defb $0, $11
	defb $0, $10
	defb $0, $11
._tiles_nanako195

._tiles_nanako195_DATA
	defb $3C, $96
	defb $CF, $7F
	defb $EF, $FF
	defb $FE, $FD
	defb $F8, $F3
	defb $CC, $32
	defb $C0, $11
	defb $CC, $10
._tiles_nanako196

._tiles_nanako196_DATA
	defb $73, $C8
	defb $31, $88
	defb $0, $0
	defb $0, $0
	defb $80, $0
	defb $80, $0
	defb $80, $0
	defb $88, $0
._tiles_nanako197

._tiles_nanako197_DATA
	defb $0, $0
	defb $0, $30
	defb $0, $40
	defb $0, $80
	defb $10, $20
	defb $10, $50
	defb $10, $0
	defb $20, $10
._tiles_nanako198

._tiles_nanako198_DATA
	defb $F0, $F0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $C0, $80
	defb $F0, $B0
	defb $B0, $60
	defb $80, $0
._tiles_nanako199

._tiles_nanako199_DATA
	defb $0, $0
	defb $C0, $0
	defb $20, $0
	defb $10, $0
	defb $80, $80
	defb $C0, $80
	defb $C0, $80
	defb $0, $40
._tiles_nanako200

._tiles_nanako200_DATA
	defb $20, $0
	defb $20, $0
	defb $20, $0
	defb $40, $0
	defb $40, $0
	defb $50, $0
	defb $20, $A0
	defb $0, $50
._tiles_nanako201

._tiles_nanako201_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $40, $20
	defb $E6, $72
._tiles_nanako202

._tiles_nanako202_DATA
	defb $0, $40
	defb $0, $40
	defb $0, $40
	defb $0, $20
	defb $0, $20
	defb $0, $20
	defb $50, $40
	defb $E4, $80
._tiles_nanako203

._tiles_nanako203_DATA
	defb $31, $EC
	defb $11, $C8
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $0, $10
	defb $0, $10
	defb $0, $11
._tiles_nanako204

._tiles_nanako204_DATA
	defb $96, $C3
	defb $EF, $3F
	defb $FF, $7F
	defb $FB, $F7
	defb $FC, $F1
	defb $C4, $33
	defb $88, $30
	defb $80, $33
._tiles_nanako205

._tiles_nanako205_DATA
	defb $77, $80
	defb $31, $88
	defb $11, $88
	defb $80, $0
	defb $88, $0
	defb $88, $0
	defb $80, $0
	defb $88, $0
._tiles_nanako206

._tiles_nanako206_DATA
	defb $0, $0
	defb $0, $F7
	defb $0, $73
	defb $0, $30
	defb $0, $53
	defb $0, $B7
	defb $10, $1F
	defb $1, $3F
._tiles_nanako207

._tiles_nanako207_DATA
	defb $0, $0
	defb $FE, $0
	defb $EC, $0
	defb $C0, $0
	defb $EC, $0
	defb $FE, $0
	defb $FF, $80
	defb $FF, $88
._tiles_nanako208

._tiles_nanako208_DATA
	defb $1, $5F
	defb $1, $3F
	defb $10, $5F
	defb $0, $2F
	defb $0, $97
	defb $0, $70
	defb $0, $73
	defb $0, $0
._tiles_nanako209

._tiles_nanako209_DATA
	defb $BF, $88
	defb $1F, $88
	defb $BF, $80
	defb $FF, $0
	defb $5E, $0
	defb $E0, $0
	defb $EC, $0
	defb $0, $0
._tiles_nanako210

._tiles_nanako210_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $10
	defb $0, $31
	defb $0, $33
	defb $E, $73
._tiles_nanako211

._tiles_nanako211_DATA
	defb $0, $0
	defb $10, $EC
	defb $73, $EA
	defb $F7, $E6
	defb $FE, $EC
	defb $FD, $CC
	defb $FB, $C8
	defb $F7, $80
._tiles_nanako212

._tiles_nanako212_DATA
	defb $9, $76
	defb $9, $75
	defb $9, $7B
	defb $7, $84
	defb $0, $7
	defb $0, $8
	defb $0, $8
	defb $0, $7
._tiles_nanako213

._tiles_nanako213_DATA
	defb $FE, $0
	defb $EC, $0
	defb $80, $0
	defb $0, $0
	defb $0, $0
	defb $8, $0
	defb $8, $0
	defb $8, $0
._tiles_nanako214

._tiles_nanako214_DATA
	defb $0, $E0
	defb $0, $60
	defb $0, $E0
	defb $0, $61
	defb $0, $E1
	defb $0, $61
	defb $0, $E1
	defb $0, $61
._tiles_nanako215

._tiles_nanako215_DATA
	defb $0, $E4
	defb $10, $EE
	defb $73, $7E
	defb $FF, $FF
	defb $7F, $BF
	defb $BF, $FF
	defb $7F, $BF
	defb $3F, $FF
._tiles_nanako216

._tiles_nanako216_DATA
	defb $0, $E0
	defb $0, $60
	defb $0, $A0
	defb $0, $60
	defb $0, $A0
	defb $0, $60
	defb $0, $A0
	defb $0, $E0
._tiles_nanako217

._tiles_nanako217_DATA
	defb $53, $7E
	defb $10, $EE
	defb $0, $E4
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako218

._tiles_nanako218_DATA
	defb $73, $EC
	defb $D5, $BA
	defb $9B, $9D
	defb $EE, $77
	defb $73, $EC
	defb $32, $CC
	defb $10, $80
	defb $11, $88
._tiles_nanako219

._tiles_nanako219_DATA
	defb $0, $43
	defb $10, $CF
	defb $11, $A9
	defb $11, $80
	defb $73, $0
	defb $F7, $88
	defb $FA, $88
	defb $0, $0
._tiles_nanako220

._tiles_nanako220_DATA
	defb $14, $92
	defb $1B, $9C
	defb $D, $1A
	defb $E, $34
	defb $F, $1E
	defb $F, $2D
	defb $96, $5A
	defb $43, $A4
._tiles_nanako221

._tiles_nanako221_DATA
	defb $A4, $0
	defb $3F, $80
	defb $59, $88
	defb $10, $88
	defb $0, $EC
	defb $11, $FE
	defb $11, $F5
	defb $0, $0
._tiles_nanako222

._tiles_nanako222_DATA
	defb $30, $C0
	defb $60, $60
	defb $60, $60
	defb $20, $60
	defb $E6, $40
	defb $EE, $40
	defb $0, $76
	defb $0, $77
._tiles_nanako223

._tiles_nanako223_DATA
	defb $30, $C0
	defb $60, $60
	defb $60, $60
	defb $60, $40
	defb $20, $76
	defb $20, $77
	defb $E6, $0
	defb $EE, $0
._tiles_nanako224

._tiles_nanako224_DATA
	defb $0, $0
	defb $0, $31
	defb $0, $72
	defb $0, $C4
	defb $0, $EC
	defb $0, $E6
	defb $0, $62
	defb $0, $0
._tiles_nanako225

._tiles_nanako225_DATA
	defb $12, $84
	defb $17, $8E
	defb $1A, $85
	defb $B, $85
	defb $D, $B
	defb $86, $16
	defb $43, $2C
	defb $21, $48
._tiles_nanako226

._tiles_nanako226_DATA
	defb $C8, $0
	defb $EC, $0
	defb $66, $0
	defb $76, $0
	defb $73, $0
	defb $76, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako227

._tiles_nanako227_DATA
	defb $0, $31
	defb $0, $73
	defb $0, $66
	defb $0, $E6
	defb $0, $EC
	defb $0, $E6
	defb $0, $0
	defb $0, $0
._tiles_nanako228

._tiles_nanako228_DATA
	defb $0, $0
	defb $C8, $0
	defb $E4, $0
	defb $32, $0
	defb $73, $0
	defb $76, $0
	defb $64, $0
	defb $0, $0
._tiles_nanako229

._tiles_nanako229_DATA
	defb $75, $EC
	defb $FB, $EE
	defb $F6, $EA
	defb $EB, $AE
	defb $E6, $AA
	defb $73, $EC
	defb $31, $44
	defb $11, $C8
._tiles_nanako230

._tiles_nanako230_DATA
	defb $21, $2C
	defb $3, $E
	defb $42, $1A
	defb $7, $87
	defb $7, $F
	defb $14, $C1
	defb $43, $1E
	defb $31, $EC
._tiles_nanako231

._tiles_nanako231_DATA
	defb $33, $FF
	defb $77, $FF
	defb $EF, $F
	defb $DF, $5F
	defb $CF, $AF
	defb $DF, $5F
	defb $CF, $AF
	defb $DF, $5F
._tiles_nanako232

._tiles_nanako232_DATA
	defb $5F, $4C
	defb $AF, $AE
	defb $F, $5F
	defb $5F, $2F
	defb $AF, $9F
	defb $5F, $2F
	defb $AF, $9F
	defb $4F, $2F
._tiles_nanako233

._tiles_nanako233_DATA
	defb $4F, $AF
	defb $DF, $5F
	defb $CF, $AF
	defb $9F, $4F
	defb $4F, $AF
	defb $AF, $F
	defb $57, $FF
	defb $23, $AF
._tiles_nanako234

._tiles_nanako234_DATA
	defb $AF, $BF
	defb $F, $2F
	defb $AF, $BF
	defb $F, $3F
	defb $AF, $BF
	defb $F, $7F
	defb $FF, $EE
	defb $FF, $CC
._tiles_nanako235

._tiles_nanako235_DATA
	defb $FF, $5F
	defb $FF, $AF
	defb $F, $F
	defb $5F, $5F
	defb $AF, $AF
	defb $5F, $5F
	defb $AF, $AF
	defb $5F, $4F
._tiles_nanako236

._tiles_nanako236_DATA
	defb $AF, $AF
	defb $5F, $F
	defb $AF, $AF
	defb $4F, $F
	defb $AF, $AF
	defb $F, $F
	defb $FF, $FF
	defb $AF, $FF
._tiles_nanako237

._tiles_nanako237_DATA
	defb $CF, $AF
	defb $DF, $5F
	defb $CF, $AF
	defb $DF, $5F
	defb $4F, $AF
	defb $DF, $5F
	defb $CF, $AF
	defb $9F, $4F
._tiles_nanako238

._tiles_nanako238_DATA
	defb $AF, $9F
	defb $5F, $2F
	defb $AF, $9F
	defb $4F, $2F
	defb $AF, $BF
	defb $F, $2F
	defb $AF, $BF
	defb $F, $3F
._tiles_nanako239

._tiles_nanako239_DATA
	defb $AF, $AF
	defb $5F, $5F
	defb $AF, $AF
	defb $5F, $4F
	defb $AF, $AF
	defb $5F, $F
	defb $AF, $AF
	defb $4F, $F
._tiles_nanako240

._tiles_nanako240_DATA
	defb $0, $0
	defb $0, $9
	defb $1, $6
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako241

._tiles_nanako241_DATA
	defb $0, $0
	defb $8, $0
	defb $7, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako242

._tiles_nanako242_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $3, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako243

._tiles_nanako243_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $1
	defb $0, $6
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako244

._tiles_nanako244_DATA
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $C, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
	defb $0, $0
._tiles_nanako245

._tiles_nanako245_DATA
	defb $37, $8C
	defb $7E, $46
	defb $EE, $E6
	defb $D9, $8C
	defb $B9, $F7
	defb $6F, $DE
	defb $26, $BD
	defb $0, $EA
._tiles_nanako246

._tiles_nanako246_DATA
	defb $33, $EE
	defb $22, $22
	defb $22, $22
	defb $2, $2
	defb $2, $2
	defb $20, $20
	defb $30, $E0
	defb $0, $0
._tiles_nanako247

._tiles_nanako247_DATA
	defb $0, $CC
	defb $0, $44
	defb $0, $44
	defb $0, $4
	defb $0, $4
	defb $0, $40
	defb $0, $40
	defb $0, $0
._tiles_nanako248

._tiles_nanako248_DATA
	defb $33, $EE
	defb $22, $22
	defb $0, $22
	defb $3, $E
	defb $2, $0
	defb $20, $20
	defb $30, $E0
	defb $0, $0
._tiles_nanako249

._tiles_nanako249_DATA
	defb $33, $EE
	defb $22, $44
	defb $0, $44
	defb $1, $C
	defb $0, $4
	defb $20, $40
	defb $30, $E0
	defb $0, $0
._tiles_nanako250

._tiles_nanako250_DATA
	defb $22, $0
	defb $22, $0
	defb $22, $44
	defb $3, $E
	defb $0, $4
	defb $0, $40
	defb $0, $E0
	defb $0, $0
._tiles_nanako251

._tiles_nanako251_DATA
	defb $33, $EE
	defb $22, $0
	defb $22, $0
	defb $3, $E
	defb $0, $2
	defb $20, $20
	defb $30, $E0
	defb $0, $0
._tiles_nanako252

._tiles_nanako252_DATA
	defb $33, $EE
	defb $22, $0
	defb $22, $0
	defb $3, $E
	defb $2, $2
	defb $20, $20
	defb $30, $E0
	defb $0, $0
._tiles_nanako253

._tiles_nanako253_DATA
	defb $33, $EE
	defb $22, $44
	defb $0, $44
	defb $0, $4
	defb $0, $4
	defb $0, $40
	defb $0, $E0
	defb $0, $0
._tiles_nanako254

._tiles_nanako254_DATA
	defb $33, $EE
	defb $22, $22
	defb $22, $22
	defb $3, $E
	defb $2, $2
	defb $20, $20
	defb $30, $E0
	defb $0, $0
._tiles_nanako255

._tiles_nanako255_DATA
	defb $33, $EE
	defb $22, $22
	defb $22, $22
	defb $3, $E
	defb $0, $2
	defb $20, $20
	defb $30, $E0
	defb $0, $0
