// Copyright (c) 2013 "Pollos Hermanos"
// "Larcenas Legacy", a game for Amastrad CPC 464
//
// This file is part of "Larcenas Legacy".
//
// "Larcenas Legacy" is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

extern const int EFFECT_TABLE[];
extern const int SONG_TABLE_0[];
extern const int RULE_TABLE_0[];
extern const int SOUND_TABLE_0[];
extern const unsigned char SONG_0[];

void sounds(void) {
__asm
  _SONG_TABLE_0: 
    .dw _SONG_0

  _RULE_TABLE_0:
    .dw PAUTA_0,PAUTA_1,PAUTA_2,PAUTA_3,PAUTA_4,PAUTA_5,PAUTA_6
    PAUTA_0:  .DB #46,#0,#12,#0,#10,#0,#9,#0,#129
    PAUTA_1:  .DB #46,#0,#13,#0,#12,#0,#10,#0,#10,#0,#9,#0,#8,#0,#12,#0,#10,#0,#9,#0,#129
    PAUTA_2:  .DB #7,#0,#8,#0,#9,#0,#9,#0,#8,#0,#7,#0,#6,#0,#129
    PAUTA_3:  .DB #45,#0,#12,#0,#12,#0,#11,#0,#11,#0,#10,#0,#10,#0,#9,#0,#129
    PAUTA_4:  .DB #7,#0,#8,#0,#8,#0,#8,#0,#7,#0,#6,#0,#6,#0,#6,#0,#6,#0,#6,#0,#5,#0,#5,#0,#5,#0,#5,#0,#5,#0,#138
    PAUTA_5:  .DB #7,#0,#8,#0,#9,#0,#8,#0,#7,#0,#6,#0,#129
    PAUTA_6:  .DB #77,#0,#12,#0,#11,#0,#10,#0,#9,#0,#8,#0,#7,#0,#9,#0,#8,#0,#7,#0,#129

  _SOUND_TABLE_0:
    .dw SONIDO1
    .dw SONIDO2
    .dw SONIDO3
  SONIDO0:  .DB #23,#63,#0,#116,#110,#0,#255
  SONIDO1:  .DB #162,#47,#0,#23,#93,#9,#255
  SONIDO2:  .DB #0,#10,#5,#255
  SONIDO3:  .DB #186,#58,#0,#0,#102,#0,#162,#131,#0,#255

  _EFFECT_TABLE:
    .dw _EFECTO0
    .dw _EFECTO1
    .dw _EFECTO2
    .dw _EFECTO3

  _EFECTO0:                
    .db #0x58,#0x0D
    .db #0x50,#0x0B
    .db #0x47,#0x0A
    .db #0x3E,#0x06
    .db #0x35,#0x03
    .db #0x50,#0x09
    .db #0x47,#0x0A
    .db #0x3E,#0x07
    .db #0xFF

  _EFECTO1:                
    .db #0x58,#0x0C
    .db #0x5D,#0x0D
    .db #0x61,#0x0E
    .db #0x66,#0x0F
    .db #0x6A,#0x0E
    .db #0x6F,#0x0D
    .db #0x7A,#0x0C
    .db #0x78,#0x0B
    .db #0x7C,#0x0A
    .db #0x85,#0x09
    .db #0x8E,#0x08
    .db #0x97,#0x07
    .db #0xA0,#0x06
    .db #0xA9,#0x05
    .db #0xFF

  _EFECTO2:               
    .db #0x1F,#0x0B
    .db #0x1A,#0x0C
    .db #0x1F,#0x0D
    .db #0x16,#0x0E
    .db #0x1F,#0x0E
    .db #0x0D,#0x0D
    .db #0x1F,#0x0C
    .db #0x0D,#0x0B
    .db #0x00,#0x00
    .db #0x00,#0x00
    .db #0x1F,#0x08
    .db #0x1A,#0x09
    .db #0x1F,#0x0A
    .db #0x16,#0x0B
    .db #0x1F,#0x0B
    .db #0x0D,#0x0A
    .db #0x1F,#0x09
    .db #0x0D,#0x07
    .db #0x00,#0x00
    .db #0x00,#0x00
    .db #0x1F,#0x06
    .db #0x1A,#0x07
    .db #0x1F,#0x08
    .db #0x16,#0x08
    .db #0x1F,#0x07
    .db #0x0D,#0x06
    .db #0x1F,#0x05
    .db #0xFF

  _EFECTO3:                
    .db #0x1A,#0x0E
    .db #0x1A,#0x0E
    .db #0x00,#0x00
    .db #0x1A,#0x0A
    .db #0x1A,#0x0A
    .db #0x00,#0x00
    .db #0x1A,#0x0C
    .db #0x1A,#0x0C
    .db #0x00,#0x00
    .db #0x1A,#0x08
    .db #0x1A,#0x08
    .db #0xFF

  _SONG_0:
    .db #0x04, #0x07, #0x00, #0x00, #0x3F, #0x02, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x52
    .db #0x55, #0x52, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x4B, #0x52
    .db #0x4E, #0x52, #0x4B, #0x52, #0x4E, #0x52, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x49, #0x50
    .db #0x4D, #0x50, #0x49, #0x50, #0x4D, #0x50, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x52
    .db #0x55, #0x52, #0x4E, #0x52, #0x55, #0x52, #0x4E, #0x4E, #0x55, #0x52, #0x55, #0x51, #0x50, #0x51, #0x4E, #0x4E
    .db #0x55, #0x52, #0x55, #0x50, #0x51, #0x52, #0x00, #0x3F, #0x00, #0xC1, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE
    .db #0xC1, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69
    .db #0x6A, #0x69, #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D, #0x6A, #0xA6
    .db #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69, #0x6A, #0x69, #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63
    .db #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D, #0x6A, #0x3F, #0x03, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6
    .db #0x66, #0x69, #0x6A, #0x69, #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D
    .db #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69, #0x6A, #0x69, #0x6A, #0x3F, #0x00, #0xA6
    .db #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D, #0x6A, #0x49, #0x55, #0x55, #0x55, #0x49
    .db #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50, #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B
    .db #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52, #0x57, #0x49, #0x55, #0x55, #0x55, #0x49
    .db #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50, #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B
    .db #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52, #0x57, #0x49, #0x55, #0x55, #0x55, #0x49
    .db #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50, #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B
    .db #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52, #0x57, #0x49, #0x55, #0x55, #0x55, #0x49
    .db #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50, #0x55, #0x4E, #0x55, #0x55, #0x55, #0x4E
    .db #0x55, #0x55, #0x55, #0x4E, #0x55, #0x55, #0x55, #0x4E, #0x55, #0x55, #0x3F, #0x02, #0x61, #0x3F, #0x03, #0xA6
    .db #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69, #0x6A, #0x69, #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63
    .db #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D, #0x6A, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69
    .db #0x6A, #0x69, #0x6A, #0x3F, #0x00, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x6D
    .db #0x6A, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50
    .db #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52
    .db #0x57, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50
    .db #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52
    .db #0x57, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50
    .db #0x55, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x57, #0x57, #0x4B, #0x57, #0x4B, #0x57, #0x4B, #0x4E, #0x52
    .db #0x57, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x55, #0x55, #0x49, #0x55, #0x49, #0x55, #0x49, #0x4D, #0x50
    .db #0x55, #0x4E, #0x55, #0x55, #0x55, #0x4E, #0x55, #0x55, #0x55, #0x4E, #0x55, #0x55, #0x55, #0x4E, #0x55, #0x55
    .db #0x3F, #0x02, #0x61, #0xC1, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0x00, #0x3F, #0x03, #0xC1, #0xFE, #0xFE
    .db #0xFE, #0xFE, #0xFE, #0xFE, #0xC1, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0x41, #0x7E, #0xA6, #0xA6, #0x66
    .db #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69, #0x6A, #0x29, #0x6A, #0x7E, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6
    .db #0xA6, #0x66, #0x6D, #0x6A, #0xAD, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x69, #0x6A, #0x29
    .db #0x6A, #0x7E, #0xA6, #0xA6, #0x66, #0x61, #0x63, #0xA6, #0xA6, #0x66, #0x6D, #0x6A, #0x2D, #0x3F, #0x00, #0xED
    .db #0xFE, #0xFE, #0x3F, #0x03, #0xED, #0x3F, #0x00, #0x6A, #0x66, #0x6A, #0x66, #0xEA, #0x3F, #0x03, #0xAA, #0x3F
    .db #0x00, #0xB2, #0xAD, #0x3F, #0x03, #0xAD, #0x3F, #0x00, #0xAA, #0xA6, #0xED, #0xFE, #0xFE, #0x3F, #0x03, #0xED
    .db #0x3F, #0x00, #0x6A, #0x66, #0x6A, #0x66, #0xEA, #0xFE, #0xA8, #0xE6, #0x3F, #0x03, #0xA6, #0x3F, #0x00, #0xAD
    .db #0xE8, #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xA6, #0xE5, #0xA6, #0xA8, #0xEA, #0x3F, #0x03, #0xAA, #0x3F, #0x00
    .db #0xA8, #0xE6, #0xA1, #0xA3, #0xE8, #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xAA, #0xED, #0xAA, #0xA8, #0xEA, #0x3F
    .db #0x03, #0xAA, #0x3F, #0x00, #0xA8, #0xE6, #0xAD, #0xAD, #0xE8, #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xA6, #0xE5
    .db #0xA6, #0xA8, #0xEA, #0x3F, #0x03, #0xAA, #0x3F, #0x00, #0xA8, #0xE6, #0xA1, #0xA3, #0xE8, #0x3F, #0x03, #0xA8
    .db #0x3F, #0x00, #0xAA, #0xED, #0xAA, #0xA8, #0xE6, #0xFE, #0xFE, #0xFE, #0x3F, #0x03, #0xE6, #0x3F, #0x02, #0x9A
    .db #0x3F, #0x00, #0xED, #0xFE, #0xFE, #0x3F, #0x03, #0xED, #0x3F, #0x00, #0x6A, #0x66, #0x6A, #0x66, #0xEA, #0x3F
    .db #0x03, #0xAA, #0x3F, #0x00, #0xB2, #0xAD, #0x3F, #0x03, #0xAD, #0x3F, #0x00, #0xAA, #0xA6, #0xED, #0xFE, #0xFE
    .db #0x3F, #0x03, #0xED, #0x3F, #0x00, #0x6A, #0x66, #0x6A, #0x66, #0xEA, #0xFE, #0xA8, #0xE6, #0x3F, #0x03, #0xA6
    .db #0x3F, #0x00, #0xAD, #0xE8, #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xA6, #0xE5, #0xA6, #0xA8, #0xEA, #0x3F, #0x03
    .db #0xAA, #0x3F, #0x00, #0xA8, #0xE6, #0xA1, #0xA3, #0xE8, #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xAA, #0xED, #0xAA
    .db #0xA8, #0xEA, #0x3F, #0x03, #0xAA, #0x3F, #0x00, #0xA8, #0xE6, #0xAD, #0xAD, #0xE8, #0x3F, #0x03, #0xA8, #0x3F
    .db #0x00, #0xA6, #0xE5, #0xA6, #0xA8, #0xEA, #0x3F, #0x03, #0xAA, #0x3F, #0x00, #0xA8, #0xE6, #0xA1, #0xA3, #0xE8
    .db #0x3F, #0x03, #0xA8, #0x3F, #0x00, #0xAA, #0xED, #0xAA, #0xA8, #0xE6, #0xFE, #0xFE, #0xFE, #0x3F, #0x03, #0xE6
    .db #0x3F, #0x02, #0x9A, #0xC1, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0xFE, #0x00, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F
    .db #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x01, #0x7F
    .db #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x41, #0x7F, #0x40, #0x7F
    .db #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x40, #0x7F, #0x40, #0x7F
    .db #0x42, #0x7F, #0x41, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x41, #0x7F, #0x42, #0x7F, #0x40, #0x7F, #0x42, #0x7F, #0x41, #0x7F, #0x42, #0x7F
    .db #0x40, #0x7F, #0x40, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x7F, #0x01, #0x00, #0x00
__endasm;
}
