﻿/**
 * @file  fox.c

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *	Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#include <cpcrslib.h>
#include <cpcwyzlib.h>
#include "constants.h"
#include "core.h"
#include "gems.h"
#include "sprites.h"
#include "exographics.h"
#include "audio.h"

unsigned int nplayers=1, predefined = 1, nTimeLast=0;
char cifra3ScoreP1,cifra2ScoreP1,cifra1ScoreP1,cifra0ScoreP1,cifra3ScoreP2,cifra2ScoreP2,cifra1ScoreP2,cifra0ScoreP2,cifra1Time,cifra0Time;
unsigned char char1,char2,char3,char4;
unsigned char a;
unsigned char i;
int gemsHit=0;
	
const unsigned char map[]={
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
		5,43,44,48,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
		5,49,50,54,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,33,34,37,5,
		5,55,56,60,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,38,39,42,5,
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,33,34,35,36,37,5,5,5,5,5,5,5,5,5,5,5,5,5,
		61,62,62,62,63,5,5,5,5,5,5,5,5,5,38,39,40,41,42,5,5,5,5,5,5,5,5,5,61,62,62,63,
		9,10,9,10,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,10,9,10,9,9,		
		5,5,5,5,5,5,5,5,5,5,43,44,45,46,47,48,5,5,43,44,45,48,5,5,5,5,5,5,5,5,5,5,
		5,5,5,5,5,5,5,5,5,5,49,50,51,52,53,54,5,5,49,50,51,54,5,5,5,5,5,5,5,5,5,5,
		5,25,27,28,5,5,5,5,5,5,55,56,57,58,59,60,5,5,55,56,57,60,5,5,5,5,5,5,43,44,48,5,
		5,29,31,32,5,5,5,5,61,62,62,62,62,62,62,62,62,62,62,62,62,62,62,63,5,5,5,5,55,56,60,5,
		5,5,5,5,5,5,5,10,9,10,9,10,9,10,9,10,10,9,10,9,10,9,10,9,10,5,5,5,5,5,5,5,
		5,33,34,37,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,25,27,28,5,
		5,38,39,42,5,5,5,5,5,33,34,35,36,37,5,5,5,5,5,5,5,5,5,5,5,5,5,5,29,31,32,5,
		61,62,62,62,63,5,5,5,5,38,39,40,41,42,5,5,5,5,5,5,43,44,45,46,47,48,5,61,62,62,62,63,
		9,10,9,10,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,49,50,51,52,53,54,5,9,10,9,10,9,
		5,5,5,5,5,5,25,26,27,28,5,43,44,48,5,5,5,5,5,5,55,56,57,58,59,60,5,5,5,5,5,5,
		5,5,5,5,5,5,29,30,31,32,5,55,56,60,5,5,6,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
		5,5,6,7,61,62,62,62,62,62,62,62,62,62,63,6,7,6,7,61,62,62,62,62,62,62,62,63,6,7,5,5,
		9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10,9,10
};

extern const int pointOfInterest[]={
	//GROUND (0, 2)
	 5, 18,
    26, 18, 

    //FIRST PLATFORMS (4, 6)
     2, 14, 
	29, 14, 

	//MIDDLE PLATFORM (8, 10)
	10, 10, 
	20, 10, 
    
	//TOP PLATFORMS (12, 14)
	 1,  5, 
    29,  5
 };

void main(void){

	unsigned char player1Position = 0;
	unsigned char player2Position = 0;
	nplayers = 1;

	initGame();		// Initialize dependent data

	while(1){
	
		// Set player state to static left of right
    	sprites[0].state = sprites[0].lastState % 2;
    	sprites[1].state = sprites[1].lastState % 2;
    	sprites[0].lastState = sprites[0].state;
    	sprites[1].lastState = sprites[1].state;

		// --------------------------------------------------------------------
		// ----------------- TESTING CONTROL KEYS -----------------------------
		// --------------------------------------------------------------------
		
		// Players Right Movement
		if (cpc_TestKey(KEY_RIGHT_P1)==1 && sprites[0].cx <= MAP_MAX_X){
			s_moveX(&sprites[0], 1);
        	sprites[0].lastState = sprites[0].state;
        	sprites[0].state=sprites[0].lastState = Walk_Right;
        }

		if (nplayers == 2 && cpc_TestKey(KEY_RIGHT_P2)==1 && sprites[1].cx<=MAP_MAX_X){
        	s_moveX(&sprites[1], 1);
        	sprites[1].lastState = sprites[1].state;
        	sprites[1].state=sprites[1].lastState = Walk_Right;
        }
		
		// Players Left Movement
        if (cpc_TestKey(KEY_LEFT_P1)==1 && sprites[0].cx>0){
        	s_moveX(&sprites[0], 0);
        	sprites[0].state=sprites[0].lastState = Walk_Left;
        }
    	
        if (nplayers == 2 && cpc_TestKey(KEY_LEFT_P2)==1 && sprites[1].cx>0){
        	s_moveX(&sprites[1], 0);
        	sprites[1].lastState = sprites[1].state;
        	sprites[1].state=sprites[1].lastState = Walk_Left;
        }
		
		// Players Jump Movement
		if (cpc_TestKey(KEY_UP_P1)==1){
        	if(t_canMove(&sprites[0], sprites[0].tilX, sprites[0].tilY +1) == 1 && t_canMove(&sprites[0], sprites[0].tilX - 1, sprites[0].tilY +1) == 1){
    			s_jump(&sprites[0]);    			
    		}
    		sprites[0].state= sprites[0].lastState % 2 ==1  ? Jump_Left : Jump_Right;
        }

        if (nplayers == 2 && cpc_TestKey(KEY_UP_P2)==1){
        	if(t_canMove(&sprites[1], sprites[1].tilX, sprites[1].tilY +1) == 1 && t_canMove(&sprites[1], sprites[1].tilX - 1, sprites[1].tilY +1) == 1){
    			s_jump(&sprites[1]);    			
    		}
        	sprites[1].state= sprites[1].lastState % 2 == 1 ? Jump_Left : Jump_Right;
        }
		
		// Players Hit Movement
        if (cpc_TestKey(KEY_DOWN_P1)==1 && !sprites[0].invincible){
        	sprites[0].state= sprites[0].lastState % 2 ==1  ? Attack_Left : Attack_Right;
        	if(!sprites[1].invincible && cpc_CollSp(p_sprites[0], p_sprites[1])){
        		//s_invincibleMode(1,1);
				cpc_WyzStartEffect(2,1);  
				sprites[1].invincible = 1;
				lastInvincible[1]=c_getTime();
        		g_resetGems();
        		gemsHit=g_random(10);
				
				gemsHit = gemsHit > sprites[1].gatheredGems ? sprites[1].gatheredGems : gemsHit;
        		g_throwGems(gemsHit, &sprites[1]);
				actScoreP1(-gemsHit);
				drawScoreP1();
        	}
        }

        if (nplayers == 2 && cpc_TestKey(KEY_DOWN_P2)==1 && !sprites[1].invincible){
        	sprites[1].state= sprites[1].lastState % 2 ==1  ? Attack_Left : Attack_Right;
        	if(!sprites[0].invincible &&cpc_CollSp(p_sprites[0], p_sprites[1])){
        		//s_invincibleMode(1,0);
				cpc_WyzStartEffect(2,1);
				sprites[0].invincible = 1;
				lastInvincible[0]=c_getTime();
        		g_resetGems();
        		gemsHit=g_random(10);
        		gemsHit = gemsHit > sprites[0].gatheredGems ? sprites[0].gatheredGems : gemsHit;
        		g_throwGems(gemsHit, &sprites[0]);
				actScoreP2(-gemsHit);
				drawScoreP2();
        	}
        }


        // --------------------------------------------------------------------
		//--------------------------------- AI --------------------------------
		// --------------------------------------------------------------------

        // IF WE PLAY AGAINST AI, THIS CODE WILL BE EXECUTED

        if(nplayers == 1){
	        player1Position = calculateDistance(0);
	        player2Position = calculateDistance(1);

	        ///////////////////////////////////////////////////////////  SAME LEVEL      ///////////////////////////////////////////////////////////

	        if(player2Position == 8 && player1Position == 14){
	        	s_moveX(&sprites[1], 1);
		        	sprites[1].lastState = sprites[1].state;
		        	sprites[1].state=sprites[1].lastState = Walk_Right;
	        }
	        else
		        if(player2Position == 10 && player1Position == 12){
		        	s_moveX(&sprites[1], 0);
		        	sprites[1].lastState = sprites[1].state;
		        	sprites[1].state=sprites[1].lastState = Walk_Left;
		        }
	        
	        else if((sprites[0].tilY != sprites[1].tilY && sprites[1].tilX < 5 && sprites[1].tilY == 17)){
					s_moveX(&sprites[1], 1);
		        	sprites[1].lastState = sprites[1].state;
		        	sprites[1].state=sprites[1].lastState = Walk_Right;
	        }
	        else{
	        	if((sprites[0].tilY != sprites[1].tilY && sprites[1].tilX > 27 && sprites[1].tilY == 17)){
	        		s_moveX(&sprites[1], 0);
		        	sprites[1].lastState = sprites[1].state;
		        	sprites[1].state=sprites[1].lastState = Walk_Left;
		        }
		        else{

			        if(player1Position == player2Position || (player1Position >= 8 && player1Position <= 10 && player2Position >= 8 && player2Position <= 10) || (player1Position >= 0 && player1Position <= 2 && player2Position >= 0 && player2Position <= 2)){

			        	if(sprites[0].tilX < sprites[1].tilX){
			        		s_moveX(&sprites[1], 0);
				        	sprites[1].lastState = sprites[1].state;
				        	sprites[1].state=sprites[1].lastState = Walk_Left;
			        	}
			        	else{
							s_moveX(&sprites[1], 1);
				        	sprites[1].lastState = sprites[1].state;
				        	sprites[1].state=sprites[1].lastState = Walk_Right;
			        	}
			        }
			 
			        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


					///////////////////////////////////////////////////////////  IS UNDER US      ///////////////////////////////////////////////////////////


			        if(sprites[0].tilY > sprites[1].tilY + 1){

			        	if(player2Position != 12 && player2Position != 4 && player2Position != 16 && player2Position != 10){
			        		s_moveX(&sprites[1], 0);        	
				        	sprites[1].lastState = sprites[1].state;
				        	sprites[1].state=sprites[1].lastState = Walk_Left;
			        	}
			        	else{
							s_moveX(&sprites[1], 1);
				        	sprites[1].lastState = sprites[1].state;	        
				        	sprites[1].state=sprites[1].lastState = Walk_Right;
			        	}
			        }

			        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


			        ///////////////////////////////////////////////////////////  IS ABOVE US      ///////////////////////////////////////////////////////////


			        if(sprites[0].tilY < sprites[1].tilY){
			     
			        	if(player2Position == 0 || player2Position == 6 || player2Position == 8){
			        		if( player2Position == 8 && sprites[1].tilY == 9 && sprites[1].ySpeed < 0){
			        			s_moveX(&sprites[1], 1);
				        			sprites[1].lastState = sprites[1].state;
					        		sprites[1].state=sprites[1].lastState = Walk_Right;	
			        		}
			        		if(sprites[1].tilX <= 7 || sprites[1].tilX >= 28){
			        			if(t_canMove(&sprites[1], sprites[1].tilX, sprites[1].tilY +1) == 1 && t_canMove(&sprites[1], sprites[1].tilX - 1, sprites[1].tilY +1) == 1){
					    			s_jump(&sprites[1]);    			
					    		}
					        	sprites[1].state= sprites[1].lastState % 2 == 1 ? Jump_Left : Jump_Right;
			        		}
			        		
		        			if(sprites[1].ySpeed < 0){
			        			s_moveX(&sprites[1], sprites[1].lastState % 2 == 1 ? 0 : 1);
			        		}
		        			else{
			        			s_moveX(&sprites[1], 0);
			        			sprites[1].lastState = sprites[1].state;
				        		sprites[1].state=sprites[1].lastState = Walk_Left;	
		        			}
			        	}
			        	else{
			        		if(player2Position == 2 || player2Position == 4 || player2Position == 10){
			        			if( player2Position == 10 && sprites[1].tilY == 9 && sprites[1].ySpeed < 0){
				        			s_moveX(&sprites[1], 0);
				        			sprites[1].lastState = sprites[1].state;
					        		sprites[1].state=sprites[1].lastState = Walk_Left;	
				        		}
				        		if(sprites[1].tilX >= 25 || (sprites[1].tilX >= 4 && sprites[1].tilX <= 5) ){
				        			if(t_canMove(&sprites[1], sprites[1].tilX, sprites[1].tilY +1) == 1 && t_canMove(&sprites[1], sprites[1].tilX - 1, sprites[1].tilY +1) == 1){
						    			s_jump(&sprites[1]);    			
						    		}
						        	sprites[1].state= sprites[1].lastState % 2 == 1 ? Jump_Left : Jump_Right;
						        	
				        		}
				        		if(sprites[1].ySpeed < 0){
				        			s_moveX(&sprites[1], sprites[1].lastState % 2 == 1 ? 0 : 1);
				        		}
			        			else{
				        			s_moveX(&sprites[1], 1);
				        			sprites[1].lastState = sprites[1].state;
					        		sprites[1].state=sprites[1].lastState = Walk_Right;	
			        			}
				        	}
			        	}
			        }

			        // We try to attack the player
			        if (!sprites[1].invincible && cpc_CollSp(p_sprites[0], p_sprites[1]) && (g_random(2) - 1)){
			        	sprites[1].state= sprites[1].lastState % 2 ==1  ? Attack_Left : Attack_Right;
			        	if(!sprites[0].invincible){
							cpc_WyzStartEffect(2,1);
							sprites[0].invincible = 1;
							lastInvincible[0]=c_getTime();
			        		g_resetGems();
			        		gemsHit=g_random(10);
			        		gemsHit = gemsHit > sprites[0].gatheredGems ? sprites[0].gatheredGems : gemsHit;
			        		g_throwGems(gemsHit, &sprites[0]);
							actScoreP2(-gemsHit);
							drawScoreP2();
			        	}
			        }
			    }
		    }
		}

		// --------------------------------------------------------------------
		//------------------------------ END AI -------------------------------
		// --------------------------------------------------------------------

		// --------------------------------------------------------------------
		//--------------------- END TESTING CONTROL KEYS ----------------------
		// --------------------------------------------------------------------
		
		
		// --------------------------------------------------------------------
		//--------------------------- FRAME CONTROL ---------------------------
		// --------------------------------------------------------------------

		if (c_getTime() - sprites[0].lastMoveTime > sprites[0].frameSpeed) {
			sprites[0].actualFrame++;
			sprites[0].lastMoveTime += sprites[0].frameSpeed;
		}

		if (c_getTime() - sprites[1].lastMoveTime > sprites[1].frameSpeed) {
			sprites[1].actualFrame++;
			sprites[1].lastMoveTime += sprites[1].frameSpeed;
		}


		if(sprites[0].actualFrame>2)
			sprites[0].actualFrame = 0;

		if(sprites[1].actualFrame>2)
			sprites[1].actualFrame = 0;
			
		// --------------------------------------------------------------------
		//------------------------- END FRAME CONTROL -------------------------
		// --------------------------------------------------------------------	
			
		
		// --------------------------------------------------------------------
		//-------------------------- JUMPING CONTROL --------------------------
		// --------------------------------------------------------------------
		
		if(sprites[0].ySpeed < 8){
			sprites[0].ySpeed += sprites[0].gravity;
		}

		if(sprites[1].ySpeed < 8){
			sprites[1].ySpeed += sprites[1].gravity;
		}
		
		s_canJump(&sprites[0]);
		s_canJump(&sprites[1]);

		if (sprites[0].isJumping) {
			if(sprites[0].state == Walk_Left){
				sprites[0].state = Jump_Left;
			}
		}

		if (sprites[1].isJumping) {
			if(sprites[1].state == Walk_Left){
				sprites[1].state = Jump_Left;
			}
		}

		// --------------------------------------------------------------------
		//------------------------ END JUMPING CONTROL ------------------------
		// --------------------------------------------------------------------
		
		
		
		// --------------------------------------------------------------------
		//---------------------------- GEMS SYSTEM ----------------------------
		// --------------------------------------------------------------------
		
		g_updateGems();

		for(i=0;i<MAX_GEMS_ARRAY;i++){
			if(gemsMask[i] == 1 && gems[i].yDirection == 1 && cpc_CollSp(p_sprites[0],p_gems[i])){
				sprites[0].gatheredGems += gems[i].value;
				gemsMask[i]=0;
				actScoreP2(gems[i].value);
				drawScoreP2();
				gems[i].sp1=(unsigned char *)notShowingGem;
				gems[i].sp0=(unsigned char *)notShowingGem;
				cpc_WyzStartEffect(2,2);
			}
			if(gemsMask[i] == 1 && gems[i].yDirection == 1 && cpc_CollSp(p_sprites[1],p_gems[i])){
				cpc_CollSp(p_gems[0],p_gems[i]);
				sprites[1].gatheredGems += gems[i].value;
				gemsMask[i]=0;
				actScoreP1(gems[i].value);
				drawScoreP1();
				gems[i].sp1=(unsigned char *)notShowingGem;
				gems[i].sp0=(unsigned char *)notShowingGem;
				cpc_WyzStartEffect(2,2);
			}
		}

		if(spawningGemsMask == 1  && cpc_CollSp(p_sprites[0],p_spawningGem)){
			sprites[0].gatheredGems += spawningGem.value;
			spawningGemsMask=0;
			actScoreP2(spawningGem.value);
			drawScoreP2();
			spawningGem.sp1=(unsigned char *)notShowingGem;
			spawningGem.sp0=(unsigned char *)notShowingGem;
			cpc_WyzStartEffect(2,2);
		}
		if(spawningGemsMask == 1 && cpc_CollSp(p_sprites[1],p_spawningGem)){
			sprites[1].gatheredGems += spawningGem.value;
			spawningGemsMask=0;
			actScoreP1(spawningGem.value);
			drawScoreP1();
			spawningGem.sp1=(unsigned char *)notShowingGem;
			spawningGem.sp0=(unsigned char *)notShowingGem;
			cpc_WyzStartEffect(2,2);
		}

		// --------------------------------------------------------------------
		//-------------------------- END GEMS SYSTEM --------------------------
		// --------------------------------------------------------------------
		
		
		// --------------------------------------------------------------------
		//------------------------------ DRAW DATA ----------------------------
		// --------------------------------------------------------------------
		s_disableBlink();
		if(sprites[0].invincible == 1){
			if(c_getTime() - lastInvincible[0] > INVINCIBLE_TIME){
				sprites[0].invincible = 0;
			}
		}
		
		if(sprites[1].invincible == 1){
			if(c_getTime() - lastInvincible[1] > INVINCIBLE_TIME){
				sprites[1].invincible = 0;
			}
		}
				
		sprites[0].sp0 = (unsigned char *)PlayerKeyFrames[sprites[0].state][sprites[0].actualFrame];
		sprites[0].sp1 = sprites[0].sp0;
		
		sprites[1].sp0 = (unsigned char *)PlayerKeyFrames[sprites[1].state][sprites[1].actualFrame];
		sprites[1].sp1 = sprites[1].sp0;

		
		
		cpc_ResetTouchedTiles();

		s_colorizePlayerData((unsigned char *)PlayerKeyFrames[sprites[0].state][sprites[0].actualFrame],sprites[0].state%2, 0);
		if(sprites[0].invincible == 1 && sprites[0].actualFrame ==1){
			sprites[0].sp0 =sprites[0].sp1 = (unsigned char *)PlayerSpriteTransparent;
		}
		if(sprites[1].invincible == 1 && sprites[1].actualFrame ==1){
			sprites[1].sp0 =sprites[1].sp1 = (unsigned char *)PlayerSpriteTransparent;
		}
		cpc_PutSpTileMap(p_sprites[0]);		//search the tiles where is and was the sprite

		s_colorizePlayerData((unsigned char *)PlayerKeyFrames[sprites[1].state][sprites[1].actualFrame],sprites[1].state%2, 1);

		cpc_PutSpTileMap(p_sprites[1]);


		for(i = 0; i<MAX_GEMS_ARRAY;i++){
			cpc_PutSpTileMap(p_gems[i]);
		}
		cpc_PutSpTileMap(p_spawningGem);

		cpc_UpdScr();
		
		s_colorizePlayerData((unsigned char *)PlayerKeyFrames[sprites[0].state][sprites[0].actualFrame],sprites[0].state % 2, 0);
		sprites[0].cy += 4;
		cpc_PutMaskSpTileMap2b(p_sprites[0]);
		sprites[0].cy -= 4;
		s_colorizePlayerData((unsigned char *)PlayerKeyFrames[sprites[1].state][sprites[1].actualFrame],sprites[1].state % 2, 1);
		sprites[1].cy += 4;
		cpc_PutMaskSpTileMap2b(p_sprites[1]);
		sprites[1].cy -= 4;

		for(i = 0; i<MAX_GEMS_ARRAY;i++){
			cpc_PutMaskSpTileMap2b(p_gems[i]);
		}
		cpc_PutMaskSpTileMap2b(p_spawningGem);

		cpc_ShowTileMap2();
		
		actTime();
		drawTime();
		//if(cpc_TestKey(KEY_ESC)==1){c_exit();}

		// --------------------------------------------------------------------
		//---------------------------- END DRAW DATA --------------------------
		// --------------------------------------------------------------------
		
		
		// --------------------------------------------------------------------
		//---------------------------- GAME ENDING ----------------------------
		// --------------------------------------------------------------------
		
		if( (cifra1Time == 0 && cifra0Time == 0)){
			restart = endGame();
			if(restart == 0){		
				cpc_WyzSetPlayerOff();			
				initGame(); 	// Reinitialize game
			}
			else{
				c_exit();
			}
		}
    }
}

void actScoreP1(char value){
	cifra3ScoreP1+=value;
	if(cifra3ScoreP1<0){
		cifra3ScoreP1+=10;
		cifra2ScoreP1--;
	}
	if(cifra3ScoreP1>=10){
		cifra3ScoreP1-=10;
		cifra2ScoreP1++;
	}
	if(cifra2ScoreP1<0){
		cifra2ScoreP1+=10;
		cifra1ScoreP1--;
	}
	if(cifra2ScoreP1==10){
		cifra2ScoreP1=0;
		cifra1ScoreP1++;
	}
	if(cifra1ScoreP1==10){
		cifra1ScoreP1=0;
		cifra0ScoreP1++;
	}
}

void actScoreP2(char value){
	cifra3ScoreP2+=value;
	if(cifra3ScoreP2<0){
		cifra3ScoreP2+=10;
		cifra2ScoreP2--;
	}
	if(cifra3ScoreP2>=10){
		cifra3ScoreP2-=10;
		cifra2ScoreP2++;
	}
	if(cifra2ScoreP2<0){
		cifra2ScoreP2+=10;
		cifra1ScoreP2--;
	}
	if(cifra2ScoreP2==10){
		cifra2ScoreP2=0;
		cifra1ScoreP2++;
	}
	if(cifra1ScoreP2==10){
		cifra1ScoreP2=0;
		cifra0ScoreP2++;
	}
}

void actTime(){
	if(c_getTime() - nTimeLast >= 300){
			nTimeLast=c_getTime();

			if(cifra1Time==0){
				cifra1Time=9;
				cifra0Time--;
			}
			else
				cifra1Time--;
	}
}

void drawTime(){
	switch(cifra0Time){
		case 0: cpc_PutSp(Cero,8,2,0xcf26);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf26);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf26);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf26);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf26);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf26);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf26);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf26);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf26);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf26);break;
	}
	switch(cifra1Time){
		case 0: cpc_PutSp(Cero,8,2,0xcf28);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf28);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf28);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf28);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf28);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf28);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf28);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf28);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf28);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf28);break;
	}
}

void drawScoreP1(){
		switch(cifra3ScoreP1){
		case 0: cpc_PutSp(Cero,8,2,0xcef4);break;
		case 1: cpc_PutSp(Uno,8,2,0xcef4);break;
		case 2: cpc_PutSp(Dos,8,2,0xcef4);break;
		case 3: cpc_PutSp(Tres,8,2,0xcef4);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcef4);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcef4);break;
		case 6: cpc_PutSp(Seis,8,2,0xcef4);break;
		case 7: cpc_PutSp(Siete,8,2,0xcef4);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcef4);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcef4);break;
	}
	switch(cifra2ScoreP1){
		case 0: cpc_PutSp(Cero,8,2,0xcef2);break;
		case 1: cpc_PutSp(Uno,8,2,0xcef2);break;
		case 2: cpc_PutSp(Dos,8,2,0xcef2);break;
		case 3: cpc_PutSp(Tres,8,2,0xcef2);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcef2);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcef2);break;
		case 6: cpc_PutSp(Seis,8,2,0xcef2);break;
		case 7: cpc_PutSp(Siete,8,2,0xcef2);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcef2);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcef2);break;
	}
	switch(cifra1ScoreP1){
		case 0: cpc_PutSp(Cero,8,2,0xcef0);break;
		case 1: cpc_PutSp(Uno,8,2,0xcef0);break;
		case 2: cpc_PutSp(Dos,8,2,0xcef0);break;
		case 3: cpc_PutSp(Tres,8,2,0xcef0);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcef0);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcef0);break;
		case 6: cpc_PutSp(Seis,8,2,0xcef0);break;
		case 7: cpc_PutSp(Siete,8,2,0xcef0);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcef0);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcef0);break;
	}
	switch(cifra0ScoreP1){
		case 0: cpc_PutSp(Cero,8,2,0xceee);break;
		case 1: cpc_PutSp(Uno,8,2,0xceee);break;
		case 2: cpc_PutSp(Dos,8,2,0xceee);break;
		case 3: cpc_PutSp(Tres,8,2,0xceee);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xceee);break;
		case 5: cpc_PutSp(Cinco,8,2,0xceee);break;
		case 6: cpc_PutSp(Seis,8,2,0xceee);break;
		case 7: cpc_PutSp(Siete,8,2,0xceee);break;
		case 8: cpc_PutSp(Ocho,8,2,0xceee);break;
		case 9: cpc_PutSp(Nueve,8,2,0xceee);break;
	}
}

void drawScoreP2(){
	switch(cifra3ScoreP2){
		case 0: cpc_PutSp(Cero,8,2,0xcf16);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf16);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf16);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf16);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf16);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf16);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf16);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf16);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf16);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf16);break;
	}
	switch(cifra2ScoreP2){
		case 0: cpc_PutSp(Cero,8,2,0xcf14);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf14);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf14);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf14);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf14);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf14);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf14);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf14);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf14);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf14);break;
	}
	switch(cifra1ScoreP2){
		case 0: cpc_PutSp(Cero,8,2,0xcf12);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf12);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf12);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf12);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf12);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf12);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf12);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf12);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf12);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf12);break;
	}
	switch(cifra0ScoreP2){
		case 0: cpc_PutSp(Cero,8,2,0xcf10);break;
		case 1: cpc_PutSp(Uno,8,2,0xcf10);break;
		case 2: cpc_PutSp(Dos,8,2,0xcf10);break;
		case 3: cpc_PutSp(Tres,8,2,0xcf10);break;
		case 4: cpc_PutSp(Cuatro,8,2,0xcf10);break;
		case 5: cpc_PutSp(Cinco,8,2,0xcf10);break;
		case 6: cpc_PutSp(Seis,8,2,0xcf10);break;
		case 7: cpc_PutSp(Siete,8,2,0xcf10);break;
		case 8: cpc_PutSp(Ocho,8,2,0xcf10);break;
		case 9: cpc_PutSp(Nueve,8,2,0xcf10);break;
	}
}

void pause(void){
    __asm
    ld b,#40
pause_loop:
    halt
    djnz pause_loop
    __endasm;
}

void setColours(void){
    unsigned char x;
    for (x=0; x<16; x++)
    {
        cpc_SetInk(x,PlayerPalette[x]);
    }
    cpc_SetBorder(0);
}

unsigned char endGame(){
	unsigned char go = 0;
	cpc_ClrScr();
	cpc_UnExo(background2,0xC000);

	drawScoreP1();
	drawScoreP2();

    cpc_PrintGphStrXY("1;REINICIAR;PARTIDA",1*2,5*8);
    cpc_PrintGphStrXY("2;SALIR;DEL;JUEGO",1*2,7*8);
	cpc_PrintGphStrXY("PLAYER;1",12,165); 
	cpc_PrintGphStrXY("PLAYER;2",45,165); 

    while(1){
	    if(cpc_TestKey(KEY_ME1)==1){
			
	    	return 0;
	    }
	    else if(cpc_TestKey(KEY_ME2)==1){
	    	return 1;
	    }
	}	
}

void setTilemap(void){
    unsigned char x,y;

    for(x=0; x < 32; x++)
    	for(y=0; y < 20; y++)
    		cpc_SetTile(x,y, map[y*32 + x]);





}

unsigned int c_getTime(void){
  unsigned int nTime = 0;

  __asm
    CALL #0xBD0D ;KL TIME PLEASE
    PUSH HL
    POP DE
    LD HL, #_char3
    LD (HL), D
    LD HL, #_char4
    LD (HL), E
  __endasm;

  nTime = (char3 << 8) + char4;

  return nTime;
}

void s_jump(struct s_Sprite * sprite){
	if(!sprite->isJumping){
		sprite->ySpeed = -12;
		sprite->isJumping=1;
	}
}

int t_canMove(struct s_Sprite *pSprite, unsigned char tileX, unsigned char tileY){   
  	int result = 0;
	if(tileX < 32 && tileY >= 0 && tileY < 20 && cpc_ReadTile(tileX, tileY) != 9 && cpc_ReadTile(tileX, tileY) != 10){
		result = 1;
	} 

    return result;
}

void s_moveX(struct s_Sprite *pSprite, int direction){
	if(direction == 1){
		pSprite->acumX += 2;
		if(pSprite->acumX >= TILE_WIDTH){
			pSprite->tilX++;
			pSprite->acumX = 0;
		}
		
		if(t_canMove(pSprite, pSprite->tilX, pSprite->tilY) == 0 || t_canMove(pSprite, pSprite->tilX, pSprite->tilY - 1) == 0 || t_canMove(pSprite, pSprite->tilX, pSprite->tilY + 1) == 0){
			pSprite->tilX--;
		}
		else if(pSprite->cx +2 <= MAP_MAX_X){
			pSprite->cx += 2;
		}
	}
	else{
		pSprite->acumX -= 2;
		if(pSprite->acumX <= -2){
			pSprite->tilX--;
			pSprite->acumX = 0;
		}
		
		if(t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY) == 0 || t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY - 1) == 0 || t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY + 1) == 0){
			pSprite->tilX++;
		}
		else if(pSprite->cx -2 >= MAP_MIN_X){
			pSprite->cx -= 2;
		}
	}
}

void s_canJump(struct s_Sprite *pSprite){
	if(pSprite->isJumping && pSprite->ySpeed < 0){

			pSprite->acumY -= 8;
        	if(pSprite->acumY <= -8){
        		pSprite->tilY--;
        		pSprite->acumY = 0;
        	}

        	if( (t_canMove(pSprite, pSprite->tilX, pSprite->tilY -2) == 0 || t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY -2) == 0)){
        		pSprite->tilY++;
        		pSprite->ySpeed = 8;
        	}
        	else{
        		pSprite->cy -= 8;
        	}

		}
		else 
			if(pSprite->ySpeed > 0){
				if(t_canMove(pSprite, pSprite->tilX, pSprite->tilY+2) == 1 && t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY+2) == 1){
													    
		        	if(t_canMove(pSprite, pSprite->tilX, pSprite->tilY+1) == 0 || t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY + 1) == 0){
		        		pSprite->tilY--;
		        		pSprite->isJumping = 0;
		        		pSprite->acumY = 0;
		        	}
		        	else if(t_canMove(pSprite, pSprite->tilX, pSprite->tilY) == 1 && t_canMove(pSprite, pSprite->tilX - 1, pSprite->tilY) == 1){
							pSprite->cy += 8;
							pSprite->acumY += 8;
				        	if(pSprite->acumY >= 8){
				        		pSprite->tilY++;
				        		pSprite->acumY = 0;
				        	}
		        	}
		        	
	        	}
	        	else{
	        		pSprite->isJumping = 0;
	        	}
			}
}

void c_exit(void){
	__asm
		call #0x0000
	__endasm;
}

void Show_Menu(void){
	unsigned int exit = 0;

	cpc_UnExo(background2,0xC000);
	cpc_PrintGphStrXY("1;EMPEZAR",1*2,5*8);
    cpc_PrintGphStrXY("2;UN;JUGADOR",1*2,7*8);
    cpc_PrintGphStrXY("3;DOS;JUGADORES",1*2,9*8);
    cpc_PrintGphStrXY("4;SALIR",1*2,11*8);
    
	while(exit==0){
		if (cpc_TestKey(KEY_ME1)==1) {if(predefined==1){init_keyboard();}exit=1;cpc_ClrScr();}
		if (cpc_TestKey(KEY_ME2)==1) {nplayers=1;}
		if (cpc_TestKey(KEY_ME3)==1) {nplayers=2;}
		if (cpc_TestKey(KEY_ME4)==1) {c_exit();}
	}
}

void Wait(void){
    unsigned int salir;
    salir=0;
	while(salir<35)
	{
	    if (cpc_AnyKeyPressed()) salir=35;
	    pause();
	    salir++;
	}
}

void Show_Intro(void){

        cpc_UnExo(background1,0xC000);
        cpc_PrintGphStrXY("REDFUR;Y;GREENFUR;SON;DOS;ZORROS;",1*2,17*8 + 2);
        cpc_PrintGphStrXY("RIVALES;QUE;HAN;ACUDIDO;A;LA;",1*2,18*8 + 2);
		cpc_PrintGphStrXY("INAUGURACION;DE;OESUM;",1*2,19*8 + 2);       
        cpc_PrintGphStrXY("AMBOS;QUIEREN;CONSEGUIR;LAS;GEMAS;",1*2,20*8 + 2);
        cpc_PrintGphStrXY("QUE;SERAN;EXPUESTAS;ALLI",1*2,21*8 + 2);
        Wait();
        cpc_ClrScr();
}


void init_keyboard(void){
    cpc_AssignKey (KEY_LEFT_P1, 0x4101);		// CUR LEFT
	cpc_AssignKey (KEY_RIGHT_P1, 0x4002);		// CUR RIGHT
	cpc_AssignKey (KEY_UP_P1, 0x4001);		    // CUR UP
	cpc_AssignKey (KEY_DOWN_P1, 0x4004);		// CUR DOWN
	
	cpc_AssignKey (KEY_LEFT_P2, 0x4820);		// CUR LEFT
	cpc_AssignKey (KEY_RIGHT_P2, 0x4720);		// CUR RIGHT
	cpc_AssignKey (KEY_UP_P2, 0x4708);		    // CUR UP
	cpc_AssignKey (KEY_DOWN_P2, 0x4710);		// CUR DOWN
}

void init_numbers_keys(void){
	cpc_AssignKey (KEY_ME1, 0x4801);		// 1
	cpc_AssignKey (KEY_ME2, 0x4802);		// 2
	cpc_AssignKey (KEY_ME3, 0x4702);		// 3
	cpc_AssignKey (KEY_ME4, 0x4701);		// 4
	//cpc_AssignKey (KEY_ESC, 0x4804);        // ESC
}


void s_disableBlink(){

			PlayerKeyFrames[Static_Right][1] = (unsigned char *)PlayerSpriteStatic;
			PlayerKeyFrames[Static_Left][1] = (unsigned char *)PlayerSpriteStaticL;
			PlayerKeyFrames[Walk_Right][1] = (unsigned char *)PlayerSpriteStatic;
			PlayerKeyFrames[Walk_Left][1] = (unsigned char *)PlayerSpriteStaticL;
			PlayerKeyFrames[Jump_Right][1] = (unsigned char *)PlayerSpriteJump;
			PlayerKeyFrames[Jump_Left][1] = (unsigned char *)PlayerSpriteJumpL;
			PlayerKeyFrames[Attack_Right][1] = (unsigned char *)PlayerSpriteAttack;
			PlayerKeyFrames[Attack_Left][1] = (unsigned char *)PlayerSpriteAttackL;
		//sprites[playerIndex].invincible = 0;
	
}

void g_initGemsSystem(void) {

	unsigned int i;
	FAST_ACCESS(gems,0).sp1 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,0).sp0 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,0).ox = 0;
	FAST_ACCESS(gems,0).oy = 0;
	FAST_ACCESS(gems,0).cx = 10;
	FAST_ACCESS(gems,0).cy = 10;
	FAST_ACCESS(gems,0).move1 = 3;
	FAST_ACCESS(gems,0).xDirection = 1;
	FAST_ACCESS(gems,0).yDirection = -2;
	FAST_ACCESS(gems,0).yMov = 0;
	FAST_ACCESS(gems,0).ySpeed = 2;
	FAST_ACCESS(gems,0).xSpeed = 1;
	FAST_ACCESS(gems,0).value =0;
	FAST_ACCESS(gems,0).acumX = 0;
	FAST_ACCESS(gems,0).acumY = 0;
	FAST_ACCESS(gems,0).tilX = 8;
	FAST_ACCESS(gems,0).tilY = 11;
	cpc_SuperbufferAddress(p_gems[0]); //first time it's important to do this

	FAST_ACCESS(gems,1).sp1 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,1).sp0 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,1).ox = 0;
	FAST_ACCESS(gems,1).oy = 0;
	FAST_ACCESS(gems,1).cx = 14;
	FAST_ACCESS(gems,1).cy = 10;
	FAST_ACCESS(gems,1).move1 = 3;
	FAST_ACCESS(gems,1).xDirection = -1;
	FAST_ACCESS(gems,1).yDirection = -2;
	FAST_ACCESS(gems,1).yMov = 0;
	FAST_ACCESS(gems,1).ySpeed = 1;
	FAST_ACCESS(gems,1).xSpeed = 1;
	FAST_ACCESS(gems,1).value =0;
	FAST_ACCESS(gems,1).acumX = 0;
	FAST_ACCESS(gems,1).acumY = 0;
	FAST_ACCESS(gems,1).tilX = 8;
	FAST_ACCESS(gems,1).tilY = 11;
	cpc_SuperbufferAddress(p_gems[1]); //first time it's important to do this

	FAST_ACCESS(gems,2).sp1 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,2).sp0 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,2).ox = 0;
	FAST_ACCESS(gems,2).oy = 0;
	FAST_ACCESS(gems,2).cx = 18;
	FAST_ACCESS(gems,2).cy = 10;
	FAST_ACCESS(gems,2).move1 = 3;
	FAST_ACCESS(gems,2).xDirection = 1;
	FAST_ACCESS(gems,2).yDirection = -2;
	FAST_ACCESS(gems,2).yMov = 0;
	FAST_ACCESS(gems,2).ySpeed = 1;
	FAST_ACCESS(gems,2).xSpeed = 2;
	FAST_ACCESS(gems,2).value =0;
	FAST_ACCESS(gems,2).acumX = 0;
	FAST_ACCESS(gems,2).acumY = 0;
	FAST_ACCESS(gems,2).tilX = 8;
	FAST_ACCESS(gems,2).tilY = 11;
	cpc_SuperbufferAddress(p_gems[2]); //first time it's important to do this

	FAST_ACCESS(gems,3).sp1 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,3).sp0 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,3).ox = 0;
	FAST_ACCESS(gems,3).oy = 0;
	FAST_ACCESS(gems,3).cx = 22;
	FAST_ACCESS(gems,3).cy = 10;
	FAST_ACCESS(gems,3).move1 = 3;
	FAST_ACCESS(gems,3).xDirection = -1;
	FAST_ACCESS(gems,3).yDirection = -2;
	FAST_ACCESS(gems,3).yMov = 0;
	FAST_ACCESS(gems,3).ySpeed = 1;
	FAST_ACCESS(gems,3).xSpeed = 2;
	FAST_ACCESS(gems,3).value =0;
	FAST_ACCESS(gems,3).acumX = 0;
	FAST_ACCESS(gems,3).acumY = 0;
	FAST_ACCESS(gems,3).tilX = 8;
	FAST_ACCESS(gems,3).tilY = 11;
	cpc_SuperbufferAddress(p_gems[3]); //first time it's important to do this

	FAST_ACCESS(gems,4).sp1 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,4).sp0 = (unsigned char *)notShowingGem;
	FAST_ACCESS(gems,4).ox = 0;
	FAST_ACCESS(gems,4).oy = 0;
	FAST_ACCESS(gems,4).cx = 26;
	FAST_ACCESS(gems,4).cy = 10;
	FAST_ACCESS(gems,4).move1 = 3;
	FAST_ACCESS(gems,4).xDirection = 1;
	FAST_ACCESS(gems,4).yDirection = -2;
	FAST_ACCESS(gems,4).yMov = 0;
	FAST_ACCESS(gems,4).ySpeed = 1;
	FAST_ACCESS(gems,4).xSpeed = 2;
	FAST_ACCESS(gems,4).value =0;
	FAST_ACCESS(gems,4).acumX = 0;
	FAST_ACCESS(gems,4).acumY = 0;
	FAST_ACCESS(gems,4).tilX = 8;
	FAST_ACCESS(gems,4).tilY = 11;
	cpc_SuperbufferAddress(p_gems[4]); //first time it's important to do this

	//SPAWNING GEMS


	lastSpawn = c_getTime();
	nextSpawn = 500;

	spawningGemsMask =0;
	spawningGem.sp1 = (unsigned char *)notShowingGem;//blueGemData;
	spawningGem.sp0 = (unsigned char *)notShowingGem;//blueGemData;
	spawningGem.ox = 0;
	spawningGem.oy = 0;
	spawningGem.cx = 20;
	spawningGem.cy = 10;
	spawningGem.move1 = 3;
	spawningGem.xDirection = 1;
	spawningGem.yDirection = -2;
	spawningGem.yMov = 0;
	spawningGem.ySpeed = 1;
	spawningGem.xSpeed = 2;
	spawningGem.value =0;
	cpc_SuperbufferAddress(p_spawningGem); //first time it's important to do this
}

void g_throwGems(unsigned char value, s_Sprite *target){
	unsigned char nGreen=0;
	unsigned char nRed=0;
	unsigned char nBlue=0;
	char nActiveGems = 0;
	unsigned char i = 0;
	unsigned char j = 0;

	target->gatheredGems -= value;
	
	nBlue = value / 10;
	if(!nBlue){
		nRed = value / 5;
		nGreen = value % 5;

	}
	nActiveGems = nGreen + nRed + nBlue;
	for(i = 0; i < MAX_GEMS_ARRAY; i++){
		gemsMask[i] = nActiveGems > 0 ? 1 : 0;
		nActiveGems--;
	}

	for(i = 0, j = 0; j < nGreen; i++, j++){
		gems[i].value = VALUE_GREEN_GEM;
		gems[i].cx = target->cx;
		gems[i].cy = target->cy;
		gems[i].ox = target->ox;
		gems[i].oy = target->oy;
		gems[i].sp0 = (unsigned char *)greenGemData;
		gems[i].sp1 = (unsigned char *)greenGemData;
	}

	for(j = 0; j < nRed; i++, j++){
		gems[i].value = VALUE_RED_GEM;
		gems[i].cx = target->cx;
		gems[i].cy = target->cy;
		gems[i].ox = target->ox;
		gems[i].oy = target->oy;
		gems[i].sp0 = (unsigned char *)redGemData;
		gems[i].sp1 = (unsigned char *)redGemData;
	}

	for(j = 0; j < nBlue; i++, j++){
		gems[i].value = VALUE_BLUE_GEM;
		gems[i].cx = target->cx;
		gems[i].cy = target->cy;
		gems[i].ox = target->ox;
		gems[i].oy = target->oy;
		gems[i].sp0 = (unsigned char *)blueGemData;
		gems[i].sp1 = (unsigned char *)blueGemData;
	}
}

void g_resetGems(void){

	gemsMask[0]=0;
	gemsMask[1]=0;
	gemsMask[2]=0;
	gemsMask[3]=0;
	gemsMask[4]=0;

		gems[0].sp0=(unsigned char *)notShowingGem;
		gems[1].sp0=(unsigned char *)notShowingGem;
		gems[2].sp0=(unsigned char *)notShowingGem;
		gems[3].sp0=(unsigned char *)notShowingGem;
		gems[4].sp0=(unsigned char *)notShowingGem;

		gems[0].sp1=(unsigned char *)notShowingGem;
		gems[1].sp1=(unsigned char *)notShowingGem;
		gems[2].sp1=(unsigned char *)notShowingGem;
		gems[3].sp1=(unsigned char *)notShowingGem;
		gems[4].sp1=(unsigned char *)notShowingGem;

		gems[0].xDirection = 1;
		gems[0].yDirection = -2;
		gems[0].yMov = 0;
		gems[0].ySpeed = 4;
		gems[0].xSpeed = 1;


		gems[1].xDirection = -1;
		gems[1].yDirection = -2;
		gems[1].yMov = 0;
		gems[1].ySpeed = 3;
		gems[1].xSpeed = 1;


		gems[2].xDirection = 1;
		gems[2].yDirection = -2;
		gems[2].yMov = 0;
		gems[2].ySpeed = 2;
		gems[2].xSpeed = 2;

		gems[3].xDirection = -1;
		gems[3].yDirection = -2;
		gems[3].yMov = 0;
		gems[3].ySpeed = 4;
		gems[3].xSpeed = 2;

		gems[4].xDirection = 1;
		gems[4].yDirection = -2;
		gems[4].yMov = 0;
		gems[4].ySpeed = 3;
		gems[4].xSpeed = 3;
}

unsigned char g_random(unsigned char n){

	// Esto no es para nada aleatorio, simplemente obtenemos la última cifra del tiempo
	// transcurrido desde el reseteo de la máquina. Así ganamos máquina

	// PSEUDO-CHUSTA-RANDOOOOOOOOOOM!!!!

	return (c_getTime() % n) + 1;

}

void g_spawnGem(unsigned char type){
	unsigned char holderIndex;
	unsigned char xPos;

	if(spawningGemsMask == 0){
	switch(type){
			case 1:
				spawningGem.value = VALUE_GREEN_GEM;
				spawningGem.sp0 = (unsigned char *)greenGemData;
				spawningGem.sp1 = (unsigned char *)greenGemData;
				break;
			case 2:
				spawningGem.value = VALUE_RED_GEM;
				spawningGem.sp0 = (unsigned char *)redGemData;
				spawningGem.sp1 = (unsigned char *)redGemData;
				break;
			case 3:
				spawningGem.value = VALUE_BLUE_GEM;
				spawningGem.sp0 = (unsigned char *)blueGemData;
				spawningGem.sp1 = (unsigned char *)blueGemData;
				break;
	}

	xPos = g_random(55);
	spawningGem.cx = xPos;
	spawningGem.cy = 8;
	spawningGem.ox = xPos;
	spawningGem.oy = 8;
	spawningGemsMask = 1;
	}
}

void g_updateGems(void){
	unsigned char i;

	for(i = 0; i<MAX_GEMS_ARRAY;i++){
		if(gemsMask[i] == 1){
			// POSICIONES EN Y
			gems[i].yMov = gems[i].yMov < 10 ? gems[i].yMov + 1 : gems[i].yMov;
			gems[i].yDirection = gems[i].yMov >= 10 || gems[i].cy<= 4 ? 1: gems[i].yDirection;
			gems[i].cy += gems[i].cy> 4 && gems[i].cy<148? gems[i].yDirection * gems[i].ySpeed : 4;

			// POSICIONES EN X
			gems[i].cx += gems[i].cx>0 && gems[i].cx<60 ? gems[i].xDirection * gems[i].xSpeed : 0;

			if(gems[i].cy>=148){
				gems[i].sp0 = (unsigned char *)notShowingGem;
				gems[i].sp1 = (unsigned char *)notShowingGem;
				gemsMask[i] = 0;
			}
		}
	}


	if(c_getTime()-lastSpawn > nextSpawn){
		lastSpawn += 500;
		nextSpawn = 500; // RANDOMIZARRRRR HIJO PERRA

		//lastSpawn = c_getTime();

		g_spawnGem(g_random(3));
	}

	if(spawningGemsMask == 1){
		// POSICIONES EN Y
		spawningGem.cy+=3;
		// POSICIONES EN X
		//spawningGems[i].cx = g_random(134);
		if(spawningGem.cy>=148){
			spawningGem.sp0 = (unsigned char *)notShowingGem;
			spawningGem.sp1 = (unsigned char *)notShowingGem;
			spawningGemsMask = 0;
		}
	}
}


	
	
void s_colorizePlayerData(unsigned char * data, unsigned char direction, unsigned char playerIndex){
	if(direction==1){ // Izquierda
		if(playerIndex==1){ //Player 1 ROJO
			data[41]= 0xA4;
			data[43]= 0x58;
			data[45]= 0x0C;
			data[47]= 0x5C;
			data[103]= 0x04;
			data[115]= 0x04;
			data[127]= 0x04;
		}else{	// Player 0
			data[41]= 0xA5;
			data[43]= 0x5A;
			data[45]= 0x0F;
			data[47]= 0x5E;
			data[103]= 0x00;
			data[115]= 0x00;
			data[127]= 0x00;
		}
		
	}else{	// Derecha
		if(playerIndex==1){ //Player 1 Rojo
			data[41]= 0xAC;
			data[43]= 0x0C;
			data[45]= 0xA4;
			data[47]= 0x58;
			data[105]= 0x08;
			data[117]= 0x08;
			data[129]= 0x08;
		}else{	// Player 0
			data[41]= 0xAD;
			data[43]= 0x0F;
			data[45]= 0xA5;
			data[47]= 0x5A;
			data[105]= 0x00;
			data[117]= 0x00;
			data[129]= 0x00;
		}
	}
}	

void initGame(void){

	cpc_WyzInitPlayer(SOUND_TABLE_1, RULE_TABLE_1, EFFECT_TABLE, SONG_TABLE_1);		//initialize data
	cpc_WyzLoadSong(0);	//Select song to play (uncompress it and the start to play)
	cpc_WyzSetPlayerOn();		//start music and sound effects (SFX)
	cpc_WyzSetTempo(5);  //adjust music timing!!!
	for(numSprite = 0; numSprite < 2; numSprite++){
		p_sprites[numSprite] = &sprites[numSprite];
    }
    
    for(numSprite = 0; numSprite < MAX_GEMS_ARRAY; numSprite++){
    	p_gems[numSprite] = &gems[numSprite];

    }
    p_spawningGem = &spawningGem;

	
    PlayerKeyFrames[Static_Right][0] = (unsigned char *)PlayerSpriteStatic;
    PlayerKeyFrames[Static_Right][1] = (unsigned char *)PlayerSpriteStatic;
    PlayerKeyFrames[Static_Right][2] = (unsigned char *)PlayerSpriteStatic;

    PlayerKeyFrames[Static_Left][0] = (unsigned char *)PlayerSpriteStaticL;
    PlayerKeyFrames[Static_Left][1] = (unsigned char *)PlayerSpriteStaticL;
    PlayerKeyFrames[Static_Left][2] = (unsigned char *)PlayerSpriteStaticL;

    PlayerKeyFrames[Walk_Right][0] = (unsigned char *)PlayerSpriteWalk1;
    PlayerKeyFrames[Walk_Right][1] = (unsigned char *)PlayerSpriteStatic;
    PlayerKeyFrames[Walk_Right][2] = (unsigned char *)PlayerSpriteWalk2;

    PlayerKeyFrames[Walk_Left][0] = (unsigned char *)PlayerSpriteWalk1L;
    PlayerKeyFrames[Walk_Left][1] = (unsigned char *)PlayerSpriteStaticL;
    PlayerKeyFrames[Walk_Left][2]= (unsigned char *)PlayerSpriteWalk2L;

    PlayerKeyFrames[Jump_Right][0] = (unsigned char *)PlayerSpriteJump;
    PlayerKeyFrames[Jump_Right][1] = (unsigned char *)PlayerSpriteJump;
    PlayerKeyFrames[Jump_Right][2] = (unsigned char *)PlayerSpriteJump;

    PlayerKeyFrames[Jump_Left][0] = (unsigned char *)PlayerSpriteJumpL;
    PlayerKeyFrames[Jump_Left][1] = (unsigned char *)PlayerSpriteJumpL;
    PlayerKeyFrames[Jump_Left][2] = (unsigned char *)PlayerSpriteJumpL;

    PlayerKeyFrames[Attack_Right][0] = (unsigned char *)PlayerSpriteAttack;
    PlayerKeyFrames[Attack_Right][1] = (unsigned char *)PlayerSpriteAttack;
    PlayerKeyFrames[Attack_Right][2] = (unsigned char *)PlayerSpriteAttack;

    PlayerKeyFrames[Attack_Left][0] = (unsigned char *)PlayerSpriteAttackL;
    PlayerKeyFrames[Attack_Left][1] = (unsigned char *)PlayerSpriteAttackL;
    PlayerKeyFrames[Attack_Left][2] = (unsigned char *)PlayerSpriteAttackL;
	
    setColours();
    cpc_SetModo(0);
	cpc_SetInkGphStr(0,0);

    //cpc_DisableFirmware();

    FAST_ACCESS(sprites,0).sp1 = (unsigned char *)PlayerKeyFrames[Static_Left][0];
    FAST_ACCESS(sprites,0).sp0 = (unsigned char *)PlayerKeyFrames[Static_Left][0];
    FAST_ACCESS(sprites,0).ox = 0;
    FAST_ACCESS(sprites,0).oy = 0;
    FAST_ACCESS(sprites,0).cx = (30 - 2)*2;
    FAST_ACCESS(sprites,0).cy = (11-1)*8;
    FAST_ACCESS(sprites,0).move1 = 3;
    FAST_ACCESS(sprites,0).isJumping = 0;
    FAST_ACCESS(sprites,0).ySpeed = 0;
    FAST_ACCESS(sprites,0).gravity = 2;
    FAST_ACCESS(sprites,0).actualFrame = 0;
    FAST_ACCESS(sprites,0).frameSpeed = 40;
    FAST_ACCESS(sprites,0).lastMoveTime = c_getTime();
    FAST_ACCESS(sprites,0).state = Static_Left;
    FAST_ACCESS(sprites,0).lastState = Static_Left;
    FAST_ACCESS(sprites,0).acumX = 0;
    FAST_ACCESS(sprites,0).acumY = 0;
    FAST_ACCESS(sprites,0).tilX = 30;
    FAST_ACCESS(sprites,0).tilY = 11;
    FAST_ACCESS(sprites,0).gatheredGems = 0;
    FAST_ACCESS(sprites,0).invincible = 0;
	cpc_SuperbufferAddress(p_sprites[0]); //first time it's important to do this

	FAST_ACCESS(sprites,1).sp1 = (unsigned char *)PlayerKeyFrames[Static_Right][0];
	FAST_ACCESS(sprites,1).sp0 = (unsigned char *)PlayerKeyFrames[Static_Right][0];
	FAST_ACCESS(sprites,1).ox = 0;
	FAST_ACCESS(sprites,1).oy = 0;
	FAST_ACCESS(sprites,1).cx = (3 - 2)*2;
    FAST_ACCESS(sprites,1).cy = (11-1)*8;
	FAST_ACCESS(sprites,1).move = 1;
	FAST_ACCESS(sprites,1).move1 = 3;
	FAST_ACCESS(sprites,1).isJumping = 0;
	FAST_ACCESS(sprites,1).ySpeed = 0;
	FAST_ACCESS(sprites,1).gravity = 2;
    FAST_ACCESS(sprites,1).actualFrame = 0;
    FAST_ACCESS(sprites,1).frameSpeed = 40;
    FAST_ACCESS(sprites,1).lastMoveTime = c_getTime();
    FAST_ACCESS(sprites,1).state = Static_Right;
    FAST_ACCESS(sprites,1).lastState = Static_Right;
	FAST_ACCESS(sprites,1).acumX = 0;
	FAST_ACCESS(sprites,1).acumY = 0;
	FAST_ACCESS(sprites,1).tilX = 3;
	FAST_ACCESS(sprites,1).tilY = 11;
	FAST_ACCESS(sprites,1).gatheredGems = 0;
	FAST_ACCESS(sprites,1).invincible = 0;
	cpc_SuperbufferAddress(p_sprites[1]);
	
	setTilemap();

	cpc_ShowTileMap();

	predefined=1;
	init_numbers_keys();
    
    Show_Intro();
	Show_Menu();
	
	cpc_UnExo(background2,0xC000);

	g_initGemsSystem();
	
	cifra1Time=0;
	cifra0Time=6;

	cifra0ScoreP2=0;
	cifra1ScoreP2=0;
	cifra2ScoreP2=0;
	cifra3ScoreP2=0;

    cifra0ScoreP1=0;
	cifra1ScoreP1=0;
	cifra2ScoreP1=0;
	cifra3ScoreP1=0;

	cpc_PutSp(Cero,8,2,0xceee);
	cpc_PutSp(Cero,8,2,0xcef0);
	cpc_PutSp(Cero,8,2,0xcef2);
	cpc_PutSp(Cero,8,2,0xcef4);
	
	cpc_PutSp(Seis,8,2,0xcf26);
	cpc_PutSp(Cero,8,2,0xcf28);
	
    cpc_PutSp(Cero,8,2,0xcf10);
	cpc_PutSp(Cero,8,2,0xcf12);
	cpc_PutSp(Cero,8,2,0xcf14);
	cpc_PutSp(Cero,8,2,0xcf16);
	
	cpc_PrintGphStrXY("PLAYER;1",12,165); 
	cpc_PrintGphStrXY("PLAYER;2",45,165); 
	cpc_PrintGphStrXY("TIME",68,165); 

}

unsigned char calculateDistance(unsigned char playerNumber){

    char result = 0;
	unsigned char c = 0;
	int amount = 100;
	int amount1 = 0;
	int acum = 0;
	int spriteTilX = sprites[playerNumber].tilX;
	int spriteTilY = sprites[playerNumber].tilY;

	for(c = 0; c < 20; c += 2){
		amount1 = pointOfInterest[c] - spriteTilX;
		if(amount1 < 0)
			amount1 *= -1;
		acum = pointOfInterest[c+1] - spriteTilY;
		if(acum < 0)
			acum *= -1;
		amount1 += acum;
		if(amount1  < amount){
			result = c;
			amount = amount1;
		}
	}

	return result;
}