/**
 * @file  exographics.h

 * @author Ángel González Redondo
 * @author Dulce Isis Segarra López
 * @author Tomás Alemañ Baeza
 * @author Rómulo Espinosa Montoya
 * @author Jorge Torregrosa Lloret
 * @date   September, 2013
 * @brief  Main file of the game.
 *
 * This file contain the main loop of our game.
 * The game is made for the Retroconsolas Alicante 2013 event.
 *
 * It is released under a GPL 3.0 license.
 *  Copyright (C) 2013  Cocos
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Special thanks to Mochilote from CPCMANIA(www.cpcmania.com) for the info
 * and Raúl Simarro for the library. 
 *
 *   ____  _____  _  _    ____  __  __  ____   ___  __      __    ____
 *  ( ___)(  _  )( \/ )  (  _ \(  )(  )(  _ \ / __)(  )    /__\  (  _ \
 *   )__)  )(_)(  )  (    ) _ < )(__)(  )   /( (_-. )(__  /(__)\  )   /
 *  (__)  (_____)(_/\_)  (____/(______)(_)\_) \___/(____)(__)(__)(_)\_)
 *
 */

#ifndef EXOGRAPHICS_H_
#define EXOGRAPHICS_H_
const unsigned char background1[] = {
0x22, 0x23, 0x45, 0x55, 0x97, 0x56, 0x43, 0x60, 0x13, 0x55, 0x24, 0x58, 0x9A, 0x70, 0x0B, 0xBD,
    0x01, 0x03, 0x61, 0x46, 0x76, 0xA9, 0x57, 0x00, 0x00, 0x01, 0xF0, 0x01, 0xB8, 0x3C, 0xA0, 0x08,
    0x0C, 0xDA, 0x0A, 0xCD, 0x30, 0x00, 0x44, 0xFF, 0x04, 0xFE, 0x0C, 0x5C, 0xFC, 0xAC, 0x88, 0x04,
    0x4C, 0x90, 0x84, 0x7D, 0x00, 0x50, 0x44, 0xC3, 0x69, 0x8A, 0xD4, 0xEB, 0x86, 0xF0, 0xE4, 0x55,
    0x34, 0x85, 0x45, 0x48, 0x73, 0x6F, 0x28, 0x14, 0x50, 0xF4, 0xB5, 0xF0, 0x55, 0xFF, 0x21, 0x6D,
    0x0A, 0x1F, 0xE5, 0x54, 0xF4, 0xFC, 0xDC, 0xFB, 0x0C, 0x44, 0xCC, 0x08, 0xD8, 0x1D, 0x98, 0xCA,
    0x95, 0xDA, 0x91, 0x49, 0x48, 0x8B, 0x2A, 0x0E, 0x40, 0xA9, 0xE5, 0x97, 0x51, 0x2B, 0x1D, 0xC5,
    0x94, 0x57, 0xA0, 0x7D, 0xBE, 0xA5, 0x3C, 0x3F, 0xF0, 0x7F, 0xCF, 0x00, 0x28, 0x51, 0xD0, 0xD8,
    0xB6, 0x0F, 0x01, 0x9A, 0x6E, 0xDB, 0x77, 0x72, 0x02, 0x50, 0x55, 0x50, 0xB0, 0x0E, 0x41, 0xE4,
    0xA1, 0xFC, 0x88, 0x11, 0xA4, 0xC9, 0x42, 0xE5, 0x9B, 0xF6, 0xA0, 0x10, 0x58, 0x1A, 0x6A, 0x54,
    0xA8, 0x36, 0x31, 0x07, 0x1E, 0x71, 0xE1, 0xD2, 0x0C, 0x7D, 0xE1, 0xFC, 0xA8, 0x64, 0x3C, 0x54,
    0x50, 0xE4, 0x4F, 0xE5, 0x72, 0xCF, 0x11, 0x90, 0x33, 0x19, 0x22, 0xA5, 0x46, 0xE9, 0x67, 0x00,
    0x18, 0xA6, 0xEF, 0x9A, 0x82, 0x68, 0xF4, 0x72, 0x96, 0xE1, 0xC3, 0xE0, 0x34, 0x06, 0x96, 0x21,
    0xCE, 0x54, 0xA2, 0xE8, 0x54, 0x22, 0xD5, 0x4F, 0x8A, 0xEC, 0x47, 0xD4, 0xA5, 0x72, 0xB4, 0x8A,
    0x0F, 0x2A, 0x05, 0x83, 0xEB, 0xD2, 0xA0, 0x2A, 0x90, 0x04, 0x72, 0xA0, 0x4D, 0x45, 0x0B, 0xDA,
    0x15, 0x6E, 0x44, 0xFC, 0x28, 0x16, 0x15, 0x3D, 0x00, 0xE5, 0x45, 0xC5, 0x85, 0x83, 0x0F, 0x44,
    0xB8, 0xDC, 0xC7, 0x37, 0x59, 0x8A, 0x51, 0xDD, 0xDA, 0x50, 0x1E, 0xA2, 0x2B, 0xBB, 0x39, 0x8C,
    0xC0, 0x61, 0xFB, 0xB1, 0x41, 0x39, 0x3D, 0x0F, 0x41, 0xDD, 0xEF, 0x22, 0x05, 0x9C, 0x0F, 0xA0,
    0xB3, 0xD6, 0x0C, 0x88, 0x92, 0x09, 0x02, 0x0E, 0x42, 0xE8, 0x9D, 0x22, 0x29, 0x28, 0xD6, 0x69,
    0x19, 0x51, 0x53, 0xDD, 0x22, 0xCF, 0x0A, 0x0A, 0x74, 0x5D, 0xCE, 0xC7, 0x2F, 0x21, 0x04, 0x83,
    0x50, 0x91, 0xBD, 0x24, 0x51, 0x13, 0x85, 0x43, 0x61, 0xA3, 0x2F, 0x22, 0x41, 0x27, 0x71, 0x73,
    0x3D, 0xA2, 0x9A, 0x9D, 0xA0, 0x66, 0xA8, 0x06, 0xD0, 0xD4, 0x80, 0x50, 0xBA, 0x4B, 0x41, 0x95,
    0x70, 0xD2, 0xD8, 0x21, 0x70, 0x54, 0x9E, 0x44, 0x37, 0x89, 0xDB, 0x89, 0x53, 0xF3, 0xDA, 0x38,
    0xCD, 0x45, 0x66, 0x6D, 0xA0, 0x88, 0x4B, 0xC6, 0xE4, 0x52, 0xD2, 0xDA, 0xA0, 0xEA, 0xCD, 0x50,
    0xCC, 0x6C, 0x35, 0x4A, 0x00, 0x00, 0x7D, 0x00, 0x07, 0x17, 0x0C, 0xE0, 0x4C, 0x8C, 0xA8, 0x54,
    0x69, 0xE1, 0x9E, 0xBE, 0x6D, 0xE4, 0xCF, 0xCE, 0xA8, 0x0C, 0xFC, 0x41, 0x2F, 0x08, 0xAC, 0x4C,
    0xD8, 0x12, 0x56, 0xB0, 0x4B, 0x13, 0x13, 0x13, 0x4F, 0x45, 0x9E, 0xAA, 0x3D, 0x15, 0x7A, 0x8A,
    0xFC, 0xAA, 0x2E, 0x47, 0x9A, 0xFC, 0xB1, 0xD7, 0x4C, 0xD8, 0xEE, 0xC7, 0x22, 0x4D, 0x4A, 0xE2,
    0x8F, 0x33, 0x05, 0x8A, 0x8F, 0x87, 0xC6, 0x42, 0xA0, 0xA4, 0xDA, 0x04, 0x0A, 0xD2, 0xD0, 0x7D,
    0x3C, 0xED, 0x55, 0x3F, 0x15, 0x26, 0xF8, 0x1C, 0xE3, 0xCA, 0xD6, 0x62, 0xF0, 0x04, 0xD8, 0xF3,
    0xAF, 0xE2, 0xEC, 0x45, 0x26, 0x25, 0x6E, 0x16, 0x75, 0xD1, 0x26, 0xBA, 0xFA, 0x41, 0xEC, 0x00,
    0xDC, 0xFC, 0x83, 0x3C, 0x10, 0x6C, 0xE8, 0x23, 0x4E, 0x2C, 0xB7, 0xCE, 0xA4, 0x44, 0x2E, 0x99,
    0x3C, 0xC3, 0x50, 0xD8, 0xB2, 0xD9, 0xB4, 0x03, 0xCF, 0x0A, 0x95, 0xCF, 0x4F, 0x6C, 0x8A, 0xFD,
    0x70, 0xA8, 0x63, 0x1E, 0x0A, 0x19, 0xFC, 0x54, 0x6A, 0xD4, 0xA0, 0xD8, 0x7D, 0x12, 0x4C, 0x7D,
    0x5C, 0x06, 0x4F, 0x11, 0xF8, 0x17, 0x13, 0xE8, 0xDA, 0x7E, 0x5C, 0x50, 0xAE, 0x9D, 0x9F, 0xA0,
    0xAE, 0x88, 0xF0, 0x4F, 0x77, 0x58, 0x61, 0x35, 0xB1, 0x4E, 0xD8, 0x15, 0x0A, 0x42, 0x75, 0xC3,
    0x93, 0xC5, 0x62, 0x0F, 0x41, 0x38, 0xA1, 0x21, 0x7F, 0xDC, 0x7A, 0x18, 0x1E, 0xE4, 0x21, 0xF9,
    0xA0, 0x65, 0xC9, 0x05, 0x32, 0x4F, 0x4C, 0x65, 0x63, 0xC2, 0x1A, 0x08, 0x8D, 0x45, 0xA9, 0x88,
    0x23, 0x89, 0x06, 0xE4, 0xEC, 0x76, 0x03, 0x9F, 0x9D, 0xCF, 0xEC, 0xCF, 0x75, 0x1F, 0x13, 0xD2,
    0x88, 0x05, 0xC0, 0xD3, 0xB7, 0x95, 0xDB, 0x09, 0x19, 0x91, 0xC9, 0xDD, 0x8A, 0x05, 0x22, 0x89,
    0xEB, 0xCA, 0xC8, 0x68, 0x7E, 0x09, 0x07, 0xAD, 0x00, 0xA8, 0x14, 0xC0, 0x16, 0x82, 0xE5, 0x08,
    0x40, 0xEE, 0xED, 0xCE, 0x37, 0xC6, 0xD5, 0x88, 0xD8, 0x11, 0xA9, 0xCD, 0x33, 0x95, 0xD7, 0xCD,
    0x58, 0x83, 0xC8, 0x68, 0x8A, 0x45, 0xBC, 0x85, 0x1B, 0xDA, 0xE5, 0x43, 0x81, 0x8D, 0x6A, 0x7C,
    0x4D, 0x08, 0x76, 0xE5, 0x3A, 0xDC, 0xCC, 0xF2, 0xA5, 0xD2, 0x53, 0xFC, 0x8A, 0xDA, 0xCD, 0x00,
    0x1A, 0xCD, 0xE5, 0x8C, 0x70, 0x7C, 0x04, 0x5C, 0xED, 0x0A, 0x74, 0x19, 0x78, 0x3F, 0x00, 0xFF,
    0x78, 0x71, 0x37, 0x04, 0xDC, 0xB5, 0xCC, 0xD7, 0x00, 0xE2, 0x50, 0x4B, 0xF2, 0x91, 0xB7, 0xD7,
    0xB5, 0x1C, 0x2E, 0x20, 0xFB, 0xD4, 0x51, 0x36, 0x20, 0x69, 0x21, 0x7D, 0x29, 0xBF, 0x8A, 0xFF,
    0x75, 0x82, 0x38, 0xAA, 0xF5, 0x5A, 0x9F, 0x45, 0xFC, 0x04, 0xE4, 0x08, 0xCC, 0x88, 0xC2, 0x9C,
    0x66, 0xA0, 0xC7, 0x38, 0x31, 0xE4, 0x5C, 0x50, 0x98, 0xA0, 0xAA, 0xEA, 0xDF, 0x14, 0x3C, 0x28,
    0xFF, 0x2B, 0x82, 0x7A, 0xFB, 0xED, 0x68, 0xA0, 0x81, 0x10, 0x00, 0x53, 0x90, 0xA0, 0x75, 0x3B,
    0x45, 0xE2, 0x01, 0x18, 0x16, 0xC2, 0x13, 0x3B, 0x50, 0xF4, 0xEC, 0x3B, 0x92, 0xC8, 0xEA, 0x41,
    0xD4, 0xC4, 0x20, 0xEF, 0xFC, 0x13, 0x72, 0x14, 0x05, 0x95, 0xE4, 0x7C, 0xAF, 0x0A, 0xCC, 0x22,
    0xE4, 0x0A, 0x0D, 0x01, 0xDD, 0xF0, 0xF4, 0x30, 0x25, 0x93, 0xD2, 0xF0, 0x00, 0x99, 0xDC, 0xA8,
    0x43, 0xBD, 0x82, 0xC8, 0xE5, 0x72, 0x76, 0x18, 0x5C, 0x57, 0x7C, 0x9B, 0xFE, 0xAC, 0xE5, 0x2C,
    0xCB, 0x80, 0x96, 0x2D, 0xB8, 0xED, 0x8A, 0x0A, 0x87, 0xC3, 0x42, 0xD4, 0xCE, 0xE5, 0xC3, 0x2E,
    0x57, 0x72, 0xBB, 0x33, 0x00, 0x8F, 0x53, 0x41, 0xF2, 0x44, 0x33, 0xD0, 0x8E, 0xA3, 0xD2, 0x10,
    0xB2, 0xE0, 0x10, 0xB0, 0xFA, 0x87, 0x0B, 0x96, 0x8F, 0x71, 0xBA, 0x05, 0xA8, 0xE4, 0xED, 0x88,
    0xDA, 0xF9, 0x7F, 0x24, 0x08, 0x64, 0xD2, 0x33, 0x10, 0x2F, 0x07, 0x41, 0xE7, 0x13, 0x7B, 0x19,
    0xD6, 0xA0, 0xA0, 0xF4, 0x2C, 0xFA, 0xA0, 0xFC, 0xCC, 0x32, 0xE5, 0x17, 0x0E, 0x66, 0x15, 0x56,
    0x0A, 0x8B, 0xB8, 0x95, 0x45, 0x66, 0xE2, 0xEF, 0xF4, 0x13, 0x8D, 0xA6, 0x44, 0x45, 0xC3, 0xC0,
    0x27, 0x03, 0xC7, 0xC2, 0x8A, 0xCF, 0xD4, 0x5E, 0x6C, 0x66, 0x8F, 0xE9, 0x79, 0x4D, 0xB5, 0x7C,
    0xD1, 0x44, 0xCC, 0x53, 0x1D, 0xFC, 0xCF, 0xDA, 0xEA, 0x9A, 0xEB, 0x08, 0xCD, 0x38, 0x98, 0xFA,
    0xFA, 0x95, 0x25, 0x0A, 0xD3, 0x3C, 0xF5, 0xC2, 0xCE, 0xC2, 0x72, 0xC7, 0xCF, 0x71, 0x56, 0xA0,
    0xE5, 0x94, 0xD2, 0x00, 0x17, 0xCD, 0x04, 0x0C, 0xB1, 0x20, 0x28, 0x93, 0x7F, 0xE5, 0x3F, 0xAF,
    0x7F, 0xA0, 0x1C, 0x68, 0xAD, 0x0C, 0xD6, 0xBE, 0x50, 0x08, 0x44, 0x88, 0x0C, 0x93, 0x94, 0x6F,
    0xDA, 0x21, 0xBB, 0xC8, 0xD4, 0x79, 0x8D, 0x8F, 0x8A, 0x44, 0xAA, 0x25, 0x25, 0x17, 0x63, 0x27,
    0x3C, 0xBF, 0x2A, 0xAB, 0x01, 0x17, 0xF5, 0x3F, 0x57, 0x0C, 0x56, 0xD5, 0x54, 0xA8, 0x6C, 0x60,
    0x1B, 0x11, 0x26, 0xD2, 0x30, 0x82, 0xD0, 0x56, 0x58, 0xDA, 0x8F, 0x14, 0x5F, 0xE0, 0x15, 0x7F,
    0x50, 0x28, 0xE9, 0xD6, 0x0C, 0xE8, 0x4B, 0x9C, 0xE5, 0x83, 0xDA, 0x51, 0x05, 0x99, 0xF0, 0xE5,
    0x00, 0x27, 0x4E, 0x00, 0x0E, 0x62, 0x02, 0xE3, 0x55, 0x9B, 0xCC, 0x78, 0x5B, 0xC1, 0x0A, 0x63,
    0xD2, 0x39, 0x85, 0xB7, 0xEA, 0x8A, 0x68, 0xDA, 0xE5, 0x11, 0xBC, 0xDE, 0x9B, 0x9C, 0x6A, 0x27,
    0x50, 0x7C, 0x99, 0x05, 0x5F, 0x9B, 0x87, 0x4D, 0x91, 0xA7, 0x3E, 0x82, 0xED, 0xF8, 0xE5, 0xDC,
    0x54, 0xA8, 0xAF, 0xD4, 0xFE, 0x04, 0x1B, 0x63, 0x62, 0x14, 0x11, 0x6E, 0x0A, 0x56, 0xA9, 0x05,
    0xA2, 0xF7, 0x65, 0xC9, 0x63, 0xF0, 0xA1, 0x48, 0x5A, 0x10, 0xAF, 0x00, 0x25, 0x9B, 0xDC, 0xD2,
    0xC2, 0x58, 0xE5, 0xD5, 0x34, 0xF0, 0x9B, 0xB1, 0x72, 0x54, 0x99, 0x8A, 0x53, 0x6A, 0x9F, 0xD4,
    0x45, 0xD8, 0xCF, 0x86, 0xC5, 0xFB, 0x54, 0xE8, 0xCD, 0x0E, 0x51, 0x09, 0x9A, 0xC4, 0xF4, 0xBD,
    0xA7, 0x4B, 0xC9, 0x72, 0xA0, 0x5E, 0xBB, 0xCF, 0x8A, 0x11, 0xF7, 0xFE, 0x16, 0xA3, 0xA2, 0x5C,
    0x07, 0xE0, 0xC2, 0xC6, 0x15, 0x76, 0x2C, 0xF8, 0x3C, 0xEA, 0xAE, 0x0E, 0x05, 0x22, 0x11, 0xE5,
    0x31, 0xF1, 0xD6, 0x01, 0x84, 0xA8, 0xCF, 0x93, 0x87, 0x84, 0xE5, 0x33, 0x25, 0x8A, 0x8C, 0xF4,
    0x8A, 0x4E, 0x34, 0xE2, 0x77, 0xBB, 0xE0, 0xF4, 0x50, 0x45, 0x3F, 0xC1, 0xE9, 0x84, 0x8A, 0xBD,
    0xEB, 0xDA, 0x17, 0xA4, 0xEF, 0x5E, 0x2E, 0x35, 0x31, 0xD7, 0xCC, 0x88, 0xFD, 0xE1, 0xEC, 0xCE,
    0xF8, 0xC9, 0x55, 0xCE, 0x00, 0x14, 0x36, 0xEC, 0xE4, 0x24, 0x00, 0x16, 0xCA, 0x44, 0x0B, 0xE9,
    0x2F, 0xC0, 0xD8, 0xA7, 0x7F, 0xF6, 0xFF, 0x14, 0xBF, 0xBE, 0x0E, 0xCA, 0x08, 0xD8, 0xE7, 0x44,
    0xCC, 0x6C, 0x24, 0x86, 0x81, 0x59, 0x45, 0x1B, 0x14, 0x42, 0x63, 0x8E, 0x43, 0x14, 0x57, 0xFE,
    0x2A, 0x3C, 0x01, 0x50, 0x15, 0xF0, 0x57, 0x1B, 0xC1, 0x57, 0x54, 0xEC, 0x9B, 0xCC, 0x25, 0x50,
    0x12, 0x1B, 0xB5, 0x78, 0xF2, 0xDE, 0x8F, 0xC0, 0x7F, 0x14, 0x55, 0xC0, 0x28, 0x3F, 0x24, 0x96,
    0xD2, 0xA0, 0x3C, 0xC9, 0x7A, 0x45, 0x8A, 0x4D, 0xC3, 0x7C, 0x24, 0xAB, 0x8A, 0x16, 0x54, 0xB0,
    0x7F, 0x2D, 0x5E, 0xE7, 0xB0, 0x17, 0x2A, 0xA0, 0x20, 0xE6, 0xA4, 0x45, 0xD9, 0xF4, 0xD4, 0xA8,
    0x0C, 0x18, 0x84, 0x1F, 0x4C, 0x44, 0x9B, 0xCD, 0xE6, 0x4D, 0x7D, 0xCA, 0x86, 0xDF, 0x62, 0xA7,
    0x49, 0x5E, 0x57, 0x51, 0x18, 0x6D, 0x0F, 0x7F, 0x63, 0x45, 0x3F, 0x0B, 0xB2, 0xCC, 0xDC, 0x09,
    0x61, 0xD5, 0x16, 0x21, 0xAE, 0x82, 0x27, 0x6A, 0x7B, 0x8A, 0x77, 0x58, 0x91, 0xC3, 0xE0, 0x4E,
    0xAA, 0xD4, 0xE1, 0xF7, 0xB2, 0xCB, 0x82, 0xA1, 0xCD, 0xC0, 0x7D, 0xFF, 0xC1, 0xEA, 0x36, 0x82,
    0xD4, 0x4D, 0x54, 0x72, 0x81, 0x4B, 0xA7, 0xD4, 0x28, 0xA3, 0x9B, 0xC3, 0x17, 0x9E, 0x99, 0xE3,
    0x0A, 0x50, 0xE2, 0x0B, 0x20, 0xC3, 0x45, 0xDC, 0x86, 0xD2, 0x35, 0x59, 0xB7, 0xA0, 0x11, 0x54,
    0x46, 0xF0, 0x00, 0x1B, 0x2E, 0x1B, 0xED, 0xE1, 0x19, 0x04, 0x07, 0xB4, 0xEF, 0x98, 0xC3, 0xF4,
    0x8F, 0xFC, 0xA8, 0x5A, 0x11, 0xAF, 0xCD, 0xCF, 0x49, 0x26, 0x1E, 0x19, 0x90, 0xDA, 0x5D, 0x32,
    0x54, 0xCF, 0xE1, 0xA8, 0x44, 0xFC, 0x08, 0xD5, 0x8E, 0x78, 0xB2, 0xAC, 0xE6, 0x7E, 0xE9, 0xF1,
    0xE5, 0xB7, 0x91, 0xD0, 0x8A, 0x00, 0x96, 0xCF, 0xC9, 0x85, 0x34, 0xE5, 0xDA, 0xE9, 0x58, 0x86,
    0xEE, 0xA6, 0x57, 0x68, 0x5D, 0xE1, 0x00, 0x5F, 0x57, 0xC5, 0x2A, 0xE4, 0x65, 0x41, 0xDB, 0x87,
    0xE2, 0xFB, 0xF7, 0xAF, 0x01, 0x38, 0x00, 0x01, 0x8C, 0xFD, 0xCE, 0x0C, 0x50, 0x8C, 0xFC, 0x44,
    0x2C, 0xCC, 0x50, 0x36, 0x3E, 0x53, 0xDA, 0xD3, 0x10, 0xDD, 0xD6, 0x95, 0x55, 0xFA, 0x15, 0xF8,
    0x63, 0x8B, 0xD7, 0xA0, 0xD5, 0x23, 0x36, 0x4D, 0x00, 0x88, 0x1F, 0x1C, 0x28, 0x07, 0xE2, 0x93,
    0x65, 0x55, 0x7F, 0x28, 0x00, 0xF0, 0x3F, 0xB5, 0x7F, 0xFA, 0xE9, 0x6C, 0x0B, 0x54, 0x88, 0x60,
    0x41, 0x84, 0x82, 0x9C, 0x25, 0x58, 0xAE, 0xF8, 0xA4, 0x4C, 0xD7, 0x28, 0xBF, 0x80, 0x2F, 0xCB,
    0x00, 0x51, 0xBA, 0x8A, 0x70, 0xA2, 0xA8, 0x95, 0x13, 0xA0, 0xD8, 0x48, 0x1E, 0xC4, 0x68, 0xEC,
    0x89, 0xDA, 0x8D, 0xFD, 0x1E, 0xC9, 0x99, 0x4C, 0x70, 0x44, 0x45, 0x9B, 0x95, 0x9D, 0x97, 0xFC,
    0x00, 0x67, 0xF8, 0x04, 0x72, 0xD2, 0x63, 0xC3, 0x2A, 0x8C, 0xE4, 0x54, 0x33, 0x29, 0x41, 0xE1,
    0x0F, 0x99, 0x8A, 0x3E, 0x2C, 0xD3, 0x45, 0xA6, 0xDA, 0x05, 0x30, 0xDC, 0x09, 0x9D, 0xFA, 0x49,
    0xE6, 0xA8, 0x61, 0xB5, 0x1B, 0xFB, 0x72, 0xFB, 0xFF, 0x4A, 0x8D, 0xA0, 0xBB, 0xB2, 0xB6, 0xF6,
    0x5D, 0x45, 0x00, 0xF7, 0xD0, 0xA7, 0x17, 0xE3, 0x61, 0x41, 0x44, 0x39, 0x44, 0xF4, 0xD0, 0x6C,
    0x77, 0x6C, 0x67, 0x19, 0x54, 0x4A, 0x93, 0x4C, 0xD9, 0x0A, 0x93, 0x57, 0x8F, 0x0F, 0x19, 0xC4,
    0x67, 0xA5, 0x78, 0x30, 0xD5, 0x11, 0x68, 0xEB, 0xA9, 0x27, 0x8F, 0xDE, 0xEF, 0xAE, 0x45, 0xB2,
    0x4F, 0xB7, 0x59, 0x53, 0x2C, 0xFB, 0x89, 0x01, 0x96, 0x63, 0xA0, 0xF8, 0x53, 0x1F, 0x05, 0x8A,
    0x27, 0x45, 0x4A, 0x11, 0xF0, 0x08, 0x1B, 0x00, 0x97, 0xDE, 0xE5, 0xF8, 0x0E, 0x2D, 0xBC, 0x7D,
    0x86, 0x8B, 0x1A, 0xB6, 0x00, 0x64, 0x07, 0xE5, 0x89, 0x45, 0x79, 0x0A, 0x5A, 0x29, 0xA5, 0xF1,
    0xD5, 0xA8, 0x94, 0xD2, 0x06, 0xD5, 0xBD, 0xCF, 0xAF, 0xA0, 0xF5, 0x45, 0x44, 0xF4, 0x25, 0xF5,
    0x20, 0x00, 0x0E, 0x35, 0x33, 0x43, 0xDA, 0xF4, 0xD4, 0xFC, 0xCC, 0x02, 0x09, 0x46, 0xFA, 0xC7,
    0x0B, 0x8E, 0x42, 0x1E, 0x50, 0xEF, 0x00, 0xBE, 0x3C, 0x15, 0xF0, 0x7F, 0x78, 0x55, 0xAA, 0xC4,
    0xD6, 0xE5, 0xA8, 0xDB, 0x08, 0x11, 0x13, 0x21, 0x50, 0x98, 0xD5, 0x29, 0xC9, 0xB3, 0x8A, 0xE1,
    0x3B, 0x23, 0x75, 0xB4, 0x55, 0xBE, 0xFE, 0x02, 0xFA, 0xA0, 0x1F, 0x8C, 0x66, 0x3E, 0xF3, 0x80,
    0x69, 0xE2, 0x9F, 0x11, 0x7A, 0x02, 0xE6, 0xAC, 0x7D, 0x02, 0x09, 0x69, 0xF8, 0x1D, 0xED, 0x5C,
    0x77, 0x9E, 0x9D, 0x8A, 0x30, 0xF2, 0xA8, 0x9B, 0xFD, 0xAC, 0xDE, 0x36, 0x8A, 0x0D, 0x3A, 0x45,
    0xF4, 0xBD, 0xA4, 0x7B, 0xED, 0x05, 0xE1, 0xE7, 0xED, 0x40, 0xFF, 0x7A, 0xF3, 0x0D, 0x40, 0x43,
    0x0B, 0x3E, 0x4D, 0xDA, 0xBB, 0xC4, 0x87, 0xE0, 0xFB, 0xEB, 0x71, 0xE5, 0xA0, 0x26, 0xEF, 0x7E,
    0xFE, 0x4D, 0xE7, 0x0E, 0xB1, 0x63, 0x4E, 0x67, 0xCB, 0xC4, 0xEF, 0x66, 0xF9, 0xA0, 0x3F, 0x80,
    0x00, 0xA9, 0x02, 0x78, 0xC5, 0x3D, 0xE4, 0xDA, 0x53, 0x84, 0x9A, 0x07, 0x06, 0xDE, 0xAE, 0xAF,
    0x1C, 0x4B, 0x90, 0x9E, 0x91, 0x05, 0xC7, 0xAF, 0x27, 0xDF, 0xF9, 0x6F, 0x71, 0x27, 0xD0, 0x50,
    0xA8, 0x97, 0xDA, 0x76, 0x01, 0xB4, 0x57, 0x41, 0xFC, 0x1C, 0x8F, 0xF0, 0x87, 0x1F, 0x72, 0x56,
    0xB6, 0xEF, 0xED, 0x00, 0x6B, 0xAE, 0x4F, 0xB8, 0x7D, 0xF6, 0xE2, 0xF7, 0xB1, 0x75, 0x53, 0x53,
    0x30, 0xFF, 0x07, 0x78, 0xFE, 0x7A, 0xFC, 0xDA, 0x54, 0xFE, 0x00, 0x07, 0x21, 0x24, 0x7C, 0x55,
    0xB4, 0x3C, 0xC0, 0xBB, 0x2F, 0x8A, 0x44, 0xC6, 0x74, 0x66, 0x80, 0xBA, 0xDE, 0xB6, 0x1B, 0x93,
    0xC1, 0xF1, 0x01, 0x19, 0x27, 0xE5, 0x1A, 0x0E, 0xAA, 0x07, 0xC8, 0xAE, 0xB3, 0x61, 0x74, 0xD5,
    0x80, 0x78, 0x07, 0xD4, 0xE0, 0x4C, 0x3F, 0x37, 0x36, 0x7B, 0x30, 0x9F, 0xBD, 0x7E, 0x44, 0xE5,
    0xA5, 0xDA, 0x53, 0xEA, 0x40, 0x00, 0xF6, 0x60, 0x00, 0x45, 0x25, 0xB4, 0x3C, 0xDE, 0xEC, 0xA8,
    0xCC, 0x7F, 0xE8, 0x09, 0x67, 0x2C, 0x4E, 0x37, 0x7A, 0xF2, 0xFF, 0x84, 0xC7, 0x70, 0x5F, 0x14,
    0x00, 0x3C, 0x78, 0xB7, 0x3E, 0x00, 0x50, 0xAD, 0x00, 0x1F, 0xA4, 0x88, 0x45, 0x44, 0xFC, 0xD0,
    0x0C, 0xCC, 0x4A, 0xCD, 0x57, 0x25, 0x4C, 0xE8, 0xB4, 0xBD, 0xC6, 0xCB, 0xE5, 0x2A, 0xA9, 0x4B,
    0xF0, 0x88, 0x9F, 0xF0, 0x36, 0x5F, 0xAF, 0xF3, 0xE7, 0x3F, 0x2A, 0x9F, 0x4A, 0xEF, 0x1E, 0xE4,
    0xE7, 0xC7, 0x1E, 0x0C, 0x80, 0xFC, 0x16, 0x5F, 0xAF, 0xE8, 0x12, 0xBC, 0x38, 0x1E, 0x4B, 0xE6,
    0x4F, 0x84, 0x00, 0xFF, 0xD6, 0xE6, 0x22, 0x84, 0xB0, 0xCE, 0xE7, 0x9B, 0x54, 0xF8, 0xFF, 0x91,
    0x41, 0x0A, 0x62, 0x29, 0x8D, 0xEA, 0x92, 0xFC, 0xDA, 0x69, 0xB5, 0x61, 0x33, 0x59, 0x4F, 0x88,
    0xE5, 0xEE, 0x4C, 0xB6, 0x5F, 0x38, 0x60, 0x2D, 0xEF, 0x0F, 0xA8, 0xA0, 0x51, 0xE5, 0x17, 0xBF,
    0xF2, 0x12, 0x0A, 0xB9, 0x3A, 0x62, 0xAF, 0x36, 0xFB, 0x16, 0x9F, 0x9E, 0xD2, 0x5F, 0xB3, 0xCB,
    0x37, 0x01, 0x8C, 0xAA, 0x02, 0x35, 0xDE, 0xBB, 0xF8, 0x68, 0xFC, 0x65, 0x52, 0xB1, 0x72, 0xAC,
    0x38, 0x0A, 0xFB, 0x15, 0x23, 0x72, 0x41, 0x5D, 0x1B, 0xCD, 0x05, 0xFD, 0x09, 0xE3, 0xF6, 0xEC,
    0xBB, 0x8A, 0xAB, 0x6B, 0x63, 0x93, 0x13, 0xDF, 0x2F, 0x05, 0x83, 0xF7, 0xB1, 0xF0, 0x44, 0x0C,
    0x4C, 0x08, 0x49, 0xC8, 0x53, 0x04, 0xE3, 0x77, 0xAE, 0x8B, 0xF8, 0xC8, 0x6E, 0xB1, 0xB2, 0xED,
    0x05, 0xFF, 0xF5, 0xF1, 0x22, 0xDD, 0x96, 0x8A, 0x04, 0x3E, 0x7F, 0xF9, 0xE5, 0xE2, 0x10, 0x3E,
    0x2C, 0xC1, 0x11, 0x42, 0x8A, 0xAB, 0x2B, 0x30, 0x2B, 0x30, 0xE5, 0x50, 0x36, 0xF5, 0x35, 0x00,
    0x7F, 0x92, 0xDA, 0x7C, 0xEC, 0x09, 0xE8, 0xA5, 0xC9, 0x8A, 0x45, 0xAD, 0x60, 0x7C, 0xB6, 0xCC,
    0x3F, 0xFE, 0xBE, 0xE5, 0x94, 0x00, 0x11, 0xC8, 0x00, 0x00, 0xE8, 0x00, 0x00, 0x08
};


const unsigned char background2[] = {
0x26, 0x32, 0x64, 0x63, 0x20, 0x10, 0x00, 0x00, 0x03, 0x63, 0x12, 0x75, 0x93, 0xA8, 0x0B, 0xBD,
    0x00, 0x13, 0x60, 0x00, 0x45, 0x98, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, 0xE8, 0x04, 0x5C,
    0xFC, 0x50, 0xA8, 0xC7, 0x8C, 0x5C, 0x27, 0x08, 0x88, 0xB8, 0x4C, 0xDC, 0x3C, 0xAA, 0x72, 0x8E,
    0x79, 0x08, 0xB5, 0xA4, 0x50, 0xA0, 0xA6, 0x93, 0x3C, 0x3F, 0x11, 0xCF, 0x5A, 0x8F, 0x9B, 0x0A,
    0x55, 0x00, 0x50, 0xA0, 0xF0, 0x38, 0xDD, 0x50, 0x46, 0xA0, 0xE7, 0xA2, 0xA0, 0x17, 0xD8, 0x50,
    0xF0, 0xEB, 0xAA, 0xAC, 0x98, 0xD6, 0x96, 0x80, 0xE3, 0x75, 0xA0, 0x54, 0x86, 0xC2, 0x49, 0xA0,
    0x86, 0x90, 0x58, 0x71, 0x01, 0xE0, 0xF0, 0x01, 0xF5, 0xAA, 0x02, 0x87, 0xFA, 0x15, 0x29, 0x28,
    0x98, 0xC6, 0x8C, 0x04, 0xD2, 0x1E, 0x41, 0xA8, 0x16, 0xAC, 0x90, 0xA3, 0xDE, 0x1B, 0x8F, 0xD2,
    0xDA, 0xE3, 0xA8, 0xAC, 0x82, 0x20, 0x2D, 0x70, 0x54, 0x32, 0x50, 0x8A, 0xB4, 0xC6, 0x25, 0xD4,
    0x86, 0x68, 0xA5, 0x5A, 0x54, 0xB5, 0x25, 0x82, 0x95, 0xA0, 0x58, 0xCD, 0xFC, 0x42, 0x50, 0x63,
    0x42, 0xA3, 0x9C, 0xFC, 0xF8, 0xE5, 0xAE, 0xCA, 0x7A, 0xF0, 0x44, 0xFC, 0xCB, 0x51, 0x76, 0x30,
    0x62, 0x05, 0x47, 0xB4, 0xE5, 0x8A, 0xCA, 0xEF, 0x86, 0x34, 0xA5, 0x03, 0x13, 0xC3, 0xE7, 0x4D,
    0xA8, 0xAC, 0xF1, 0x0C, 0xE4, 0x8C, 0x4C, 0xA8, 0x90, 0x54, 0xB3, 0x14, 0xFF, 0x0B, 0x47, 0xBF,
    0x14, 0x28, 0xDF, 0x89, 0x2A, 0x33, 0x22, 0x47, 0xF0, 0xB1, 0x09, 0x9D, 0x9B, 0x33, 0x22, 0x30,
    0x03, 0x8F, 0x5E, 0x13, 0x8D, 0x88, 0xA0, 0xB5, 0xC7, 0xD3, 0x22, 0xEA, 0x35, 0x8D, 0x1F, 0x8E,
    0xB1, 0x96, 0x07, 0x55, 0x10, 0x31, 0x88, 0x0E, 0x84, 0x88, 0xD6, 0x84, 0x32, 0x1B, 0x60, 0x98,
    0x1E, 0x55, 0x3F, 0xFA, 0xFF, 0x15, 0x14, 0x7D, 0x5B, 0x10, 0x17, 0x75, 0xFD, 0x41, 0x1B, 0x33,
    0x86, 0x78, 0x4C, 0xCC, 0xDC, 0x0C, 0xBA, 0x57, 0xF2, 0x8F, 0x22, 0x64, 0x27, 0x43, 0xE4, 0xA0,
    0x76, 0x22, 0xBF, 0xEC, 0x2C, 0x62, 0xA2, 0x86, 0x6C, 0x42, 0xD2, 0xB3, 0xE9, 0x45, 0x58, 0xEB,
    0xDF, 0xEF, 0x00, 0x45, 0xA0, 0x99, 0xDA, 0xB5, 0x98, 0xD5, 0xE5, 0x26, 0x2C, 0xB6, 0x95, 0x64,
    0x53, 0x00, 0xF0, 0xFC, 0x08, 0xF4, 0x04, 0x0C, 0x44, 0x8C, 0x71, 0xFD, 0x45, 0xCC, 0x07, 0x1B,
    0x14, 0xC7, 0x3C, 0x7F, 0x2A, 0xE7, 0xB8, 0x15, 0xF0, 0xF5, 0x93, 0x3F, 0x8A, 0xA0, 0xD2, 0xB1,
    0x0A, 0x1F, 0x95, 0x8A, 0xE4, 0x40, 0xEE, 0x41, 0x50, 0x13, 0x80, 0x00, 0x8D, 0xD8, 0xED, 0x46,
    0xE1, 0x0F, 0x11, 0x19, 0x5E, 0x0D, 0x50, 0xD5, 0x1A, 0xF6, 0x57, 0x41, 0x54, 0x69, 0xC4, 0x86,
    0xE4, 0xA0, 0x36, 0xCA, 0xB6, 0x78, 0x01, 0xE0, 0xAD, 0x15, 0x1C, 0xB0, 0x7F, 0xAA, 0x88, 0x7E,
    0x09, 0xD1, 0x88, 0x99, 0x11, 0x43, 0x33, 0x22, 0x7C, 0x8B, 0x54, 0xC4, 0x34, 0x8A, 0x72, 0x81,
    0x2F, 0x21, 0xDA, 0xB3, 0x0C, 0x08, 0xAC, 0x54, 0x2B, 0x20, 0xA8, 0x7A, 0x0F, 0x9A, 0xF4, 0x8A,
    0xC7, 0x8B, 0x00, 0xF4, 0xB6, 0x16, 0x71, 0xC6, 0x99, 0xB5, 0x99, 0x16, 0xA9, 0xB8, 0xC0, 0xF0,
    0xE4, 0xEE, 0xFF, 0xED, 0x44, 0xCC, 0x6C, 0xB0, 0x69, 0xBB, 0xA0, 0x0A, 0xE3, 0x8C, 0x4C, 0x88,
    0x9A, 0x46, 0x8E, 0x8C, 0xE7, 0x28, 0x14, 0x0C, 0xC7, 0xA1, 0x41, 0x0F, 0x55, 0x3C, 0x3F, 0x50,
    0x8A, 0x7D, 0x3F, 0x82, 0xD9, 0x72, 0x11, 0x23, 0x43, 0x11, 0x0A, 0xE0, 0x0F, 0x4F, 0x8A, 0x0B,
    0x8B, 0x83, 0x5F, 0x73, 0xB8, 0xAC, 0x55, 0x21, 0x5D, 0x5A, 0xB0, 0x86, 0x9C, 0x42, 0x34, 0x3F,
    0x1F, 0xA0, 0x88, 0x4C, 0x18, 0xD0, 0x9E, 0xA1, 0xF0, 0x00, 0xE7, 0x50, 0x55, 0xBF, 0xC1, 0xB4,
    0xEF, 0x01, 0x6C, 0xCC, 0xDC, 0x66, 0x6D, 0x4F, 0xD2, 0x4D, 0x8D, 0x44, 0x78, 0x65, 0x22, 0x52,
    0x8F, 0x61, 0x88, 0xA0, 0xEE, 0x38, 0xAF, 0xC8, 0xFC, 0xB3, 0x8D, 0xBE, 0xC2, 0xDA, 0x65, 0x3D,
    0xE5, 0x5E, 0xB6, 0x44, 0x24, 0x57, 0xC4, 0x16, 0x00, 0xC7, 0x96, 0xA0, 0xC5, 0x29, 0x5B, 0x28,
    0x8A, 0xA0, 0xD4, 0xC7, 0x19, 0xB1, 0xCF, 0x96, 0x89, 0x70, 0x35, 0x9A, 0x04, 0x0C, 0x0A, 0x41,
    0xB8, 0x87, 0xF0, 0xFC, 0xCC, 0x43, 0xAC, 0x44, 0x1F, 0x8D, 0xC1, 0x35, 0xF3, 0x2A, 0xDA, 0x19,
    0x88, 0xBD, 0xD7, 0x71, 0x7D, 0xBF, 0x2A, 0x7A, 0x14, 0x7A, 0x27, 0x33, 0x11, 0x43, 0x9F, 0x3D,
    0x05, 0x22, 0x0F, 0x40, 0x01, 0xB2, 0xF0, 0x83, 0x09, 0x7D, 0xF6, 0x29, 0x8A, 0xC5, 0x12, 0x02,
    0xE2, 0x6D, 0x94, 0x85, 0xC2, 0x65, 0x54, 0x26, 0x24, 0x30, 0xDB, 0x3B, 0x87, 0x61, 0x03, 0x6D,
    0xD8, 0x01, 0x0F, 0x45, 0x55, 0x01, 0x14, 0x82, 0xBF, 0x02, 0xD1, 0x8C, 0x9D, 0xEB, 0x90, 0xFF,
    0x27, 0x72, 0x93, 0x1B, 0x00, 0x88, 0x0C, 0xFC, 0x8C, 0xA8, 0xA8, 0x00, 0x97, 0x46, 0x59, 0x6B,
    0xB5, 0xF9, 0xAB, 0x11, 0xDA, 0x44, 0x88, 0x29, 0xE5, 0x7C, 0xA1, 0xDC, 0xDA, 0x5C, 0xE0, 0x64,
    0x8F, 0x45, 0x0C, 0x3F, 0xCE, 0xCD, 0x54, 0x50, 0x2B, 0x31, 0x8A, 0x0F, 0x54, 0x0A, 0xE6, 0xA8,
    0x3C, 0x6B, 0xDD, 0xB5, 0xE5, 0xF2, 0x16, 0x34, 0x10, 0x26, 0xA1, 0xE5, 0x33, 0x3E, 0x54, 0x0B,
    0x64, 0xB8, 0x1A, 0xA1, 0x4E, 0x4C, 0xBD, 0xA4, 0x46, 0x88, 0xBE, 0x2C, 0x28, 0x54, 0x74, 0x4C,
    0xCC, 0x0C, 0x42, 0x34, 0xBB, 0x88, 0x8B, 0xF1, 0x01, 0xAA, 0x7A, 0x55, 0x47, 0xB5, 0xCB, 0xA0,
    0xE6, 0x3D, 0x15, 0xC5, 0xF0, 0xBE, 0x5D, 0x87, 0x27, 0x1B, 0xE1, 0x5B, 0xD4, 0x00, 0x20, 0x13,
    0x2D, 0xA0, 0x8E, 0x7C, 0x45, 0x79, 0x35, 0xF0, 0x75, 0x52, 0x12, 0xE3, 0x31, 0xF7, 0xFE, 0xA6,
    0x13, 0xBD, 0x84, 0xA0, 0x2E, 0x0F, 0x68, 0x80, 0x01, 0x0E, 0x3F, 0x3C, 0x2B, 0xC8, 0x0F, 0x91,
    0x54, 0x7B, 0x40, 0xBD, 0x05, 0x0A, 0x33, 0xB1, 0x0D, 0x00, 0x0C, 0x08, 0xA8, 0xCF, 0x2A, 0xA4,
    0x4F, 0x95, 0xE6, 0xBF, 0x2C, 0xE5, 0x45, 0x89, 0x34, 0x8C, 0xF6, 0x1E, 0x8D, 0xFC, 0x09, 0xF8,
    0x5E, 0xC4, 0xED, 0xA0, 0xEF, 0xD0, 0x6D, 0x04, 0x06, 0x5C, 0xD6, 0xD8, 0x44, 0x0E, 0xF0, 0x57,
    0xC4, 0x7C, 0x4F, 0x44, 0xA8, 0xA0, 0xC6, 0xD1, 0xEF, 0x45, 0xBF, 0x70, 0xAD, 0x96, 0xF0, 0x11,
    0x45, 0x33, 0xE8, 0xF0, 0x2E, 0x7C, 0xDF, 0x80, 0xE7, 0x7F, 0xEE, 0x5C, 0x0C, 0x4C, 0x17, 0x2D,
    0xAC, 0x8D, 0x33, 0x15, 0x2A, 0x0B, 0x88, 0x71, 0xAA, 0xBF, 0x7F, 0x9F, 0x4E, 0x37, 0xBA, 0xEF,
    0x9F, 0x3F, 0x7A, 0x9E, 0x15, 0xB1, 0x05, 0x71, 0x1D, 0xA0, 0x28, 0x00, 0x03, 0x01, 0x06, 0xC3,
    0x47, 0xD7, 0x85, 0xF0, 0x20, 0x8F, 0x3F, 0xE3, 0xEB, 0xC0, 0x21, 0x62, 0x43, 0x30, 0x27, 0xDB,
    0x20, 0x80, 0xF8, 0x1C, 0x71, 0x14, 0x03, 0xC3, 0x88, 0x00, 0x85, 0x9F, 0xFF, 0x8B, 0x38, 0x54,
    0x08, 0x7C, 0x8B, 0xA8, 0xCE, 0x4B, 0x11, 0xDA, 0xBD, 0x45, 0x53, 0x90, 0x0C, 0x48, 0xFD, 0xBD,
    0xE5, 0x50, 0xDA, 0xAA, 0xF7, 0xD2, 0x34, 0xFD, 0xEB, 0xDF, 0x0A, 0xFF, 0x7A, 0xF3, 0x36, 0x55,
    0x45, 0xFF, 0x44, 0x88, 0xDC, 0xFC, 0xE5, 0xF0, 0x2C, 0x5A, 0xEF, 0xDC, 0xF8, 0xE5, 0x32, 0x65,
    0xA0, 0x45, 0xAF, 0x8C, 0xB1, 0xA0, 0x83, 0xDA, 0xA0, 0x6C, 0x00, 0xC0, 0x7F, 0xFD, 0x7F, 0xEC,
    0xA8, 0xAC, 0xC6, 0xCC, 0x4C, 0xA1, 0xB2, 0x08, 0xF9, 0xBE, 0x0D, 0xFF, 0xAF, 0xE2, 0xBE, 0x55,
    0x7F, 0x91, 0xA0, 0x5E, 0x0B, 0xE7, 0xAE, 0x5E, 0xA2, 0x0F, 0x15, 0xEA, 0x00, 0x1F, 0xFD, 0x79,
    0x07, 0x0F, 0xEB, 0xDF, 0x50, 0x19, 0x51, 0x9C, 0xDD, 0x88, 0x5C, 0x26, 0x55, 0x47, 0x7D, 0x48,
    0x07, 0x41, 0x15, 0x5D, 0x84, 0x00, 0x1C, 0x87, 0x55, 0x3F, 0x28, 0xBF, 0xBE, 0x94, 0x18, 0x35,
    0x4B, 0x11, 0x8C, 0xBF, 0xFA, 0xFF, 0x0F, 0x45, 0x11, 0x8A, 0xA7, 0x00, 0xF8, 0x04, 0x6C, 0x6A,
    0x1F, 0x39, 0xDA, 0x50, 0x8A, 0x67, 0x01, 0xAB, 0xFF, 0x5E, 0xAF, 0xEC, 0x52, 0x15, 0xFF, 0xF5,
    0xEA, 0xF4, 0xED, 0xAE, 0xF8, 0xC6, 0x0C, 0x47, 0xDB, 0xEF, 0x18, 0x58, 0xDF, 0xBD, 0xDA, 0x59,
    0x65, 0xE5, 0x9F, 0x00, 0xCA, 0x00, 0x00, 0x08
};

#endif /* EXOGRAPHICS_H_ */
